/*
   Projekt  : XRAY
   Datei    : rp2gif.c

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996 Helmut Fahrion
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xv.h"

#define CANTALLOCCOLCELLS   5

#define uns unsigned
int MAXCOL = 6;			/* Kantenlnge des Farbwrfels */
#define WORD  uns short		/* Achtung ev. neudefinition da sons uns int!!! */
#define DWORD uns long
#define longunsint long unsigned int
#define longint unsigned int
#define FALSE 0
#define TRUE  1

typedef unsigned short word;
typedef unsigned int dword;
typedef unsigned long dlong;

/* ************ Globale Bildpuffer ********************* */
struct icol
  {
    byte r, g, b;
  }
 *cbuff;

word cbuffx, cbuffy;

byte *pbuff;
struct icol pal[256];

int ReadGIFImage (byte ** text, word * x, word * y, struct icol *pal, char *Name);


/* **************** Globale Variablen *********************** */

Display *display;		/* Zeiger auf die Display Struktur */
int screen_num;			/* Nummer des Bildschirms */
GC gc;				/* Grafikkontext */

longunsint wm_del_win;		/* del Window Massage */
longint millisek;
int stereo;
uns long new_foreground = 0, foreground = 1;

Visual *Dvis;
XVisualInfo visual;

/* ****** Struktur zur Bildverwaltung ****** */
typedef struct
  {
    int left, top;		/* Obere linke Fensterecke */
    int width;			/* Fensterbreite */
    int height;			/* Fensterhhe */
    /* gr_Sprite     *first;  *//* Erstes Sprite */

    /* X Windows-Spezifisch */
    Window window;
    Pixmap pixmap;		/* Animation */

    /* Pixmap        background; */
    Drawable drawable;
    Colormap colormap;
    unsigned long colref;
  }
gr_Window;

/* Strings fr die Fehlerausgabe */
char *ErrorString[] =
{
  "In %s: Unbekannter Fehler",
  "In %s: Kein Speicherplatz mehr",
  "In %s: %s kann nicht geffnet werden",
  "In %s: %s falsches Dateiformat",
  "In %s: Keine Verbindung zum X server",
  "In %s: Kann Farbzellen nicht allokieren",
};

gr_Window win;			/* Toplevel Window */
Colormap Cmap;			/* Farbtabellen */
Colormap errmap;

/* Farbzellen in Colormaps */
/* Feld der Indexe in der Farbtabelle */
uns long Pixels[256];
char truecolor;
char visok;

struct icol old_c = {0, 0, 0};

int rgb[3];			/* speichert einen RGB-Wert */
int dither_mode = 0;

XEvent event;			/* Event Struktur */
Screen *screen;			/* Zeiger auf Screen Struktur */
XColor xcolor;			/* Struktur zur Farbverwaltung */

/* Linke oder Rechte Seite */
int par = 1;

inline float 
retcol256 (byte col)
{
  return ((float) col / 255.0);
}

int 
error (int errnum, char *funcname, char *info)
{
  Window errwin, root, child;
  char *window_name = "Error";
  char *icon_name = "Error";
  XSizeHints *size_hints;
  XWMHints *wm_hints;
  XClassHint *class_hints;
  XTextProperty name_window, name_icon;
  char *progname = "Error";
  char hilf[100];
  int rootretx, rootrety, x, y;
  int left, top, width, height;
  unsigned int mask;
  XFontStruct *font_struct;
  GContext idgc;

  idgc = XGContextFromGC (gc);
  font_struct = XQueryFont (display, idgc);

  sprintf (hilf, ErrorString[errnum], funcname, info);
  height = 100;
  width = strlen (hilf) * (font_struct->max_bounds.width) + 20;
  left = (XDisplayWidth (display, screen_num) - width) / 2;
  top = (XDisplayHeight (display, screen_num) - height) / 2;

  if (!(size_hints = XAllocSizeHints ()))
    {
      fprintf (stderr, "%s: Fehler beim Allokieren von Speicherplatz\n",
	       progname);
      exit (0);
    }

  if (!(wm_hints = XAllocWMHints ()))
    {
      fprintf (stderr, "%s: Fehler beim Allokieren von Speicherplatz\n",
	       progname);
      exit (0);
    }

  if (!(class_hints = XAllocClassHint ()))
    {
      fprintf (stderr, "%s: Fehler beim Allokieren von Speicherplatz\n",
	       progname);
      exit (0);
    }

  errwin = XCreateWindow (display,
			  RootWindow (display, screen_num),
			  left, top, width, height, 0,
			  DefaultDepth (display, screen_num),
			  InputOutput,
			  XDefaultVisual (display, screen_num),
			  0, NULL);

  size_hints->flags = PPosition | PSize | PMinSize;
  size_hints->min_width = width;
  size_hints->min_height = height;

  if (XStringListToTextProperty (&window_name, 1, &name_window) == 0)
    {
      fprintf (stderr, "%s: Fehler beim allokieren der Struktur fr den Windownamen\n",
	       progname);
      exit (-1);
    }

  if (XStringListToTextProperty (&icon_name, 1, &name_icon) == 0)
    {
      fprintf (stderr, "%s: Fehler beim allokieren der Struktur fr den Iconnamen\n",
	       progname);
      exit (-1);
    }

  wm_hints->initial_state = NormalState;
  wm_hints->input = True;
  wm_hints->flags = StateHint | InputHint;

  class_hints->res_name = progname;
  class_hints->res_class = "Errorwindow";

  XSetWMProperties (display, errwin, &name_window, &name_icon,
		    NULL, 0, size_hints, wm_hints, class_hints);

  XMapWindow (display, errwin);

  XSetWindowColormap (display, errwin, DefaultColormap (display, DefaultScreen (display)));
  XSetWindowBackground (display, errwin, XWhitePixel (display, screen_num));
  XSetForeground (display, gc, XBlackPixel (display, screen_num));

  do
    {
      XDrawString (display, errwin, gc, 10, 40, hilf, strlen (hilf));
      XQueryPointer (display, errwin, &root, &child,
		     &rootretx, &rootrety, &x, &y, &mask);
    }
  while ((x > width || x < 0 || y > height || y < 0) || mask != 256);

  XDestroyWindow (display, errwin);
  return errnum;
}

int highbit(unsigned long ul)
{
  int i;  unsigned long hb;
  hb = 0x8000;  hb = (hb<<16);  /* hb = 0x80000000UL */
  for (i=31; ((ul & hb) == 0) && i>=0;  i--, ul<<=1);
  return i;
}

void XRAllocColor(Display *dp, Colormap cm, XColor *cdef)
{
  unsigned long r, g, b, rmask, gmask, bmask, origr, origg, origb;
  int rshift, gshift, bshift;

  origr = r = cdef->red;  
  origg = g = cdef->green;  
  origb = b = cdef->blue;

  rmask = visual.red_mask;
  gmask = visual.green_mask;
  bmask = visual.blue_mask;

  rshift = 15 - highbit(rmask);
  gshift = 15 - highbit(gmask);
  bshift = 15 - highbit(bmask);

  r = (rshift<0)? r << (-rshift) : r >> rshift;
  g = (gshift<0)? g << (-gshift) : g >> gshift;
  b = (bshift<0)? b << (-bshift) : b >> bshift;

  r = r & rmask;
  g = g & gmask;
  b = b & bmask;

  cdef->pixel = r | g | b;

  cdef->red   = r = (rshift<0)? r >> (-rshift) : r << rshift;
  cdef->green = g = (gshift<0)? g >> (-gshift) : g << gshift;
  cdef->blue  = b = (bshift<0)? b >> (-bshift) : b << bshift;
}

void SetColor (struct icol rgb)
{
  struct icol c;
  XColor xcol;

  if ((old_c.r != rgb.r) || (old_c.g != rgb.g) || (old_c.b != rgb.b))
    {
      if (truecolor)
	{
	  xcol.flags = DoRed | DoGreen | DoBlue;
	  xcol.red = (unsigned) (retcol256 (rgb.r) * 0xffff);
	  xcol.green = (unsigned) (retcol256 (rgb.g) * 0xffff);
	  xcol.blue = (unsigned) (retcol256 (rgb.b) * 0xffff);

	  if (!visok)
	    XAllocColor (display, Cmap, &xcol);
	  else
	    XRAllocColor (display, Cmap, &xcol);

	  new_foreground = xcol.pixel;
	}
      else
	{
	  c.r = (byte) (retcol256 (rgb.r) * (float) (MAXCOL - 1));
	  c.g = (byte) (retcol256 (rgb.g) * (float) (MAXCOL - 1));
	  c.b = (byte) (retcol256 (rgb.b) * (float) (MAXCOL - 1));
	  new_foreground = Pixels[(unsigned)
			(c.r + (MAXCOL) * c.g + (MAXCOL) * (MAXCOL) * c.b)];
	}
      old_c = rgb;

      XSetForeground (display, gc, new_foreground);	// Fenster

    }
}

/*  Name     : initwindow() */
/*  Funktion : initialisiert ein Grafikausgabefenster */
/*  Parameter : anzahl der Argumente, Argument */
int 
initwindow (gr_Window * wi)
{
  XTextProperty name_window,	/* Struktur fuer Windownamen */
    name_icon;			/* Struktur fuer Iconname */
  char *window_name = "Anzeige", *icon_name = "Anz",	/* Titel des Icons */
   *display_name = NULL;	/* Knotennamen */

  /* Strukturen zur Inter-Client-Kommunikation */
  XSizeHints *size_hints;
  XWMHints *wm_hints;
  XClassHint *class_hints;

  XSetWindowAttributes attributes;
  unsigned long valuemask;

  /* Speicher fuer Inter-Client-Kommunikations- */
  /* Strukturen allokieren */
  if (!(size_hints = XAllocSizeHints ()))
    {
      fprintf (stderr, "rp2gif: Fehler beim Allokieren von Speicherplatz\n");
      return (FALSE);
    }

  if (!(wm_hints = XAllocWMHints ()))
    {
      fprintf (stderr, "rp2gif: Fehler beim Allokieren von Speicherplatz\n");
      return (FALSE);
    }

  if (!(class_hints = XAllocClassHint ()))
    {
      fprintf (stderr, "rp2gif: Fehler beim Allokieren von Speicherplatz\n");
      return (FALSE);
    }

  /* Verbindung zum X Server herstellen */

  if ((display = XOpenDisplay (display_name)) == NULL)
    {
      fprintf (stderr, "pr2gif: Verbindung zum X Server %s konnte nicht hergestellt werden\n",
	       XDisplayName (display_name));
      exit (FALSE);
    }

  /* Nummer des Bildschirms */
  screen_num = XDefaultScreen (display);

  /* Zeiger auf Screen Struktur setzen */
  screen = XScreenOfDisplay (display, screen_num);

  if (XDoesBackingStore (XScreenOfDisplay (display, screen_num)))
    {
      valuemask = CWBackingStore | CWBackPixel;
      attributes.backing_store = Always;
      attributes.background_pixel = XWhitePixel (display, screen_num);
    }
  else
    {
      valuemask = CWBackPixel;
      attributes.background_pixel = XWhitePixel (display, screen_num);
    }

  /* Toplevel Window erzeugen */
  win.window = XCreateWindow (display,
			      RootWindow (display, screen_num),
			      170, 200, win.width, win.height, 1,
			      DefaultDepth (display, screen_num),
			      InputOutput,
			      XDefaultVisual (display, screen_num),
			      valuemask, &attributes);

  /*   Delete Window Protokoll clientmassage wird gesetzt! mu abgefragt werden */
  wm_del_win = XInternAtom (display, "WM_DELETE_WINDOW", False);
  XSetWMProtocols (display, win.window, &wm_del_win, 1);

  /* Grafikkontext erzeugen */
  gc = XCreateGC (display, RootWindow (display, screen_num),
		  0, NULL);

  /* Struktur zur Inter-Client-Kommunikation */
  /* initialisieren */
  size_hints->flags = PPosition | PSize | PMinSize;
  size_hints->min_width = win.width;
  size_hints->min_height = win.height;

  /* Strings konvertieren */
  if (XStringListToTextProperty (&window_name, 1, &name_window) == 0)
    {
      fprintf (stderr, "rp2gif: Fehler beim allokieren der Struktur fr den Windownamen\n");
      return (FALSE);
    }

  if (XStringListToTextProperty (&icon_name, 1, &name_icon) == 0)
    {
      fprintf (stderr, "rp2gif: Fehler beim allokieren der Struktur fr den Iconnamen\n");
      return (FALSE);
    }

  /* Struktur zur Inter-Client-Kommunikation */
  /* initialisieren */
  wm_hints->initial_state = NormalState;
  wm_hints->input = True;
  wm_hints->flags = StateHint | InputHint;

  class_hints->res_name = "rp2gif";
  class_hints->res_class = "grafik";

  /* Hintergrund des Windows Wei faerben */
  XSetWindowBackground (display, win.window, XWhitePixel (display, screen_num));

  /* Alle initialisierten Strukturen zur */
  /* Inter-Client-Kommunikation, sowie der Namen */
  /* des Windows und des Icons werden dem */
  /* Window Manager bekannt gemacht */
  XSetWMProperties (display, win.window, &name_window, &name_icon,
		    0, 0, size_hints, wm_hints, class_hints);


  /* Die gewnschten Eventtypen */
  /* werden selektiert */
  XSelectInput (display, win.window, ExposureMask | KeyPress |
		KeyPressMask | ButtonPressMask | StructureNotifyMask);

  /* Das Window wird abgebildet */
  XMapWindow (display, win.window);


  /*  Pixmap erzeugen um Bildschirminhalt zu speichern */
  win.pixmap = XCreatePixmap (display, RootWindow (display, screen_num),
		 win.width, win.height, DefaultDepth (display, screen_num));

  /* Inhalt lschen */
  /*  XSetForeground(display, WhitePixelOfScreen(screen_num)); */
  XFillRectangle (display, win.pixmap, gc, 0, 0, win.width, win.height);

  /* inhalt ins Window sichern */
  XCopyArea (display, win.pixmap, win.window, gc, 0, 0,
	     win.width, win.height, 0, 0);

  /* XSetInputFocus(display, win.window, RevertToParent, CurrentTime); */

  win.drawable = win.window;
  return (TRUE);
}

/* Neu */
int get_colormap (void)
{
  int x, y, anz, red, green, blue, depth;
  XColor xcol;

  Cmap = DefaultColormap (display, DefaultScreen (display));
  Dvis = DefaultVisual (display, DefaultScreen (display));

  x = FALSE;

  visok = anz = y = 0;
  MAXCOL = 6;

  // Ermittle Visual fr Berechnung der Farbpixel
  depth = DefaultDepth(display, DefaultScreen(display));

  // Truecolor ab bpp 15 
  if ((depth >= 15) && !XAllocColorCells(display, Cmap, 0, 0, 0, Pixels, 1))
    {
      if (XMatchVisualInfo(display, DefaultScreen(display),
			   depth, TrueColor, (XVisualInfo *) & visual))
	visok = 1;
      if (visok)
	{
	  truecolor = 1;
	  return 1;
	}
      else
	{
	  fprintf(stderr, "Keine Farbzelle und Visualtype ungleich! \n");
	  truecolor = 0;
	}

    }

  // Teste wieviele Farben frei sind
  while ((MAXCOL > 3) && (!x))
    {
      x = XAllocColorCells (display, Cmap, True, (unsigned long *) NULL, 0,
			    Pixels, MAXCOL * MAXCOL * MAXCOL);
      if (!x)
	MAXCOL--;
    }

  // 6 geht noch mit bpp 8 und Pseudocolor, Staticcolor,
  if (MAXCOL < 6)
    {
      MAXCOL = 6;
      Cmap = XCreateColormap (display, win.window, XDefaultVisual (display,
						    screen_num), AllocNone);

      if (XAllocColorCells (display, Cmap, FALSE, 0, 0, Pixels, MAXCOL * MAXCOL * MAXCOL))
	{
	  y = 0;
	  for (blue = 0; blue < MAXCOL; blue++)
	    for (green = 0; green < MAXCOL; green++)
	      for (red = 0; red < MAXCOL; red++)
		{
		  xcol.pixel = Pixels[y];
		  xcol.flags = DoRed | DoGreen | DoBlue;
		  xcol.red = (unsigned) (red * 65535L / (MAXCOL - 1));
		  xcol.green = (unsigned) (green * 65535L / (MAXCOL - 1));
		  xcol.blue = (unsigned) (blue * 65535L / (MAXCOL - 1));
		  XStoreColor (display, Cmap, &xcol);
		  y++;
		}
	  /*XSetWindowColormap(Disp, XtWindow(top), Cmap); */
	  XSetWindowColormap (display, win.window, Cmap);
	}
      if (y > 0)
	return TRUE;
    }
  else
    // berechne auf die vorhandene Colortabelle
    {
      anz = y = 0;

      for (blue = 0; blue < MAXCOL; blue++)
	for (green = 0; green < MAXCOL; green++)
	  for (red = 0; red < MAXCOL; red++)
	    {
	      xcol.flags = DoRed | DoGreen | DoBlue;
	      xcol.pixel = Pixels[y];
	      xcol.red = (unsigned) (red * 65535L / (MAXCOL - 1));
	      xcol.green = (unsigned) (green * 65535L / (MAXCOL - 1));
	      xcol.blue = (unsigned) (blue * 65535L / (MAXCOL - 1));
	      if (XStoreColor (display, Cmap, &xcol))
		anz++;
	      y++;
	    }
      if (anz > 0)
	return TRUE;
    }

  // infobox("Kein TrueColor und kein Pseudocolor mglich!\nVersuche langsame Farbberechnung!");
  // keine Farbe allociert -> True Color?
  truecolor = TRUE;
  return TRUE;
}

void 
gr_CloseWindow (gr_Window * wi)
{
  XFreePixmap (display, wi->pixmap);
  XFreeGC (display, gc);
  XDestroyWindow (display, wi->window);
  XCloseDisplay (display);
}

void 
gr_xevents (void)
{
  /* Hier werden die eintreffenden */
  /* Events abgearbeitet */
  while (TRUE)
    {
      /* Nchster Event wird */
      /* aus der Warteschlange gelesen */
      XNextEvent (display, &event);

      /* Event Typ auswerten */
      switch (event.type)
	{
	case ConfigureNotify:
	  win.width = event.xconfigure.width;
	  win.height = event.xconfigure.height;
	  break;
	case Expose:
	  /* Eingabefokus setzen */
	  XSetInputFocus (display, win.window, RevertToNone, CurrentTime);
	  if (event.xexpose.count == 0)
	    {
	      if (XEventsQueued (display, QueuedAfterReading) > 0)
		{
		  while (XEventsQueued (display, QueuedAfterReading) > 0)
		    XNextEvent (display, &event);
		}
	      XCopyArea (display, win.pixmap, win.window, gc, 0, 0,
			 win.width, win.height, 0, 0);
	    }
	  break;

	case ClientMessage:
	  if (event.xclient.format == 32 &&
	      event.xclient.data.l[0] == wm_del_win)
	    {
	      gr_CloseWindow (&win);
	      exit (0);
	    }

	case ButtonPress:
	  if (event.xbutton.button == 3)
	    {
	      gr_CloseWindow (&win);
	      exit (0);
	    }
	  else if (event.xbutton.button == 1)
	    {
	      XCopyArea (display, win.pixmap, win.drawable, gc, 0, 0,
			 win.width, win.height, 0, 0);
	    }
	  else if (event.xbutton.button == 2)
	    {
	      /* Bild anzeigen */
	    }
	  break;
	}
    }
}

int 
initw (int x, int y)
{
  win.width = x;
  win.height = y;

  if (!initwindow (&win))
    {
      fprintf (stderr, "Fehler in Funktion initwindow()");
      XCloseDisplay (display);
      return (FALSE);
    }

  if (!get_colormap ())
    {
      fprintf (stderr, "Fehler beim Farben allocieren der Farbzellen!\n");
      XCloseDisplay (display);
      return (FALSE);
    }
  return (TRUE);
}

/* Funktionen zum Pixelgenerieren */
void 
writexy (word x, word y, int num, struct icol rgb)
{
  SetColor (rgb);

  /* Zur Kontrolle */
  XDrawPoint (display, win.pixmap, gc, x, y);
  /* XDrawPoint(display, win.window, gc, x, y); */
}

void 
zeichnepuffer (int a, int b)
{
  dword x, y;

  for (y = 0; y < b; y++)
    {
      for (x = 0; x < a; x++)
	writexy (x, y, x + y, cbuff[y * a + x]);

      if (!(y % 100))
	XCopyArea (display, win.pixmap, win.window, gc, 0, 0, win.width, win.height, 0, 0);
    }

  free (cbuff);

  XCopyArea (display, win.pixmap, win.window, gc, 0, 0, win.width, win.height, 0, 0);
}

void 
readdatei (char *name, char w)
{
  dword x1, y1, x2, y2;
  long alle;

  FILE *D;

  if ((D = fopen (name, "r+")) == NULL)
    {
      fprintf (stderr, "rp2gif: Fehler beim ffnen der Datei %s\n", name);
      exit (1);
    }

  fread (&x1, sizeof (unsigned short), 1, D);
  fread (&y1, sizeof (unsigned short), 1, D);
  fread (&x2, sizeof (unsigned short), 1, D);
  fread (&y2, sizeof (unsigned short), 1, D);

  cbuffx = x2 - x1;
  cbuffy = y2 - y1;
  alle = (cbuffx + 1) * (cbuffy + 1);

  if (w)
    initw (cbuffx, cbuffy);

  cbuff = (struct icol *) malloc (sizeof (struct icol) * alle);

  fread (cbuff, sizeof (struct icol), alle, D);

  fclose (D);
}

void 
anzeige (char *name)
{
  readdatei (name, TRUE);
  zeichnepuffer (cbuffx, cbuffy);
}

void 
anzeigegif (char *name)
{
  dword x, y;

  ReadGIFImage ((byte **) & pbuff, &cbuffx, &cbuffy, pal, name);

  initw (cbuffx, cbuffy);

  for (y = 0; y < cbuffy; y++)
    {
      for (x = 0; x < cbuffx; x++)
	writexy (x, y, x + y, pal[pbuff[y * cbuffx + x]]);

      if (!(y % 100))
	XCopyArea (display, win.pixmap, win.window, gc, 0, 0, win.width, win.height, 0, 0);
    }

  free (cbuff);

  XCopyArea (display, win.pixmap, win.window, gc, 0, 0, win.width, win.height, 0, 0);
}

void 
konvert (char *name)
{
  char wname[256];
  byte x, e;

  FILE *D;

  /* Daten einlesen */
  readdatei (name, FALSE);

  strcpy (wname, name);

  x = strlen (wname);
  wname[x - 3] = (char) 0;
  strcat (wname, ".gif");

  if ((D = fopen (wname, "w+")) == NULL)
    {
      fprintf (stderr, "rp2gif: Fehler beim ffnen der Datei %s\n", name);
      exit (1);
    }

  /* Baue Puffer fuer Funktion */
  e = WriteGIF (D, (byte *) cbuff, PIC24, cbuffx, cbuffy, NULL, NULL, NULL,
		0, 0, NULL);

  /*
     int WriteGIF(
     FILE *fp,             geoeffnete Datei
     byte *pic,            Zeiger auf Bildmatrix rgb Tripel vom Type byte = uns char
     int   ptype,          PIC24
     int w, int h,         Geometrie
     byte *rmap,           Zeiger auf Colormap, wird zugewiesen
     byte *gmap,
     byte *bmap,
     int   numcols,        Anz.der Farben, wird zugewiesen
     int colorstyle,       ==2 Schwartz/Weis bild, ==1 Grayscale sonst nicht ausgewertet
     char *comment)        mit GIF89a  sonst GIF87a
   */

  free (cbuff);

  /* fertig ! */
  fclose (D);

  if (e)
    {
      fprintf (stderr, "rp2gif: Fehler!\n");
      exit (-1);
    }
  else
    fprintf (stderr, "rp2gif: OK!\n");
}

void 
parametererror (void)
{
  fprintf (stderr, "rp2gif: Falsche Parameter angegeben!\n\trp2gif -srp name.rp -> anzeige\n\trp2gif -sgif name.gif -> anzeige\n\trp2gif name.rp -> erzeugt name.gif\n");
}

int 
main (int argc, char **argv)
{
  /* Parametertest */
  if (argc > 1)
    {
      if (argc > 2)
	{
	  /* Bildanzeige */
	  if (!strcmp (argv[1], "-srp"))
	    {
	      printf ("rp2gif: Anzeige rp von %s\n", argv[2]);
	      anzeige (argv[2]);
	      /* X-Schleife */
	      while (TRUE)
		gr_xevents ();
	      return 1;
	    }
	  else
	    /* Bildanzeige */
	  if (!strcmp (argv[1], "-sgif"))
	    {
	      printf ("rp2gif: Anzeige gif von %s\n", argv[2]);
	      anzeigegif (argv[2]);
	      /* X-Schleife */
	      while (TRUE)
		gr_xevents ();
	      return 1;
	    }
	  else
	    {
	      parametererror ();
	      return -1;
	    }
	}
      /* Bildkonvertierung */
      printf ("rp2gif: Konvertierung von %s\n", argv[1]);
      konvert (argv[1]);
      return 1;
    }
  else
    {
      parametererror ();
      return -1;
    }
  return 0;
}
