/*
  Tool zum Einlesen und erzeugen eines ppm Files
 
  Copyright (C) 1997 Helmut Fahrion
*/


#include <stdio.h>
#include <string.h>
#include <malloc.h>


#include "ppm.h"

int ReadPPMImage(icol * text[], word * x, word * y, char *Name)
{
  FILE *D;
  
  char version[80];
  char kommentar[80];
  char c;

  dword xz, yz, xanz, yanz, maxcol, r, g, b;

  if ((D = fopen(Name, "r+")) == NULL)
    {
      fprintf(stderr, "rp2ppm: Fehler beim lesen der Datei %s\n" , Name);
      exit (1);
    }

  fscanf(D, "%s\n", version);
  
  for (xz=0;xz<80;xz++) kommentar[xz]=0;

  xz = 0;
  do
    {
      fscanf(D, "%c", &c);
      kommentar[xz] = c;
      xz++;
    }
  while (c != '\n');

  fprintf(stderr, "Kommentar: %s\n", kommentar);

  fscanf(D, "%u %u\n", &xanz, &yanz);
  fscanf(D, "%u\n", &maxcol);

  *text = (icol*) malloc(sizeof(icol)*(xanz+1)*(yanz+1));

  for (yz=0; yz<yanz; yz++)
    for (xz=0; xz<xanz; xz++)
     {
	fscanf(D, "%u %u %u", &r, &g, &b);
	(*text)[yz * xanz + xz].r = (byte) r;
	(*text)[yz * xanz + xz].g = (byte) g;
	(*text)[yz * xanz + xz].b = (byte) b;
      }

  *x = xanz;
  *y = yanz;

  fclose(D);

  return 0;
}

int WritePPM(FILE * D, icol cbuff[], int cbuffx, int cbuffy)
{
  word x, y;
  longint i;

  fprintf(D, "P3\n# XRay-Image: konvertiert von rp2ppm.\n%d %d\n%d\n", cbuffx, cbuffy, 255);

   for (y=0; y<cbuffy; y++)
    for (x=0; x<cbuffx; x++)
     {
       i = y * cbuffx + x;
       fprintf(D, "%d %d %d ", cbuff[i].r, cbuff[i].g, cbuff[i].b);

       if (!(i%5))
	 fprintf(D, "\n");
     } 

 return 0;
}





