#include <stdio.h>

/*  Hinweise auf die GIF-Entwickler: CompuServe Inc.
   "The Graphics Interchange Format (C) is the Copyright
   property of CompuServe Inc. GIF is a Service Mark 
   property of CompuServe Inc."
 */

struct icol
  {
    unsigned char r, g, b;
  };

struct GIFFILEHEADER
  {
    unsigned char GIF[6];
    unsigned short scrwidth;
    unsigned short scrheight;
    unsigned char resflag;
    unsigned char background;
    unsigned char Pixel;
  }
gifheader;

struct GIFIMAGEHEADER
  {
    unsigned short AX;
    unsigned short AY;
    unsigned short imgwidth;
    unsigned short imgheight;
    unsigned char flagbyte;
  }
gifimage;


#define      MAXENTRY   4096
int packet[MAXENTRY];		/* Tabelle mit Pixelwerten */
int pre[MAXENTRY];		/* Tabelle mit Prefixen */


int 
testbits (int bits)
{
  while (pre[bits] != -1)
    bits = pre[bits];
  return bits;
}

#define CLEAR_CODE  (1<<pixel_size)
#define EOI_CODE    (1<<pixel_size)+1


unsigned short 
getWinWordFILE (FILE * pointer, char x)
{
  unsigned short hilf = 0;
  if (x == 'I')
    {
      hilf = (getc (pointer) & 0xff);
      hilf |= (getc (pointer) & 0xff) << 8;
      return (hilf);
    }
  if (x == 'M')
    {
      hilf = (getc (pointer) & 0xff) << 8;
      hilf |= (getc (pointer) & 0xff);
      return (hilf);
    }
  return 0;
}

static unsigned long x;

void 
setpoint2 (unsigned char *im, int prefix)
{
  if (pre[prefix] != -1)
    setpoint2 (im, pre[prefix]);
  *(im + x) = packet[prefix];
  x++;
}

int 
ReadGIFImage (unsigned char **text,
	      unsigned int *X, unsigned int *Y, struct icol pal[],
	      char *Name)
{
  FILE *fp;			/*  Dateizeiger  */
  int i;			/*  Laufvariable  */
  unsigned char gblock[256],	/*  Block fr Bilddaten */
    pixel_size, block_size;	/*  Speichert aktuelle Blockgre    */
  unsigned next_entry,		/*  zeigt auf ersten freie Eintrag */
    counter,			/*  Anzahl der benutzten Bits in count_word */
    mask_width,			/*  Gre der Bitmask */
    mask,			/*  Bitmaske */
    bits;			/*  aktuell gelesene Daten */
  int prefix,			/*  Vorgnger   */
    colcount,			/*  Anzahl der Farben */
    suffix,			/*  Nachfolger   */
    old_code;			/*  alter Wert */
  unsigned long count_word,	/*  nimmt Bits aus Bitstrom auf */
    help;			/*  Hilfsvariable zum Schiften */

  /* Datei ffnen */
  if ((fp = fopen (Name, "rb")) != NULL)
    {
      /* lesen des GIFFILEHEADER */
      fread (&gifheader, 13, 1, fp);

      /* Test auf GIF-Datei */
      if (strncmp ((const char *) &(gifheader.GIF[0]), "GIF", 3))
	{
	  fprintf (stderr, "Falsches Dateiformat, keine *.gif Datei.\n");

	  fclose (fp);
	  return 0;
	}

      /* Test auf Farbtabelle */
      if (gifheader.resflag & 0x80)
	{
	  i = 0;
	  colcount = 1 << ((gifheader.resflag & 0x07) + 1);
	  while (i < colcount)
	    {
	      pal[i].r = (unsigned char) getc (fp);
	      pal[i].g = (unsigned char) getc (fp);
	      pal[i].b = (unsigned char) getc (fp);
	      i++;
	    }
	}

      if (fgetc (fp) == 0x21)
	{
	  fprintf (stderr, "Kein Erweiterungsblock in *.gif Datei gefunden.\n");

	  fclose (fp);
	  return (0);
	}
      else
	{
	  gifimage.AX = getWinWordFILE (fp, 'I');
	  gifimage.AY = getWinWordFILE (fp, 'I');
	  gifimage.imgwidth = getWinWordFILE (fp, 'I');
	  gifimage.imgheight = getWinWordFILE (fp, 'I');
	  gifimage.flagbyte = getc (fp);
	}

      *X = gifimage.imgwidth;
      *Y = gifimage.imgheight;

      pixel_size = fgetc (fp);

      if ((*text = (unsigned char *) malloc (sizeof (unsigned char) *
				    gifimage.imgwidth * gifimage.imgheight))
	  == NULL)
	{
	  fprintf (stderr, "Nicht gengend Speicher um *.gif Datei zu lesen.\n");
	  return (0);
	}

      x = 0;


      /*   Tabelle vorbesetzen */

      for (i = 0; i < (1 << pixel_size) + 2; i++)
	{
	  packet[i] = i;
	  pre[i] = -1;
	}

      /* Variablen initialisieren  */
      next_entry = (1 << pixel_size) + 2;
      counter = 0;
      count_word = 0;
      mask_width = pixel_size + 1;
      mask = (1 << mask_width) - 1;
      old_code = -1;

      /* Lese, solange es Blcke > 0 gibt  */
      for (block_size = fgetc (fp); block_size > 0; block_size = fgetc (fp))
	{
	  /*  einen Block einlesen  */
	  fread (&(gblock[0]), block_size, 1, fp);

	  /*  Block bearbeiten */
	  for (i = 0; i < block_size; i++)
	    {
	      help = (unsigned long) gblock[i];
	      count_word |= (help << counter);
	      counter += 8;

	      /*  Hole gengend Bits in count_word  */
	      while (counter >= mask_width)
		{
		  /*  Neuen Wert basteln */
		  bits = ((unsigned) count_word) & mask;
		  counter -= mask_width;
		  count_word >>= mask_width;

		  /*  EOI-Code empfangen */
		  if (bits == EOI_CODE)
		    {
		      /*  Datei schlieen  */
		      fclose (fp);
		      return (1);
		    }

		  /*  Clear Code empfangen */
		  if (bits == CLEAR_CODE)
		    {
		      next_entry = (1 << pixel_size) + 2;
		      mask_width = pixel_size + 1;
		      mask = (1 << mask_width) - 1;
		      old_code = -1;
		      continue;
		    }

		  /*  Erster Wert an die Ausgabe */
		  if (old_code == -1)
		    {
		      old_code = bits;
		      setpoint2 (*text, bits);
		      continue;
		    }
		  else
		    {
		      /*  Ist neuer Code schon in der Tabelle ? */
		      if (bits < next_entry)
			{
			  setpoint2 (*text, bits);
			  prefix = old_code;
			  suffix = testbits (bits);
			}
		      else
			{
			  prefix = old_code;
			  suffix = testbits (prefix);
			  setpoint2 (*text, prefix);
			  setpoint2 (*text, suffix);
			}

		      /*  Neuen Eintrag in die Tabelle speichern */
		      packet[next_entry] = suffix;
		      pre[next_entry] = prefix;
		      next_entry++;
		      old_code = bits;
		    }
		  /*  Breite der Bitmaske justieren, falls ntig */
		  if (next_entry > mask)
		    {
		      if (next_entry < MAXENTRY)
			{
			  mask_width++;
			  mask = (1 << mask_width) - 1;
			}
		    }
		}
	    }
	}

      /*  Datei schlieen  */
      fclose (fp);
      return (1);
    }
  return (0);
}
