/*
  Berechnet die Pixelmatrix mittels abgewandelten z-Buffering
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Copyright (C) 1996, 1997 Helmut Fahrion
  */

#include "ray.H"

// Setzt je nach Scallierungsfaktor, einen Bildpunkt oder ein Rechteck
// der Farbe c
extern void writecxy (word x, word y, word s, color c);

// Setzt Farbe c und fuellt ein Rechteck
extern void writecboxxy (word x, word y, word dx, word dy, word s, color c);

zbuffer::zbuffer (word x1, word y1, word x2, word y2, word S, word O)
:p1 (-0.5, -0.5, 0.0), p2 (0.5, -0.5, 0.0), p3 (0.5, 0.5, 0.0), pt (0.0, 0.0, -1.0)
{
  word x, y;

  // Scallierung
  s = S;
  // Optimierung
  o = O;
  // Bildschirmgroesse
  dx = x2 - x1;
  dy = y2 - y1;
  // ZBuffer
  z = new float[(dx + 1) * (dy + 1) + 1];

  // Init, Wert 0.0 kennzeichnet uninitialiesierten Zustand
  for (y = 0; y < dy; y++)
    for (x = 0; x < dx; x++)
      z[y * dx + x] = 0.0;

  // Farbpuffer
  cbuff = new cbyte[(dx + 1) * (dy + 1) + 1];

  np |= (p3 - p1) && (p2 - p1);	// Polygonnormalvektor

  // Projektion aendern
  kammove (&pt);
  kammove (&p1);
  polyrot (&p1);

  rotationVN (&np, pwelt->cam.w);

  /*
     // Punkte werden nicht mehr gebraucht
     kammove(&p2);  
     kammove(&p3);
     polyrot(&p1);  
     polyrot(&p2);  
     polyrot(&p3);
   */

  anzobj = 0;

  // berechne Hintergrund
  calc_background ();
  // Init, Wert 0.0 kennzeichnet uninitialiesierten Zustand
  for (y = 0; y < dy; y++)
    for (x = 0; x < dx; x++)
      z[y * dx + x] = 0.0;

  // geht Baum durch
  ray(ptree);
}

void zbuffer::kammove (vector * point)
{
  *point += (pwelt->cam.mov + vector (0.0, 0.0, 1.0));
}

void zbuffer::polyrot (vector * point)
{
  float l;
  vector tmp;

  tmp = *point - pt;
  l = abs (tmp);
  tmp |= tmp;
  rotationVN (&tmp, pwelt->cam.w);
  *point = pt + (tmp * l);
}

inline vector zbuffer::hit (vector point)
{
  vector dir;
  float t;
  dir |= pt - point;		// Richtung von point nach pt

  t = np * dir;
  t = (fabs (t) > eps10) ? (np * (p1 - point)) / t : 0.0;
  return ((dir * t) + point);
}

inline vector zbuffer::mkdir (int x, int y)
{
  vector dir;
  dir |= vector (((float) x / (float) dx) - 0.5,
		 ((float) y / (float) dy) - 0.5,
		 1.0);
  rotationVN (&dir, pwelt->cam.w);
  return dir;
}

void zbuffer::zray (obj * obj, int x, int y)
{
  dword index;
  float entf;
  vector intpt, norm;
  color col (1.0, 1.0, 1.0);

  if ((pwelt->methode == ZBUFFER) ||
      (pwelt->methode == RADIOSITY))
    {
      // alle Daten global (in Klasse) fuer Raytracing
      if (!pray.hit(obj, pt, mkdir (x, y), &intpt, &norm))
	{
	  // Backgroundfarbe
	  index = y * dx + x;
	  if (z[index] == 0.0)
	    {
	      pray.bckgrnd(&col, pwelt->backh, pwelt->backb, mkdir(x, y));
	      cbuff[index] = intcolor256(col);
	      writecxy(x, mky (y), s, col);
	    }
	  return;
	}
      entf = intpt || pt;
    }
  else
    {
      // Alle Anderen Methoden
      pray.zbuffobj = obj;
      // im Fehlerfall -1.0
      entf = pray.raytrace (pt, mkdir (x, y), 0, &col);
    }

  if (entf > 0.0)
    {
      // Test im Puffer of Wert gueltig ist
      index = y * dx + x;

      if ((z[index] == 0.0) || (z[index] > entf))
	{
	  // z-Wert eintragen
	  z[index] = entf;

	  if (pwelt->methode == ZBUFFER)
	    obj->surfaceCol (&col, intpt);
	  else 
	    if (pwelt->methode == RADIOSITY)
	    {
	      col = obj->surfaceColRadio(intpt, pt, mkdir (x, y));
	    }
	  cbuff[index] = intcolor256(col);
	  writecxy (x, mky (y), s, col);
	}
    }
}

void zbuffer::calc_background (void)
{
  int x, y;
  dword index;

  for (y = 0; y < dy; y++)
    for (x = 0; x < dx; x++)
      {
	index = y * dx + x;
	if (z[index] == 0.0)
	  {
	    color col (1.0, 1.0, 1.0);
	    pray.bckgrnd (&col, pwelt->backh, pwelt->backb, mkdir (x, y));
	    cbuff[index] = intcolor256 (col);
	    writecxy (x, mky (y), s, col);
	  }
      }
}

void zbuffer::sortmin (vector p)
{
  if (p.x < intmin.x)
    intmin.x = p.x;
  if (p.y < intmin.y)
    intmin.y = p.y;
  if (p.x > intmax.x)
    intmax.x = p.x;
  if (p.y > intmax.y)
    intmax.y = p.y;
}

vector zbuffer::tf (vector p)
{
  float l;
  vector po;

  po = p - p1;
  l = abs (po);
  po |= po;
  rotationVZ (&po, pwelt->cam.w);

  return po * l;
}

void zbuffer::anzeigen (obj * obj)
{
  vector nv;
  longint x, y;

  if (obj != NULL)
    {
      intmin = vector (1.0, 1.0, 1.0);
      intmax = vector (0.0, 0.0, 0.0);

      x = 0;
      while (obj->grobjp->getpoints (&nv, ++x))
	sortmin (tf (hit (nv)));

      // ermittle Bildschirmpunkte, Runden eps2 reicht
      hitminx = (int) ((float) dx * (intmin.x - eps2));
      hitminy = (int) ((float) dy * (intmin.y - eps2));
      hitmaxx = (int) ((float) dx * (intmax.x + eps2));
      hitmaxy = (int) ((float) dy * (intmax.y + eps2));

      // Nur Bildschirm rechnen
      if (hitminx < 0)	hitminx = 0;
      if (hitminy < 0)	hitminy = 0;
      if (hitmaxx > dx)	hitmaxx = dx;
      if (hitmaxy > dy)	hitmaxy = dy;

      for (y = hitminy; y <= hitmaxy; y++)
	for (x = hitminx; x <= hitmaxx; x++)
	  zray (obj, x, y);

      anzobj++;			// Statistik
    }
}

void zbuffer::ray (tree * ptr)
{
  byte x;
  obj *obj = ptr->o;

  // Bilde rekursiv die Objekte und rechne weiter
  while (obj)
    {
      anzeigen (obj);
      obj = obj->next;
    }

  // rekursiv den Baum durchsuchen
  for (x = 0; x < 8; x++)
    if (ptr->t[x] != NULL)
      ray(ptr->t[x]);
}

zbuffer::~zbuffer ()
{
  delete cbuff;
  delete z;
}

// Ende

