/*
   Objekttyp Y-Puffer
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"


ybuffer::ybuffer (float *v, word dx, word dy,
	 obj ** Objekt, obj ** Ox, obj ** Nextsp, cover * Ycover,
	 float R, float G, float B, float E,
	 float Mat, float Sp, float Du, float Dif, float Spec,
	 float High, float Vel, char Ch)
{
  // Optische Eigenschaften

  objekt = Objekt;
  ox = Ox;
  nextsp = Nextsp;
  ycover = Ycover;
  r = R;
  g = G;
  b = B;
  e = E;
  mat = Mat;
  sp = Sp;
  du = Du;
  dif = Dif;
  spec = Spec;
  high = High;
  vel = Vel;
  ch = Ch;

  // Objekteigenschaften
  yanz = dy;
  xanz = dx;
  p1 = vector (v[0], v[1], v[2]);
  p2 = vector (v[3], v[4], v[5]);
  p3 = vector (v[6], v[7], v[8]);
  p4 = vector (v[9], v[10], v[11]);

  // Speicher bereitstellen
  ybuf = new float[dx * dy];

  // Test auf Ebene
  // if (fabs(((p3 - p2) && (p4 - p2)) * (p1 - p2)) > eps5)
  // Test auf Ebene
  // ########### noch testen!!!!!!!!!!!!!!
  if (!testebene (p1, p2, p3, p4))
    {
      cerr << "ray: Vektoren des Y-Buffer bilden keine Ebene!\n";
      exit (1);
    }

  // Normalvektor der Ebene
  // Definition des Polygons gegen den Uhrzeiger zeigt nach oben!
  nor |= ((p2 - p1) && (p3 - p1)) * -1.0;
}

// Hier besteht die Mglichkeit die Anzahl der Dreiecke durch zusammenfuegen
// zu Polygonen zu vermindern
void ybuffer::
maketri (void)
{
  word x, y;
  float xabs, yabs, a, b, c, d;
  vector rp1, rp2, rp3, rp4, xa, ya, bx, by;

  // Achsenrichtung und Lnge
  xa = p2 - p1;
  ya = p4 - p1;
  xabs = abs (xa) / (float) (xanz - 1);
  yabs = abs (ya) / (float) (yanz - 1);
  xa |= xa;
  ya |= ya;

  xa *= xabs;
  ya *= yabs;

  // laufe Sttzpunkte -1 durch
  for (y = 0; y < yanz - 1; y++)
    {
      by = ya * (float) y;

      for (x = 0; x < xanz - 1; x++)
	{
	  bx = xa * (float) x;

	  // Punkte in der Ebene
	  rp1 = p1 + bx + by;
	  rp2 = rp1 + xa;
	  rp3 = rp2 + ya;
	  rp4 = rp1 + ya;

	  // Punkte mit Hhe
	  a = ybuf[y * xanz + x];
	  b = ybuf[y * xanz + x + 1];
	  c = ybuf[(y + 1) * xanz + x + 1];
	  d = ybuf[(y + 1) * xanz + x];

	  rp1 += nor * a;
	  rp2 += nor * b;
	  rp3 += nor * c;
	  rp4 += nor * d;

	  // Objekt generieren, es knnten auch, in Abhngigkeit von der Position, die 
	  // Optischen Eigenschaften gendert werden.

	  // Die einfachste Art ohne Interpolation, nach dem Hhenlinienmodell
	  if ((a + c) < (b + d))
	    {
	      // Dreieck 123
	      genobj ();
	      if (ch == 'N')
		((polygon *) ((*ox)->grobjp))->set (&rp1, &rp2, &rp3, NULL);
	      else
		((polygon *) ((*nextsp)->grobjp))->set (&rp1, &rp2, &rp3, NULL);

	      // Dreieck 134
	      genobj ();
	      if (ch == 'N')
		((polygon *) ((*ox)->grobjp))->set (&rp1, &rp3, &rp4, NULL);
	      else
		((polygon *) ((*nextsp)->grobjp))->set (&rp1, &rp3, &rp4, NULL);
	    }
	  else
	    {
	      // Dreieck 124
	      genobj ();
	      if (ch == 'N')
		((polygon *) ((*ox)->grobjp))->set (&rp1, &rp2, &rp4, NULL);
	      else
		((polygon *) ((*nextsp)->grobjp))->set (&rp1, &rp2, &rp4, NULL);

	      // Dreieck 234
	      genobj ();
	      if (ch == 'N')
		((polygon *) ((*ox)->grobjp))->set (&rp2, &rp3, &rp4, NULL);
	      else
		((polygon *) ((*nextsp)->grobjp))->set (&rp2, &rp3, &rp4, NULL);
	    }
	}
    }
}

void ybuffer::
genobj (void)
{
  if (*objekt == NULL)
    {
      // erstes Objekt  definieren
      *ox = *objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel, ycover,
			       POLYGON, NONE);
    }
  else
    {
      if (ch == 'N')
	{
	  // kein Schnittkrper
	  *ox = new obj (*ox, r, g, b, e, mat, sp, du, dif, spec, high, vel, ycover, 
			 POLYGON, NONE);
	}
      else
	{
	  // Schnittkrper erzeugen
	  *nextsp = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel, ycover,
			     POLYGON, (ch == 'S') ? SCHN : DIFF);
	  // Schnittkrper einfgen
	  (*ox)->sobj (*nextsp);
	  ((polygon *) ((*nextsp)->grobjp))->ebene = true;
	}
    }
}
