/*
   Mit diesem Modul wird das 3D Datenmodell im Speicher definiert

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"
#include "gif.H"
#include "planeten.H"

extern void rotation (vector * e, vector p, vector w);

char planetenname[][11] =
{"Merkur", "Venus", "Erde", "Mars", "Jupiter", "Saturn",
 "Uran", "Neptun", "Pluto", "Mond", "Sonne"};

// liest Gif-Dateien
int 
readtextinfo (texture * text, char *name)
{
  // Bild in Imagestruktur einlesen
  if (ReadGIFImage (text, name) == 0)
    return false;
  return true;
}

/*
   Pos ist der Winkel den der Planet von ,,vector(0, 0, entf)'' rotiert
   werden mu um die richtige Lage zu haben!
 */
void world::
posplanet (word planet, vector pos)
{
  obj *o = ptree->o;
  lamp *l = pwelt->lampe;

  if (planet <= SONNE)
    cout << "Posplanet: " << planetenname[planet - 1] << "\n";
  else
    {
      cout << "Undefinierter Planet!\n";
      return;
    }

  // Schleife durch alle Objekte
  while (o)
    {
      // Stern ?
      if (o->type == STAR)
	{
	  if (((star *) (o->grobjp))->num == planet)
	    {
	      // ist er der richtige Stern dann Koordinaten setzen
	      ((star *) (o->grobjp))->rotstar (pos);

	      if (planet == SONNE)
		while (l)
		  {
		    if (l->type == SUNLAMP)	// Sonnenlicht ?

		      {
			// Lichtquelle wird mit Sonne rotiert, es wird nicht der gleiche Punkt gesetzt
			// da Kugel sonst Lichtquelle verdeckt
			rotation (&(l->m), VNULL, vector (-pi / 8, 0, 0));
		      }
		    l = l->next;
		  }
	    }
	}
      o = o->next;
    }				//  while

}

longint world::step(int seite)
{
  char c, str[10];
  byte planet;
  int dx, dy, bl, en;
  longint frame_anz, frame_x;
  float xw, yw, zw, r1, r2, r3, r4, r5, r6;

  FILE *D;
  vector step;

  // Befehlsdatei einlesen
  cout << "Step()! \n";
  if ((D = fopen (RAYNUMMER, "r")) == NULL)
    {
      cerr << "raywin: Fehler beim lesen der Datei,\nev. nicht vorhanden.\n" << RAYNUMMER << "!\n";
      exit (1);
    }

  // Bildschirm
  fscanf (D, "x1:%d y1:%d x2:%d y2:%d\n", &dx, &dy, &observ.p_width,
	  &observ.p_height);	// Weltbereich

  fscanf (D, "x1:%d y1:%d x2:%d y2:%d\n", &observ.x1, &observ.y1,
	  &observ.x2, &observ.y2);	// Raytracebereich

  fscanf (D, "x:%f m:%s p:%d a:%f d:%d\n",
	  &cam.scal, str, &observ.opixel, &MinA, &diff);	// Streckung, Optimierung

  if (!strcmp ("ZB", str))
    methode = ZBUFFER;
  else if (!strcmp ("RY", str))
    methode = RAYTRACING;
  else if (!strcmp ("RD", str))
    methode = RADIOSITY;
  else if (!strcmp ("RDY", str))
    methode = RADIOSITYRAY;
  else
    methode = RAYTRACING;

  // Bildqualitt
  fscanf (D, "Meth:%c Pixel:%u Blende:%u Entf:%u", &c, &dx, &bl, &en);

  observ.ch = c;		// G=gleichmig,R=random,N=kein
  observ.pixel = dx;		// Pixelvergrerung
  cam.blende = bl;		// Blendeneinstellung
  cam.entf = en;		// Entfernungseinstellung
  fclose (D);

  // Kameraposition einlesen
  if ((D = fopen ("./scene_kameras", "r")) == NULL)
    {
      cerr << "raywin: Fehler beim lesen der Datei ./scene_kameras\n";
      exit (1);
    }
  fscanf (D, "%ld\n", &frame_anz);

  for (frame_x = 0; (frame_x <= cam.frame) && (frame_x <= frame_anz); frame_x++)
    {
      fscanf (D, "%f %f %f %f %f %f\n",
	      &step.x, &step.y, &step.z, &xw, &yw, &zw);
    }
  // Linkes Auge oder Rechtes ?
  step.x += (seite == 1) ? +0.035 : -0.035;	// Einheit ist Meter, Augenabstand 7 cm

  // nicht weiterrcken sondern setzen!
  cam.mov = step;

  cam.frame = frame_x;
  // Fehler ausgleichen
  cam.w |= vector (xw + eps8, yw, zw);

  cout << "Gelesene Kamera = " << step << " " << cam.w << "\n" << flush;

  fclose (D);			// Ende Kamera

  // Sterne an die richtige Position drehen

  if ((D = fopen ("./star_pos", "r")) == NULL)
    {
      fprintf (stderr, "raywin: Fehler beim lesen der Datei %s!\n", "./star_pos");
      goto abbruch;
    }

  for (planet = 1; planet <= SONNE; planet++)
    {
      fscanf (D, "%f %f %f %f %f %f\n", &r1, &r2, &r3, &r4, &r5, &r6);	// Rotationsdaten

      // Hier Umrechnung fr die Koordinaten einfgen
      // Besser in xdate berechnen
      // Pos r1,r2,r3 ist der Winkel den der Planet von ,,vector(0, 0, entf)'' rotiert
      // werden mu um die richtige Lage zu haben!

      if (planet != ERDE)
	// posplanet(planet, vector(r1, r2, r3));
	switch (planet)
	  {
	  case MERKUR:
	    posplanet(planet, vector (0, -pi / 8, 0));
	    break;
	  case VENUS:
	    posplanet(planet, vector (0, -pi / 16, 0));
	    break;
	  case MARS:
	    posplanet(planet, vector (0, 0.0, 0));
	    break;
	  case JUPITER:
	    posplanet(planet, vector (0, pi / 16, 0));
	    break;
	  case SATURN:
	    posplanet(planet, vector (0, pi / 8, 0));
	    break;
	  case URAN:
	    posplanet(planet, vector (-pi / 16, -pi / 8, 0));
	    break;
	  case NEPTUN:
	    posplanet(planet, vector (-pi / 16, -pi / 16, 0));
	    break;
	  case PLUTO:
	    posplanet(planet, vector (-pi / 16, 0, 0));
	    break;
	  case MOND:
	    posplanet(planet, vector (-pi / 16, pi / 16, 0));
	    break;
	  case SONNE:
	    posplanet(planet, vector (-pi / 8, 0, 0));
	    break;
	  default:
	    cerr << "Falscher Planet!\n";
	  }
    }
  fclose (D);

  // keine Sterne !
abbruch:

  // erst hier unten da sonst keine Kameraanzeige im Fenster
  if (cam.frame == frame_anz)
    {
      return 0L;
    }

  return frame_x;
}

// Datenmodell der knstliche Welt
world::world () :cam ()
{
  FILE *D;
  char str[80], ch;

  dword objecttyp, dx, dy, map, map3d, tu, wl, art, zx, zy, blende, entf;
  dword t1, t2;

  longint satz, covernr;

  float x, y, z, r, g, bl, a, b, c, e, r1, r2, mat, sp, du, dif, spec,
    high, vel, x1, x2, y1, y2, w, z1, max, v[16];	// Entfernung fr Himmel eigentlich egal!

  //vector bpuf[4][4];		// Datenpuffer fuer Bezierflaeche

  texture *tx, *tn, *tp, *ts, *tb;
  texture3d *tx3d, *tn3d, *tp3d;
  // Freigeben !!!
  muster *mp, *mp2, *ms, *mb, *mx;
  wave *wp, *wx;
  spot *strahlerx;
  lichtpoly *lichtpolyx;

  cover *cp, *cx;
  ybuffer *ybu;
  bezier *pbezier;


  lamp *lx;
  obj *ox, *nextsp;

  // Alle Pointer auf NULL setzen
  tx = text = tn = tp = ts = tb = NULL;
  tx3d = text3d = tn3d = tp3d = NULL;
  mustp = mp = mp2 = mx = ms = mb = NULL;
  wavep = wp = wx = NULL;
  lx = lampe = NULL;
  nextsp = objekt = ox = NULL;
  ybu = NULL;
  coverl = cp = cx = NULL;
  strahlerx = strahler = NULL;
  lichtpolyx = lichtpolyp = NULL;
  pbezier = NULL;

  satz = 1;
  covernr = 0;

  black = ambient = backh = backb = color(0, 0, 0);	// Farbe = 0

  nebel = -1.0;			// ist Nebel < 0.0 dann ist kein Nebel, sonst Sichtweite

  observ.pixel = 1;		// 1 Pixel pro Bildpunkt

  observ.ch = 'R';		// Antialiasing Zufallsverteilt

  bgmuster1 = bgmuster2 = NULL;
  bgtextur1 = bgtextur2 = NULL;
  mv1 = mv2 = vector (0.0, 0.0, 0.0);
  ish = isb = false;
  max = 2.0;			// fr Himmel und Bodenmuster

  // pid fr Ausgabezwecke lesen

  pid = getpid();

  // Befehlsdatei einlesen, bei step() noch mal !!!
  cout << "Lade Daten\n";
  if ((D = fopen(RAYNUMMER, "r")) == NULL)
    {
      cerr << "raywin: Fehler beim lesen der Datei " << RAYNUMMER << "!\n";
      exit (1);
    }

  // Bildschirm
  fscanf (D, "x1:%u y1:%u x2:%d y2:%d\n", &dx, &dy, &observ.p_width, &observ.p_height);
  // Weltbereich

  fscanf (D, "x1:%d y1:%d x2:%d y2:%d\n", &observ.x1, &observ.y1,
	  &observ.x2, &observ.y2);	// Raytracebereich

  fscanf (D, "x:%f m:%s p:%d a:%f d:%d\n",
	  &cam.scal, str, &observ.opixel, &MinA, &diff);	// Streckung, Optimierung

  if (!strcmp ("ZB", str))
    methode = ZBUFFER;
  else if (!strcmp ("RY", str))
    methode = RAYTRACING;
  else if (!strcmp ("RD", str))
    methode = RADIOSITY;
  else if (!strcmp ("RDY", str))
    methode = RADIOSITYRAY;
  else
    methode = RAYTRACING;

  // Bildqualitt
  fscanf (D, "Meth:%c Pixel:%u Blende:%u Entf:%u", &ch, &dx, &blende, &entf);
  observ.ch = ch;		// G=gleichmig,R=random,N=kein

  observ.pixel = dx;		// Pixelvergrerung

  cam.blende = blende;		// Blendeneinstellung

  cam.entf = entf;		// Entfernungseinstellung

  fclose (D);

  // Faktor fr beide Seiten setzen
  observ.dx = cam.scal;
  observ.dy = cam.scal;

  // lese Scenenfile
  if ((D = fopen ("./scene", "r")) == NULL)
    {
      cerr << "raywin: Fehler beim ffnen der Datei 'scene'\n";
      exit (1);
    }

  // lese Zeile fuer Zeile
  while (!feof (D))
    {
      fscanf (D, "%s\n", str);
      satz++;
      objecttyp = 65535L;

      // einfachstes Parsing?
      if (!strcmp (str, "polygon"))
	objecttyp = POLYGON;
      else if (!strcmp (str, "sphere"))
	objecttyp = SPHERE;
      else if (!strcmp (str, "star"))
	objecttyp = STAR;
      else if (!strcmp (str, "lampe"))
	objecttyp = LAMP;
      else if (!strcmp (str, "spotlight"))
	objecttyp = SPOT;
      else
	// if (!strcmp(str, "sunlamp"))   objecttyp = SUNLAMP;   else
      if (!strcmp (str, "ambient"))
	objecttyp = AMBIENT;
      else if (!strcmp (str, "backgrnd"))
	objecttyp = BACKGRND;
      else if (!strcmp (str, "nebel"))
	objecttyp = NEBEL;
      else if (!strcmp (str, "textur"))
	objecttyp = TEXTURE;
      else if (!strcmp (str, "textur3d"))
	objecttyp = TEXTURE3D;
      else if (!strcmp (str, "elipsoid"))
	objecttyp = ELIPSOID;
      else if (!strcmp (str, "cone"))
	objecttyp = CONE;
      else if (!strcmp (str, "torus"))
	objecttyp = TORUS;
      else if (!strcmp (str, "block"))
	objecttyp = BLOCK;
      else if (!strcmp (str, "cover"))
	objecttyp = COVER;
      else if (!strcmp (str, "wave"))
	objecttyp = WAVE;
      else if (!strcmp (str, "muster"))
	objecttyp = MUSTER;
      else if (!strcmp (str, "ybuffer"))
	objecttyp = YBUFFER;
      // else if (!strcmp (str, "bezier"))	objecttyp = BEZIER;
      else if (!strcmp (str, "lightpoly"))
	objecttyp = POLYLIGHT;
      else if (!strcmp (str, "patchobj"))
	objecttyp = PATCHOBJ;
      else
	{
	  cout << "undefinierten Objekttyp gelesen! Zeile=" << satz << "\n";
	  exit (1);
	}

      // Auswahl der Objekte
      switch (objecttyp)
	{
	case AMBIENT:
	  fscanf (D, "%f %f %f\n", &r, &g, &b);
	  satz++;
	  ambient = color (r, g, b);
	  break;		// AMBIENT

	case NEBEL:
	  fscanf (D, "%f\n", &r);
	  satz++;
	  nebel = r;
	  break;		// NEBEL

	case BACKGRND:
	  // Farbe rgb, Texture Nr, Muster Nr, Turbolenz Nr. Frequenz, Scalierung
	  fscanf (D, "%f %f %f\n", &r, &g, &b);
	  satz++;
	  backh = color (r, g, b);
	  fscanf (D, "%f %f %f\n", &r, &g, &b);
	  satz++;
	  backb = color (r, g, b);

	  fscanf (D, "%f %d\n", &max, &tu);  // Hhe des Himmels bzw. Tiefe des Bodens
	  satz++;
	  srand(tu); // Zufallszahlen definiert setzen

	  // 1.Textur  1.Muster (Nr. Verschiebung x,y) 
	  // 1.Turbolenz lesen (Turbo Art, Noise Art, Freq., Scalierung)
	  fscanf (D, "%u %u %f %f %u %u %u %f\n", &map, &tu, &r, &g, &dx, &art, &dy, &x);
	  satz++;

	  // Turbolenz setzen
	  tb1.tu = dx;
	  tb1.lvl = dy;
	  tb1.t = x;
	  tb1.noise = art;
	  mv1 = vector (r, g, 0.0);

	  // Texture anketten, mu vorher geladen werden!!!
	  if (map != 0)
	    {
	      tn = text;
	      bgtextur1 = NULL;
	      while ((tn != NULL) && (bgtextur1 == NULL))
		{
		  if (tn->num == map)
		    bgtextur1 = tn;
		  tn = tn->next;
		}
	    }
	  else
	    bgtextur1 = NULL;

	  // Muster anketten, mu vorher geladen werden!!!
	  if (tu != 0)
	    {
	      mp = mustp;
	      bgmuster1 = NULL;
	      while ((mp != NULL) && (bgmuster1 == NULL))
		{
		  if (mp->num == tu)
		    bgmuster1 = mp;
		  mp = mp->next;
		}
	    }
	  else
	    bgmuster1 = NULL;

	  // 2.Textur  2.Muster (Nr. Verschiebung x,y) 
	  // 2.Turbolenz lesen (Turbo Art, Noise Art, Freq., Scalierung)
	  fscanf (D, "%u %u %f %f %u %u %u %f\n", &map, &tu, &r, &g, &dx, &art, &dy, &x);
	  satz++;

	  // Turbolenz setzen
	  tb2.tu = dx;
	  tb2.lvl = dy;
	  tb2.t = x;
	  tb2.noise = art;
	  mv2 = vector (r, g, 0.0);

	  // Texture anketten, mu vorher geladen werden!!!
	  if (map != 0)
	    {
	      tn = text;
	      bgtextur2 = NULL;
	      while ((tn != NULL) && (bgtextur2 == NULL))
		{
		  if (tn->num == map)
		    bgtextur2 = tn;
		  tn = tn->next;
		}
	    }
	  else
	    bgtextur2 = NULL;

	  // Muster anketten, mu vorher geladen werden!!!
	  if (tu != 0)
	    {
	      mp = mustp;
	      bgmuster2 = NULL;
	      while ((mp != NULL) && (bgmuster2 == NULL))
		{
		  if (mp->num == tu)
		    bgmuster2 = mp;
		  mp = mp->next;
		}
	    }
	  else
	    bgmuster2 = NULL;

	  // Ist Himmel und Erde definiert
	  fscanf (D, "%u %u\n", &dx, &dy);
	  satz++;
	  if (dx)
	    {
	      ish = true;
	      hi.ebene = true;
	      hi.setvector(0, vector (-max, max+cam.mov.y, -max));
	      hi.setvector(1, vector (+max, max+cam.mov.y, -max));
	      hi.setvector(2, vector (+max, max+cam.mov.y, +max));
	      hi.setvector(3, vector (-max, max+cam.mov.y, +max));
	    }
	  if (dy)
	    {
	      isb = true;
	      bo.ebene = true;
	      bo.setvector(0, vector (-max, -max+cam.mov.y, -max));
	      bo.setvector(1, vector (+max, -max+cam.mov.y, -max));
	      bo.setvector(2, vector (+max, -max+cam.mov.y, +max));
	      bo.setvector(3, vector (-max, -max+cam.mov.y, +max));
	    }
	  break;		// BACKGROUND

	case SUNLAMP:
	case LAMP:
	  // Lichtquelle ist Lampe oder Sonne
	  cout << "Lampe gelesen\n";
	  fscanf (D, "%f %f %f\n", &x, &y, &z);
	  satz++;
	  fscanf (D, "%f %f %f\n", &r, &g, &b);
	  satz++;
	  fscanf (D, "%f\n", &c);
	  satz++;

	  // cerr << "l: " << x << " " << y << " " << z << "\n";

	  if (lampe == NULL)
	    {
	      lx = lampe = new lamp (NULL,
				     x, y, z,	// Entfernung zum Ursprung
				      r, g, b,	// [0<=x<=1] Farbe 1 1 1 ist Wei
				      c, objecttyp);	// [ 0<=i<=1 ] Lichtstrke
	    }
	  else
	    {
	      lx = new lamp (lx, x, y, z, r, g, b, c, objecttyp);
	    }
	  break;		//LAMP, SUNLAMP

	case SPOT:
	  // Lichtquelle ist Lampe oder Sonne
	  cout << "Strahler gelesen\n";
	  fscanf (D, "%f %f %f\n", &x, &y, &z);
	  satz++;
	  fscanf (D, "%f %f %f\n", &x1, &y1, &z1);
	  satz++;
	  fscanf (D, "%f %f %f\n", &r, &g, &b);
	  satz++;
	  fscanf (D, "%f %f\n", &c, &w);
	  satz++;

	  if (strahler == NULL)
	    {
	      strahlerx = strahler = new spot (NULL,
					       x, y, z,		// Entfernung zum Ursprung
					        x1, y1, z1,	// Richtung
					        r, g, b,	// [0<=x<=1] Farbe 1 1 1 ist Wei
					        c, w, objecttyp);	// [ 0<=i<=1 ] Lichtstrke, Winkel

	    }
	  else
	    {
	      strahlerx = new spot (strahlerx, x, y, z, x1, y1, z1, r, g, b, c, w, objecttyp);
	    }
	  break;		// SPOT

	case POLYLIGHT:
	  // Lichtquelle ist Polygon
	  cout << "Lichtflche gelesen\n";
	  fscanf (D, "%f %f %f\n", &v[0], &v[1], &v[2]);
	  satz++;		// Punkt

	  fscanf (D, "%f %f %f\n", &v[3], &v[4], &v[5]);
	  satz++;		// Punkt

	  fscanf (D, "%f %f %f\n", &v[6], &v[7], &v[8]);
	  satz++;		// Punkt

	  fscanf (D, "%f %f %f\n", &v[9], &v[10], &v[11]);
	  satz++;		// Punkt

	  fscanf (D, "%f %f %f\n", &r, &g, &b);
	  satz++;		// Punkt

	  fscanf (D, "%f %d %d %f\n", &c, &dx, &dy, &w);
	  satz++;		// Farbe
	  // Lichtquelle erzeugen #############################################################

	  if (lichtpolyp == NULL)
	    {
	      lichtpolyx = lichtpolyp =
		new lichtpoly (NULL, v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8], v[9],
			       v[10], v[11], r, g, b, dx, dy, c, w);
	    }
	  else
	    {
	      lichtpolyx =
		new lichtpoly (lichtpolyx, v[0], v[1], v[2], v[3], v[4], v[5], v[6], v[7], v[8],
			       v[9], v[10], v[11], r, g, b, dx, dy, c, w);
	    }
	  break;		// POLYLIGHT

	case TEXTURE:
	  cout << "Texture gelesen\n";
	  fscanf (D, "%u %f %s\n", &dx, &x, str);
	  satz++;
	  if (text == NULL)
	    {
	      // Zeiger auf Vorgnger, [0<=x<=1] Mischung Textur oder Oberflche,Nummer
	      tx = text = new texture (NULL, x, dx);
	    }
	  else
	    {
	      tx = new texture (tx, x, dx);
	    }
	  if (!readtextinfo (tx, str))
	    {
	      cerr << "Konnte Gif-Datei nicht lesen!\n";
	      exit (1);
	    };
	  break;		//TEXTURE

	case TEXTURE3D:
	  cout << "Texture3d gelesen\n";
	  fscanf (D, "%u %u %u %u %f %f\n", &dx, &dy, &tu, &art, &v[1], &v[2]);
	  satz++;
	  fscanf (D, "%f %f %f %f %f %f\n", &v[3], &v[4], &v[5], &v[6], &v[7], &v[8]);
	  satz++;
	  fscanf (D, "%f %f %f %f %f %f\n", &v[9], &v[10], &v[11], &v[12], &v[13], &v[14]);
	  satz++;
	  if (text3d == NULL)
	    {
	      //  Nummer, Welche Textur (Kugel, Zylinder, u.a.), Anzahl der Inneinanndergesch. Ausf.
	      // [0<=x<=1] Mischung Textur oder Oberflche, Abstand von Obj zu Obj,
	      // Durchmesser der Objekte, Richtung, Anfangspunkt
	      tx3d = text3d = new texture3d (NULL, dx, dy, tu, art, v[1], v[2],
		       vector (v[3], v[4], v[5]), vector (v[6], v[7], v[8]),
		   color (v[9], v[10], v[11]), color (v[12], v[13], v[14]));
	    }
	  else
	    {
	      tx3d = new texture3d (tx3d, dx, dy, tu, art, v[1], v[2],
		       vector (v[3], v[4], v[5]), vector (v[6], v[7], v[8]),
		   color (v[9], v[10], v[11]), color (v[12], v[13], v[14]));
	    }
	  break;		//TEXTURE3D

	case MUSTER:
	  cout << "Muster gelesen\n";
	  fscanf (D, "%u %u %u %f %f %f %f %f %f %f %f %f\n",
		  &dx, &dy, &tu, &x1, &x, &y, &v[0], &v[1], &v[2], &v[3], &v[4], &v[5]);
	  satz++;
	  if (mustp == NULL)
	    {
	      // Zeiger auf Vorgnger, Muster Nr, Musterart, Randomfehler, Mix
	      // x y Bereich der Wiederholung, Grundfarbe1, Grundfarbe2,
	      mx = mustp = new muster (NULL, dx, dy, tu, x1, x, y,
			color (v[0], v[1], v[2]), color (v[3], v[4], v[5]));
	    }
	  else
	    {
	      mx = new muster (mx, dx, dy, (bool) tu, x1, x, y,
			color (v[0], v[1], v[2]), color (v[3], v[4], v[5]));
	    }
	  break;		// Muster

	case WAVE:
	  cout << "Welle gelesen\n";
	  // Nummer, Anzahl der Wellen lesen
	  fscanf (D, "%u %u\n", &dy, &dx);
	  satz++;

	  if (wavep == NULL)
	    {
	      // Zeiger auf Vorgnger, Nummer der Welle
	      wx = wavep = new wave (NULL, dy);
	    }
	  else
	    {
	      wx = new wave (wx, dy);
	    }

	  for (dy = 0; dy < dx; dy++)
	    {
	      // Mittelpunkt, Frequenz [G], Amplitude [0.0<=a<=1.0], 
	      // Dmpfung [0.0<=d<=1.0], Lnge d
	      fscanf (D, "%f %f %f %f %f %f %f\n",
		      &v[0], &v[1], &v[2], &v[3], &v[4], &v[5], &v[6]);
	      satz++;
	      wx->setwave (vector (v[0], v[1], v[2]), v[3], v[4], v[5], v[6]);
	    }

	  break;		// WAVE

	case COVER:
	  cout << "Oberflchenstruktur gelesen\n";
	  if ((tx == NULL) && (wx == NULL) && (mx == NULL))
	    {
	      cerr << "Vor \"cover\" mu ein Objekt und eine Texture oder Wave oder Muster definiert sein!\n";
	      exit (1);
	    }
	  else
	    {
	      // Lese Textur fr Farbnderung
	      // Textur Nr., Textur zur N-Vektornderung, Viereck in Map
	      fscanf (D, "%u %u %u %u %f %f %f %f\n", &map, &dx, &t1, &t2, &x1, &x2, &y1, &y2);
	      satz++;

	      // richtigen Texurepointer suchen
	      scantexture(&tn, text, map);
	      scantexture(&tp, text, dx);
	      scantexture(&ts, text, t1);
	      scantexture(&tb, text, t2);

	      // Lese Muster fr Oberflchenfarbe, Muster fr Vektornderung, Verschiebung
	      fscanf (D, "%u %u %u %u %f %f\n", &map, &dx, &t1, &t2, &x, &y);
	      satz++;

	      scanmuster(&mp,  mustp, map);
	      scanmuster(&mp2, mustp, dx);
	      scanmuster(&ms,  mustp, t1);
	      scanmuster(&mb,  mustp, t2);

	      // Lese Parameter fr Turbolenzen
	      // 1. Parameter 0=keine 1=Musterverwischen 2=Mischung der Farbe 3=Beides, Farbe
	      // 2. Parameter -''- , nderung der Normalvektros
	      // 3. Parameter Anzahl der Frequenzen
	      // 4. Parameter Scalierung der Turbolenz
	      fscanf (D, "%u %u %u %f\n", &tu, &dy, &dx, &z);
	      satz++;

	      // Lese Nummer der Welle
	      fscanf (D, "%u\n", &wl);
	      satz++;
	      // ermittle Pointer
	      if (wl == 0)
		wp = NULL;
	      else
		{
		  wp = wavep;
		  while ((wp != NULL) && (wp->num != wl))
		    wp = wp->next;
		}

	      // Lese 3D - Textur fr Farbnderung
	      // Textur Nr.
	      fscanf (D, "%u\n", &map3d);
	      satz++;
	      // richtigen Texurepointer suchen
	      if (map3d == 0)
		tn3d = NULL;
	      else
		{
		  tn3d = text3d;
		  while ((tn3d != NULL) && (tn3d->num != map3d))
		    tn3d = tn3d->next;
		}

	      // erzeuge Cover, generiere Covernummer! Reihenfolge ist entscheident!!!
	      if (coverl == NULL)
		{
		  // erstes Objekt  definieren
		  cp = coverl = new cover (NULL, ++covernr, x1, y1, x2, y2, 
					   tn, tp, ts, tb,
					   vector (x, y, 0.0),
					   mp, mp2, ms, mb,
					   tu, dx, z, dy, wp, tn3d);
		}
	      else
		{
		  cp = new cover (cp, ++covernr, x1, y1, x2, y2, 
				  tn, tp, ts, tb,
				  vector (x, y, 0.0),
				  mp, mp2, ms, mb,
				  tu, dx, z, dy, wp, tn3d);
		}
	    }
	  break;		//COVER

	case YBUFFER:
	  cout << "Y-Puffer gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;
	  // Vectoren definieren
	  fscanf (D, "%f %f %f\n", &v[0], &v[1], &v[2]);
	  satz++;
	  fscanf (D, "%f %f %f\n", &v[3], &v[4], &v[5]);
	  satz++;
	  fscanf (D, "%f %f %f\n", &v[6], &v[7], &v[8]);
	  satz++;
	  fscanf (D, "%f %f %f\n", &v[9], &v[10], &v[11]);
	  satz++;

	  // Raster definieren
	  fscanf (D, "%u %u\n", &dx, &dy);
	  satz++;

	  ybu = new ybuffer (v, dx, dy,
			     &objekt, &ox, &nextsp, NULL,
			 r, g, b, e, mat, sp, du, dif, spec, high, vel, ch);
	  // Hhen lesen
	  for (zy = 0; zy < dy; zy++)
	    {
	      for (zx = 0; zx < dx; zx++)
		{
		  fscanf (D, "%f", &x);
		  ybu->ybuf[zy * dx + zx] = x;
		}
	      fscanf (D, "\n");
	      satz++;
	    }
	  ybu->maketri ();

	  // wenn Dreiecke erzeugt sind, Y-Puffer wieder lschen
	  delete ybu;

	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }

	  break;		// YBUFFER
	  /*
	case BEZIER:
	  cout << "Bezier gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;

	  pbezier = new bezier (&ox, &objekt, &nextsp, ch,
			     r, g, b, e, mat, sp, du, dif, spec, high, vel);
	  // lese anz x, anz z, approx, order
	  fscanf (D, "%d %d\n", &dx, &dy);
	  satz++;

	  for (zy = 0; zy < 4; zy++)
	    {
	      for (zx = 0; zx < 4; zx++)
		fscanf (D, "%f %f %f ", &bpuf[zx][zy].x, &bpuf[zx][zy].y, &bpuf[zx][zy].z);
	      fscanf (D, "\n");
	      satz++;
	    }
	  cerr << "Bezier Matrix gelesen\n";

	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &map);
	  satz++;

	  if (map != 0 && ch == 'N')
	    // Zeiger aussuchen
	    for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	  else
	    cx = NULL;

	  pbezier->init (cx, dx, dy, bpuf);

	  delete pbezier;
	  break;		// Bezier
	  */

	case POLYGON:
	  cout << "Polygon gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;

	  if (objekt == NULL)
	    {
	      // erstes Objekt  definieren
	      ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				     NULL, POLYGON, NONE);
	    }
	  else
	    {
	      if (ch == 'N')
		{
		  // kein Schnittkrper
		  ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				NULL, POLYGON, NONE);
		}
	      else
		{
		  // Schnittkrper erzeugen
		  nextsp = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				  NULL, POLYGON, (ch == 'S') ? SCHN : DIFF);
		  // Schnittkrper einfgen
		  ox->sobj (nextsp);
		  ((polygon *) (nextsp->grobjp))->ebene = true;
		}
	    }
	  // Vectoren definieren
	  fscanf (D, "%u\n", &dx);
	  satz++;		// Anzahl der Vektoren lesen

	  cout << "lese Vektoren " << dx << "\n";
	  for (dy = 0; dy < dx; dy++)
	    {
	      fscanf (D, "%f %f %f\n", &x, &y, &z);
	      satz++;
	      if (ch == 'N')
		((polygon *) (ox->grobjp))->setvector (dy, vector (x, y, z));
	      else
		((polygon *) (nextsp->grobjp))->setvector (dy, vector (x, y, z));
	    }

	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }
	  break;		// POLYGON

	case SPHERE:
	  cout << "Kugel gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;

	  nextsp = NULL;
	  if (objekt == NULL)
	    {
	      // erstes Objekt  definieren
	      ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				     NULL, SPHERE, NONE);
	    }
	  else
	    {
	      if (ch == 'N')
		{
		  // kein Schnittkrper
		  ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel, NULL, SPHERE, NONE);
		}
	      else
		{
		  // Schnittkrper erzeugen
		  nextsp = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				    NULL, SPHERE, (ch == 'S') ? SCHN : DIFF);
		  // Schnittkrper einfgen
		  ox->sobj (nextsp);
		}
	    }
	  // Mittelpunkt
	  fscanf (D, "%f %f %f %f %f %f\n",
		  &x, &y, &z, &r, &a, &b);
	  satz++;		// Mittelpunkt r alpha beta

	  if (ch == 'N')
	    ((sphere *) (ox->grobjp))->setsphere (vector (x, y, z), r, a, b);
	  else if (nextsp != NULL)
	    ((sphere *) (nextsp->grobjp))->setsphere (vector (x, y, z), r, a, b);
	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }
	  break;		// SPHERE

	case PATCHOBJ:
	  cout << "Patchobj gelesen";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;

	  nextsp = NULL;
	  if (objekt == NULL)
	    {
	      // erstes Objekt  definieren
	      ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				     NULL, PATCHOBJ, NONE);
	    }
	  else
	    {
	      if (ch == 'N')
		// kein Schnittkrper
		ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel, 
			      NULL, PATCHOBJ, NONE);
	      else
		cerr << "Patchobj kann noch nicht als Schnittkrper verwendet werden!\n";
	      
	    }
	  
	  // Anzahl der Patches lesen
	  fscanf (D, "%u %f\n", &dx, &g);
	  satz++;

	  for (dy=0; dy<dx; dy++)
	    {
	      cout << ".";
	      // Mittelpunkt, Normalvektor lesen
	      fscanf(D, "%f %f %f %f %f %f\n", &x, &y, &z, &r, &a, &b);
	      ((patchobj *) (ox->grobjp))->
		setpatch(vector (x, y, z), vector(r, a, b));
	    }
	  cout << "\n";

	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }

	  patcharray *pt;
	  // da nicht mit Schnittkrpern gearbeitet wird geht das auch hier
	  pt = ((patchobj *) (ox->grobjp))->createpatch(g, true, ox);
	  pt->bilde_at();
	  break;		// PATCHOBJ

	case ELIPSOID:
	  cout << "Elipsoid gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;

	  if (objekt == NULL)
	    {
	      // erstes Objekt  definieren
	      ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				     NULL, ELIPSOID, NONE);
	    }
	  else
	    {
	      if (ch == 'N')
		{
		  // erstes Objekt  definieren
		  ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				NULL, ELIPSOID, NONE);
		}
	      else
		{
		  // Schnittkrper erzeugen
		  nextsp = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				 NULL, ELIPSOID, (ch == 'S') ? SCHN : DIFF);
		  // Schnittkrper einfgen
		  ox->sobj (nextsp);
		}
	    }
	  // Mittelpunkt, abc Sehnen, xyz Winkel
	  fscanf (D, "%f %f %f %f %f %f %f %f %f\n",
		  &x, &y, &z, &a, &b, &c, &r, &g, &bl);
	  satz++;		// Mittelpunkt a,b,c Radien

	  if (ch == 'N')
	    ((elipsoid *) (ox->grobjp))->setelip (vector (x, y, z), vector (r, g, bl), vector (a, b, c));
	  else if (nextsp != NULL)
	    ((elipsoid *) (nextsp->grobjp))->setelip (vector (x, y, z),
				       vector (r, g, bl), vector (a, b, c));
	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }
	  break;		// ELIPSOID

	case CONE:
	  cout << "Zylinder gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
		  &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;

	  if (objekt == NULL)
	    {
	      // erstes Objekt  definieren
	      ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				     NULL, CONE, NONE);
	    }
	  else
	    {
	      if (ch == 'N')
		{
		  // erstes Objekt  definieren
		  ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel, NULL, CONE, NONE);
		}
	      else
		{
		  // Schnittkrper erzeugen
		  nextsp = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				    NULL, CONE, (ch == 'S') ? SCHN : DIFF);
		  // Schnittkrper einfgen
		  ox->sobj (nextsp);
		}
	    }
	  // Punkt1, Punkt2, Radius, Drehungwinkel der Texture
	  fscanf (D, "%f %f %f %f %f %f %f %f %f\n",
		  &x, &y, &z, &a, &b, &c, &r1, &r2, &x1);	// Mittelpunkt a,b,c Radien

	  satz++;
	  if (ch == 'N')
	    ((cone *) (ox->grobjp))->setcone (vector (x, y, z), vector (a, b, c), r1, r2, x1);
	  else if (nextsp != NULL)
	    ((cone *) (nextsp->grobjp))->setcone (vector (x, y, z),
					      vector (a, b, c), r1, r2, x1);
	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }
	  break;		// Zylinder

	case TORUS:
	  cout << "Torus gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;
	  if (objekt == NULL)
	    {
	      // erstes Objekt  definieren
	      ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				     NULL, TORUS, NONE);
	    }
	  else
	    {
	      if (ch == 'N')
		{
		  // erstes Objekt  definieren
		  ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel, 
				NULL, TORUS, NONE);
		}
	      else
		{
		  // Schnittkrper erzeugen
		  nextsp = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				    NULL, TORUS, (ch == 'S') ? SCHN : DIFF);
		  // Schnittkrper einfgen
		  ox->sobj (nextsp);
		}
	    }
	  // Punkt1, Radius1, Radius2, Winkel
	  fscanf (D, "%f %f %f %f %f %f %f %f\n",
		  &x, &y, &z, &a, &b, &r, &g, &bl);
	  satz++;		// Mittelpunkt, a,b Radien, Winkel

	  if (ch == 'N')
	    ((torus *) (ox->grobjp))->settorus (vector (x, y, z), a, b, vector (r, g, bl));
	  else if (nextsp != NULL)
	    ((torus *) (nextsp->grobjp))->settorus (vector (x, y, z), a, b, vector (r, g, bl));
	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }
	  break;		// Torus

	case BLOCK:
	  cout << "Block gelesen\n";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;
	  if (objekt == NULL)
	    {
	      // erstes Objekt  definieren
	      ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				     NULL, BLOCK, NONE);
	    }
	  else
	    {
	      if (ch == 'N')
		{
		  // erstes Objekt  definieren
		  ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				NULL, BLOCK, NONE);
		}
	      else
		{
		  // Schnittkrper erzeugen
		  nextsp = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				    NULL, BLOCK, (ch == 'S') ? SCHN : DIFF);
		  // Schnittkrper einfgen
		  ox->sobj (nextsp);
		}
	    }
	  cout << "lese 8 Vektoren\n";
	  for (dy = 0; dy < 8; dy++)
	    {
	      fscanf (D, "%f %f %f\n", &x, &y, &z);
	      satz++;
	      if (ch == 'N')
		((block *) (ox->grobjp))->setvector (dy, vector (x, y, z));
	      else
		((block *) (nextsp->grobjp))->setvector (dy, vector (x, y, z));
	    }
	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }
	  break;		// Block

	case STAR:
	  /*
	     Fr die Sonne sunlamp - Datentyp erzeugen und
	     in posplanet dann gezielt die Lichtquelle nach der Uhrzeit
	     aendern!!!
	   */
	  cout << "Stern gelesen ";
	  fscanf (D, "%f %f %f %f %f %f %f %f %f %f %f %c\n",
	     &r, &g, &b, &e, &mat, &sp, &du, &dif, &spec, &high, &vel, &ch);
	  satz++;

	  // Drehung xw, yw, zw und nummer
	  fscanf (D, "%u %f %f %f\n", &dx, &r1, &r2, &c);
	  satz++;

	  switch (dx)
	    {
	    case ERDE:
	      cout << "Erde wird nicht dargestellt!\n";
	      break;
	    case SONNE:	// Lichtquelle ist Sonne

	      cout << "Sonne gelesen\n";
	      if (lampe == NULL)
		{
		  lx = lampe = new lamp (NULL,
					 0.0, 0.0, r1 - r2 * 2,		// Entfernung zum Ursprung
					  r, g, b,	// [0<=x<=1] Farbe 1 1 1 ist Wei
					  c, SUNLAMP);	// [ 0<=i<=1 ] Lichtstrke

		}
	      else
		{
		  lx = new lamp (lx, 0.0, 0.0, r1 - r2 * 2, r, g, b, c, SUNLAMP);
		}
	      // Kein break, trotzdem noch Sonne als Kugel erzeugen!
	      // break;

	    default:
	      // Ein Stern ist eine Kugel mit festgeschriebenen Eingenschaften
	      if (objekt == NULL)
		{
		  // erstes Objekt  definieren
		  ox = objekt = new obj (NULL, r, g, b, e, mat, sp, du, dif, spec, high, vel,
					 NULL, STAR, NONE);
		}
	      else
		{
		  // erstes Objekt  definieren
		  ox = new obj (ox, r, g, b, e, mat, sp, du, dif, spec, high, vel,
				NULL, STAR, NONE);
		}

	      ((star *) (ox->grobjp))->setstar (dx, r1, r2);

	      if (dx <= SONNE)
		cout << planetenname[dx - 1] << "\n";
	      else
		cout << "Planet nicht definiert!\n";
	    }			// switch

	  // Nummer des Covers lesen
	  fscanf (D, "%u\n", &dx);
	  satz++;
	  if (dx != 0 && ch == 'N')
	    {
	      // Zeiger aussuchen
	      for (cx = coverl; cx && (cx->nr != dx); cx = cx->next);
	      // Cover setzen
	      ox->coverp = cx;
	    }
	  break;
	}
    }				// while

  fclose (D);

  // erzeuge Baumstruktur
  gentree ();
}

void world::
gentree (void)
{

  // generiere Baumstruktur, ermittele grte Ausdehnung
  vector max (0, 0, 0);
  vector min (0, 0, 0);
  vector v1, v2, nv1 (0, 0, 0), nv2 (0, 0, 0);

  longint anz = 0;
  obj *ox = objekt;

  // min und max auf 1. Objekt setzen
  // Ausnahme bildet STAR, die Sterne werden in der Wurzel eingeordnet
  // und immer getestet!
  if (ox != NULL)
    ox->grobjp->testgrobj (&min, &max, nv1, nv2);

  while (ox != NULL)
    {
      anz++;
      ox->grobjp->testgrobj (&v1, &v2, nv1, nv2);

      if (v1.x < min.x)
	min.x = v1.x;
      if (v1.y < min.y)
	min.y = v1.y;
      if (v1.z < min.z)
	min.z = v1.z;
      if (v2.x > max.x)
	max.x = v2.x;
      if (v2.y > max.y)
	max.y = v2.y;
      if (v2.z > max.z)
	max.z = v2.z;
      ox = ox->next;
    }

  // fr Testzwecke
  ox = objekt;
  anz = 0;
  while (ox != NULL)
    {
      anz++;
      ox = ox->next;
    }
  cout << "Anzahl der Objekte = " << anz << "\n";

  // Baum erzeugen, wird nur fr jede Szene 1x gebildet!
  ptree = new tree (min, max, objekt);

  // fr Testzwecke, Ausgabe
  anz = 1L;
  ptree->print (&anz);
}

// Datenmodell der knstliche Welt
world::~world ()
{
  delete text;
  delete mustp;
  delete wavep;
  delete coverl;		// Covers

  delete lampe;			// Lichtquellen

  delete strahler;		// Strahler

  delete lichtpolyp;		// Flchenlicht

  delete text3d;		// 3D-Texture

  delete ptree;			// Baum
  //delete objekt;   // Objekte, werden mit ptree freigegeben

}
