
/*
   Wellen als Oberflche
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ray.H"

void wave::
setwave(vector M, float F, float A, float D, float De)
{
  // Liste aufbauen
  if (w == NULL)
    wl = w = new welle(NULL, M, F, A, D, De);
  else
    wl = new welle(wl, M, F, A, D, De);
  // allocerror(wl);
}

// liefert den Normalvektor der Welle
void wave::
getnorm(vector * norm, vector i)
{
  float x;
  vector r, winkel = vector(0, 0, 0);
  welle *wp;

  // Alle Wellen aufaddieren
  for (wp = w; wp; wp = wp->next)
    {
      // X-Achse der Welle
      x = i || wp->m;

      // Dmpfung                     Kehrwert
      // d = damping(0.0, wp->d, x) * ((wp->de < eps5)? 1.0 : 1.0/wp->de);

      // Richtung
      r |= i - wp->m;

      //                    h wellenfunktion
      winkel = r * ((wp->a * sin(x * wp->f)) * pi05 *
	   damping(0.0, wp->d, x) * ((wp->de < eps5) ? 1.0 : 1.0 / wp->de));
      // Drehung des Richtungsstrahles
      rotation(norm, i, winkel);
    }
}
