/*
   Modul fr die 2 Pass Methode
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "ray.H"

// Konstruktor
twopass::twopass (word X1, word Y1, word X2, word Y2, word S, word P)
{
  x1 = X1;
  y1 = Y1;
  x2 = X2;
  y2 = Y2;
  s = S;
  p = P;
}

void twopass::calcray(void)
{
  // Einflu der Patches auf die Lichtquellen des Raytracings
  if (pwelt->observ.opixel)
    pray.raytraceboxR(x1, y1, x2, y2, s, p);
  else
    pray.raytracebox(x1, y1, x2, y2, s);
}

void twopass::calcradio (void)
{
  radios r(x1, y1, x2, y2, s, p, pwelt->diff);  // Speicher und init
  r.verteile();  // Strahlung verteilen
}

void twopass::twopasscalc (void)
{
  calcradio ();			// Lichtverteilung nach Radiosity
  calcray ();			// Anzeige nach Raytracing
}

// Methode die die 2Passmethode startet, kein Raytracing, deshalb hier
void ray::calc2pass (word x1, word y1, word x2, word y2, word S, word P)
{
  twopass tp (x1, y1, x2, y2, S, P);	// Speicher und init

  tp.twopasscalc ();
  cout << "Ende 2Pass\n";
}

