/*
   Berechnet Rauschen und Turbolenzen

   Definition in ray.H
   Copyright (C) 1996 Helmut Fahrion

   noise Funktionen aus Literatur:

   - Fotorealismus und Ray Tracing
   Watkins/Coy/Finaly

 */

#include "ray.H"

// Anzahl der Zufallszahlen fr Rauschen

#define TP1          173
#define TP2          263
#define TP3          337
#define TPoint       vector(TP1, TP2, TP3)
#define Tphi	     0.6180339
#define HASH(a,b,c)  (a+b+c & ANZ_TPTS-1)

// Initialisiert Matrix
turbo::turbo()
{
  int x;

  for (x = 0; x < ANZ_TPTS; x++)
    pts[x] = ((float) rand() / (float) RAND_MAX) - 0.5;
}

float turbo::noise_1(vector p)
{
  int xi, yi, zi, xa, xb, ya, yb, za, zb;
  float xf, yf, zf;
  float p000, p100, p010, p110;
  float p001, p101, p011, p111;

  xf = fabs(p.x);
  yf = fabs(p.y);
  zf = fabs(p.z);

  xi = (int) xf;
  xa = (int) (TP1 * (xi * Tphi - (int) (xi * Tphi)));
  xb = (int) (TP1 * ((xi + 1) * Tphi - (int) ((xi + 1) * Tphi)));

  yi = (int) yf;
  ya = (int) (TP2 * (yi * Tphi - (int) (yi * Tphi)));
  yb = (int) (TP2 * ((yi + 1) * Tphi - (int) ((yi + 1) * Tphi)));

  zi = (int) zf;
  za = (int) (TP3 * (zi * Tphi - (int) (zi * Tphi)));
  zb = (int) (TP3 * ((zi + 1) * Tphi - (int) ((zi + 1) * Tphi)));

  p000 = pts[HASH(xa, ya, za)];
  p001 = pts[HASH(xa, ya, zb)];
  p010 = pts[HASH(xa, yb, za)];
  p100 = pts[HASH(xb, ya, za)];
  p011 = pts[HASH(xa, yb, zb)];
  p110 = pts[HASH(xb, yb, za)];
  p101 = pts[HASH(xb, ya, zb)];
  p111 = pts[HASH(xb, yb, zb)];

  xf = xf - xi;
  yf = yf - yi;
  zf = zf - zi;

  /* Weil wir zwischen den Punkten linear interpolieren, mssen wir
     die Linie ein bisschen "verbiegen", um Spline-Interpolation 
     nachzuahmen. Sieht fast so gut aus wie Splines, ist aber
     viel schneller. */

  if (xf > 0.5)
    {
      xf = 1.0 - xf;
      xf = 2.0 * xf * xf;
      xf = 1.0 - xf;
    }
  else
    xf = 2.0 * xf * xf;

  if (yf > 0.5)
    {
      yf = 1.0 - yf;
      yf = 2.0 * yf * yf;
      yf = 1.0 - yf;
    }
  else
    yf = 2.0 * yf * yf;

  if (zf > 0.5)
    {
      zf = 1.0 - zf;
      zf = 2.0 * zf * zf;
      zf = 1.0 - zf;
    }
  else
    zf = 2.0 * zf * zf;

  // Ergebnisse zwischen -0.5 .. x .. 0.5
  return (p000 * (1.0 - xf) * (1.0 - yf) * (1.0 - zf) +
	  p001 * (1.0 - xf) * (1.0 - yf) * zf +
	  p010 * (1.0 - xf) * yf * (1.0 - zf) +
	  p100 * xf * (1.0 - yf) * (1.0 - zf) +
	  p011 * (1.0 - xf) * yf * zf +
	  p110 * xf * yf * (1.0 - zf) +
	  p101 * xf * (1.0 - yf) * zf +
	  p111 * xf * yf * zf);
}

// Punkt, der verrauscht wird; Vektor zurckgeben
void turbo::noise_3(vector p, vector * v)
{
  vector tmp;

  v->x = noise_1(p);    tmp = p + TPoint;
  v->y = noise_1(tmp);  tmp += vector(TP2, TP3, TP1);
  v->z = noise_1(tmp);
}

// Punkt, der verrauscht wird; Vektor zurckgeben
void turbo::dnoise_3(vector p, vector * v)
{
  float center;

  center = noise_1(p);
  v->x = (noise_1(vector(p.x + 0.1, p.y, p.z)) - center) * 10.0;
  v->y = (noise_1(vector(p.x, p.y + 0.1, p.z)) - center) * 10.0;
  v->z = (noise_1(vector(p.x, p.y, p.z + 0.1)) - center) * 10.0;
}

// Eingabepunkt, wird verndert; Max. Anzahl der Ebenen
float turbo::getgturbo(vector p)
{
  float result = 0.0;
  int i;

  for (i = 0; i < lvl; i++)
    {
      result += noise_1(p) / (float) (1 << i);
      p *= 2.0;
    }

  return fabs(result);
}

// Eingabepunkt, wird verndert; Rckgabevektor; Max. Anzahl der Ebenen
vector turbo::getturbo(vector p)
{
  vector v(0,0,0), c;
  int i;

  for (i = 0; i < lvl; i++)
    {
      if (!noise) noise_3(p, &c);
      else  	 dnoise_3(p, &c);

      c *= 1.0 / (float) (1 << i);
      v += c;
      p *= 2.0;
    }
  return v;
}


