/*
   Baum - Datenstruktur fr raytracer.
   Begrenzungsflchen als Kugeln definiert.
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ray.H"

// Konstruktor (R)
tree::tree (vector p1, vector p2, obj * no)
{
  byte x;
  longint bleib, neu;
  vector nv1, nv2, m, min, max;

  obj *obln, *oblo, *ox;

  // init
  o = no;			// alle Objs

  v1 = p1;
  v2 = p2;

  // Teste ob Begrenzungskrper verkleinert werden kann
  // dadurch gibt es keine leeren Boxen mehr, und eine Verringerung
  // des berschneidens!
  ox = o;
  if (ox != NULL)
    ox->grobjp->testgrobj (&min, &max, v1, v2);		// 1. Definieren

  anzobj = 0L;
  while (ox != NULL)
    {
      anzobj++;
      ox->grobjp->testgrobj (&nv1, &nv2, v1, v2);

      if (nv1.x < min.x)
	min.x = nv1.x;
      if (nv1.y < min.y)
	min.y = nv1.y;
      if (nv1.z < min.z)
	min.z = nv1.z;
      if (nv2.x > max.x)
	max.x = nv2.x;
      if (nv2.y > max.y)
	max.y = nv2.y;
      if (nv2.z > max.z)
	max.z = nv2.z;
      ox = ox->next;
    }
  // neue Gre setzen
  v1 = min;
  v2 = max;

  // Begrenzungskugel definieren
  m = (v2 - v1) / 2.0;
  vect = v1 + m;
  radius = abs (m);

  // die neuen Wrfel berechnen
  for (x = 0; x < 8; x++)
    {
      newpol (&nv1, &nv2, x);	// neues Begrenzungsvolumen

      testobj (&bleib, &neu, nv1, nv2);
      // if ((neu >= MIN_OBJ) && (bleib > MIN_OBJ)) // berechnet die Anzahl
      if (neu >= MIN_OBJ)
	{
	  newobj (&obln, &oblo, nv1, nv2);	// neue Liste

	  o = oblo;		// briggebliebenen

	  anzobj = bleib;
	  t[x] = new tree (nv1, nv2, obln);
	}
      else
	t[x] = NULL;
    }
}

// der gleiche Algogithmus wie bei der Kugel
// jedoch der Treffpunkt und der Normalvektor brauchen
// nicht berechnet werden!
bool tree::
hit_object (vector point, vector dir)
{
  float t1, t2;			// Platzhalter

  vector v0 = vect - point;
  vector v1 = dir;

  return
    (solve_quad (v1.x * v1.x + v1.y * v1.y + v1.z * v1.z,	// A 
		  (v0.x * v1.x + v0.y * v1.y + v0.z * v1.z) * 2.,	// B
		  v0.x * v0.x + v0.y * v0.y + v0.z * v0.z - radius * radius,	// C
		  &t1, &t2)) ? true : false;
}

void tree::
print (longint * blatt)
{
  byte x;
  longint anz;
  obj *ob;

  // Objekte zhlen
  ob = o;
  anz = 0L;
  while (ob)
    {
      anz++;
      ob = ob->next;
    }

  if (anz > 0)
    cerr << (int) anz << " Objekte im Blatt " << (int) *blatt << ".\n";
  else
    // alle in kleinere Kugelbernommen
    cerr << "keine Objekte im Blatt " << (int) *blatt << ".\n";

  // rekursiv den Baum durchsuchen
  for (x = 0; x < 8; x++)
    if (t[x])
      {
	*blatt += 1;
	t[x]->print (blatt);
      }
}

void tree::
testobj (longint * entf, longint * neu, vector p1, vector p2)
{
  vector d1, d2;
  obj *ob = o;			// Komplette Liste des Vorgngers

  // dummy
  d1 = d2 = vector (0, 0, 0);

  // Durchlaufe Liste
  *neu = *entf = 0L;
  while (ob != NULL)
    {
      if (ob->grobjp->testgrobj (&d1, &d2, p1, p2))
	*neu += 1;		// Achtung Zeiger!

      else
	*entf += 1;
      ob = ob->next;
    }
}


// bildet eine neue Objektliste und entfernt die bernommenen aus
// der alten Liste
void tree::
newobj (obj ** obn, obj ** obo, vector p1, vector p2)
{
  vector d1, d2;
  byte objin = false;

  obj *ob = o;			// Komplette Liste des Vorgngers

  obj *obnn = NULL;		// mit leerer Liste beginnen

  obj *obon = NULL;

  *obn = NULL;
  *obo = NULL;
  d1 = d2 = vector (0, 0, 0);

  // Durchlaufe Liste
  while (ob)
    {
      objin = ob->grobjp->testgrobj (&d1, &d2, p1, p2);
      // Wenn ja, Objekt in neue Liste einketten und in alter lschen
      if (objin)
	{
	  if (obnn == NULL)
	    {
	      *obn = ob;	// erstes anketten

	      obnn = ob;
	      ob = ob->next;	// ob ausklinken

	      obnn->next = NULL;	// Endekennung

	    }
	  else
	    {
	      obnn->next = ob;	// letztes einklinken

	      ob = ob->next;	// ob ausklinken

	      obnn = obnn->next;	// Zeiger auf letztes

	      obnn->next = NULL;
	    }
	}
      else
	{
	  // zurckbleibende einketten
	  if (obon == NULL)
	    {
	      *obo = ob;
	      obon = ob;
	      ob = ob->next;
	      obon->next = NULL;
	    }
	  else
	    {
	      obon->next = ob;
	      ob = ob->next;
	      obon = obon->next;
	      obon->next = NULL;
	    }
	}
    }
}

// bildet neuen Wrfel je nach Nummer
void tree::
newpol (vector * p1, vector * p2, char x)
{
/*
+   Definition der 8 Punkte des neuen Wrfels
+
+      8         7
+      +--------+
+     /|       /|
+    / |      / |
+  4+--------+3 |
+   |  +-----|--+
+   | / 5    | / 6
+   |/       |/
+   +--------+
+  1          2
+
*/

  switch (x)
    {
    case 0:
      *p1 = v1;
      *p2 = vector ((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      break;
    case 1:
      *p1 = vector ((v1.x + v2.x) / 2.0, v1.y, v1.z);
      *p2 = vector (v2.x, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      break;
    case 2:
      *p1 = vector ((v1.x + v2.x) / 2.0, v1.y, (v1.z + v2.z) / 2.0);
      *p2 = vector (v2.x, (v1.y + v2.y) / 2.0, v2.z);
      break;
    case 3:
      *p1 = vector (v1.x, v1.y, (v1.z + v2.z) / 2.0);
      *p2 = vector ((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, v2.z);
      break;
    case 4:
      *p1 = vector (v1.x, (v1.y + v2.y) / 2.0, v1.z);
      *p2 = vector ((v1.x + v2.x) / 2.0, v2.y, (v1.z + v2.z) / 2.0);
      break;
    case 5:
      *p1 = vector ((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, v1.z);
      *p2 = vector (v2.x, v2.y, (v1.z + v2.z) / 2.0);
      break;
    case 6:
      *p1 = vector ((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      *p2 = v2;
      break;
    case 7:
      *p1 = vector (v1.x, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      *p2 = vector ((v1.x + v2.x) / 2.0, v2.y, v2.z);
    }
}
