/*
   Ein einfacher Torus als Krper.
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"

bool torus::in_obj(vector mp)
{
  vector r0 = m - mp;
  rotation(&r0, VNULL, w);
  return hit_in(r0, d * d, r0.x * r0.x, r0.y * r0.y, r0.z * r0.z, r * r);
}

// Oberflchenfarbe
patcharray *torus::createpatch(float Min, bool Schn, obj * grobj)
 {
  pp = new patcharray(Min, Schn, grobj, d, r, m, w);
  return pp;
}

void torus::surfaceCol(color * col, vector intpoint, cover * cp, byte art)
{
  vector i, t;
  float x, y, alpha;

  texture *tp=NULL;
  muster  *mp=NULL;

  switch (art)
    {
      case NORMALTXT:
	tp = cp->textcp;
	mp = cp->musterp;
	break;
      case VECTORTXT:
	tp = cp->textvp;
	mp = cp->musterp2;
	break;
      case SPIEGTXT:
	tp = cp->textsp;
	mp = cp->mustersp;
	break;
      case BRECHTXT:
	tp = cp->textbp;
	mp = cp->musterbp;
	break;
    }

  i = m - intpoint;

  // Verschiebung des Treffpunktes je nach Muster
  if ((cp->tb.tu == 1) || (cp->tb.tu == 3))
    i += cp->tb.getturbo((m - intpoint) * cp->tb.t);

  // Drehen des Koordinatensystems
  rotation(&i, vector(0.0, 0.0, 0.0), w);

  // Nherungsweise bestimmen, reicht fr reine Muster vllig aus
  //y = fabs((i.y+r*pi05) / (pi*r));

  alpha = x = y = 0.0;
  // Quadrant beachten, zuerst die am meisten verwendeten
  if ((i.z < 0.0) && (i.x < 0.0))
    alpha = atan(fabs(i.z / i.x)) + pi;
  else if ((i.z < 0.0) && (i.x > 0.0))
    alpha = pi2 - atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x > 0.0))
    alpha = atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x < 0.0))
    alpha = pi - atan(fabs(i.z / i.x));

  if (alpha > pi2)
    alpha -= pi2;
  x = (alpha * d) / (pi2 * d);	// Abstand in Bezug auf die Gesamtlnge

  t = i;
  // in den Mittelpunkt holen
  t.z = sqrt(t.z * t.z + t.x * t.x) - d;

  // Quadrant beachten, zuerst die am meisten verwendeten
  if ((t.z < 0.0) && (t.y < 0.0))
    y = atan(fabs(t.z / t.y)) + pi;
  else if ((t.z < 0.0) && (t.y > 0.0))
    y = pi2 - atan(fabs(t.z / t.y));
  else if ((t.z > 0.0) && (t.y > 0.0))
    y = atan(fabs(t.z / t.y));
  else if ((t.z > 0.0) && (t.y < 0.0))
    y = pi - atan(fabs(t.z / t.y));

  if (y > pi2)
    y -= pi2;
  y = (y * r) / (pi2 * r);	// Abstand in Bezug auf die Gesamtlnge

  if (tp)
    tp->gettexture(col, x, y, cp, intpoint - m);

  if (mp)
    {
      if ((cp->tb.tu == 2) || (cp->tb.tu == 3))
	mp->mix = cp->tb.getgturbo((m - intpoint) * cp->tb.t);
      mp->getmust(col, cp->musterfp, vector(x, y, 0.0));
    }
  // 3D-Texture / Muster
  if (cp->text3d)
    cp->text3d->gettext(col, cp->musterfp, intpoint - m);
}

bool torus::hit_in(vector r0, float dq, float xq, float yq, float zq, float rq)
{
  vector r1;
  double in[5], out[4], aq, bq, cq;
  int vor[4], x, l, anz;

  r1 |= r0;

  aq = r1.x * r1.x;
  bq = r1.y * r1.y;
  cq = r1.z * r1.z;

  // Torus
  in[0] = (aq + bq + cq) * (aq + bq + cq) / (4.0 * dq);
  in[1] = (r1.x * r0.x + r1.y * r0.y + r1.z * r0.z) * (aq + bq + cq) / dq;
  in[2] = -(aq * (dq + rq - 3.0 * xq - yq - zq) - 4.0 * r1.x * r0.x * 
	    (r1.y * r0.y + r1.z * r0.z)
	    - bq * (dq - rq + xq + 3.0 * yq + zq) + r1.z * (r1.z * 
	  (dq + rq - xq - yq - 3.0 * zq) - 4.0 * r1.y * r0.y * r0.z))
    / (2.0 * dq);
  in[3] = -(r1.x * r0.x * (dq + rq - xq - yq - zq) - r1.y * r0.y * (dq - rq + xq + yq + zq)
	    + r1.z * r0.z * (dq + rq - xq - yq - zq)) / dq;
  in[4] = (dq * dq - 2.0 * dq * (rq + xq - yq + zq) + (rq - xq - yq - zq) * (rq - xq - yq - zq)) / (4.0 * dq);

  // QG Lsen
  anz = solve_quartic(in, out);

  // erzeuge Vorzeichenmatrix
  for (x = 0; x < 4; x++)
    vor[x] = out[x] > 0.0 ? true : false;

  switch (anz)
    {
    case 1:
      return true;
      break;
    case 2:
      l = vor[0] + vor[1];
      if (l == 1)
	return true;
      break;
    case 3:
      l = vor[0] + vor[1] + vor[2];
      if ((l == 1) || (l == 2))
	return true;
      break;
    case 4:
      l = vor[0] + vor[1] + vor[2] + vor[3];
      if ((l == 1) || (l == 3))
	return true;
      break;
    }
  return false;			// 0 oder liegt auerhalb
}

// Treffpunkt
// Eingangswerte: Gerade durche point und dir definiert
// Ausgangswerte: Treffpunkt in int_point falls return true
//                Normalvektor in norma
// Return:        true falls ein Schnittpunk exisitert ansonst false
bool torus::hit_object(vector point, vector dir, bool hitin,
	 vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2)
{
  byte x, y;
  int l;
  double in[5], out[4], dq, aq, bq, cq, xq, yq, zq, t, rq, aqbqcq, drxyz, rxyz, dq2, dq4;
  vector pt, dr, r0, r1;

  // Transformation in Koordinaten des Kegels
  pt = point;
  dr = dir;

  r0 = m - pt;			// neuer Richtungsvektor
  r1 = dr;

  // Drehen des Koordinatensystems in das des Torus, gradercken
  rotation(&r0, VNULL, w);
  rotation(&r1, VNULL, w);

  // Quadrate berechnen
  dq = d * d;
  dq4 = dq*4.0;
  dq2 = dq*2.0;
  aq = r1.x * r1.x;
  bq = r1.y * r1.y;
  cq = r1.z * r1.z;
  aqbqcq = aq + bq + cq;
  xq = r0.x * r0.x;
  yq = r0.y * r0.y;
  zq = r0.z * r0.z;
  rq = r * r;

  drxyz = dq + rq - xq - yq - zq;
  rxyz  = rq - xq - yq - zq;

  // ist point im Torus?
  // ###########################################################
  //if (hitin) if (hit_in(r0, dq, xq, yq, zq, rq)) return false;

  // Torus
  in[0] = aqbqcq * aqbqcq / dq4;

  in[1] = (r1.x * r0.x + r1.y * r0.y + r1.z * r0.z) * aqbqcq / dq;

  in[2] = -(aq * (dq + rq - 3.0 * xq - yq - zq) - 4.0 * r1.x * r0.x *
	    (r1.y * r0.y + r1.z * r0.z) - bq * (dq - rq + xq + 3.0 * yq + zq) +
	    r1.z * (r1.z * (dq + rq - xq - yq - 3.0 * zq) - 4.0 * r1.y * r0.y *
		    r0.z)) / dq2;

  in[3] = -(r1.x * r0.x * drxyz - r1.y * r0.y * (dq - rq + xq + yq + zq) + r1.z * r0.z * 
	    drxyz) / dq;

  in[4] = (dq * dq - dq2 * (rq + xq - yq + zq) + 
	   rxyz*rxyz) / dq4;
	   
  // QG Lsen
  if ((l = solve_quartic(in, out)) != 0)
    {
      // warum ? Fehler wenn eine Lichtquelle in die Nhe kommt fhrt das
      // weglassen dieses Testes zu falschen Schatten!!!
      // Tangiert 
      if (l == 1)
	return false;
      
      else if (l == 2)
	{
	  if ((out[0] > 0) && (out[1] > 0))
	    return false;
	}
      else if (l == 3)
	{
	  if ((out[0] > 0) && (out[1] > 0) && (out[2] > 0))
	    return false;
	}
      else if (l == 4)
	if ((out[0] > 0) && (out[1] > 0) && (out[2] > 0) && (out[3] > 0))
	  return false;

      switch (l)
	{
	case 1:
	  t= -out[0];
	  break;
	case 2:
	  t = (out[0] > out[1]) ? -out[0] : -out[1]; 
	  break;
	case 3:
	  t = (out[0] > out[1]) ? out[0] : out[1];
	  t = t > out[3] ? -t : -out[3];
	  break;
	default:
	  t = (out[0] > out[1]) ? out[0] : out[1];
	  if (out[2] > t) t = out[2];
	  if (out[3] > t) t = out[3];
	  t = -t;
	}
      
      *int_pt1 = point + (dir * t);
            
      r0 = *int_pt1 - m;	// von Mitte zum Treffpunkt

      r1 = vector(r0.x * (xq + yq + zq - dq - rq) / dq,
		  r0.y * (xq + yq + zq + dq - rq) / dq,
		  r0.z * (xq + yq + zq - dq - rq) / dq);	// Gradiend

      *norm1 |= r0 + r1;	// Richtungsvektor
      
      // 2. Schnittpunkt berechnen
      switch (l)
	{
	case 1:
	  t = out[0];	// Tangiert
	  break;
	case 2:
	  t = out[0];
	  t = (t > out[1]) ? t : out[1];
	  break;
	case 3:
	  for (x = 0; x < 2; x++)
	    for (y = x + 1; y <= 2; y++)
	      if (out[x] > out[y])
		{
		  t = out[x];
		  out[x] = out[y];
		  out[y] = t;
		}
	  t = out[1];
	  break;
	default:
	  for (x = 0; x < 3; x++)
	    for (y = x + 1; y <= 3; y++)
	      if (out[x] > out[y])
		{
		  t = out[x];
		  out[x] = out[y];
		  out[y] = t;
		}
	  t = out[1];
	}

      // Treffpunkt berechnen
      *int_pt2 = point + (dir * fabs(t));
      r0 = *int_pt2 - m;	// von Mitte zum Treffpunkt
      
      r1 = vector(r0.x * (xq + yq + zq - dq - rq) / dq,
		  r0.y * (xq + yq + zq + dq - rq) / dq,
		  r0.z * (xq + yq + zq - dq - rq) / dq);	// Gradiend
      
      *norm2 |= r0 + r1;	// Richtungsvektor
    }
  else
    return false;
  return true;
}

bool torus::testgrobj(vector * p1, vector * p2, vector nv1, vector nv2)
{
  float r2;

  r2 = d + r;

  // aus einem Torus wird eine Kugel gemacht
  *p1 = m - vector(r2, r2, r2);
  *p2 = m + vector(r2, r2, r2);

  // Test ob reinpasst
  if ((nv1.x <= p1->x && nv1.y <= p1->y && nv1.z <= p1->z) &&
      (nv2.x >= p2->x && nv2.y >= p2->y && nv2.z >= p2->z))
    return true;
  else
    return false;
}

bool torus::getpoints(vector * v1, longint x)
{
  float t = d + r + eps2;


  if ((x >= 1) && (x <= 15))
    {
      switch (x)
	{
	case 1:
	  *v1 = m + vector(0, 0, 0);
	  break;
	case 2:
	  *v1 = m + vector(0, 0, t);
	  break;
	case 3:
	  *v1 = m + vector(0, t, 0);
	  break;
	case 4:
	  *v1 = m + vector(t, 0, 0);
	  break;
	case 5:
	  *v1 = m + vector(0, t, t);
	  break;
	case 6:
	  *v1 = m + vector(t, t, 0);
	  break;
	case 7:
	  *v1 = m + vector(t, 0, t);
	  break;
	case 8:
	  *v1 = m + vector(t, t, t);
	  break;
	case 9:
	  *v1 = m - vector(0, 0, t);
	  break;
	case 10:
	  *v1 = m - vector(0, t, 0);
	  break;
	case 11:
	  *v1 = m - vector(t, 0, 0);
	  break;
	case 12:
	  *v1 = m - vector(0, t, t);
	  break;
	case 13:
	  *v1 = m - vector(t, t, 0);
	  break;
	case 14:
	  *v1 = m - vector(t, 0, t);
	  break;
	case 15:
	  *v1 = m - vector(t, t, t);
	  break;
	}
      return true;
    }
  else
    return false;
}






