/*
    Klasse fr Texturfunktionen
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Copyright (C) 1996, 1997 Helmut Fahrion
*/


#include "ray.H"


void texture::gettexture(color *col, float px, float py, cover * cp, vector tbp)
{
  word tx, ty;
  byte mapx;
  float nmix;

  // Treffpunkt in map
  tx = (word) (px * (float) x);
  ty = (word) (py * (float) y);

  // fr den Fall das ber den Rahmen hinaus geht
  while (tx > x) tx -= x;
  while (ty > y) ty -= y;

  // Farbwert holen 
  mapx = map[(ty - 1) * x + (tx - 1)];

  // ist Turbolenz vorhanden?
  if ((cp->tb.tu == 2) || (cp->tb.tu == 3))
    nmix = cp->tb.getgturbo(tbp * cp->tb.t);
  else
    nmix = mix;

  // rgb wert holen 
  *col = color(col->r * (1.0 - nmix) + (pal[mapx].r) * nmix,
	       col->g * (1.0 - nmix) + (pal[mapx].g) * nmix,
	       col->b * (1.0 - nmix) + (pal[mapx].b) * nmix);
}
