/*
   3D - Texture
   Definition in ray.H
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion

 */

#include "ray.H"

texture3d::texture3d(texture3d * text, word Num, word Objtype, word Anzi, bool Ausf,
	  float Mix, float Abs,
	  vector Gr, vector R, color C1, color C2)
{
  word i;

  next = 0x0;
  // einketten
  if (text)
    text->next = this;
  num = Num;
  objtype = Objtype;
  anzi = Anzi;
  mix = Mix;
  abso = Abs;
  gr = Gr;
  r = R;
  c1 = C1;
  c2 = C2;
  ausfall = Ausf;

  // Ausfall - Array
  if (ausfall)
    for (i = 0; i < 100; i++)
      ausf[i] = (((float) rand() / (float) RAND_MAX) > 0.5) ? 1 : 0;
}


// wird von Obj aufgerufen
void texture3d::
gettext(color * col, vector f, vector p)
{
  color farbe;

  // alle 3D Krper sind mglich
  switch (objtype)
    {
    case KUGELM:
      farbe = sphere(f, p);
      break;			// Kugeln

    case ZYLINDERM:
      farbe = cone(f, p);
      break;			// Zylinder
      // im Fall einer Falschen Nummer

    default:
      *col = c1;
      return;
    }

  // Farbmischung
  *col = color(col->r * (1.0 - mix) + farbe.r * mix,
	       col->g * (1.0 - mix) + farbe.g * mix,
	       col->b * (1.0 - mix) + farbe.b * mix);
}

bool texture3d::
ausfrand(vector v)
{
  word a;

  // Ausflle je Rasterpunkt ?
  a = abs(((int) v.y + 1) * ((int) v.x + 1) * ((int) v.z + 1) + 10);

  // sicher ist sicher
  while (a > 100)
    a /= 10;

  return ausf[a];
}

color texture3d::
sphere(vector f, vector p)
{
  char s;
  float t, r2, abs;
  vector m, v;

  m = f + p;
  rotationVN(&m, r);		// in beliebige Richtung drehen

  m /= gr;			// Vergrern

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(m))
    return c2;

  // Auf Rasterpunkte setzen - Abstand
  v.x = fabs(m.x - (int) (m.x)) - 0.5;
  v.y = fabs(m.y - (int) (m.y)) - 0.5;
  v.z = fabs(m.z - (int) (m.z)) - 0.5;

  t = v.x * v.x + v.y * v.y + v.z * v.z;

  // r - Abstnde berechnen
  abs = 0.5 / (float) anzi;

  // Durchtesten
  for (s = anzi, r2 = 0.0; s > 1; s--)	// fall s == 1 ist normalfall

    {
      r2 += abs;		// Abstand berechnen

      if (t < r2 * r2)		// Pat Punkt rein?

	return (s % 2) ? c1 : c2;	// Gerade? dann c1 sonst c2

    }

  r2 = 0.5 - abso;
  // Kugel, innerhalb oder Auerhalb? r^2=0.25?
  return (t < r2 * r2) ? c1 : c2;
}

color texture3d::
cone(vector f, vector p)
{
  char s;
  float t, r2, abs;
  vector m, v;

  m = f + p;
  rotationVN(&m, r);		// in beliebige Richtung drehen

  m /= gr;			// Vergrern

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(m))
    return c2;

  // Auf Rasterpunkte setzen - Abstand
  v.x = fabs(m.x - (int) (m.x)) - 0.5;
  v.y = fabs(m.y - (int) (m.y)) - 0.5;
  v.z = 1.0;

  t = v.x * v.x + v.y * v.y;	// x^2+y^2-r^2=0

  // r - Abstnde berechnen
  abs = 0.5 / (float) anzi;

  // Durchtesten
  for (s = anzi, r2 = 0.0; s > 1; s--)	// fall s == 1 ist normalfall

    {
      r2 += abs;		// Abstand berechnen

      if (t < r2 * r2)		// Pat Punkt rein?

	return (s % 2) ? c1 : c2;	// Gerade? dann c1 sonst c2

    }

  // Zylinder, innerhalb oder Auerhalb? r^2=0.25?
  r2 = 0.5 - abso;
  return (t < r2 * r2) ? c1 : c2;
}
