/*

   Testprogramm zur Lsung von Gleichungen n-ten Grades.

   g++ test_polynom.C vect.o -lm -o test_polynom
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>
#include "vect.H"


int 
main (void)
{
  int x, order;
  float in[MAX_ORDER + 1], out[MAX_ORDER];

  // Gleichungen n-ten Grades
  printf ("x^n*x1 + x^(n-1)*x2 + x^(n-2)*x3 + ... + xn\n");
  printf (" Order= ");
  scanf ("%i", &order);

  for (x = 0; x < order + 1; x++)
    {
      printf ("x%d = ", x);
      scanf ("%lf", &in[x]);
    }

  if (order == 2)
    x = solve_quad (in[0], in[1], in[2], &out[0], &out[1]);
  else if (order == 3)
    x = solve_cubic (in, out);
  else if (order == 4)
    x = solve_quartic (in, out);
  else if (order > 4)
    x = polysolve (order + 1, in, out);

  printf ("%d Lsungen:\n", x);

  for (x = 0; x < order; x++)
    printf ("x%d = %f\n", x, out[x]);

  return 0;
}
