
char *HILFESTR = "     Das Startprogramm fr den Raytracer\n                Version 0.1\n\nWenn ich %s, \ndas Programm (oder eine darauf basierende \nArbeit) modifiziere oder verbreite, erklre ich \nmein Einverstndnis mit dieser Lizenz und allen \nihren Begriffen und Bedingungen zum Kopieren, \nVerbreiten und Modifizieren des Programms oder \neiner darauf basierenden Arbeit.\n\nThis program ist free software; you can redistribute \nist and/or modify it under the terms of the GNU \nGeneral Public License as publisched by the Free \nSoftware Foundation; either version 2 of the License, \nor (at your opption) any later version.\n\nThis program is distributed in the hope that it well \nbe useful, but WITHOUT ANY WARRANTY; without even the \nimplied warranty of MERCHANTABILITY or FITNESS FOR A \nPARTICULAR PURPOSE. See the GNU General Public License \nfor more details.\n\nYou should have received a copy of the GNU General \nPublic License along with this program; if not, write \nto the Free Software Foundation, Inc., 675 Mass Ave, \nCambridge, MA 02139, USA.\n\nDie GPL finden Sie in der HTML-Dokumentation.\n\nCopyright (C) 1996 Helmut Fahrion\n\nAls Student (ev. bis Januar 1997) bin ich erreichbar \nunter:\n   sfa2002@informatik.htw-dresden.de\n\nIn Verbindung mit dem Softwareprojekt:\n   nazca@vermessung.htw-dresden.de\n\nPost:\n   Helmut Fahrion jun.\n   An der Wyhra 35\n   04552 Borna\n   Germany\n";

#include <Xm/XmAll.h>		// Motif
#include <stdlib.h>		// system
#include <unistd.h>		// getlogin
#include <pwd.h>
#include <iostream.h>


typedef char *STRING;		// C - String

#ifndef _G_HAVE_BOOL
#define bool    unsigned char
#define true    1
#define false   0
#endif 

typedef enum
  {
    IM_ENDE,
    IM_START, IM_START3D, IM_STARTB, IM_START3DB,
    IM_SHOW, IM_SHOW3D,
    IM_KILL,
    IM_SCENE, IM_DATE,
    IM_DOKU, IM_README, IM_LIZENZ, IM_HINWEIS,
    IM_QSTART, IM_QOK
  };

typedef enum
  {
    QB_ENDE, QB_START, QB_SHOW, QB_KILL, QB_EDIT, QB_HILFE, LETZTE_PD
  };

typedef enum
  {
    QB_QSTART, QB_QOK, LETZTE_QUICK
  };

typedef enum
  {
    QB_IM_ENDE, LETZTE_ENDE
  };
typedef enum
  {
    QB_IM_START, QB_IM_START3D, QB_IM_STARTB, QB_IM_START3DB, LETZTE_START
  };
typedef enum
  {
    QB_IM_SHOW, QB_IM_SHOW3D, LETZTE_SHOW
  };
typedef enum
  {
    QB_IM_KILL, LETZTE_KILL
  };
typedef enum
  {
    QB_IM_SCENE, QB_IM_DATE, LETZTE_EDIT
  };
typedef enum
  {
    QB_IM_DOKU, QB_IM_README, QB_IM_HINWEIS, LETZTE_HILFE
  };

XtAppContext app;
Widget top, WHelpDialog;

// ***** Kameraposition *****
Widget WPosL, WPosV1, WPosV2;
char posvon[20], posnach[20];

// **** Bildbereich ****
Widget WBildstr;

// **** Scallierung ***
Widget WScalstr;

// **** Pixel ****
Widget WPixelstr;

// **** PatchA ****
Widget WPatchstr;

//  **** Diffuse Reflexion? **** 
bool Diff;


// **** Methode ****
Widget WMethr;
Widget AWButtonD[5];
int Methode;
static int MethodeID[] =
{
  0, 1, 2, 3
};

// **** Optim-Pixel ****
Widget WPixelostr;
// **** EntfA ****
Widget WEntfstr;
// **** Blende ****
Widget WBlendestr;

// **** Methode-Antialiasing ****
Widget WMethalias;
Widget AWButtonaD[3];
int Methodealias;

static int MethodealiasID[] =
{
  0, 1, 2
};

/*  Prototypen */
void helpfiledialog (Widget Parent, char *str);

void 
showhinweis (void)
{
  char text[3072], *un;		/* Puffer fr Text */
  char anonymous[] = "ANONYMOUS";
  struct passwd *pwd;

  if (!(pwd = getpwuid (getuid ())))
    un = anonymous;
  else
    un = pwd->pw_gecos;

  if (!strlen (un))
    un = pwd->pw_name;		/* 0 Lnge in passwd */
  if (!strlen (un))
    un = anonymous;		/* 0 Lnge in passwd */

  sprintf (text, HILFESTR, un);
  helpfiledialog (top, text);
}

void starteditor (char *str)
{
  char xedit[] = "xedit";
  char command[80], *ed;
  char x;

  ed = getenv("EDITOR");

  if (!ed)
    {
      ed = xedit;
      fprintf (stderr, "startm: Bitte setzen sie die Umgebungsvariable EDITOR !\n");
    }

  x = strlen(ed);
  x += strlen(str);
  if (x >= 80)
    fprintf (stderr, "startm: Variable EDITOR ist zu gross!?\n");
  else
    {
      sprintf(command, "%s %s&\n", ed, str);
      system(command);
    }
}

/* Callback function to quit the program. */
void CBquit(Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtDestroyWidget (top);
  exit (0);
}

void 
writeconfig (void)
{
  FILE *D;
  char *str;
  int x, y, e;
  float scale, A;

  char raytracer1[80], bildstr[80], methstr[80], qualistr[80], mstr[10];

  /* schreibe Kommandofile */
  if ((D = fopen ("raytrace_1", "w+")) == NULL)
    {
      fprintf (stderr, "xstart: Fehler beim ffnen der Datei 'raytrace_1'\n
Datei existiert nicht oder keine Schreibrechte!\n");
      return;
      //exit(1);
    }

  str = XmTextGetString (WBildstr);
  sscanf (str, "%dx%d", &x, &y);
  sprintf (bildstr, "x1:0 y1:0 x2:%d y2:%d\n", x, y);
  fprintf (D, bildstr);		/* Weltbild */

  strcpy (raytracer1, bildstr);	/* zur Zeit gleich mit dem Bild */
  fprintf (D, raytracer1);	/* Koordinatenbereich */

  str = XmTextGetString (WScalstr);
  sscanf (str, "%f", &scale);
  str = XmTextGetString (WPixelstr);
  sscanf (str, "%d", &x);
  str = XmTextGetString (WPatchstr);
  sscanf (str, "%f", &A);
  switch (Methode)
    {
    case 0:
      strcpy (mstr, "ZB");
      break;
    case 1:
      strcpy (mstr, "RY");
      break;
    case 2:
      strcpy (mstr, "RD");
      break;
    case 3:
      strcpy (mstr, "RDY");
      break;
    default:
      mstr[0]=0;
      break;
    }
  sprintf (methstr, "x:%0.2f m:%s p:%d a:%f d:%d\n", scale, mstr, x, A, Diff);
  fprintf (D, methstr);

  str = XmTextGetString (WPixelostr);
  sscanf (str, "%d", &x);
  if (!x)
    x = 1;

  str = XmTextGetString (WEntfstr);
  sscanf (str, "%d", &e);
  str = XmTextGetString (WBlendestr);
  sscanf (str, "%d", &y);
  switch (Methodealias)
    {
    case 0:
      strcpy (mstr, "N");
      break;
    case 1:
      strcpy (mstr, "G");
      break;
    case 2:
      strcpy (mstr, "R");
      break;
    }
  sprintf (qualistr, "Meth:%s Pixel:%d Blende:%d Entf:%d\n", mstr, x, y, e);
  fprintf (D, qualistr);

  fclose (D);
}

/* Start button callback function */
void 
startmono (void)
{
  writeconfig ();
  /* Neustart */
  printf ("nice -n 5 raywin 1 0&\n");
  system ("nice -n 5 raywin 1 0&");
}

/* Callback function to quit the program. */
void 
CBstart (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  switch (*(int *) pClientData)
    {
    case IM_START:
      startmono ();
      break;
    case IM_START3D:
      writeconfig ();
      /* Raytrace Links */
      system ("nice -n 5 raywin 1 0&");
      /* Raytrace Rechts */
      system ("nice -n 5 raywin 2 0&");
      break;
    case IM_STARTB:
      Diff = true;
      writeconfig ();
      system ("nohup nice -n 5 raywin 1 1&");
      break;
    case IM_START3DB:
      Diff = true;
      writeconfig ();
      /* Raytrace Links */
      system ("nohup nice -n 5 raywin 1 1&");
      /* Raytrace Rechts */
      system ("nohup nice -n 5 raywin 2 1&");
      break;
    default:
      fprintf (stderr, "Falsche Menue-ID!\n");
    }
}

int 
getanzahl (void)
{
  int anz;
  FILE *D;
  if ((D = fopen ("scene_kameras", "r+")) == NULL)
    {
      fprintf (stderr, "show: Fehler beim ffnen der Datei scene_kameras\n");
      exit (1);
    }
  fscanf (D, "%d\n", &anz);
  fclose (D);
  return anz;
}


/* Callback function to quit the program. */
void 
CBshow (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  char command[40];
  int a = getanzahl ();

  switch (*(int *) pClientData)
    {
    case IM_SHOW:
      sprintf (command, "show 100 0 %d&", a);
      system (command);
      break;
    case IM_SHOW3D:
      sprintf (command, "show 100 1 %d&", a);
      system (command);
      break;
    default:
      fprintf (stderr, "Falsche Menue-ID!\n");
    }
}

/* Callback function to quit the program. */
void 
CBkill (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  // Linux
  //   system("killall raywin");
  system ("killname raywin");
}

/* Callback function to quit the program. */
void 
CBedit (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  switch (*(int *) pClientData)
    {
    case IM_SCENE:
      starteditor("scene");
      break;
    case IM_DATE:
      system("datem&");
      break;
    default:
      fprintf (stderr, "Falsche Menue-ID!\n");
    }
}

/* Callback function to quit the program. */
void 
CBhilfe (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  switch (*(int *) pClientData)
    {
    case IM_DOKU:
      system ("cad_mosaic&");
      break;
    case IM_README:
      system ("cad_liesmich&");
      break;
    case IM_LIZENZ:
      system ("cad_lizenz&");
      break;
    case IM_HINWEIS:
      showhinweis ();
      break;
    default:
      fprintf (stderr, "Falsche Menue-ID!\n");
    }
}

/* Showmono Quickbutton */
void 
showmono (void)
{
  char command[40];
  int a = getanzahl ();
  sprintf (command, "show 100 0 %d&", a);
  system (command);
}

void 
writekamera (void)
{
  char *str;
  FILE *D;
  float px, py, pz, zx, zy, zz;

  /* schreibe Kammerafile */
  if ((D = fopen ("scene_kameras", "w+")) == NULL)
    {
      fprintf (stderr, "xstart: Fehler beim ffnen der Datei 'raytrace_1'\n
Keine Schreibrechte oder nicht vorhanden!\n");
      return;
    }
  fprintf (D, "1\n");

  str = XmTextGetString (WPosV1);
  sscanf (str, "%f;%f;%f", &px, &py, &pz);

  str = XmTextGetString (WPosV2);
  sscanf (str, "%f;%f;%f", &zx, &zy, &zz);

  fprintf (D, "%0.1f %0.1f %0.1f %0.1f %0.1f %0.1f\n",
	   px, py, pz, zx, zy, zz);
  fclose (D);
}

/* Callback function to quit the program. */
void 
CBQButton (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  switch (*(int *) pClientData)
    {
    case IM_QOK:
      writeconfig ();
      writekamera ();
      break;
    case IM_QSTART:
      startmono ();
      break;
    default:
      fprintf (stderr, "Falsche QButton-ID!\n");
    }
}

void 
CBMethode (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  Methode = (*(int *) pClientData);
}

void 
CBMethodealias (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  Methodealias = (*(int *) pClientData);
}

void 
CBDiff (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  Diff = Diff ? false : true;
}

void 
CBBildPulldown (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  char bildtextstr[10];
  Arg Aargs;

  switch (*(int *) pClientData)
    {
    case 0:
      sprintf (bildtextstr, "200x200");
      break;
    case 1:
      sprintf (bildtextstr, "300x300");
      break;
    case 2:
      sprintf (bildtextstr, "400x400");
      break;
    case 3:
      sprintf (bildtextstr, "500x500");
      break;
    default:
      fprintf (stderr, "Falsche CBBildPulldownID!\n");
    }
  XtSetArg (Aargs, XmNvalue, bildtextstr);
  XtSetValues (WBildstr, &Aargs, 1);
}

int 
main (int argc, char *argv[])
{
  STRING AIPulldown[] =
  {"ende", "starte", "show", "kill", "edit", "hilfe"};
  STRING AICascade[] =
  {"Ende", "Starte", "Show", "Kill", "Edit", "Hilfe"};
  STRING AIEnde[] =
  {"Ende"};
  STRING AIStart[] =
  {"Start", "Start-3D", "Start&", "Start-3D&"};
  STRING AIShow[] =
  {"Show-M", "Show-3D"};
  STRING AIKill[] =
  {"Kill"};
  STRING AIEdit[] =
  {"Scene", "Date"};
  STRING AIHilfe[] =
  {"Doku", "README", "Hinweis"};
  STRING AIQButtons[] =
  {"QStart", "Kamera OK"};

  static int AiEndeMenuID[] =
  {IM_ENDE};
  static int AiStartMenuID[] =
  {IM_START, IM_START3D, IM_STARTB, IM_START3DB};
  static int AiShowMenuID[] =
  {IM_SHOW, IM_SHOW3D};
  static int AiKillMenuID[] =
  {IM_KILL};
  static int AiEditMenuID[] =
  {IM_SCENE, IM_DATE};
  static int AiHilfeMenuID[] =
  {IM_DOKU, IM_README, IM_HINWEIS};
  static int AiQButtonsID[] =
  {IM_QSTART, IM_QOK};
  static int AiDiffID = 1;


  Widget WMenuBar, AWPulldown[LETZTE_PD], AWCascade[LETZTE_PD], AWEnde[LETZTE_ENDE],
    AWStart[LETZTE_START], AWShow[LETZTE_SHOW], AWKill[LETZTE_KILL], AWEdit[LETZTE_EDIT],
    AWHilfe[LETZTE_HILFE], AWButtons[LETZTE_QUICK], WRowCol, WQBox, QWframe;

  Arg Aargs[5];
  int x, nArgs;


  top = XtVaAppInitialize (&app, "XMStart", NULL, 0, &argc, argv, NULL, NULL);

  WRowCol = XmCreateRowColumn (top, "rowcol", NULL, 0);
  XtManageChild (WRowCol);

  /* 1. MenuBar mit PulldownMenu als Kind erzeugen */
  WMenuBar = XmCreateMenuBar (WRowCol, "menubar", NULL, 0);
  XtVaSetValues (WMenuBar, XmNtopAttachment, XmATTACH_FORM, XmNleftAttachment, XmATTACH_FORM,
		 XmNrightAttachment, XmATTACH_FORM, NULL);
  XtManageChild (WMenuBar);


  /* Pulldowns erzeugen */
  for (x = 0; x < LETZTE_PD; x++)
    AWPulldown[x] = XmCreatePulldownMenu (WMenuBar, AIPulldown[x], NULL, 0);

  /* 2. PulldownMens an CascadeButtons binden */
  for (x = 0; x < LETZTE_PD; x++)
    {
      nArgs = 0;
      XtSetArg (Aargs[nArgs], XmNsubMenuId, AWPulldown[x]);
      nArgs++;
      AWCascade[x] = XmCreateCascadeButton (WMenuBar, AICascade[x], Aargs, nArgs);
    }

  /* Hilfe Menue steht ganz rechts */
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNmenuHelpWidget, (XtArgVal) AWCascade[x - 1]);
  nArgs++;
  XtSetValues (WMenuBar, Aargs, nArgs);
  XtManageChildren (AWCascade, x);

  for (x = 0; x < LETZTE_ENDE; x++)
    {
      AWEnde[x] = XmCreatePushButton (AWPulldown[0], AIEnde[x], NULL, 0);
      XtAddCallback (AWEnde[x], XmNactivateCallback, (XtCallbackProc) CBquit, &AiEndeMenuID[x]);
    }
  XtManageChildren (AWEnde, x);


  for (x = 0; x < LETZTE_START; x++)
    {
      AWStart[x] = XmCreatePushButton (AWPulldown[1], AIStart[x], NULL, 0);
      XtAddCallback (AWStart[x], XmNactivateCallback, (XtCallbackProc) CBstart, &AiStartMenuID[x]);
    }
  XtManageChildren (AWStart, x);


  for (x = 0; x < LETZTE_SHOW; x++)
    {
      AWShow[x] = XmCreatePushButton (AWPulldown[2], AIShow[x], NULL, 0);
      XtAddCallback (AWShow[x], XmNactivateCallback, (XtCallbackProc) CBshow, &AiShowMenuID[x]);
    }
  XtManageChildren (AWShow, x);

  for (x = 0; x < LETZTE_KILL; x++)
    {
      AWKill[x] = XmCreatePushButton (AWPulldown[3], AIKill[x], NULL, 0);
      XtAddCallback (AWKill[x], XmNactivateCallback, (XtCallbackProc) CBkill, &AiKillMenuID[x]);
    }
  XtManageChildren (AWKill, x);

  for (x = 0; x < LETZTE_EDIT; x++)
    {
      AWEdit[x] = XmCreatePushButton (AWPulldown[4], AIEdit[x], NULL, 0);
      XtAddCallback (AWEdit[x], XmNactivateCallback, (XtCallbackProc) CBedit, &AiEditMenuID[x]);
    }
  XtManageChildren (AWEdit, x);

  for (x = 0; x < LETZTE_HILFE; x++)
    {
      AWHilfe[x] = XmCreatePushButton (AWPulldown[5], AIHilfe[x], NULL, 0);
      XtAddCallback (AWHilfe[x], XmNactivateCallback, (XtCallbackProc) CBhilfe, &AiHilfeMenuID[x]);
    }
  XtManageChildren (AWHilfe, x);


  /* Q-Buttons */
  QWframe = XtCreateManagedWidget ("quickframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWframe,
				   XmNorientation, XmHORIZONTAL, 
				   XmNpacking,  XmPACK_COLUMN, 
				   //XmNheight, 150,
				   XmNadjustLast, False,
				   NULL);
  for (x = 0; x < LETZTE_QUICK; x++)
    {
//       AWButtons[x] =
// 	XtCreateManagedWidget (AIQButtons[x], xmPushButtonWidgetClass, WQBox, NULL, 0);
      AWButtons[x] =
	XtVaCreateManagedWidget (AIQButtons[x], xmPushButtonWidgetClass, WQBox, 
				 XmNadjustLast, True,
				 NULL);

      XtAddCallback (AWButtons[x], XmNactivateCallback, (XtCallbackProc) CBQButton, 
		     &AiQButtonsID[x]);
    }

  /* Position und Richtung der Kamera */
  Widget QWposframe, WQposBox;

  QWposframe = XtCreateManagedWidget ("posframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQposBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWposframe,
				      XmNorientation, XmHORIZONTAL,
				      XmNpacking, XmPACK_TIGHT, NULL);

  WPosL = XtCreateManagedWidget ("Kamera:", xmLabelWidgetClass, WQposBox, NULL, 0);
  sprintf (posvon, "0.0;0.0;-1.0");
  // nArgs = 0; XtSetArg(Aargs[nArgs], XmNvalue, posvon); nArgs++;
  WPosV1 = XtVaCreateManagedWidget ("posvon", xmTextWidgetClass, WQposBox,
				    XmNvalue, posvon,
				    XmNcolumns, 12,
				    NULL);

  sprintf (posnach, "0.0;0.0;1.0");
  //nArgs = 0; XtSetArg(Aargs[nArgs], XmNvalue, posnach); nArgs++;
  WPosV2 = XtVaCreateManagedWidget ("posnach", xmTextWidgetClass, WQposBox,
				    XmNvalue, posnach,
				    XmNcolumns, 12,
				    NULL);


  /* Bild */
  Widget QWbildframe, WQbildBox, WBildL, WOption, WPulldown, WWidth[4];
  char bildtextstr[80];
  static int WidthID[] =
  {0, 1, 2, 3};
  STRING WidthStrID[] =
  {"200x200", "300x300", "400x400", "500x500"};
  Arg AArgs[5];

  QWbildframe = XtCreateManagedWidget ("bildframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQbildBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWbildframe,
				       XmNorientation, XmHORIZONTAL,
				       XmNpacking, XmPACK_COLUMN, NULL);

  WBildL = XtCreateManagedWidget ("Bild:", xmLabelWidgetClass, WQbildBox, NULL, 0);
  sprintf (bildtextstr, "200x200");
  WBildstr = XtVaCreateManagedWidget ("bildstr", xmTextWidgetClass, WQbildBox,
				      XmNvalue, bildtextstr,
				      XmNcolumns, 12,
				      NULL);

  /* Pulldown fr Bild */
  WPulldown = XmCreatePulldownMenu (WQbildBox, "pd", NULL, 0);
  for (x = 0; x < 4; x++)
    {
      WWidth[x] = XmCreatePushButton (WPulldown, WidthStrID[x], NULL, 0);
      XtAddCallback (WWidth[x], XmNactivateCallback, (XtCallbackProc) CBBildPulldown, &WidthID[x]);
    }
  XtManageChildren (WWidth, 4);

  nArgs = 0;
  XtSetArg (AArgs[nArgs], XmNsubMenuId, WPulldown);
  nArgs++;

  WOption = XmCreateOptionMenu (WQbildBox, "Vorgabe", AArgs, nArgs);
  XtManageChild (WOption);

  /* Scallierung */
  Widget QWscalframe, WQscalBox, WScalL, WPixelL;
  char scaltextstr[80];

  QWscalframe = XtCreateManagedWidget ("scalframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQscalBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWscalframe,
				       XmNorientation, XmHORIZONTAL,
				       XmNpacking, XmPACK_TIGHT, NULL);

  WScalL = XtCreateManagedWidget ("Scal:", xmLabelWidgetClass, WQscalBox, NULL, 0);
  sprintf (scaltextstr, "1.00");
  WScalstr = XtVaCreateManagedWidget ("scalestr", xmTextWidgetClass, WQscalBox,
				      XmNvalue, scaltextstr,
				      XmNcolumns, 5,
				      NULL);

  /* Widget WPixelstr, WPixelL; */
  char pixelstr[80];		// Pixel je Pixel

  WPixelL = XtCreateManagedWidget ("Pixel:", xmLabelWidgetClass, WQscalBox, NULL, 0);
  sprintf (pixelstr, "64");
  WPixelstr = XtVaCreateManagedWidget ("pixelstr", xmTextWidgetClass, WQscalBox,
				       XmNvalue, pixelstr,
				       XmNcolumns, 3,
				       NULL);
  Widget WPatchL;
  char patchstr[80];		// Flchengre des Patches

  WPatchL = XtCreateManagedWidget ("A:", xmLabelWidgetClass, WQscalBox, NULL, 0);
  sprintf (patchstr, "0.05");
  WPatchstr = XtVaCreateManagedWidget ("patchstr", xmTextWidgetClass, WQscalBox,
				       XmNvalue, patchstr,
				       XmNcolumns, 5,
				       NULL);
  /*
  Widget WTeileP;
  Teile = False;
  WTeileP = XtVaCreateManagedWidget ("T", xmToggleButtonWidgetClass, WQscalBox,
				     XmNset, False,
				     NULL);
  XtAddCallback (WTeileP, XmNdisarmCallback, (XtCallbackProc) CBTeile, &AiTeileID);
  */

  Widget WDiffP;
  Diff = true;
  WDiffP = XtVaCreateManagedWidget ("D", xmToggleButtonWidgetClass, WQscalBox,
				    XmNset, true,
				    NULL);
  XtAddCallback (WDiffP, XmNdisarmCallback, (XtCallbackProc) CBDiff, &AiDiffID);


  /* *** Methode *** */
  Widget QWmethframe, WQmethBox, WMethodeL;

  QWmethframe = XtCreateManagedWidget ("methframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQmethBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWmethframe,
				       XmNorientation, XmHORIZONTAL,
				       XmNpacking, XmPACK_TIGHT, NULL);

  WMethodeL = XtCreateManagedWidget ("Methode:", xmLabelWidgetClass, WQmethBox, NULL, 0);

  /* Toggelbutton */
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WMethr = XmCreateRadioBox (WQmethBox, "meth", Aargs, nArgs);
  XtManageChild (WMethr);

  /* 4 Togglebuttons erzeugen */
  x = 0;
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[x++] = XtCreateManagedWidget ("ZB", xmToggleButtonWidgetClass,
					  WMethr, Aargs, nArgs);
  XtSetArg (Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[x++] =
    XtCreateManagedWidget ("Ray", xmToggleButtonWidgetClass, WMethr, Aargs, nArgs);

  /* Methode = 3; */
  XtSetArg (Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonD[x++] =
    XtCreateManagedWidget ("Rad", xmToggleButtonWidgetClass, WMethr, Aargs, nArgs);

  Methode = 3;
  XtSetArg (Aargs[nArgs], XmNset, True);
  nArgs++;
  AWButtonD[x++] =
    XtCreateManagedWidget ("2P", xmToggleButtonWidgetClass, WMethr, Aargs, nArgs);

  /* Callbacks fr alle 4 Buttons */
  for (x = 0; x < 4; x++)
    XtAddCallback (AWButtonD[x], XmNdisarmCallback, (XtCallbackProc) CBMethode, &MethodeID[x]);

  /* Qualitt */
  Widget QWqualiframe, WQqualiBox;

  QWqualiframe = XtCreateManagedWidget ("qualiframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQqualiBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWqualiframe,
					XmNorientation, XmHORIZONTAL,
					XmNpacking, XmPACK_TIGHT, NULL);
  Widget WPixeloL;
  char opixelstr[80];

  WPixeloL = XtCreateManagedWidget ("Pixelo:", xmLabelWidgetClass, WQqualiBox, NULL, 0);
  sprintf (opixelstr, "2");
  WPixelostr = XtVaCreateManagedWidget ("pixelostr", xmTextWidgetClass, WQqualiBox,
					XmNvalue, opixelstr,
					XmNcolumns, 2,
					NULL);
  Widget WEntfL;
  char entfstr[80];
  WEntfL = XtCreateManagedWidget ("Entf:", xmLabelWidgetClass, WQqualiBox, NULL, 0);
  sprintf (entfstr, "10");
  WEntfstr = XtVaCreateManagedWidget ("entfstr", xmTextWidgetClass, WQqualiBox,
				      XmNvalue, entfstr,
				      XmNcolumns, 3,
				      NULL);
  Widget WBlendeL;
  char blendestr[80];

  WBlendeL = XtCreateManagedWidget ("Blende:", xmLabelWidgetClass, WQqualiBox, NULL, 0);
  sprintf (blendestr, "0");
  WBlendestr = XtVaCreateManagedWidget ("blendestr", xmTextWidgetClass, WQqualiBox,
					XmNvalue, blendestr,
					XmNcolumns, 2,
					NULL);
  /* *** Methode *** */
  Widget QWmethaframe, WQmethaBox, WMethodeaL;

  QWmethaframe = XtCreateManagedWidget ("methaframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQmethaBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWmethaframe,
					XmNorientation, XmHORIZONTAL,
					XmNpacking, XmPACK_TIGHT, NULL);

  WMethodeaL = XtCreateManagedWidget ("Anti-Alias:", xmLabelWidgetClass, WQmethaBox, NULL, 0);

  /* Toggelbutton */
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNentryClass, xmToggleButtonWidgetClass);
  nArgs++;
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WMethalias = XmCreateRadioBox (WQmethaBox, "metha", Aargs, nArgs);
  XtManageChild (WMethalias);

  /* 4 Togglebuttons erzeugen */
  x = 0;
  nArgs = 0;
  Methodealias = 0;
  XtSetArg (Aargs[nArgs], XmNset, True);
  nArgs++;
  AWButtonaD[x++] =
    XtCreateManagedWidget ("No", xmToggleButtonWidgetClass,
			   WMethalias, Aargs, nArgs);
  nArgs = 0;

  XtSetArg (Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonaD[x++] =
    XtCreateManagedWidget ("Ganz", xmToggleButtonWidgetClass, WMethalias, Aargs, nArgs);

  XtSetArg (Aargs[nArgs], XmNset, False);
  nArgs++;
  AWButtonaD[x++] =
    XtCreateManagedWidget ("Rand", xmToggleButtonWidgetClass, WMethalias, Aargs, nArgs);

  /* Callbacks fr alle 3 Buttons */
  for (x = 0; x < 3; x++)
    XtAddCallback (AWButtonaD[x], XmNdisarmCallback, (XtCallbackProc) CBMethodealias, &MethodealiasID[x]);

  /* Hauptprogramm */
  XtRealizeWidget (top);
  XtAppMainLoop (app);		// Endlosschleife

  /* UNREACHABLE */
  return (0);
}


/* ******** ffnet eine Textbox als Hilfetext ******** */
void 
CBHelpOk (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtUnmanageChild (WHelpDialog);
  WHelpDialog = NULL;
}

void 
helpfiledialog (Widget Parent, char *str)
{
  Arg Aargs[5];
  int nArgs;

  Widget WButtonOK, WRowCol, WRowCol2, helptext, Wframe;

  WHelpDialog = XmCreateDialogShell (Parent, "helpfiledialog", NULL, 0);
  XtManageChild (WHelpDialog);

  WRowCol = XtVaCreateManagedWidget ("helpfilerow", xmRowColumnWidgetClass, WHelpDialog,
				     XmNorientation, XmVERTICAL,
				     XmNpacking, XmPACK_TIGHT,
				     XmNwidth, 600,
				     XmNheight, 390,
				     NULL);

  Wframe = XtCreateManagedWidget ("helpframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WRowCol2 = XmCreateRowColumn (Wframe, "helpfilerow2", NULL, 0);
  XtManageChild (WRowCol2);

  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNeditMode, XmMULTI_LINE_EDIT);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNeditable, false);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNrows, 15);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNcolumns, 40);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNwordWrap, true);
  nArgs++;
  helptext = XmCreateScrolledText (WRowCol2, "helptext", Aargs, nArgs);

  XmTextSetString (helptext, str);
  XtManageChild (helptext);

  WButtonOK = XtCreateManagedWidget ("OK", xmPushButtonWidgetClass, WRowCol, NULL, 0);
  XtManageChild (WButtonOK);

  XtAddCallback (WButtonOK, XmNactivateCallback, (XtCallbackProc) CBHelpOk, NULL);
}
