 /*
    Kuelobjekt
    Definition in ray.H
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Copyright (C) 1996, 1997 Helmut Fahrion
  */


#include "ray.H"

bool sphere::in_obj(vector mp)
{
  // Test ob point in der Kugel liegt
  return (abs(vect - mp) < (radius + eps4)) ? true : false;
}

patcharray *sphere::createpatch(float Min, bool Schn, obj * grobj)
{
  pp = new patcharray(Min, Schn, grobj, vect, radius);
  return pp;
}

// Treffpunkt
bool sphere::hit_object(vector point, vector dir, bool hitin,
			vector * int_pt1, vector * norm1,
			vector * int_pt2, vector * norm2)
{
  int l;
  float t1, t2;

  // Transformation in Koordinaten des Kegels
  vector v0 = vect - point;	// vektor
  vector v1 = dir;

  // Test ob point in der Kugel liegt
  if (hitin)
    if (abs(v0) < (radius + eps4))
      return false;

  // Treffpunkt auf Kugel
  if ((l = solve_quad(v1.x * v1.x + v1.y * v1.y + v1.z * v1.z,	// A 
		      (v0.x * v1.x + v0.y * v1.y + v0.z * v1.z) * 2.,	// B
		  v0.x * v0.x + v0.y * v0.y + v0.z * v0.z - radius * radius,	// C
		      &t1, &t2)))
    {
      // warum ? Fehler wenn eine Lichtquelle in die Nhe kommt fhrt das
      // weglassen dieses Testes zu falschen Schatten!!!
      if ((t1 > 0.0) && (t2 > 0.0))
	return false;

      if (l == 2)
	{
	  *int_pt1 = point + (dir * fabs(t1));
	  *norm1 |= *int_pt1 - vect;
	  *int_pt2 = point + (dir * fabs(t2));
	  *norm2 |= *int_pt2 - vect;
	  return true;
	}
      else
	// Tangiert
	return false;
    }
  return false;
}

// Texture auftragen
void sphere::surfaceCol(color * col, vector intpoint, cover * cp, byte art)
{
  vector i;
  float dx, dy;

  texture *tp=NULL;
  muster  *mp=NULL;

  switch (art)
    {
      case NORMALTXT:
	tp = cp->textcp;
	mp = cp->musterp;
	break;
      case VECTORTXT:
	tp = cp->textvp;
	mp = cp->musterp2;
	break;
      case SPIEGTXT:
	tp = cp->textsp;
	mp = cp->mustersp;
	break;
      case BRECHTXT:
	tp = cp->textbp;
	mp = cp->musterbp;
	break;
    }


  // Verschiebung des Treffpunktes je nach Muster
  if ((cp->tb.tu == 1) || (cp->tb.tu == 3))
    i = intpoint + cp->tb.getturbo((intpoint - vect) * cp->tb.t);
  else
    i = intpoint;

  /*
     // Vereinfachte Methode
     // je Auftragerichtung Vector setzen
     dx = i.x - vect.x;
     dy = i.y - vect.y;
     vz = i.z - vect.z;

     // Drehung der Textur um Winkel alpha der Z-Achse
     sa = sin(alpha);
     ca = cos(alpha);
     vx = dx * ca - dy * sa;
     vy = dx * sa + dy * ca;
     // Drehung der Textur um Winkel beta der Y-Achse
     vx =  vx * cos(beta) + vz * sin(beta);
   */

  // Kugelkoordinaten
  i = vect - i;

  dx = dy = 0.0;
  // Quadrant beachten, zuerst die am meisten verwendeten
  if ((i.z < 0.0) && (i.x < 0.0))
    dx = atan(fabs(i.z / i.x)) + pi;
  else if ((i.z < 0.0) && (i.x > 0.0))
    dx = pi2 - atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x > 0.0))
    dx = atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x < 0.0))
    dx = pi - atan(fabs(i.z / i.x));

  dx += alpha;
  if (dx > pi2)
    dx -= pi2;
  dx = (dx * radius) / (pi2 * radius);	// Abstand in Bezug auf die Gesamtlnge

  // Quadrant beachten, zuerst die am meisten verwendeten
  if ((i.z < 0.0) && (i.y < 0.0))
    dy = atan(fabs(i.z / i.y)) + pi;
  else if ((i.z < 0.0) && (i.y > 0.0))
    dy = pi2 - atan(fabs(i.z / i.y));
  else if ((i.z > 0.0) && (i.y > 0.0))
    dy = atan(fabs(i.z / i.y));
  else if ((i.z > 0.0) && (i.y < 0.0))
    dy = pi - atan(fabs(i.z / i.y));

  dy += beta;
  if (dy > pi2)
    dy -= pi2;
  dy = (dy * radius) / (pi2 * radius);	// Abstand in Bezug auf die Gesamtlnge

  if (tp)
    tp->gettexture(col, dx, dy, cp, vect - intpoint);

  if (mp)
    {
      if ((cp->tb.tu == 2) || (cp->tb.tu == 3))
	mp->mix = cp->tb.getgturbo((intpoint - vect) * cp->tb.t);
      mp->getmust(col, cp->musterfp, vector(dx, dy, 0.0));
    }

  // 3D - Texturen, Musterfp definiert den Fupunkt des Covers fr die Texturen oder
  // die Muster u.a.
  if (cp->text3d)
    cp->text3d->gettext(col, cp->musterfp, intpoint - vect);
}

bool sphere::testgrobj(vector * p1, vector * p2, vector nv1, vector nv2)
{
  float r;

  // aus einer Kugel wird ein Wrfel gemacht
  r = radius;
  *p1 = vect - vector(r, r, r);
  *p2 = vect + vector(r, r, r);

  // Test ob reinpasst
  if ((nv1.x <= p1->x && nv1.y <= p1->y && nv1.z <= p1->z) &&
      (nv2.x >= p2->x && nv2.y >= p2->y && nv2.z >= p2->z))
    return true;
  else
    return false;
}

bool sphere::getpoints(vector * v1, longint x)
{
  float r = radius + eps2;

  if ((x >= 1) && (x <= 15))
    {
      switch (x)
	{
	case 1:	  *v1 = vect + vector(0, 0, 0);	  break;
	case 2:	  *v1 = vect + vector(0, 0, r);	  break;
	case 3:	  *v1 = vect + vector(0, r, 0);	  break;
	case 4:	  *v1 = vect + vector(r, 0, 0);	  break;
	case 5:	  *v1 = vect + vector(0, r, r);	  break;
	case 6:	  *v1 = vect + vector(r, r, 0);	  break;
	case 7:	  *v1 = vect + vector(r, 0, r);	  break;
	case 8:	  *v1 = vect + vector(r, r, r);	  break;
	case 9:	  *v1 = vect - vector(0, 0, r);	  break;
	case 10:  *v1 = vect - vector(0, r, 0);	  break;
	case 11:  *v1 = vect - vector(r, 0, 0);	  break;
	case 12:  *v1 = vect - vector(0, r, r);	  break;
	case 13:  *v1 = vect - vector(r, r, 0);	  break;
	case 14:  *v1 = vect - vector(r, 0, r);	  break;
	case 15:  *v1 = vect - vector(r, r, r);	  break;
	}
      return true;
    }
  else
    return false;
}
