/*
   Nazca - Visualisierung
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>
// fuer AIX usleep()
#include <sys/time.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "defs.H"
#include "vect.H"

#define CANTALLOCCOLCELLS   5

#define uns unsigned
int MAXCOL = 6;			/* Kantenlnge des Farbwrfels */

#define WORD  uns short		/* Achtung ev. neudefinition da sons uns int!!! */
#define DWORD uns long
#define longunsint long unsigned int
#define longint unsigned int

// Videopuffer
struct icol
  {
    unsigned char r, g, b;
  }
 *cbuff;


/* **************** Globale Variablen *********************** */

// XWindows
Display *display;		/* Zeiger auf die Display Struktur */
int screen_num;			/* Nummer des Bildschirms */
GC gc;				/* Grafikkontext */

longunsint wm_del_win;		/* del Window Massage */
longint anz, lastx;		// Anzahl der Bilder

longint millisek;
int stereo, i = 0;

/* ****** Struktur zur Bildverwaltung ****** */
typedef struct
  {
    int left, top;		/* Obere linke Fensterecke */
    int width;			/* Fensterbreite */
    int height;			/* Fensterhhe */
    /* gr_Sprite     *first;  *//* Erstes Sprite */

    /* X Windows-Spezifisch */
    Window window;
    Pixmap pixmap;		/* Animation */

    /* Pixmap        background; */
    Drawable drawable;
    Colormap colormap;
    unsigned long colref;
  }
gr_Window;

// Puffer fr Animation
Pixmap *pixbuff;		/* Animation */

/* Strings fr die Fehlerausgabe */
char *ErrorString[] =
{
  "In %s: Unbekannter Fehler",
  "In %s: Kein Speicherplatz mehr",
  "In %s: %s kann nicht geffnet werden",
  "In %s: %s falsches Dateiformat",
  "In %s: Keine Verbindung zum X server",
  "In %s: Kann Farbzellen nicht allokieren",
};

gr_Window win;			/* Toplevel Window */
Colormap Cmap;			/* Farbtabellen */
Colormap errmap;

uns long Pixels[256];

Visual *Dvis;
XVisualInfo visual;

char truecolor;
char visok;
struct icol old_c = {0, 0, 0};


int rgb[3];			/* speichert einen RGB-Wert */
uns long new_foreground = 0, foreground = 1;
int dither_mode = 0;

XEvent event;			/* Event Struktur */
Screen *screen;			/* Zeiger auf Screen Struktur */
XColor xcolor;			/* Struktur zur Farbverwaltung */

/* Linke oder Rechte Seite */
int par = 1;

inline float 
retcol256 (byte col)
{
  return ((float) col / 255.0);
}

int 
error (int errnum, char *funcname, char *info)
{
  Window errwin, root, child;
  char *window_name = "Error";
  char *icon_name = "Error";
  XSizeHints *size_hints;
  XWMHints *wm_hints;
  XClassHint *class_hints;
  XTextProperty name_window, name_icon;
  char *progname = "Error";
  char hilf[100];
  int rootretx, rootrety, x, y;
  int left, top, width, height;
  unsigned int mask;
  XFontStruct *font_struct;
  GContext idgc;

  idgc = XGContextFromGC (gc);
  font_struct = XQueryFont (display, idgc);

  sprintf (hilf, ErrorString[errnum], funcname, info);
  height = 100;
  width = strlen (hilf) * (font_struct->max_bounds.width) + 20;
  left = (XDisplayWidth (display, screen_num) - width) / 2;
  top = (XDisplayHeight (display, screen_num) - height) / 2;

  if (!(size_hints = XAllocSizeHints ()))
    {
      cerr << progname << ": Fehler beim Allokieren von Speicherplatz\n";
      exit (0);
    }

  if (!(wm_hints = XAllocWMHints ()))
    {
      cerr << progname << ": Fehler beim Allokieren von Speicherplatz\n";
      exit (0);
    }

  if (!(class_hints = XAllocClassHint ()))
    {
      cerr << progname << ": Fehler beim Allokieren von Speicherplatz\n";
      exit (0);
    }

  errwin = XCreateWindow (display,
			  RootWindow (display, screen_num),
			  left, top, width, height, 0,
			  DefaultDepth (display, screen_num),
			  InputOutput,
			  XDefaultVisual (display, screen_num),
			  0, NULL);

  size_hints->flags = PPosition | PSize | PMinSize;
  size_hints->min_width = width;
  size_hints->min_height = height;

  if (XStringListToTextProperty (&window_name, 1, &name_window) == 0)
    {
      cerr << progname << ": Fehler beim allokieren der Struktur fr den Windownamen\n";
      exit (-1);
    }

  if (XStringListToTextProperty (&icon_name, 1, &name_icon) == 0)
    {
      cerr << progname << ": Fehler beim allokieren der Struktur fr den Iconnamen\n";
      exit (-1);
    }

  wm_hints->initial_state = NormalState;
  wm_hints->input = True;
  wm_hints->flags = StateHint | InputHint;

  class_hints->res_name = progname;
  class_hints->res_class = "Errorwindow";

  XSetWMProperties (display, errwin, &name_window, &name_icon,
		    NULL, 0, size_hints, wm_hints, class_hints);

  XMapWindow (display, errwin);

  XSetWindowColormap (display, errwin, DefaultColormap (display, DefaultScreen (display)));
  XSetWindowBackground (display, errwin, XWhitePixel (display, screen_num));
  XSetForeground (display, gc, XBlackPixel (display, screen_num));

  do
    {
      XDrawString (display, errwin, gc, 10, 40, hilf, strlen (hilf));
      XQueryPointer (display, errwin, &root, &child,
		     &rootretx, &rootrety, &x, &y, &mask);
    }
  while ((x > width || x < 0 || y > height || y < 0) || mask != 256);

  XDestroyWindow (display, errwin);
  return errnum;
}

int highbit(unsigned long ul)
{
  int i;  unsigned long hb;
  hb = 0x8000;  hb = (hb<<16);  /* hb = 0x80000000UL */
  for (i=31; ((ul & hb) == 0) && i>=0;  i--, ul<<=1);
  return i;
}

void XRAllocColor(XColor *cdef)
{
  unsigned long r, g, b, rmask, gmask, bmask, origr, origg, origb;
  int rshift, gshift, bshift;

  origr = r = cdef->red;  
  origg = g = cdef->green;  
  origb = b = cdef->blue;

  rmask = visual.red_mask;
  gmask = visual.green_mask;
  bmask = visual.blue_mask;

  rshift = 15 - highbit(rmask);
  gshift = 15 - highbit(gmask);
  bshift = 15 - highbit(bmask);

  r = (rshift<0)? r << (-rshift) : r >> rshift;
  g = (gshift<0)? g << (-gshift) : g >> gshift;
  b = (bshift<0)? b << (-bshift) : b >> bshift;

  r = r & rmask;
  g = g & gmask;
  b = b & bmask;

  cdef->pixel = r | g | b;

  cdef->red   = r = (rshift<0)? r >> (-rshift) : r << rshift;
  cdef->green = g = (gshift<0)? g >> (-gshift) : g << gshift;
  cdef->blue  = b = (bshift<0)? b >> (-bshift) : b << bshift;
}

void 
SetColor (struct icol rgb)
{
  struct icol c;
  XColor xcol;

  if ((old_c.r != rgb.r) || (old_c.g != rgb.g) || (old_c.b != rgb.b))
    {
      if (truecolor)
	{
	  xcol.flags = DoRed | DoGreen | DoBlue;
	  xcol.red = (unsigned) (retcol256 (rgb.r) * 0xffff);
	  xcol.green = (unsigned) (retcol256 (rgb.g) * 0xffff);
	  xcol.blue = (unsigned) (retcol256 (rgb.b) * 0xffff);

	  if (!visok)
	    XAllocColor (display, Cmap, &xcol);
	  else
	    XRAllocColor(&xcol);

	  new_foreground = xcol.pixel;
	}
      else
	{
	  c.r = (byte) (retcol256 (rgb.r) * (float) (MAXCOL - 1));
	  c.g = (byte) (retcol256 (rgb.g) * (float) (MAXCOL - 1));
	  c.b = (byte) (retcol256 (rgb.b) * (float) (MAXCOL - 1));
	  new_foreground = Pixels[(unsigned)
			(c.r + (MAXCOL) * c.g + (MAXCOL) * (MAXCOL) * c.b)];
	}
      old_c = rgb;

      XSetForeground (display, gc, new_foreground);	// Fenster

    }
}

/*  Name     : initwindow() */
/*  Funktion : initialisiert ein Grafikausgabefenster */
/*  Parameter : anzahl der Argumente, Argument */
int 
initwindow (int argc, char **argv)
{
  XTextProperty name_window,	/* Struktur fuer Windownamen */
    name_icon;			/* Struktur fuer Iconname */
  char *window_name = "Video", *icon_name = "Vid",	/* Titel des Icons */
   *display_name = NULL;	/* Knotennamen */

  /* Strukturen zur Inter-Client-Kommunikation */
  XSizeHints *size_hints;
  XWMHints *wm_hints;
  XClassHint *class_hints;

  XSetWindowAttributes attributes;
  unsigned long valuemask;

  /* Speicher fuer Inter-Client-Kommunikations- */
  /* Strukturen allokieren */
  if (!(size_hints = XAllocSizeHints ()))
    {
      cerr << argv[0] << ": Fehler beim Allokieren von Speicherplatz\n";
      return (false);
    }

  if (!(wm_hints = XAllocWMHints ()))
    {
      cerr << argv[0] << ": Fehler beim Allokieren von Speicherplatz\n";
      return (false);
    }

  if (!(class_hints = XAllocClassHint ()))
    {
      cerr << argv[0] << ": Fehler beim Allokieren von Speicherplatz\n";
      return (false);
    }

  /* Verbindung zum X Server herstellen */
  if ((display = XOpenDisplay (display_name)) == NULL)
    {
      cerr << argv[0] << ": Verbindung zum X Server " << XDisplayName (display_name) <<
	" konnte nicht hergestellt werden\n";
      exit (false);
    }

  /* Nummer des Bildschirms */
  screen_num = XDefaultScreen (display);

  /* Zeiger auf Screen Struktur setzen */
  screen = XScreenOfDisplay (display, screen_num);

  if (XDoesBackingStore (XScreenOfDisplay (display, screen_num)))
    {
      valuemask = CWBackingStore | CWBackPixel;
      attributes.backing_store = Always;
      attributes.background_pixel = XWhitePixel (display, screen_num);
    }
  else
    {
      valuemask = CWBackPixel;
      attributes.background_pixel = XWhitePixel (display, screen_num);
    }

  /* Toplevel Window erzeugen */
  win.window = XCreateWindow (display,
			      RootWindow (display, screen_num),
  // position im Root Window , breite, hoehe, rahmenbreite
			      170, 200, win.width, win.height, 1,
  // 0, 0, win.width, win.height, 1,
			      DefaultDepth (display, screen_num),
			      InputOutput,
			      XDefaultVisual (display, screen_num),
			      valuemask, &attributes);

  /*   Delete Window Protokoll clientmassage wird gesetzt! mu abgefragt werden */
  wm_del_win = XInternAtom (display, "WM_DELETE_WINDOW", False);
  XSetWMProtocols (display, win.window, &wm_del_win, 1);

  /* Grafikkontext erzeugen */
  gc = XCreateGC (display, RootWindow (display, screen_num),
		  0, NULL);

  /* Struktur zur Inter-Client-Kommunikation */
  /* initialisieren */
  size_hints->flags = PPosition | PSize | PMinSize;
  size_hints->min_width = win.width;
  size_hints->min_height = win.height;

  /* Strings konvertieren */
  if (XStringListToTextProperty (&window_name, 1, &name_window) == 0)
    {
      cerr << argv[0] << ": Fehler beim allokieren der Struktur fr den Windownamen\n";
      return (false);
    }

  if (XStringListToTextProperty (&icon_name, 1, &name_icon) == 0)
    {
      cerr << argv[0] << ": Fehler beim allokieren der Struktur fr den Iconnamen\n";
      return (false);
    }

  /* Struktur zur Inter-Client-Kommunikation */
  /* initialisieren */
  wm_hints->initial_state = NormalState;
  wm_hints->input = True;
  wm_hints->flags = StateHint | InputHint;

  class_hints->res_name = argv[0];
  class_hints->res_class = "grafik";

  /* Hintergrund des Windows Wei faerben */
  XSetWindowBackground (display, win.window, XWhitePixel (display, screen_num));

  /* Alle initialisierten Strukturen zur */
  /* Inter-Client-Kommunikation, sowie der Namen */
  /* des Windows und des Icons werden dem */
  /* Window Manager bekannt gemacht */
  XSetWMProperties (display, win.window, &name_window, &name_icon,
		    argv, argc, size_hints, wm_hints, class_hints);


  /* Die gewnschten Eventtypen */
  /* werden selektiert */
  XSelectInput (display, win.window, ExposureMask | KeyPress |
		KeyPressMask | ButtonPressMask | StructureNotifyMask);

  /* Das Window wird abgebildet */
  XMapWindow (display, win.window);


  /*  Pixmap erzeugen um Bildschirminhalt zu speichern */
  win.pixmap = XCreatePixmap (display, RootWindow (display, screen_num),
		 win.width, win.height, DefaultDepth (display, screen_num));

  /* Inhalt lschen */
  /*  XSetForeground(display, WhitePixelOfScreen(screen_num)); */
  XFillRectangle (display, win.pixmap, gc, 0, 0, win.width, win.height);

  /* inhalt ins Window sichern */
  XCopyArea (display, win.pixmap, win.window, gc, 0, 0,
	     win.width, win.height, 0, 0);

  /* XSetInputFocus(display, win.window, RevertToParent, CurrentTime); */

  win.drawable = win.window;
  return (true);
}
int 
get_colormap (void)
{
  int x, y, anz, red, green, blue, depth;
  XColor xcol;

  Cmap = DefaultColormap (display, DefaultScreen (display));
  Dvis = DefaultVisual (display, DefaultScreen (display));

  x = false;

  visok = anz = y = 0;
  MAXCOL = 6;

  // Ermittle Visual fr Berechnung der Farbpixel
  depth = DefaultDepth(display, DefaultScreen(display));

  // Truecolor ab bpp 15 
  if ((depth >= 15) && !XAllocColorCells (display, Cmap, false, 0, 0, Pixels, 1))
    {   
      if (XMatchVisualInfo(display, DefaultScreen(display),
			   depth, TrueColor, (XVisualInfo *) & visual))
	visok = true;
      if (visok)
	{
	  truecolor = true;
	  return true;
	}
      else
	{
	  cerr << "Keine Farbzelle und Visualtype ungleich! \n";
	  truecolor = false;
	}
    }

      // Teste wieviele Farben frei sind
  while ((MAXCOL > 3) && (!x))
    {
      x = XAllocColorCells (display, Cmap, True, (unsigned long *) NULL, 0,
			    Pixels, MAXCOL * MAXCOL * MAXCOL);
      if (!x)
	MAXCOL--;
    }

  // 6 geht noch mit bpp 8 und Pseudocolor, Staticcolor,
  if (MAXCOL < 6)
    {
      MAXCOL = 6;
      Cmap = XCreateColormap (display, win.window, XDefaultVisual (display,
						    screen_num), AllocNone);

      if (XAllocColorCells (display, Cmap, false, 0, 0, Pixels, MAXCOL * MAXCOL * MAXCOL))
	{
	  y = 0;
	  for (blue = 0; blue < MAXCOL; blue++)
	    for (green = 0; green < MAXCOL; green++)
	      for (red = 0; red < MAXCOL; red++)
		{
		  xcol.pixel = Pixels[y];
		  xcol.flags = DoRed | DoGreen | DoBlue;
		  xcol.red = (unsigned) (red * 65535L / (MAXCOL - 1));
		  xcol.green = (unsigned) (green * 65535L / (MAXCOL - 1));
		  xcol.blue = (unsigned) (blue * 65535L / (MAXCOL - 1));
		  XStoreColor (display, Cmap, &xcol);
		  y++;
		}
	  /*XSetWindowColormap(Disp, XtWindow(top), Cmap); */
	  XSetWindowColormap (display, win.window, Cmap);
	}
      if (y > 0)
	return true;
    }
  else
    // berechne auf die vorhandene Colortabelle
    {
      anz = y = 0;

      for (blue = 0; blue < MAXCOL; blue++)
	for (green = 0; green < MAXCOL; green++)
	  for (red = 0; red < MAXCOL; red++)
	    {
	      xcol.flags = DoRed | DoGreen | DoBlue;
	      xcol.pixel = Pixels[y];
	      xcol.red = (unsigned) (red * 65535L / (MAXCOL - 1));
	      xcol.green = (unsigned) (green * 65535L / (MAXCOL - 1));
	      xcol.blue = (unsigned) (blue * 65535L / (MAXCOL - 1));
	      if (XStoreColor (display, Cmap, &xcol))
		anz++;
	      y++;
	    }
      if (anz > 0)
	return true;
    }

  // infobox("Kein TrueColor und kein Pseudocolor mglich!\nVersuche langsame Farbberechnung!");
  // keine Farbe allociert -> True Color?
  truecolor = true;
  return true;
}

void 
gr_CloseWindow (gr_Window * wi)
{
  XFreePixmap (display, wi->pixmap);
  XFreeGC (display, gc);
  XDestroyWindow (display, wi->window);
  XCloseDisplay (display);
}

/* wartet x ms */
void 
gr_wait (int w)
{
  int x;
  XFlush (display);		/* um alles anzuzeigen */

  /* inhalt im Window sichern */
  XCopyArea (display, win.window, win.pixmap, gc, 0, 0,
	     win.width, win.height, 0, 0);

  for (x = 0; x < w; x++)
    sleep (1000);
}

void 
schleife1 (int r, int g)
{
  int mrw, mgh, mc;		// Muss int sein!

  struct icol rgb =
  {0, 0, 0};

  mc = truecolor ? 0xff : MAXCOL;

  mrw = mc * r / win.width;
  mgh = mc * g / win.height;
  // mrw=MAXCOL*r/win.width; mgh=MAXCOL*g/win.height;

  switch (i)
    {
    case 1:
      rgb.r = mrw;
      rgb.g = 0;
      rgb.b = mgh;
      break;
    case 2:
      rgb.r = mrw;
      rgb.g = mgh;
      rgb.b = 0;
      break;
    case 3:
      rgb.r = 0;
      rgb.g = mrw;
      rgb.b = mgh;
      break;
    }
  SetColor (rgb);		// Farbe setzen

  XDrawPoint (display, win.window, gc, r, g);	// Punkt im Window setzen

}

void 
writergb (void)
{
  int r, g;

  // if (!i) i=1; else if (i > 3) i = 1;
  i = ((i < 3) && i) ? i + 1 : 1;

  // RGB Models abbilden, in Verschiedenen Richtungen Bild aufbauen
  switch (i)
    {
    case 1:
      for (r = 0; r < win.width; r++)
	for (g = 0; g < win.height; g++)
	  schleife1 (r, g);
      break;
    case 2:
      for (r = win.width - 1; r >= 0; r--)
	for (g = win.height - 1; g >= 0; g--)
	  schleife1 (r, g);
      break;
    case 3:
      for (g = 0; g < win.height; g++)
	for (r = 0; r < win.width; r++)
	  schleife1 (r, g);
      break;
    }
}

void 
gr_xevents (void)
{
  char buffer[11];
  KeySym key;

  /* Hier werden die eintreffenden */
  /* Events abgearbeitet */
  while (true)
    {
      /* Nchster Event wird */
      /* aus der Warteschlange gelesen */
      XNextEvent (display, &event);

      /* Event Typ auswerten */
      switch (event.type)
	{
	case ConfigureNotify:
	  win.width = event.xconfigure.width;
	  win.height = event.xconfigure.height;
	  break;
	case Expose:
	  /* Eingabefokus setzen */
	  XSetInputFocus (display, win.window, RevertToNone, CurrentTime);
	  if (event.xexpose.count == 0)
	    {
	      if (XEventsQueued (display, QueuedAfterReading) > 0)
		{
		  while (XEventsQueued (display, QueuedAfterReading) > 0)
		    XNextEvent (display, &event);
		}
	      XCopyArea (display, win.pixmap, win.window, gc, 0, 0,
			 win.width, win.height, 0, 0);
	    }
	  break;

	case ClientMessage:
	  // Programmabbruch testen
	  if (event.xclient.format == 32 &&
	      event.xclient.data.l[0] == (int) wm_del_win)
	    {
	      gr_CloseWindow (&win);
	      exit (0);
	    }

	case ButtonPress:
	  // 3 rechte Maustaste = Ende;  2 mittlere Maustaste neuaufbau, 1. fr mwm reserviert
	  if (event.xbutton.button == 3)
	    {
	      // Window schlieen, Speicherplatz freigeben
	      // gr_CloseWindow(&win);
	      // Programm verlassen ohne Fehler
	      // exit(0);
	      if (lastx >= 1)
		lastx--;
	      else
		lastx = anz;
	      XCopyArea (display, pixbuff[lastx], win.window, gc, 0, 0,
			 win.width, win.height, 0, 0);

	    }
	  else if (event.xbutton.button == 1)
	    {
	      if (lastx < anz)
		lastx++;
	      else
		lastx = 0;
	      XCopyArea (display, pixbuff[lastx], win.window, gc, 0, 0,
			 win.width, win.height, 0, 0);
	    }
	  else if (event.xbutton.button == 2)
	    {
	      for (lastx = 0; lastx <= anz; lastx++)
		{
		  XCopyArea (display, pixbuff[lastx], win.window, gc, 0, 0,
			     win.width, win.height, 0, 0);
		  XFlush (display);
		  usleep ((longunsint) (millisek * 1000));
		}
	    }
	  break;
	case KeyPress:
	  if (XLookupString (&event.xkey, buffer, 10,
			     &key, 0) == 1 &&
	      buffer[0] == 'q')
	    {
	      gr_CloseWindow (&win);
	      // Programm verlassen ohne Fehler
	      exit (0);
	    }

	  writergb ();

	  break;
	}
    }
}

int 
initw (int argc, char **argv, int x, int y)
{
  win.width = x;
  win.height = y;

  // Kontakt zum X-Server
  if (!initwindow (argc, argv))
    {
      cerr << "Fehler in Funktion initwindow()\n";
      XCloseDisplay (display);
      return (false);
    }

  // Visual ermitteln und Farbpalette allocieren
  if (!get_colormap ())
    {
      cerr << "Fehler beim Farben allocieren der Farbzellen!\n";
      XCloseDisplay (display);
      return (false);
    }
  return (true);
}

// Funktionen zum Pixelgenerieren
void 
writexy (longint x, longint y, icol rgb)
{
  SetColor (rgb);

  /* Zur Kontrolle */
  XDrawPoint (display, win.pixmap, gc, x, y);
  /* XDrawPoint(display, win.window, gc, x, y); */
}

void 
name (char *filename, int x, int y)
{
  sprintf (filename, "scene_erg_%d_%d.rp", x, y);
}

bool 
readkopf (unsigned short *a, unsigned short *b, int anz, int num)
{
  FILE *D;
  char filename[80];
  unsigned short aa, bb, x1, y1, x2, y2;

  name (filename, anz, num);

  if ((D = fopen (filename, "r+")) == NULL)
    {
      cerr << "show: Fehler beim ffnen der Datei " << filename << "\n";
      return false;
    }

  cout << "Lese Datei " << filename << ".\n";

  fread (&x1, sizeof (unsigned short), 1, D);
  fread (&y1, sizeof (unsigned short), 1, D);
  fread (&x2, sizeof (unsigned short), 1, D);
  fread (&y2, sizeof (unsigned short), 1, D);

  // erzeuge puffer, 0 zhlt mit!
  *a = aa = x2 - x1 + 1;
  *b = bb = y2 - y1 + 1;

  cbuff = new icol[aa * bb];

  fread (cbuff, sizeof (icol), aa * bb, D);
  fclose (D);

  return true;
}

void 
zeichnepuffer (int a, int b, int y2, longint num)
{
  unsigned short x, y, n;
  n = num - 1;

  // starte Raytracing, schreibt pixel in pixmap
  for (y = 0; y < b; y++)
    for (x = 0; x < a; x++)
      writexy (x, y + y2, cbuff[y * a + x]);

  delete cbuff;
  XCopyArea (display, win.pixmap, pixbuff[n], gc, 0, 0, win.width, win.height, 0, 0);
  XCopyArea (display, win.pixmap, win.window, gc, 0, 0, win.width, win.height, 0, 0);
}

bool 
erzeuge_puffer (longint num)
{
  unsigned short a, b;

  if (!readkopf (&a, &b, num, 1))
    return false;

  pixbuff[num - 1] = XCreatePixmap (display, RootWindow (display, screen_num),
				  a, b, DefaultDepth (display, screen_num));
  zeichnepuffer (--a, --b, 0, num);
  return true;
}

bool 
erzeuge_puffer_stereo (longint num)
{
  word a, b;

  // 1. Bild lesen, oben ist Rechts !
  if (!readkopf (&a, &b, num, 1))
    return false;

  pixbuff[num - 1] = XCreatePixmap (display, RootWindow (display, screen_num),
			      a, b * 2, DefaultDepth (display, screen_num));
  zeichnepuffer (--a, --b, 0, num);

  // 2. Bild lesen, unten ist Links
  if (!readkopf (&a, &b, num, 2))
    return false;

  zeichnepuffer (--a, --b, b, num);

  return true;
}

void 
getgroesse (longint * a, longint * b)
{
  word x1, y1, x2, y2;
  FILE *D;

  if ((D = fopen ("scene_erg_1_1.rp", "r+")) == NULL)
    {
      cerr << "show: Fehler beim ffnen der Datei ./scene_erg_1_1.rp\n";
      exit (1);
    }

  fread (&x1, sizeof (word), 1, D);
  cout << "x1 = " << x1 << " ";
  fread (&y1, sizeof (word), 1, D);
  cout << "y1 = " << y1 << "\n";
  fread (&x2, sizeof (word), 1, D);
  cout << "x2 = " << x2 << " ";
  fread (&y2, sizeof (word), 1, D);
  cout << "y2 = " << y2 << "\n";

  // erzeuge puffer, 0 zhlt mit!
  *a = x2 - x1 + 1;
  *b = y2 - y1 + 1;
  fclose (D);
}

void 
lesedateien (int argc, char **argv)
{
  bool ok = true;
  longint x;
  longint a, b;

  // erzeuge Pixmapmatrix
  pixbuff = new Pixmap[anz];

  // Vorschau in die Datei um das Fenster zur Kontrollanzeige zu 
  // ffnen
  getgroesse (&a, &b);

  if (!initw (argc, argv, a - 1, stereo ? b * 2 - 2 : b - 1))
    {
      cerr << "Fehler beim Fensterffnen.\n";
      exit (1);
    }

  for (x = 1; ok && (x <= anz); x++)
    {
      // Bilde Dateinamen
      if (stereo)
	ok = erzeuge_puffer_stereo (x);
      else
	ok = erzeuge_puffer (x);
    }

  // merke das letzte angezeigte Bild
  anz = x - 2;
  lastx = anz;

  cout << "Ende einlesen!\n" << "Beenden, mit Strg-C in Shell oder q im Fenster.\n";
}

int 
main (int argc, char **argv)
{
  if (argc <= 3)
    {
      cout << "Bitte geben Sie\n als 1. Parameter die Millisekunden Pause an.\n"
	<< " als 2. Parameter 1=Stereo 0=Mono an.\n"
	<< " als 3. Parameter die Max. Anzahl der Bilder (eine Seite).\n";
      return -1;
    }
  else
    {
      sscanf (argv[1], "%d", &millisek);
      sscanf (argv[2], "%d", &stereo);
      sscanf (argv[3], "%d", &anz);

      cout << "Millisek: " << millisek << ", Stereo: "
	<< stereo << ", Max. Anzahl: " << anz << "\n";
    }

  lesedateien (argc, argv);
  while (true)
    gr_xevents ();
  return true;
}
