/*
   Berechnet den Sichtstrahl
   und schickt ihn in die "Welt".
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion

*/

#include "ray.H"

#ifdef _REENTRANT
extern pthread_mutex_t color_lock;
#endif

// ndert die Postition der Kamera durch den Sichtstrahl
void ray::position(vector * a, vector * b, world * w)
{
  // nach CAD-Tool erst verschieben dann drehen
  *b += w->cam.mov;
  rotationVN (a, w->cam.w);
}

//   verfolgt Strahl durch die Welt und gibt die Farbe zurck
float ray::showp (word x, word y, world * w, byte alias, color * col)
{
  byte n, z;
  float dx, dy, entf, grauwert;

  vector g1, g2;
  color c, cm (0.0, 0.0, 0.0);

  n = 5;			// Konstante, Anzahl der Strahlen

  // Sichtpunkt um g1 drehen
  g1.z = 0.0;
  g2.z = 1.0;
  g1.x = g1.y = 0.0;
  entf = 0.0;

  // Geradenablenkung durch Sichtfeld, Parallaxenprojektion
  // denkbar wren auch -> Perspektivprojektion, Fischauge, Orthografische Projektion
  // umdrehen
  y = w->observ.p_height - y;
  // keine Projektion -> flach
  g2.x = ((float) x / (float) w->observ.p_width - 0.5) * w->observ.dx;
  g2.y = ((float) y / (float) w->observ.p_height - 0.5) * w->observ.dy;
  // ndert die Postition der Kamera durch den Sichtstrahl
  position (&g2, &g1, w);
  // Antialiasing berechnen, ist immer xy Richtung
  if (((w->observ.ch == 'R') || (w->observ.ch == 'G')) && alias)
    {
      for (z = 0; z < n; z++)	// X Sichtstrahlen berechnen

	{
	  // Sampling gleichmig, Musterbildung mglich!
	  switch (z)
	    {
	    case 0:
	      dx = -0.4;
	      dy = 0.4;
	      break;
	    case 1:
	      dx = -0.4;
	      dy = -0.4;
	      break;
	    case 2:
	      dx = 0.4;
	      dy = -0.4;
	      break;
	    case 3:
	      dx = 0.4;
	      dy = 0.4;
	      break;
	    default:
	      dx = 0.0;
	      dy = 0.0;
	    }
	  // statistisches Sampling, zufllig bis bers Ziel schieen,
	  // besseres Ergebnis!
	  if (w->observ.ch == 'R')
	    {
	      dx += 0.2 * (((float) rand () / (float) RAND_MAX) - 0.5);
	      dy += 0.2 * (((float) rand () / (float) RAND_MAX) - 0.5);
	    }
	  dx /= (float) w->observ.p_width;
	  dy /= (float) w->observ.p_height;
	  g2.x += dx;		// Abgelenkter Strahl

	  g2.y += dy;
	  g2 |= g2;		// Richtung ist Normalvektor

	  entf += raytrace (g1, g2, 0, &c);
	  cm += c;		// Absicht keine berprfung!!!

	}
      cm /= (float) n;
      entf /= (float) n;
      *col = cm;
    }
  else
    {
      g2 |= g2;			// Richtung ist Normalvektor
      entf = raytrace (g1, g2, 0, col);
    }

  // ist Nebel vorhanden (Berechnung an dieser Stelle weil die Entfernung bentigt wird!

  if (w->nebel > eps4)		// Nebel - Sichtweite < 0 ist kein Nebel

    {
      // Nebelberechnung
      grauwert = entf / w->nebel;
      // <= begrenzt farben auf 1.0
      *col <= *col + color (grauwert, grauwert, grauwert);
    }
  return entf;
}

float ray::showpoint(word x, word y, world * w, color * col)
{
  float entf;
  int a, b, pa, pb, n, nx = 0, ny = 0, z = 0;

  color c;
  color cm (0.0, 0.0, 0.0);

  // normaler Strahl
  entf = showp (x, y, w, true, col);

  // Blende 0 ist Abbruch
  if (w->cam.blende == 0)
    return entf;

  // ist Unscharf?
  if ((n = getfuzzy (w->cam.blende, w->cam.entf, entf)) > 0)
    {
      // Berechnung der Tiefenschrfe auf Pixelbasis, Bei Bildern mit vielen Pixeln ist das 
      // Verhltnis von Bildpunkt zur Gesamtlnge anders !!! n ist dann zu erhhen
      // Grundanzahl von Pixel etwa 100, dies fhrt aber zu endlosen Rechenzeiten
      // if (w->observ.p_width  > 200) nx = n * w->observ.p_width / 100; else nx = n;
      // if (w->observ.p_height > 200) ny = n * w->observ.p_height / 100; else ny = n;
      ny = nx = n;

      // 0 weglassen und 1 machen
      for (a = 0; a <= ny; a++)
	for (b = 0; b <= nx; b++)
	  if (!((a == 0) && (b == 0)))
	    {
	      pb = x + b;
	      pa = y + a;
	      // nicht ber die Grenzen laufen!
	      if (pb > w->observ.p_width)
		pb = x;
	      if (pa > w->observ.p_height)
		pa = y;
	      entf = showp (pb, pa, w, false, &c);	// Wenn unscharf kein Anti-Aliasing!
	      // nur wenn neuer Punkt (Umgebung auch unscharf ist!

	      if (getfuzzy (w->cam.blende, w->cam.entf, entf))
		{
		  cm += c;
		  z++;
		}
	    }
      if (z)			// z ist immer 1, nur zur sicherheit!

	{
	  cm /= z;
	  *col = cm;
	}
    }				// ist Unscharf?
  return entf;
}

int ray::getfuzzy (int blende, int oentf, float rentf)
{
  float db, de, f, vent, s1, s2, s3, s4;

  // genau getroffen
  if ((vent = fabs (oentf - rentf)) < eps1)
    return 0;

  // Blendenfaktor
  switch (blende)
    {
    case 4:
      db = 1.0;
      break;
    case 8:
      db = 3.0;
      break;
    case 16:
      db = 5.0;
      break;
    default:
      return 0;			// Fehler

    }

  // Entfernungsfaktor
  if (oentf <= 1)
    de = 0.1;
  else if ((oentf > 1) && (oentf <= 3))
    de = 0.2;
  else if ((oentf > 3) && (oentf <= 10))
    de = 1.0;
  else
    de = 2.0;

  // Toleranzbereich
  f = db * de;

  // Auswahl der Fuzzy - Stufen; Bereich: [0<=b<=4] -> [0.1<=f<=6.0]
  // genauer zw 0.1 und 3 Unterschiede
  s1 = f / 5.0;
  if (vent <= s1)
    return 0;
  s2 = s1 * 2.0;
  if ((vent > s1) && (vent <= s2))
    return 1;
  s3 = s1 * 3.0;
  if ((vent > s2) && (vent <= s3))
    return 2;
  s4 = s1 * 4.0;
  if ((vent > s3) && (vent <= s4))
    return 3;
  if ((vent > s4) && (vent <= f))
    return 4;
  return 5;
}
