/*
   Raytracingmodul fr Schnittkrper und Schnittebene
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996 Helmut Fahrion

*/

#include "ray.H"

bool ray::testebene (obj * so, vector p)
{
  float d;
  vector n, r;

  n = ((polygon *) (so->grobjp))->getnormal ();
  r = *((polygon *) (so->grobjp))->getvector (0);

  d = n * (r - p);		// Hessesche Normalform

  // auf welcher Seite?
  return ((d < 0.0) ? true : false);
}

// Rekursiver Test ob der Strahl durch den Krper gelangen kann
bool ray::durchgang (obj * o, obj * last, vector point, vector dir, float entganz,
		     vector * pte, vector * dre)
{
  bool durch = false;
  float entpte, entpts2, entpts1;
  vector pts1, pts2, dirs1, dirs2;
  obj *no;

  entpte = point || *pte;

  for (no = o; !durch && no; no = no->nextS)
    {
      // schon getestetes kann entfallen
      if ((last != no) && (no->type != POLYGON) && (no->stype == SCHN) &&
	  no->hit_object (point, dir, &pts1, &dirs1, &pts2, &dirs2))
	{
	  entpts1 = point || pts1;
	  entpts2 = point || pts2;

	  // ist Durchgang?
	  if ((entpte > entpts1) && (entpte < entpts2))
	    {
	      // sichere Durchgang
	      *pte = pts2;
	      *dre = dirs2 * -1.0;
	      entpte = point || *pte;
	      // suche nchsten Durchgang
	      if (entpte >= entganz)
		durch = true;
	      else
		durch = durchgang (o, no, point, dir, entganz, pte, dre);
	    }
	}
    }
  return durch;
}

void ray::durchgangD (obj * o, vector point, vector dir, bool * durch, bool * schnitt)
{
  vector pts1, pts2, dirs1, dirs2;
  bool svorh, hit;
  obj *no;

  hit = svorh = false;
  for (no = o; no; no = no->nextS)
    {
      // gibt es diff-Schnittkrper
      if (no->stype == DIFF)
	{
	  svorh = true;
	  // schon getestetes kann entfallen
	  if ((no->type != POLYGON) &&
	      no->hit_object (point, dir, &pts1, &dirs1, &pts2, &dirs2))
	    {
	      // gibt es einen Treffer so nicht durch!
	      hit = true;
	    }
	}
    }

  // gibt es Diff-Schnitk. und kein hit
  if (svorh && !hit)
    *durch = true;

  // gibt es Diff-Schnitk. und hit
  if (svorh && hit)
    *durch = false;

  // gibt es keinen Diff-Schnitk, so nicht durch! da vor Aufruf auch nicht durch war
  // schnitt wird auf true gesetzt so wird die nchste schleife nicht mehr durchlaufen
  if (!svorh)
    *schnitt = true;
}

bool ray::hit (obj * o, vector point, vector dir, vector * sr, vector * sn)
{
  bool durch = false, schnitt = false, ok1, ok2;
  float entp1, entp2, entpts2, entpts1, entpts1o;
  vector pts1, pts2, dirs1, dirs2, pt1, pt2, dr1, dr2, pte, dre;
  obj *so;

  if (o->hit_object (point, dir, &pt1, &dr1, &pt2, &dr2))
    {
      if (o->nextS == NULL)	// kein Schnittkrper vorhanden

	{
	  *sr = pt1;
	  *sn = dr1;
	  return true;
	}

      // Schnittkrper als Schnitt
      pte = pt1;		// Anfangswert setzen

      dre = dr1;
      entp1 = point || pt1;
      entp2 = point || pt2;

      durch = false;
      // Schnittkrper als Schnitt
      // Test auf Schnittebene
      for (so = o->nextS; so && !durch; so = so->nextS)
	{
	  if ((so->type == POLYGON) && (so->stype == SCHN) &&
	      so->hit_object (point, dir, &pts1, &dirs1, &pts2, &dirs2))
	    {

	      // trifft abgeschnittene Seite?
	      ok1 = testebene (so, pt1);
	      ok2 = testebene (so, pt2);

	      // geht vorbei
	      if (ok1 && ok2)
		durch = true;

	      if (ok1 && !ok2)
		{
		  pte = pts1;	// Anfangswert neu setzen

		  dre = dirs1;
		  entp1 = point || pts1;
		}
	    }
	}

      schnitt = false;
      for (so = o->nextS; !durch && !schnitt && so; so = so->nextS)
	{
	  // wird Schnittobjekt getroffen?
	  if ((so->type != POLYGON) && (so->stype == SCHN) &&
	      so->hit_object (point, dir, &pts1, &dirs1, &pts2, &dirs2))
	    {
	      entpts2 = point || pts2;
	      entpts1 = point || pts1;

	      // schneidet der Krper die Kante?
	      if ((entp1 > entpts1) && (entp1 < entpts2))
		{
		  schnitt = true;
		  // setze Schnittpunkt
		  pte = pts2;
		  dre = dirs2 * -1.0;

		  // Gehts schon ganz durch?
		  if (entp2 < entpts2)
		    durch = true;
		  else
		    // durchsuche alle auf einen Durchgang
		    durch = durchgang (o->nextS, NULL, point, dir, entp2, &pte, &dre);
		}
	    }
	}

      if (!durch)
	{
	  // Druchlauf fr Durchschnitt

	  // erst mal einen Test ob es einen Krper mit DIFF gibt
	  // mit Absicht falsche Werte fr anfang!
	  entpts1o = entp2;

	  // gibt es treffer auf den Schnittkrper, gibt es Schnittkrper?
	  durchgangD (o->nextS, point, dir, &durch, &schnitt);

	  for (so = o->nextS; so && !durch && !schnitt; so = so->nextS)
	    {
	      // wird Schnittobjekt getroffen?
	      if ((so->type != POLYGON) && (so->stype == DIFF) &&
		  so->hit_object (point, dir, &pts1, &dirs1, &pts2, &dirs2))
		{
		  entpts2 = point || pts2;
		  entpts1 = point || pts1;

		  // Suche nhesten Punkt der Schnittkrper, aber nicht nher als entp1!
		  if ((entp1 > entpts1) && (entp1 < entpts2))	// Krper schneidet Kante

		    {
		      schnitt = true;	// es gilt Krperkante

		      pte = pt1;	// Anfangswert neu setzen

		      dre = dr1;
		    }
		  else
		    // nur wenn Schnitt im Krper & ist Schnittpunkt nher dem alten?, dann ok
		  if ((entpts1 > entp1) && (entpts1o > entpts1))
		    {
		      entpts1o = entpts1;
		      pte = pts1;	// Anfangswert neu setzen

		      dre = dirs1;
		      entp1 = point || pts1;
		    }
		}		// if hit

	    }			// for

	}			// if !durch

      if (durch)
	return false;
      else
	{
	  *sr = pte;
	  *sn = dre;
	  return true;
	}
    }
  else
    return false;		// kein Treffer

}
