/*
   Raytracingmodul fr Schnittkrper und Schnittebene
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

char *LIZENZSTR = "              Der Raytracer\n                Version 0.1\n\nWenn ich %s, \ndas Programm (oder eine darauf basierende\nArbeit) modifiziere oder verbreite, erklre ich\nmein Einverstndnis mit dieser Lizenz und allen \nihren Begriffen und Bedingungen zum Kopieren, \nVerbreiten und Modifizieren des Programms oder \neiner darauf basierenden Arbeit.\n\nThis program ist free software; you can redistribute \nist and/or modify it under the terms of the GNU \nGeneral Public License as publisched by the Free \nSoftware Foundation; either version 2 of the License, \nor (at your opption) any later version.\n\nThis program is distributed in the hope that it well \nbe useful, but WITHOUT ANY WARRANTY; without even the \nimplied warranty of MERCHANTABILITY or FITNESS FOR A \nPARTICULAR PURPOSE. See the GNU General Public License \nfor more details.\n\nYou should have received a copy of the GNU General \nPublic License along with this program; if not, write \nto the Free Software Foundation, Inc., 675 Mass Ave, \nCambridge, MA 02139, USA.\n\nDie GPL finden Sie in der HTML-Dokumentation.\n\nCopyright (C) 1996 Helmut Fahrion\n\nAls Student (ev. bis Januar 1997) bin ich erreichbar \nunter:\n   sfa2002@informatik.htw-dresden.de\n\nIn Verbindung mit dem Softwareprojekt:\n   nazca@vermessung.htw-dresden.de\n\nPost:\n   Helmut Fahrion jun.\n   An der Wyhra 35\n   04552 Borna\n   Germany\n";

#include <Xm/XmAll.h>
#include "ray.H"
#include <unistd.h>		// getlogin
#include <pwd.h>

// Bildschirm des Programmes
#define screen_num 0

// Farbwrfel Kante ()
#define COLKANTE 6

typedef enum
{
  staticgr,
  graysc,
  staticcol,
  pseudocol,
  truecol,
  directcol
};

typedef struct
{
  Visual *visual;
  VisualID visualid;
  int screen;
  unsigned int depth;
  int clas;			// weil hier im Orginal class steht !

  unsigned long red_mask;
  unsigned long green_mask;
  unsigned long blue_mask;
  int colormap_size;
  int bits_per_rgb;
}
XVisI;

XVisI visual;			// XVisualInfo visual; Trick 17

// speichern um nicht jedesmal zu errechnen
//unsigned long red_mask, redanz, green_mask, greenanz, blue_mask, blueanz;

// Globale Zeiger, nicht statisch definiert da sonst die Freigabe des
// Speichers unntig erschwert wird

world *pwelt;		// Zeiger auf Welt fr alle Welt
tree *ptree;		// Wurzel des Baumes, Globaler Pointer denn es gibt nur ein Baum

ray pray;
int par = 1;		// Linke oder Rechte Seite

cbyte *cbuff;		// Puffer zum Speichern der Pixelwerte
cbyte cbuffcolor;	// Farbe zum schreiben in Puffer

bool save = false;

// Daten fuer X-Funktionen zum zeichen
XtAppContext app;
GC Gc;
Display *Disp;
Colormap Cmap;
int MAXCOL;

uns long Pixels[COLKANTE * COLKANTE * COLKANTE + 1];

XColor xcol;
bool truecolor;
bool visok;

word anzdraw;			// Zeichnet nur alle x Pixel alles

Widget top, WGdrawarea, WFileSel, WHelpDialog;
Window Win;
Pixmap Winpixmap, Winpixmap_test;

int Width, Height;

// das X nicht rehentrant ist kann hier eine
// globale Variable fr das update der XPixmap
// gesetzt werden
#define UPDATEANZ 5000
dword  glinc;


/* ###### Ziffer fuer den neuen Button #### */
typedef enum
  {
    QB_ENDE, QB_NEU, QB_TEST, QB_SAVE, QB_LIZENZ, LETZTE
  };

Widget WGscrollwin, QWButtons[LETZTE + 1];
static int MenuID[] =
{QB_ENDE, QB_NEU, QB_TEST, QB_SAVE, QB_LIZENZ};
static String MenuStr[] =
{"Ende", "Neu", "Test", "Sichern", "Lizenz"};

// Prototypen
int get_colormap (void);

GC CreateSimpleGC (Widget W);
void errorbox (char *str);
void infobox (char *str);
void helpfiledialog (Widget Parent, char *str);

uns long new_foreground, old_foreground;
byte i = 0;

#ifdef _REENTRANT
pthread_mutex_t xlock;
#endif

color ci2cf(cbyte cb)
{
  return color((float)cb.r / (float)0xff, (float)cb.g / (float)0xff, (float)cb.b / (float)0xff);
}

void showhinweis (void)
{
  char text[3072], *un;		/* Puffer fr Text */
  char anonymous[] = "ANONYMOUS";
  struct passwd *pwd;

  if (!(pwd = getpwuid (getuid ())))
    un = anonymous;
  else
    un = pwd->pw_gecos;

  if (!strlen (un))
    un = pwd->pw_name;		/* 0 Lnge in passwd */
  if (!strlen (un))
    un = anonymous;		/* 0 Lnge in passwd */

  sprintf (text, LIZENZSTR, un);
  helpfiledialog (top, text);
}

// erst sichern Testzwecke
bool sichere_buff (word x1, word y1, word x2, word y2, word s, char *name)
{
  word a, b, nx1, nx2, ny1, ny2;
  FILE *D;

  cout << "schreibe Datei " << name << "\n";

  /* schreibe Bildfile -> Binaerfile */
  if ((D = fopen (name, "w+")) == NULL)
    {
      cerr << "raywin: Fehler beim ffnen der Datei " << name << "\n";
      return false;
    }

  // erzeuge puffer, 0 zhlt mit!
  nx1 = x1 * s;
  nx2 = x2 * s;
  ny1 = y1 * s;
  ny2 = y2 * s;

  a = nx2 - nx1;
  b = ny2 - ny1;
  fwrite (&nx1, sizeof (unsigned short), 1, D);
  fwrite (&ny1, sizeof (unsigned short), 1, D);
  fwrite (&nx2, sizeof (unsigned short), 1, D);
  fwrite (&ny2, sizeof (unsigned short), 1, D);
  fwrite (cbuff, sizeof (cbyte), a * b, D);
  fclose (D);

  cout << "fertig!\n";
  return true;
}

void buffdrawpoint (word x, word y)
{
  if ((x < Width) && (y < Height))	// nicht ber Rand schreiben!
    cbuff[y * Width + x] = cbuffcolor;
}

void buffdrawrectangle (dword x, dword y, dword s)
{
  dword xz, yz;
  for (xz = x; xz < (x + s); xz++)
    for (yz = y; yz < (y + s); yz++)
      buffdrawpoint (xz, yz);
}

void buffdrawrectangle (dword x, dword y, dword sx, dword sy)
{
  dword xz, yz;
  for (xz = x; xz < (x + sx); xz++)
    for (yz = y; yz < (y + sy); yz++)
      buffdrawpoint (xz, yz);
}

int highbit(unsigned long ul)
{
  int i;  unsigned long hb;
  hb = 0x8000;  hb = (hb<<16);  /* hb = 0x80000000UL */
  for (i=31; ((ul & hb) == 0) && i>=0;  i--, ul<<=1);
  return i;
}

void XRAllocColor(Display *dp, Colormap cm, XColor *cdef)
{
  unsigned long r, g, b, rmask, gmask, bmask, origr, origg, origb;
  int rshift, gshift, bshift;

  origr = r = cdef->red;  
  origg = g = cdef->green;  
  origb = b = cdef->blue;

  rmask = visual.red_mask;
  gmask = visual.green_mask;
  bmask = visual.blue_mask;

  rshift = 15 - highbit(rmask);
  gshift = 15 - highbit(gmask);
  bshift = 15 - highbit(bmask);

  r = (rshift<0)? r << (-rshift) : r >> rshift;
  g = (gshift<0)? g << (-gshift) : g >> gshift;
  b = (bshift<0)? b << (-bshift) : b >> bshift;

  r = r & rmask;
  g = g & gmask;
  b = b & bmask;

  cdef->pixel = r | g | b;

  cdef->red   = r = (rshift<0)? r >> (-rshift) : r << rshift;
  cdef->green = g = (gshift<0)? g >> (-gshift) : g << gshift;
  cdef->blue  = b = (bshift<0)? b >> (-bshift) : b << bshift;
}


void SetColor32(color rgb)
{
  cword c;
  XColor xcol;
  static XColor ocol;

  if (truecolor)
    {
      xcol.flags = DoRed | DoGreen | DoBlue;
      xcol.red   = (short unsigned int)(rgb.r * 0xffff);
      xcol.green = (short unsigned int)(rgb.g * 0xffff);
      xcol.blue  = (short unsigned int)(rgb.b * 0xffff);
 
      if (xcol.red == ocol.red && xcol.green == ocol.green && xcol.blue  == ocol.blue)
	new_foreground = old_foreground;
      else
	{
	  if (visok)
	    XRAllocColor(Disp, Cmap, &xcol);
	  else
	    XAllocColor(Disp, Cmap, &xcol);

	  old_foreground = new_foreground = xcol.pixel;
	  ocol = xcol;
	}
    }
  else
    {
      c.r = (byte) (rgb.r * (float) (MAXCOL - 1));
      c.g = (byte) (rgb.g * (float) (MAXCOL - 1));
      c.b = (byte) (rgb.b * (float) (MAXCOL - 1));
      new_foreground = Pixels[(unsigned)
			     (c.r + (MAXCOL) * c.g + (MAXCOL) * (MAXCOL) * c.b)];
    }

  XSetForeground (Disp, Gc, new_foreground);	// Fenster
  cbuffcolor = intcolor256(rgb);
}

void schleife1(int r, int g)
{
  float a, b;

  a = (float)r / (float)Width;
  b = (float)g / (float)Height;

#ifdef _REENTRANT
  pthread_mutex_lock(&xlock);
#endif

  switch (i)
    {
    case 1: 
      SetColor32(color(a, 0, b));  
      break;
    case 2: 
      SetColor32(color(a, b, 0));  
      break;
    case 3: 
      SetColor32(color(0, a, b));  
      break;
    }

      XDrawPoint(Disp, Winpixmap_test, Gc, r, g);

  if (!(glinc++ % (UPDATEANZ*7)))
    XCopyArea(Disp, Winpixmap_test, Win, Gc, 0, 0, Width, Height, 0, 0);

#ifdef _REENTRANT
  pthread_mutex_unlock(&xlock);
#endif

  //XDrawPoint (Disp, Win, Gc, r, g);	// Punkt im Window setzen
}


extern void thread_schleife(word Width, word Height, char num);

void writergb(void)
{
#ifndef _REENTRANT
  int r, g;
#endif

  Winpixmap_test = XCreatePixmap (Disp, RootWindow (Disp, screen_num),
				  Width, Height, 
				  DefaultDepth (Disp, screen_num));

  SetColor32(color(0,0,0));
  // Inhalt lschen
  XFillRectangle (Disp, Winpixmap_test, Gc, 0, 0, Width, Height);
  // inhalt ins Window sichern
  XCopyArea (Disp, Winpixmap_test, Win, Gc, 0, 0, Width, Height, 0, 0);
  // RGB Models abbilden, in Verschiedenen Richtungen Bild aufbauen
  switch (i)
    {
    case 1:
#ifdef _REENTRANT
      thread_schleife(Width, Height, 1);
#else
      for (r = 0; r < Width; r++)
	for (g = 0; g < Height; g++)
	  schleife1(r, g);
#endif
      break;

    case 2:
#ifdef _REENTRANT
      thread_schleife(Width, Height, 2);
#else
      for (r = Width - 1; r >= 0; r--)
	for (g = Height - 1; g >= 0; g--)
	  schleife1(r, g);
#endif
      break;


    case 3:
#ifdef _REENTRANT
      thread_schleife(Width, Height, 3);
#else
      for (g = 0; g < Height; g++)
	for (r = 0; r < Width; r++)
	  schleife1(r, g);
#endif
      break;
    }    
  XCopyArea(Disp, Winpixmap_test, Win, Gc, 0, 0, Width, Height, 0, 0);
}

void 
create_pixmap (void)
{
  //  Pixmap erzeugen um Bildschirminhalt zu speichern 
  Winpixmap = XCreatePixmap (Disp, RootWindow (Disp, screen_num),
			     Width, Height, DefaultDepth (Disp, screen_num));

  SetColor32(color(0,0,0));
  // Inhalt lschen
  XFillRectangle (Disp, Winpixmap, Gc, 0, 0, Width, Height);
  // inhalt ins Window sichern
  XCopyArea (Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0);
}

void 
CBsaveSelect (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  String file_name;

  if (XmStringGetLtoR (((XmFileSelectionBoxCallbackStruct *) pCallData)->value,
		       XmSTRING_DEFAULT_CHARSET, &file_name))
    {
      if (sichere_buff (pwelt->observ.x1, pwelt->observ.y1,
			pwelt->observ.x2, pwelt->observ.y2,
			pwelt->observ.pixel, file_name))
	save = true;
      else
	{
	  save = false;
	  errorbox ("Konnte Daten nicht sichern!");
	}
    }
  else
    errorbox ("Filebox: kein File selektiert!\n");

  XtUnmanageChild (WFileSel);
}

void 
CBsaveCancelSelect (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  /* FileBox beenden! */
  XtUnmanageChild (WFileSel);
}

void 
CBFileHelpSelect (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  infobox ("Hier knnen Sie das Bild im Ray-Format speichern. Mit \"rp2gif -srp name.rp\" anzeigen und mit \"rp2gif name.rp\" konvertieren. Falls nicht, wird in scene_x.rp gespeichert.");
}

void anzeige_neu(void)
{
  word x1, y1, x2, y2, p, o;

  save = false;
  pwelt->step(par);

  x1 = pwelt->observ.x1;
  y1 = pwelt->observ.y1;
  x2 = pwelt->observ.x2;
  y2 = pwelt->observ.y2;
  p = pwelt->observ.pixel;
  o = pwelt->observ.opixel;  

  glinc = 0;
  switch (pwelt->methode)
    {
    case ZBUFFER:
      cout << "Z-Puffer\n";
      pray.rayzbuffer(x1, y1, x2, y2, p, o);
      break;
    case RADIOSITYRAY:
    case RADIOSITY:
      pray.zmode = false;
    case RAYTRACING:
      if (pwelt->observ.opixel)
	{
	  cout << "Raytracing optimiert\n";
	  pray.raytraceboxR(x1, y1, x2, y2, p, o);
	}
      else
	{
	  cout << "Raytracing\n";
	  pray.raytracebox(x1, y1, x2, y2, p);
	}
      break;
    }   

  XCopyArea(Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0);
}

// +++++++++++++++ je nach Methode wird das Bild berechnet ++++++++++++++
void anzeige(void)
{
  word x1, y1, x2, y2, p, o;
  x1 = pwelt->observ.x1;
  y1 = pwelt->observ.y1;
  x2 = pwelt->observ.x2;
  y2 = pwelt->observ.y2;
  p = pwelt->observ.pixel;
  o = pwelt->observ.opixel;

#ifdef _REENTRANT
  pthread_mutex_init(&xlock, NULL);
  cout << "mutex_init(X11)\n";
#endif

  cout << "Methode = ";
 
  glinc = 0;
  switch (pwelt->methode)
    {
    case RADIOSITYRAY:
      cout << "Lichtstrkenverteilung+Raytracing\n";
      pray.calc2pass(x1, y1, x2, y2, p, o);
      break;
    case RADIOSITY:
      cout << "Lichtstrkenverteilung\n";  
      pray.radiosity(x1, y1, x2, y2, p, o);
      break;
    case ZBUFFER:
      cout << "Z-Puffer\n";
      pray.rayzbuffer(x1, y1, x2, y2, p, o);
      break;
    case RAYTRACING:
      if (pwelt->observ.opixel)
	{
	  cout << "Raytracing optimiert\n";
	  pray.raytraceboxR (x1, y1, x2, y2, p, o);
	}
      else
	{
	  cout << "Raytracing\n";
	  pray.raytracebox (x1, y1, x2, y2, p);
	}

      // Statistik
      cout << "\nmin " << (int) MIN_OBJ << " Objekte je Blatt:\n"
	<< "berschneidungstests:\n"
	<< "gespart = " << (int) pray.anz_erspart << "\n"
	<< "mehr    = " << (int) pray.anz_mehr << "\n";

      if (pray.anz_erspart > pray.anz_mehr)
	cout << (float) pray.anz_mehr / (float) pray.anz_erspart * 100.0
	  << " Prozent gespart\n";
      else
	cout << (float) pray.anz_erspart / (float) pray.anz_mehr * 100.0
	  << " Prozent mehr\n";
      break;
    default:
      cerr << "Falsche Methode = " << pwelt->methode << ". Nicht definiert!\n";
      break;
    }

   XCopyArea(Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0);
}

/*
void 
testbuffer (void)
{
  // RGB Models abbilden
  dword pos;
  int x, y;

  // RGB Models abbilden
  for (y = Height - 1; y >= 0; y--)
    for (x = 0; x < Width; x++)
      {
	pos = y * Width + x;
	SetColor32(ci2cf(cbuff[pos]));
	XDrawPoint (Disp, Win, Gc, x, y);	// da Zhlung bei 1 beginnt
      }
}
*/

void 
CBQButtons (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  Arg Aargs[2];
  int nArgs;

  switch (*(int *) pClientData)
    {
    case QB_NEU:
      anzeige_neu();
      break;
    case QB_TEST:
      i = (i < 4) ? i + 1 : 1;
      if (i == 4)
	{
	  XFreePixmap (Disp, Winpixmap_test);

	  XCopyArea(Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0); 
	  // oder Buffer testen
	  // testbuffer ();
	  i = 0;
	}
      else
	writergb();
      break;
    case QB_SAVE:
      nArgs = 0;
      XtSetArg (Aargs[nArgs], XmNdirMask,
		XmStringCreateLtoR ("*.rp", XmSTRING_DEFAULT_CHARSET));
      nArgs++;
      WFileSel = XmCreateFileSelectionDialog (top, "filesaveas", Aargs, nArgs);
      XtAddCallback (WFileSel, XmNokCallback, (XtCallbackProc) CBsaveSelect, NULL);
      XtAddCallback (WFileSel, XmNcancelCallback, (XtCallbackProc) CBsaveCancelSelect, NULL);
      XtAddCallback (WFileSel, XmNhelpCallback, (XtCallbackProc) CBFileHelpSelect, NULL);
      XtManageChild (WFileSel);
      break;
    case QB_LIZENZ:
      // helpfiledialog(top, LIZENZSTR);
      showhinweis ();
      break;
    }
}

/* Callback function to quit the program. */
void 
CBquit (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  // Wenn nicht gespeichert wurde dann hier
  // ###### in Endversion mal zum Testen aber nicht
  /*
     char str[40];
     if (!save)
     {
     sprintf(str, "scene_%d.rp", par);
     // erst sichern Testzwecke
     sichere_buff(pwelt->observ.x1, pwelt->observ.y1,
     pwelt->observ.x2, pwelt->observ.y2, 
     pwelt->observ.pixel, str);
     }
   */

  // sauber aufraumen
  delete pwelt;
  delete cbuff;

  XtDestroyWidget (top);

  XFreeColormap (Disp, Cmap);
  XFreePixmap (Disp, Winpixmap);
  XFreeGC (Disp, Gc);

  exit (0);
}

// Behandlung des Term-signales
void raywinkill (int sig)
{
  signal (sig, SIG_IGN);	// Signal ignorieren

  cerr << "raywin: Signal " << sig << " Terminiere!\n";

  CBquit (top, NULL, NULL);	// Definiert abbrechen

  // signal(sig, raywinkill);  // Signal wieder auf Routine setzen, zum Testen
  // exit(1);  // 1 Besagt das gekillt wurde
}

void CBRedraw (Widget w, caddr_t client_data, XEvent * event)
{
  XCopyArea (Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0);
}

// Funktionen zum Pixelgenerieren, normales Raytracing!
void 
writexy (word x, word y, word s)
{
  int xx, yy;
  color c;

  // berechnet die Farbe eines Punktes
  pray.showpoint (x, y, pwelt, &c);

#ifdef _REENTRANT
  pthread_mutex_lock(&xlock);
#endif

  // Farbe setzen SetColor (intcolor256 (c));
  SetColor32(c);

  if (s == 1)
    {
      XDrawPoint (Disp, Winpixmap, Gc, x, y);
      buffdrawpoint (x, y);
    }
  else
    {
      xx = x * s;
      yy = y * s;
      XFillRectangle (Disp, Winpixmap, Gc, xx, yy, s, s);
      buffdrawrectangle (xx, yy, s);
    }

  if (!(glinc++ % UPDATEANZ))
   XCopyArea(Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0);

#ifdef _REENTRANT
  pthread_mutex_unlock(&xlock);
#endif
}

void 
writecxy (word x, word y, word s, color c)
{
  int xx, yy;

#ifdef _REENTRANT
  pthread_mutex_lock(&xlock);
#endif

  SetColor32(c);
  if (s == 1)
    {
      XDrawPoint (Disp, Winpixmap, Gc, x, y);
      buffdrawpoint (x, y);
    }
  else
    {
      xx = x * s;
      yy = y * s;
      XFillRectangle (Disp, Winpixmap, Gc, xx, yy, s, s);
      buffdrawrectangle (xx, yy, s);
    }  

  if (!(glinc++ % UPDATEANZ))
    XCopyArea(Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0);

#ifdef _REENTRANT
  pthread_mutex_unlock(&xlock);
#endif
}

void 
writecboxxy (word x, word y, word dx, word dy, word s, color c)
{
  word xx, yy, dxx, dyy;

  xx = x * s;
  yy = y * s;
  dxx = dx * s;
  dyy = dy * s;

#ifdef _REENTRANT
  pthread_mutex_lock(&xlock);
#endif

  SetColor32(c);

  XFillRectangle (Disp, Winpixmap, Gc, xx, yy, dxx, dyy);
  buffdrawrectangle (xx, yy, dxx, dyy);
  
  if (! (glinc++ % UPDATEANZ) )
    XCopyArea(Disp, Winpixmap, Win, Gc, 0, 0, Width, Height, 0, 0);

#ifdef _REENTRANT
  pthread_mutex_unlock(&xlock);
#endif
}

bool 
init_widgets (int argc, char **argv, word width, word height)
{
  Widget bar, roll1, pulld1, WRowCol, WSframe, WForm;
  char x;

  Height = height;
  Width = width;

  top = XtVaAppInitialize (&app, "Raywin", NULL, 0, &argc, argv, NULL, NULL);

  WGscrollwin =
    XtVaCreateManagedWidget ("scrolwin", xmScrolledWindowWidgetClass, top,
			     XtNwidth, Width + 20,
			     //XtNheight, Height + 50,
			     XtNheight, Height + 70,    // Schriftartenabhngig
			     XmNscrollingPolicy, XmAUTOMATIC,
			     XmNvisualPolicy, XmVARIABLE,
			     NULL);

  WForm   = XtVaCreateManagedWidget("rowcol", xmFormWidgetClass, WGscrollwin, NULL);
  WRowCol = XtVaCreateManagedWidget("rowcol", xmRowColumnWidgetClass, WForm, NULL);

  // Create the menu bar.
  bar = XmCreateMenuBar (WRowCol, "menubar", NULL, 0);
  XtVaSetValues (bar,
	  XmNtopAttachment, XmATTACH_FORM, XmNleftAttachment, XmATTACH_FORM,
		 XmNrightAttachment, XmATTACH_FORM, NULL);
  XtManageChild (bar);

  // Create the pulldown menu.
  roll1 = XmCreatePulldownMenu (bar, "menue", NULL, 0);
  // Endebutton
  XtVaCreateManagedWidget (MenuStr[QB_ENDE], xmCascadeButtonWidgetClass, bar,
			   XmNsubMenuId, roll1, NULL);
  pulld1 = XtVaCreateManagedWidget (MenuStr[QB_ENDE], xmPushButtonWidgetClass, roll1, NULL);
  XtAddCallback (pulld1, XmNactivateCallback, (XtCallbackProc) CBquit, &MenuID[QB_ENDE]);

  // Beginne bei 1, ohne Ende
  for (x = 1; x < LETZTE; x++)
    {
      QWButtons[x] = XtVaCreateManagedWidget (MenuStr[x], xmPushButtonWidgetClass, bar, NULL);
      XtAddCallback (QWButtons[x], XmNactivateCallback, (XtCallbackProc) CBQButtons, &MenuID[x]);
    }

  WSframe = XtCreateManagedWidget ("wsframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  /*
  WGscrollwin =
    XtVaCreateManagedWidget ("scrolwin", xmScrolledWindowWidgetClass, WSframe,
			     XtNwidth, Width + 5,
			     XtNheight, Height + 5,
			     XmNscrollingPolicy, XmAUTOMATIC,
			     XmNvisualPolicy, XmVARIABLE,
			     NULL);
			     */
  // Arbeitsflche
  WGdrawarea =
    XtVaCreateManagedWidget ("drawwin", xmDrawingAreaWidgetClass, WSframe,
			     XtNwidth, Width,
			     XtNheight, Height,
			     NULL);

  // dem ScrolledWindow seinen Arbeitsbereich (WorkArea) mitteilen
  XmScrolledWindowSetAreas (WGscrollwin, NULL, NULL, WGdrawarea);
  XtAddCallback (WGdrawarea, XmNexposeCallback, (XtCallbackProc) CBRedraw, NULL);

  XtRealizeWidget (top);

  // Daten zum Zeichnen
  Disp = XtDisplay (top);
  Win = XtWindow (WGdrawarea);

  if (!get_colormap ())
    {
      cerr << "raywin: nicht mehr gengend Farbzellen frei!\n";
      errorbox ("Nicht mehr gengend Farben frei!\nBeenden Sie Farbintensive Anwendungen.");
    }

  // GC erzeugen um zeichnen zu knnen
  Gc = CreateSimpleGC (top);

  // init i fuer Test
  i = 0;
  anzdraw = 0;

  // fuer doppelte Speicherung
  create_pixmap ();

  // XtAppMainLoop(app);
  return true;
}

char *getdatum(void)
{
  static char zeit[27], x;
  time_t t;

  time(&t);
  strcpy(zeit, ctime(&t)); // DDD MMM dd hh:mm:ss YYYY

  zeit[19]=0;
  for (x=0;x<20;x++) zeit[x] = zeit[x+4];
  for (x=3;x<16;x++) zeit[x] = zeit[x+1];
  for (x=5;x<15;x++) zeit[x] = zeit[x+1];
  for (x=7;x<14;x++) zeit[x] = zeit[x+1];
  for (x=9;x<13;x++) zeit[x] = zeit[x+1];

  return zeit;
}

int 
main (int argc, char **argv)
{
  longint frames;
  int batchnr;
  char datname[256], begintime[80];
  time_t t;
  dword pos;

  // initialiesiere die Welt, und merke PID
  pwelt = new world ();

  // Test auf Stereobild
  if (argc > 1)
    {
      sscanf (argv[1], "%d", &par);
      cout << "Berechne Seite " << par << ".\n";
      sscanf (argv[2], "%d", &batchnr);
      cout << "Nummer fr Stapel " << batchnr << ".\n";
    }
  else
    {
      par = 1;
      batchnr = 0;
      cout << "Setze Seite +0.35, rechtes Auge, Objekte mehr links!\n";
    }

  // Batchmodus
  if (batchnr)
    {
      // Startzeit
      time (&t);
      sprintf (begintime, "%s", ctime (&t));
      cout << "PID: " << pwelt->pid << " " << "Start: " << begintime << "\n";

      pwelt->methode = RADIOSITYRAY;
      pwelt->diff = true;
      cout << "Raytrace im Hintergrund, Methode = 2Pass, D=ON.\n";

      // Gehe alle Kamerapositionen durch
      bool last = false;
      while (!last)
	{
	  char host[30];

	  frames = pwelt->step(par);
	  last = true;
	  cout << "Habe Frame: " << frames << " gelesen.\n";

	  gethostname(host, 30);
	  sprintf(datname, "%s_%s_%ld_%d.rp", host, getdatum(), frames, par);

	  cout << "Ermittele Dateiname = " << datname << "\n" << flush;
	  pray.raytracebuffer (pwelt->observ.x1, pwelt->observ.y1,
			       pwelt->observ.x2, pwelt->observ.y2,
			       datname);
	  cout << "Fertig = " << datname << "\n";
	}
    }
  else if (init_widgets (argc, argv, pwelt->observ.p_width * pwelt->observ.pixel,
			 pwelt->observ.p_height * pwelt->observ.pixel))
    {
      // Startzeit
      time (&t);
      sprintf (begintime, "%s", ctime (&t));
      cout << "PID: " << pwelt->pid << " " << "Start: " << begintime << "\n";

      // Bilde Puffer, genuegend ausfassen sonst Speicherueberschreitung!
      cbuff = new cbyte[(pwelt->observ.p_width + 1) * pwelt->observ.pixel *
			(pwelt->observ.p_height + 1) * pwelt->observ.pixel];

      // vorinitialisieren
      for (pos = 0; pos < (unsigned) (Width * Height); pos++)
	cbuff[pos].r = cbuff[pos].g = cbuff[pos].b = 0;

      cerr << "Anzahl x=" << pwelt->observ.p_width << ", y="
	<< pwelt->observ.p_height << ", s="
	<< pwelt->observ.pixel << ", ges="
	<< pwelt->observ.p_width * pwelt->observ.pixel *
	pwelt->observ.p_height * pwelt->observ.pixel << "\n";
      cout << "Raytrace " << Width << "x" << Height << "\n";
      pray.anz_mehr = pray.anz_erspart = 0;	// Statistik

      frames = pwelt->step (par);	//  Blickrichtung definieren

      cout << "Habe Frame: " << frames << " gelesen.\n";
      anzeige ();		// Aufteilung der Methoden

      cout << "Fertig\n";
      time (&t);		// Endezeit

      cout << "Start: " << begintime << "Ende:  " << ctime (&t) << "\n";
      signal (SIGTERM, raywinkill);	// Signalbehandlung einleiten

      XtAppMainLoop (app);
    }

  // Programmlaufzeit
  time (&t);
  cout << "PID: " << pwelt->pid << " " << "Start: " << begintime
    << "Ende: " << ctime (&t) << "\n";
  cerr << "Ende\n";
  return true;
}

GC 
CreateSimpleGC (Widget W)
{
  Arg Aargs[5];
  Cardinal nArgs;
  Pixel ForeGround, BackGround;
  Window WWRoot;
  XGCValues Xgc;
  unsigned long ulMask;

  // Die Farben des Widgets holen, fuer das GC erzeugt werden soll
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNforeground, &ForeGround);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNbackground, &BackGround);
  nArgs++;
  XtGetValues (W, Aargs, nArgs);

  // das Window, fuer das Widget muss noch nicht bestehen, also
  // Root Window des Bildschirms benutzen, weil es dieselbe Farbtiefe
  // besitzt und die Austauschbarkeit von GCs nur von der Farbtiefe
  // eines Windows bestimmt wird, i.e. alle GCs eines Bildschirms sind
  // austauschbar
  WWRoot = RootWindowOfScreen (XtScreen (W));

  // Farben und Font auf sinnvollen Wert einstellen
  Xgc.foreground = ForeGround;
  Xgc.background = BackGround;

  // Font muss unbedingt geladen werden, wenn mit FontLists und XmStringDraw
  // gearbeitet wird, sonst Xlib Error 56 (XChangeGC)
  Xgc.font = XLoadFont (XtDisplay (W), "fixed");

  // die Maske bestimmt, welche Werte von XGCValues sinnvoll
  // sind und deshalb gesetzt werden sollen
  ulMask = GCForeground | GCBackground | GCFont;
  return XCreateGC (XtDisplay (W), WWRoot, ulMask, &Xgc);
}


int get_colormap (void)
{
  int x, y, anz, red, green, blue, depth;
  XColor xcol;
  Visual *Dvis;

  Cmap = DefaultColormap(Disp, DefaultScreen (Disp));
  Dvis = DefaultVisual(Disp, DefaultScreen (Disp));

  MAXCOL = COLKANTE;
  x = false;

  visok = false; anz = y = 0;

  cerr << "Bilde Farbwrfel:\n";

  // Ermittle Visual fr Berechnung der Farbpixel
  depth = DefaultDepth(Disp, DefaultScreen(Disp));

  // Truecolor ab bpp 15 
  if ((depth >= 15) && !XAllocColorCells (Disp, Cmap, false, 0, 0, Pixels, 1))
    {
      if (XMatchVisualInfo(Disp, DefaultScreen(Disp),
			   depth, TrueColor, (XVisualInfo *) & visual))
	visok = true;
      if (visok)
	{
	  truecolor = true;
	  return true;
	}
      else
	{
	  cerr << "Keine Farbzelle und Visualtype ungleich! \n";
	  truecolor = false;
	}

    }

  // Teste wieviele Farben frei sind
  while ((MAXCOL > 3) && (!x))
    {
      x = XAllocColorCells (Disp, Cmap, True, (unsigned long *) NULL, 0,
			    Pixels, MAXCOL * MAXCOL * MAXCOL);
      if (!x)
	MAXCOL--;
    }

  // 6 geht noch mit bpp 8 und Pseudocolor, Staticcolor,
  if (MAXCOL < 6)
    {
      MAXCOL = 6;
      Cmap = XCreateColormap (Disp, Win, XDefaultVisual (Disp, screen_num), AllocNone);

      if (XAllocColorCells (Disp, Cmap, false, 0, 0, Pixels, MAXCOL * MAXCOL * MAXCOL))
	{
	  y = 0;
	  for (blue = 0; blue < MAXCOL; blue++)
	    for (green = 0; green < MAXCOL; green++)
	      for (red = 0; red < MAXCOL; red++)
		{
		  xcol.pixel = Pixels[y];
		  xcol.flags = DoRed | DoGreen | DoBlue;
		  xcol.red = (unsigned) (red * 65535L / (MAXCOL - 1));
		  xcol.green = (unsigned) (green * 65535L / (MAXCOL - 1));
		  xcol.blue = (unsigned) (blue * 65535L / (MAXCOL - 1));
		  XStoreColor (Disp, Cmap, &xcol);
		  y++;
		}
	  // Top- Window setzen !!!
	  XSetWindowColormap (Disp, XtWindow (top), Cmap);
	}
      cerr << "Pseudocolor: Anzahl der Farben: " << anz << " gesamt: " << y << "\n";
      if (y > 0)
	return true;
    }
  else
    // berechne auf die vorhandene Colortabelle
    {
      anz = y = 0;

      for (blue = 0; blue < MAXCOL; blue++)
	for (green = 0; green < MAXCOL; green++)
	  for (red = 0; red < MAXCOL; red++)
	    {
	      xcol.flags = DoRed | DoGreen | DoBlue;
	      xcol.pixel = Pixels[y];
	      xcol.red = (unsigned) (red * 65535L / (MAXCOL - 1));
	      xcol.green = (unsigned) (green * 65535L / (MAXCOL - 1));
	      xcol.blue = (unsigned) (blue * 65535L / (MAXCOL - 1));
	      if (XStoreColor (Disp, Cmap, &xcol))
		anz++;
	      y++;
	    }
      cerr << "Staticcolor: Anzahl der Farben: " << anz << " gesamt: " << y << "\n";
      if (anz > 0)
	return true;
    }

  infobox ("Kein TrueColor und kein Pseudocolor mglich!\nVersuche langsame Farbberechnung!");
  // keine Farbe allociert -> True Color?
  truecolor = true;
  return true;
}

void 
errorbox (char *str)
{
  Widget AWDialog;
  Arg Aargs[3];
  int nArgs;

  XmString errorstr, labelstr;
  errorstr = XmStringCreateLtoR (str, XmSTRING_DEFAULT_CHARSET);
  labelstr = XmStringCreateLtoR ("Ende", XmSTRING_DEFAULT_CHARSET);
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNmessageString, errorstr);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNokLabelString, labelstr);
  nArgs++;
  AWDialog = XmCreateErrorDialog (top, "errorbox", Aargs, nArgs);
  /*  Helpbutton Cancelbutton Abstellen */
  XtUnmanageChild (XmMessageBoxGetChild (AWDialog, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild (XmMessageBoxGetChild (AWDialog, XmDIALOG_CANCEL_BUTTON));
  //   XtAddCallback(AWDialog, XmNhelpCallback, (XtCallbackProc)CBquit, (XtPointer)AWDialog);
  XtAddCallback (AWDialog, XmNokCallback, (XtCallbackProc) CBquit, (XtPointer) AWDialog);
  XtManageChild (AWDialog);
}

// Widget AWInfoDialog;

void 
CBinfo (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtUnmanageChild (W);
}

void 
infobox (char *str)
{
  static Widget AWInfoDialog;
  Arg Aargs[3];
  int nArgs;

  XmString errorstr, labelstr;
  errorstr = XmStringCreateLtoR (str, XmSTRING_DEFAULT_CHARSET);
  labelstr = XmStringCreateLtoR ("OK", XmSTRING_DEFAULT_CHARSET);
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNmessageString, errorstr);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNokLabelString, labelstr);
  nArgs++;
  AWInfoDialog = XmCreateInformationDialog (top, "infobox", Aargs, nArgs);
  /*  Helpbutton Cancelbutton Abstellen */
  XtUnmanageChild (XmMessageBoxGetChild (AWInfoDialog, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild (XmMessageBoxGetChild (AWInfoDialog, XmDIALOG_CANCEL_BUTTON));
  XtAddCallback (AWInfoDialog, XmNokCallback, (XtCallbackProc) CBinfo, (XtPointer) AWInfoDialog);
  XtManageChild (AWInfoDialog);
}

/* ******** ffnet eine Textbox als Hilfetext ******** */
void 
CBHelpOk (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtUnmanageChild (WHelpDialog);
  WHelpDialog = NULL;
}

void 
helpfiledialog (Widget Parent, char *str)
{
  Arg Aargs[5];
  int nArgs;

  Widget WButtonOK, WRowCol, WRowCol2, helptext, Wframe;

  WHelpDialog = XmCreateDialogShell (Parent, "helpfiledialog", NULL, 0);
  XtManageChild (WHelpDialog);
  WRowCol = XtVaCreateManagedWidget ("helpfilerow", xmRowColumnWidgetClass, WHelpDialog,
				     XmNorientation, XmVERTICAL,
				     XmNpacking, XmPACK_TIGHT,
				     XmNwidth, 600,
				     XmNheight, 390,
				     NULL);

  Wframe = XtCreateManagedWidget ("helpframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WRowCol2 = XmCreateRowColumn (Wframe, "helpfilerow2", NULL, 0);
  XtManageChild (WRowCol2);

  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNeditMode, XmMULTI_LINE_EDIT);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNeditable, false);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNrows, 15);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNcolumns, 40);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNwordWrap, true);
  nArgs++;
  helptext = XmCreateScrolledText (WRowCol2, "helptext", Aargs, nArgs);

  XmTextSetString (helptext, str);
  XtManageChild (helptext);

  WButtonOK = XtCreateManagedWidget ("OK", xmPushButtonWidgetClass, WRowCol, NULL, 0);
  XtManageChild (WButtonOK);

  XtAddCallback (WButtonOK, XmNactivateCallback, (XtCallbackProc) CBHelpOk, NULL);
}





