/* ------------------------------------------------------------------
   Dieses Modul steht nicht unter der GPL. Alle Urheberrechte und das
   Kopierrecht gehren Helmut Fahrion.

   Der Quellcode dieses Modules wird im Quellcode ausgeliefert um das
   Portieren dieser Software zu ermglichen.

   Dieses Modul darf fr andere Zwecke nicht verwendet werden.

   Wer dieses Modul fr Zwecke der Weiterentwicklung oder fr ein
   eigenes Produkt bentigt mu sich mit mir in Verbindung setzen.

   email:
     hf@suse.de
   oder
     nazca@informatik.htw-dresden.de
--------------------------------------------------------------------- */

#include "ray.H"

#ifdef _REENTRANT


// hier kann die Anzahl der verwendeten CPU's eingestellt werden
#define ANZ_CPUS 2

extern void writexy (word x, word y, word s);
extern void writecxy (word x, word y, word s, color c);
extern void schleife1(int r, int g);

typedef struct rts
{
  word x1, y, x2, s;
};

typedef struct rtsbuff
{
  word  x1, y, x2, s;
  cbyte *cb;
};

typedef struct radtr
{
  radios *itr;
  longint von, bis, begin;
};

typedef struct testtr
{
  word h, r;
};

// +++++ Raytracing - Threads ++++++++++++++++++++++++
void * ray_work(rts * rt)
{
  word x;

  for (x = rt->x1; x < rt->x2; x++)
    writexy(x, rt->y, rt->s);

  return NULL;
}


ray::raytread::raytread(word X1, word Y1, word X2, word Y2, word S)
{
  word x, y;
  void * retval;
  rts       rt[ANZ_CPUS];
  pthread_t th[ANZ_CPUS];
  word zeile;

  zeile = 0;

  do 
    {
      for (x=0;x<ANZ_CPUS;x++)
	{
	  if (x < Y2)
	    {
	      rt[x].x1=X1; rt[x].y=zeile; rt[x].x2=X2; rt[x].s = S;
	      if (pthread_create(&th[x], NULL, ray_work, &rt[x]))  
		cerr << "create thread1 failed!\n";
	      zeile ++;
	    }
	}
      
      for (y=0;y<ANZ_CPUS;y++)
	if (y < Y2)
	  pthread_join(th[y], &retval);

    } while (zeile < Y2);
}


void * bray_work(rtsbuff * rt)
{
  word  x;
  color c;

  for (x = rt->x1; x < rt->x2; x++)
    {
      pray.showpoint (x, rt->y, pwelt, &c);
      rt->cb[rt->y * rt->x2 + x] = intcolor256(c);
    }
  
  return NULL;
}

ray::raytread::raytread(word X1, word Y1, word X2, word Y2, cbyte *cbuff)
{
  word x, y;
  void * retval;
  rtsbuff   rt[ANZ_CPUS];
  pthread_t th[ANZ_CPUS];
  word zeile;

  zeile = 0;

  do 
    {
      for (x=0;x<ANZ_CPUS;x++)
	{
	  if (x < Y2)
	    {
	      rt[x].x1=X1; rt[x].y=zeile; rt[x].x2=X2; rt[x].cb=cbuff; 
	      if (pthread_create(&th[x], NULL, bray_work, &rt[x]))
		cerr << "create thread1 failed!\n";
	      zeile ++;
	    }
	}
      
      for (y=0;y<ANZ_CPUS;y++)
	if (y < Y2)
	  pthread_join(th[y], &retval);

    } while (zeile < Y2);
}


// +++++ Radiosity - Threads ++++++++++++++++++++++++

void * rad_work(radtr * ia)
{
  ia->itr->verteile_licht(ia->begin, ia->von, ia->bis);
  return NULL;
}

void radios::verteile_treading(longint von, longint bis)
{
  void    * retval;
  longint   anzahl, anzc;
  word      x;

  radtr     rt[ANZ_CPUS];
  pthread_t th[ANZ_CPUS];


  anzahl = (bis-von) / ANZ_CPUS;

  for (anzc=x=0;x<ANZ_CPUS;x++, anzc++)
    {
      rt[x].itr = this;
      rt[x].begin = von;
      rt[x].von = von + anzahl*x; 
      rt[x].bis = von + anzahl*x + anzahl;

      if (x == ANZ_CPUS-1) rt[x].bis = bis;

      if (pthread_create(&th[x], NULL, rad_work, &rt[x]))
	cerr << "create thread1 failed!\n";

      if (rt[x].von == rt[x].bis)
	goto ende;
    }

ende:
  for (x=0;x<anzc;x++)
      pthread_join(th[x], &retval);
}


// ++++++ Test Threads Farbpallete ++++++++++

void * test_work(testtr * ia)
{
  for (word g = 0; g < ia->h; g++)
    schleife1(ia->r, g);
  return NULL;
}

void * test_work2(testtr * ia)
{
  for (word g = 0; g < ia->h; g++)
    schleife1(g, ia->r);
  return NULL;
}

void thread_schleife(word Width, word Height, char num)
{
  void    * retval;
  word      r, zeile;

  testtr    rt[ANZ_CPUS];
  pthread_t th[ANZ_CPUS];

  zeile = (num != 1)? Width-1 : 0;
  do 
    {
      for (r = 0; r < ANZ_CPUS; r++)
	{
	  if (r < Width)
	    {
	      rt[r].h = Height;
	      rt[r].r = zeile;

	      if (num == 3)
		{
		  if (pthread_create(&th[r], NULL, test_work2, &rt[r]))
		    cerr << "create thread1 failed!\n";
		}
	      else
		if (pthread_create(&th[r], NULL, test_work, &rt[r]))
		  cerr << "create thread1 failed!\n";

	      if (num != 1) zeile--; else zeile++;
	    }
	}
  
      for (r = 0; r < ANZ_CPUS; r++)
	{
	  if (r < Width)
	      pthread_join(th[r], &retval);
	}
    } while (zeile < Width);
}



#endif












