/* **********************************
   Raytracer Hauptmodul
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "ray.H"

// errechnet die Farbe eines Bildpunktes (R)
float ray::raytrace (vector point, vector dir, word depth, color * col)
{
  obj *object, *sobj=0;
  color local_col, ref_col, trans_col;
  vector npoint, normal, ref_dir, trans_dir;
  float entf, sp, br;

  // Erweiterung fr Z-Buffer Algorithmus finde nchstes Objekt, nur beim 1. Mal
  if (zmode && (depth == 0))
    {
      // Z-Buffer Raytracing, spare 1. Durchlauf durch die Objekte ein!
      object = zbuffobj;
      if (!hit (object, point, dir, &npoint, &normal))
	return -1.0;
      else
	entf = npoint || point;
    }
  else
    object = show_trace (ptree, point, dir, &npoint, &normal, sobj, &entf);

  // kein Objekt getroffen
  if (!object)
    bckgrnd (col, pwelt->backh, pwelt->backb, dir);
  else
    {
      // Farbe des Schnittpunktes
      local_color (object, point, dir, normal, npoint, &local_col);

      // Rekursionstiefe ereicht ?
      if (depth <= MAX_DEPTH)
	{
	  // berechne reflektions Strahlenvector, + Spiegeltextur
	  sp = object->mirror;
	  if ((sp > 0.0) || object->calc_spiegelnd(&sp, npoint))
	    {
	      ref_vector (object, npoint, normal, dir, &ref_dir);
	      raytrace (npoint, ref_dir, ++depth, &ref_col);
	    }
	  else
	    ref_col = color (0.0, 0.0, 0.0);

	  // berechne durchgehenden Strahlenvector
	  br = object->trans;
	  if ((br > 0.0) || object->calc_brechend(&br, npoint))
	    {
	      trans_vector (object, npoint, normal, dir, &trans_dir);
	      raytrace (npoint, trans_dir, ++depth, &trans_col);
	    }
	  else
	    trans_col = color (0.0, 0.0, 0.0);
	}
      else
	//  Alles ist schwarz
	ref_col = trans_col = color (0.0, 0.0, 0.0);

      Combine (col, &local_col, object->material, &ref_col, sp,
	       &trans_col, br);

      object->surfaceCol(col, npoint);
      return entf;
    }
  return 0.0;
}

// kombiniert alle Farben zur Gesamtfarbe
void ray::Combine (color * colour, color * local_col, float local_weight,
		   color * ref_col, float ref_weight,
		   color * trans_col, float trans_weight)
{
  color col (1.0, 1.0, 1.0);
  *colour = *local_col * local_weight;
  col = *ref_col * ref_weight;
  *colour = col + *colour;
  col = *trans_col * trans_weight;
  *colour = col + *colour;
}

// berechnet transmittiertende Richtung durch eine durchsichtige Wand
void ray::trans_vector (obj * obj, vector intpt, vector normal, vector dir, vector * trans_dir)
{
  float cosa;
  vector d = dir;

  // Texture als Vektornderung vorhanden?
  obj->calc_wave(&d, intpt, normal);
  cosa = !(normal * d);
  *trans_dir = (d * (1.0 / obj->N)) - (normal * (sqrt (1.0 - (1.0 - cosa * cosa) /
				     (obj->N * obj->N)) - (cosa / obj->N)));
}

// berechnet reflections Richtung auf eine Spiegelflche
void ray::ref_vector (obj * pbj, vector intpt, vector normal, vector dir, vector * ref_dir)
{
  vector d = dir;

  // Texture als Vektornderung vorhanden?
  pbj->calc_wave(&d, intpt, normal);
  *ref_dir |= (normal * (2.0 * (normal * !d))) + d;
}

// berechnet den lokalen Farbwert des Schnittpunktes des Objektes
void ray::local_color(obj * obj, vector point, vector dir, vector normal,
		      vector int_point, color * local_col)
{
  lamp *lamp;
  spot *spotp;
  lichtpoly *lp;
  color lc;

  // Ausnahmeflle sind Sterne, strahlen Licht aus (werden immer angeleuchtet)
  if (obj->type == STAR)
    {
      // besser ist die Objektfarbe, diese kann dann in Scenenfile bestimmt werden
      *local_col = obj->col;
      return;
    }

  // erstmal dunkel
  lc = pwelt->black;

  // *** Hier ist die Zusammenfhrung ***
  if (pwelt->methode == RAYTRACING || pwelt->methode == RADIOSITYRAY)
    {
      // alle Punktlichtquellen durchsuchen!
      for (lamp = pwelt->lampe; lamp; lamp = lamp->next)
	lc += lamp->get_color(int_point, dir, normal, obj);
      //lc += color(0.5,0.5,0.5);

      // alle Strahler durchsuchen!
      for (spotp = pwelt->strahler; spotp; spotp = spotp->next)
	lc += spotp->get_color (int_point, dir, normal, obj);

      // alle Licht-Flchen durchsuchen!
      for (lp = pwelt->lichtpolyp; lp; lp = lp->next)
	lc += lp->get_color (int_point, dir, normal, obj);
      
      if (pwelt->methode != RAYTRACING)
	//lc += obj->surfaceColRadio(int_point, point, dir);
	lc.max(obj->surfaceColRadio(int_point, point, dir));
    }
  else
    {
      // nur Glanzlichter durchsuchen
      // alle Punktlichtquellen durchsuchen!
      for (lamp = pwelt->lampe; lamp; lamp = lamp->next)
	lc += lamp->get_color_spec(int_point, dir, normal, obj);

      // alle Strahler durchsuchen!
      for (spotp = pwelt->strahler; spotp; spotp = spotp->next)
	lc += spotp->get_color_spec(int_point, dir, normal, obj);

      // alle Licht-Flchen durchsuchen!
      for (lp = pwelt->lichtpolyp; lp; lp = lp->next)
	lc += lp->get_color_spec(int_point, dir, normal, obj);

      if (pwelt->methode != RAYTRACING)
	lc.max(obj->surfaceColRadio(int_point, point, dir));
      //lc += obj->surfaceColRadio(int_point, point, dir);
    }

  if (pwelt->methode == RAYTRACING)
    lc += pwelt->ambient;

  // Begrenzen!
  *local_col <= lc;
}
 
// verfolgt einen Lichtstrahl bis zum Auftreffen
obj *ray::show_trace(tree * ptr, vector point, vector dir,
		     vector * npoint, vector * normal, obj *sobject, float *entf)
{
  vector sr, sn;
  byte x;
  float e = 0.0;
  obj *obj = ptr->o;		// erstes Objekt

  if (ptr == ptree)
    sobject = NULL;		// beim 1. Mal Null

  anz_mehr++;
  if (ptr->hit_object(point, dir))	// wird Wrfel getroffen?
    {
      while (obj)		// Schleife durch alle Objekte
	{
	  // getroffen ?
	  if (hit(obj, point, dir, &sr, &sn))
	    {
	      e = sr || point;
	      if ((!sobject) || (e < (*npoint || point)))	// am Betrachter nchste!
		{
		  sobject = obj;
		  *npoint = sr;
		  *normal = sn;
		  *entf = e;
		}
	    }
	  obj = obj->next;
	}			//  while
    }
  else
    anz_erspart += ptr->anzobj;

  // rekursiv den Baum durchsuchen
  for (x = 0; x < 8; x++)
    if (ptr->t[x] != NULL)
      show_trace (ptr->t[x], point, dir, npoint, normal, sobject, entf);

  return (sobject);
}











