/*
   Modul fr die Radiosity

   Dieses Modul steht nicht unter der GPL. Alle Urheberrechte und das
   Kopierrecht gehren Helmut Fahrion.

   Der Quellcode dieses Modules wird im Quellcode ausgeliefert um das
   Portieren dieser Software zu ermglichen.

   Dieses Modul darf fr andere Zwecke nicht verwendet werden.

   Wer dieses Modul fr Zwecke der Weiterentwicklung oder fr ein
   eigenes Produkt bentigt mu sich mit mir in Verbindung setzen.

   email:
     hf@suse.de
   oder
     nazca@informatik.htw-dresden.de

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "ray.H"

// Methode die das Radiosity startet, kein Raytracing, deshalb hier
void ray::radiosity(word x1, word y1, word x2, word y2, word S, word P)
{
  radios r(x1, y1, x2, y2, S, P, pwelt->diff);  // Speicher und init

  r.verteile();            // Strahlung verteilen
  zmode = false;

  if (pwelt->observ.opixel)  // 2-Pass Anzeige
    pray.raytraceboxR(x1, y1, x2, y2, S, P);
  else
    pray.raytracebox(x1, y1, x2, y2, S);

  // pray.zmode = true;
  // r.anzeige();             // Z-Puffer Anzeigen
}

// Methode die das Radiosity startet, kein Raytracing, deshalb hier
void ray::radiositybuf(word x1, word y1, word x2, word y2, word S, word P)
{
  radios r(x1, y1, x2, y2, S, P, pwelt->diff);  // Speicher und init
  r.verteile();            // Strahlung verteilen
}

radios::radios(word X1, word Y1, word X2, word Y2, word S, word P, bool diff)
{
  // Member init
  x1 = X1; y1 = Y1;  x2 = X2;  y2 = Y2;  s  = S;  p  = P;  spek2diff = diff;

  // Patches erzeugen
  get_tree(create_patches, ptree);

  // Patcharray fr Iteration bilden
  anzpatches = 0;
  get_tree(get_anzahl, ptree);

  // und jetzt wird geswappt !!!
  ita = new iterarray[anzpatches];

  // init iterarray
  i = 0;
  get_tree(init_array, ptree);

#ifdef _REENTRANT 
  cout << "Init Mutex.\n";
  for (longint x=0; x<anzpatches; x++)
    pthread_mutex_init(& ita[x].p->lock, NULL);
#endif

  // Verteile die Energie der Punkt u.. Raytracing-lichtquellen
  // auf die Patches
  verteile_lichtquellen();
}

void radios::verteile_quellen_lamp(light *la)
{
  vector v;
  longint x;
  for (x=0; x<anzpatches;x++)
    {
      v |= ita[x].p->m - la->m;
      if ((v * ita[x].p->n) < 0.0)  // Verdeckungsproblem lindern!
	max(ita[x].p,     // rechne ich immer falsch?
	    la->get_color(ita[x].p->m, VNULL, ita[x].p->n, ita[x].o));
    }
}

void radios::verteile_lichtquellen(void)
{
  lamp      *lp;
  spot      *spotp;
  lichtpoly *lpoly;

  // Punkt, Strahler, Lichtpoly werden auf Flchen verteilt
  if (spek2diff)
    {
      cout << "Durchsuche Lichtquellen: " << pwelt->lampe << "\n" << flush;
      // alle Punktlichtquellen durchsuchen!
      for (lp = pwelt->lampe; lp; lp = lp->next)
	  verteile_quellen_lamp(lp);

      // alle Strahler durchsuchen!
      cout << "Durchsuche Strahlerquellen: " << pwelt->strahler << "\n" << flush;
      for (spotp = pwelt->strahler; spotp; spotp = spotp->next)
	verteile_quellen_lamp(spotp);

      // alle Strahler-Flchen durchsuchen!
      cout << "Durchsuche Lichtpolygon: " << pwelt->lichtpolyp << "\n" << flush;
      for (lpoly = pwelt->lichtpolyp; lpoly; lpoly = lpoly->next)
	verteile_quellen_lamp(lpoly); 
   }
}

void radios::get_tree(worktyp work, tree * ptr)
{
  patcharray *pa;
  longint x;

  // alle Objekte
  for (obj *pobj = ptr->o; pobj; pobj = pobj->next)
    switch (work)
      {
      case init_array:
	pa = pobj->getpatches();
	// alle Patches
	for (x=0; x<pa->anz; x++)
	  {
	    ita[i].o = pobj;        // Objektpointer
	    ita[i].p = &pa->pa[x]; // Patchpointer
	    i++;
	  }
	break;
      case get_anzahl:
	pa = pobj->getpatches();
	anzpatches += pa->anz;
	break;
      case create_patches:
	pobj->createpatches(pwelt->MinA);
	break;
      default:
	cerr << "Falscher worktyp!\n";
      }

  // rekursiv den Baum weiter durchsuchen
  for (byte y = 0; y < 8; y++)
    if (ptr->t[y] != NULL)
      get_tree(work, ptr->t[y]);
}

void radios::outputarray(void)
{
  byte tab;
  for (tab = i = 0; i < anzpatches; i++, tab++)
    if (tab == 4)
      {
	tab = 0;
	cout << "[" << i << "] = " << ita[i].p->cm << "\n";
      }
    else 
      cout << "[" << i << "] = " << ita[i].p->cm << " ";
}

void radios::setmaxarray(longint anza)
{
  longint x;
  iterarray ia;
  
  // nicht sortieren sondern nur Maximalwert ermitteln
  for (x = anza+1; x < anzpatches; x++)
    if (ita[anza].p->cm < ita[x].p->cm)
      {
	ia = ita[x];
	ita[x]=ita[anza];
	ita[anza]=ia;
      }
}

void radios::verteile(void)
{
  /* Hier wird das Licht verteilt, hier knnten mehrere ,,Worker''
     sich an der Verteilung beteiligen! */

  cout << "Anzahl Punkte: " << anzpatches << "\n";

  byte    z=AUSGABE;
  longint x;

  for (z=x=0; x<(anzpatches-1); x++, z=z<250?z+1:1)
    {
      setmaxarray(x);

      if (ita[x].p->cm > eps7)
	{
	  if (!(z%AUSGABE)) 
	    cout << "PID: " << pwelt->pid << " Iterationsschritt: " << x << 
	      " Farbwert: " << ita[x].p->cm << "\r" << flush;
#ifndef _REENTRANT
	  verteile_licht(x, x+1, anzpatches);
#else
	  verteile_treading(x, anzpatches);
#endif
	}
    }
  cout << "\nEnde der Iteration, Lichtstrke = " << ita[x].p->cm << "\n";
}

void radios::max(patch *p, color c)
{
  word r, g, b;
  r = (word)(c.r * (float)0xffff);
  g = (word)(c.g * (float)0xffff);
  b = (word)(c.b * (float)0xffff);

#ifdef _REENTRANT
   pthread_mutex_lock(&p->lock);
#endif
  
  if (p->c.r < c.r) { p->c.r = c.r; if (r > p->cm) p->cm = r; };
  if (p->c.g < c.g) { p->c.g = c.g; if (g > p->cm) p->cm = g; };
  if (p->c.b < c.b) { p->c.b = c.b; if (b > p->cm) p->cm = b; };
  
#ifdef _REENTRANT
  pthread_mutex_unlock(&p->lock);
#endif
}


void radios::verteile_licht(longint anza, longint von, longint bis)
{
  longint x;
  float   e, sp, br;
  vector  npt, nor, po, vr, rr;
  patch   *p;
  obj *o, *sobj=0;

  po = ita[anza].p->m;

  for (x=von; x<bis;x++)
    {
      vr |= ita[x].p->m - po;

      if (((vr * ita[anza].p->n) > 0.0) && ((vr * ita[x].p->n) < 0.0))
	// ist obj auch das richtige?
	if (ita[x].o == pray.show_trace(ptree, po, vr, &npt, &nor, sobj, &e))
	  {
	    max(ita[x].p, calc_color(ita[x].p, ita[anza].p, 
				     e, ita[x].o->dif_const));
	    // Spiegelnde Reflexion
	    sp = ita[x].o->mirror;
	    if ((sp > 0.0) || ita[x].o->calc_spiegelnd(&sp, ita[x].p->m))
	      {
		pray.ref_vector(ita[x].o, ita[x].p->m, ita[x].p->n, vr, &rr);
		if ((o = pray.show_trace(ptree, ita[x].p->m, rr, &npt, &nor, sobj, &e)))
		  {
		    p = o->get_patch(npt, ita[x].p->m, rr);
		    max(p, calc_color(p, ita[x].p, e, sp));
		  }
	      }
	    // Brechende Reflexion
	    br = ita[x].o->trans;
	    if ((br > 0.0) || ita[x].o->calc_brechend(&br, ita[x].p->m))
	      {
		pray.trans_vector(ita[x].o, ita[x].p->m, ita[x].p->n, vr, &rr);
		if ((o = pray.show_trace(ptree, ita[x].p->m, rr, &npt, &nor, sobj, &e)))
		  {
		    p = o->get_patch(npt, ita[x].p->m, rr);
		    max(p, calc_color(p, ita[x].p, e, br));
		  }
	      }
	  }
    }
}

color radios::calc_color(patch * intp, patch * pt, float e, float f)
{
  float  licht;
  vector L;
  color pcol (0.0, 0.0, 0.0);
  
  // Richtungsvektor
  L |= pt->m - intp->m ;
  licht = L * intp->n * f;

  if (licht > 0.0)
    {
      pcol = pt->c * licht;
      if (pt->c.r>0) pcol.r *= exp(ln05/pt->c.r*e);
      if (pt->c.g>0) pcol.g *= exp(ln05/pt->c.g*e);
      if (pt->c.b>0) pcol.b *= exp(ln05/pt->c.b*e);
    }
  return pcol;
}

void radios::anzeige(void)
{
  // Z-Buffer - Algorithmus fuer Raytracing
  zbuffer zb(x1, y1, x2, y2, s, p);
  cout << "Fertig der Radiosity-Anzeige\n";
}










