/*
   Polygonobjekt

   Definition in ray.H
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"

bool polygon::in_obj(vector mp)
{
  vector dpt1;
  // noch testen ob normal oder !normal
  return hit_object(mp, normal, false, &dpt1, &dpt1, &dpt1, &dpt1);
}

// liefert den richtigen Normalvektor (public)
vector polygon::getnormal(void)
{
  return normal;
}

/*
// liefert den gesetzten Normalvektor
vector polygon::getn(vector p)
{
  vector a0;
  float d0, d1, d2, d3, g;

  if (!nset)
    return normal;

  // Durchschnitt der 3 oder 4 Normalvektoren
  if (num_vec == 4)
    {
      // Schattierungen klappt irgendwie nicht richtig!

      // Berechne die Abstnde zu den Ecken
      d0 = p || p0;
      d1 = p || p1;
      d2 = p || p2;
      d3 = p || p3;
      g = d0 + d1 + d2 + d3;
      // mit Prozentuale Abstnden nderungsvektor berechnen
      a0 |= (n0 * (1.0 - d0 / g)) +
	(n1 * (1.0 - d1 / g)) +
	(n2 * (1.0 - d2 / g)) +
	(n3 * (1.0 - d3 / g));
    }
  else
    {
      // Hier gehts wunderbar
      d0 = p || p0;
      d1 = p || p1;
      d2 = p || p2;
      g = d0 + d1 + d2;
      a0 |= (n0 * (1.0 - d0 / g)) +
	(n1 * (1.0 - d1 / g)) +
	(n2 * (1.0 - d2 / g));
    }

  return a0;
}

void polygon::setn(vector * v1,...)
{
  vector **p;

  p = &v1;
  n0 = **p++;
  n1 = **p++;
  n2 = **p++;

  num_vec = 3;
  if (*p)
    {
      n3 = **p; 
      num_vec = 4;
    }

  nset = true;
}
*/

// construktor
polygon::polygon()
{
  num_vec = 0;
  ebene = false;
  pp = NULL;
}

// liefert einen Vektor
vector *polygon::getvector(byte x)
{
  switch (x)
    {
    case 0:
      return (&p0);
    case 1:
      return (&p1);
    case 2:
      return (&p2);
    case 3:
      return (&p3);
    }
  return (0);
}

void polygon::set(vector * v1,...)
{
  vector **p;

  p = &v1;
  p0 = **p++;
  p1 = **p++;
  p2 = **p++;

  if (*p)
    {
      p3 = **p;
      num_vec = 4;
    }
  else
    num_vec = 3;

  normal |= (p1 - p0) && (p2 - p0);

  // Falls nicht gesetzt wird
  //n0 = n1 = n2 = n3 = normal;
  //nset = false;
}


void polygon::setvector(byte x, vector V)
{
  switch (x)
    {
    case 0:
      p0 = V;
      break;
    case 1:
      p1 = V;
      break;
    case 2:
      p2 = V;
      break;
    case 3:
      p3 = V;
      break;
    }
  num_vec = x + 1;

  // Normalvektor nur einmal berechnen, bleibt konstant.
  if (num_vec == 3)
    {
      normal |= (p1 - p0) && (p2 - p0);		// Rechtsgewinde!

      //n0 = n1 = n2 = n3 = normal;	// Falls nicht gesetzt wird

      //nset = false;
    }
  if (num_vec == 4)
    if (!testebene(p0, p1, p2, p3))
      {
	cerr << "ray: Vektoren des Polygons bilden keine Ebene!\n";
	exit(1);
      }
}

// Texture
void polygon::surfaceCol(color * col, vector intpoint, cover * cp, byte art)
{
  vector i, a, b;
  float x, y;

  texture *tp=NULL;
  muster  *mp=NULL;

  switch (art)
    {
      case NORMALTXT:
	tp = cp->textcp;
	mp = cp->musterp;
	break;
      case VECTORTXT:
	tp = cp->textvp;
	mp = cp->musterp2;
	break;
      case SPIEGTXT:
	tp = cp->textsp;
	mp = cp->mustersp;
	break;
      case BRECHTXT:
	tp = cp->textbp;
	mp = cp->musterbp;
	break;
    }

  // Verschiebung des Treffpunktes je nach Muster
  if ((cp->tb.tu == 1) || (cp->tb.tu == 3))
    i = intpoint + cp->tb.getturbo((p0 - intpoint) * cp->tb.t);
  else
    i = intpoint;

  // Vektoren
  a = p0 - p1;
  b = p2 - p1;

  // Abstand eine Punktes von einer Geraden / Lnge = Abstand in %
  x = abs(p1 - i + (b * (((i - p1) * b) / (b * b))));
  y = abs(p1 - i + (a * (((i - p1) * a) / (a * a))));

  if (tp)
    tp->gettexture(col, x, y, cp, intpoint - p1);

//       // Punkt in Texturmatrix
//       px = f2w(fabs(tx1 + x * (float) tp->x * (cp->x2 - cp->x1)));
//       py = f2w(fabs(ty1 + y * (float) tp->y * (cp->y2 - cp->y1)));

  if (mp)
    {
      if ((cp->tb.tu == 2) || (cp->tb.tu == 3))
	mp->mix = cp->tb.getgturbo((p0 - intpoint) * cp->tb.t);

      // Muster RGB-Wert holen
      mp->getmust(col, cp->musterfp, vector(x, y, 0.0));
    }

  if (cp->text3d)
    cp->text3d->gettext(col, cp->musterfp, intpoint - p0);
}

// Treffpunkt
bool polygon::hit_object(vector point, vector dir, bool hitin,
			 vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2)
{
  vector a, b, nor;
  float t, d, in;
  int i;

  // Abstand Punkt-Ebene, Hessesche Normalform
  d = normal * (p0 - point);
  // Richtung zur Lichtquelle
  nor = (d > 0.0) ? !normal : normal;
  t = nor * dir;
  t = (fabs(t) > eps10) ? (nor * (p0 - point)) / t : 0.0;
  *int_pt2 = *int_pt1 = (dir * t) + point;

  if (!ebene)
    {
      if (t <= eps5)
	return false;		//  Trifft Kante

      // Liegt der Schnittpunkt innerhalb vom Polygon?
      // Die Summe aller winkel zwischen Schnittpunkten und Eckpunkten mu
      // 2*pi ergeben
      for (i = 0, t = 0.0; i < num_vec; i++)
	{
	  a |= *(getvector(i)) - *int_pt1;
	  b |= *(getvector((i + 1) % num_vec)) - *int_pt1;
	  in = a * b;
	  if ((in >= -1.0) && (in <= 1.0))
	    t += acos(in);
	  else
	    return false;
	}

      // Summe der Innenwinkel rund 2pi
      if (fabs(pi2 - t) > eps3)
	return false;
    }

  // Berechne Normalvektor
  // Richtung zur Lichtquelle
  if (d > 0.0)
    {
      //*norm2 = getn(*int_pt1);
      *norm2 = normal;
      *norm1 = !*norm2;
    }
  else
    {
      *norm1 = normal;
      // *norm1 = getn(*int_pt1);
      *norm2 = !*norm1;
    }

  return true;
}

bool polygon::testgrobj(vector * z1, vector * z2, vector nv1, vector nv2)
{
  byte ok = true, x;
  vector v;

  *z1 = *z2 = *getvector(0);

  for (x = 0; x < num_vec; x++)	// min und max Punkt zurckgeben

    {
      // Sichtstrahl definieren
      v = *(getvector(x));
      if (v.x < z1->x)
	z1->x = v.x;
      if (v.y < z1->y)
	z1->y = v.y;
      if (v.z < z1->z)
	z1->z = v.z;
      if (v.x > z2->x)
	z2->x = v.x;
      if (v.y > z2->y)
	z2->y = v.y;
      if (v.z > z2->z)
	z2->z = v.z;
    }

  *z1 -= vector(eps3, eps3, eps3);
  *z2 += vector(eps3, eps3, eps3);

  // sind alle Punkte im Wrfel?
  for (x = 0; x < num_vec; x++)
    {
      v = *getvector(x);
      ok = (ok && ((nv1.x <= v.x && nv1.y <= v.y && nv1.z <= v.z) &&
		   (nv2.x >= v.x && nv2.y >= v.y && nv2.z >= v.z)))
	? true : false;
    }
  return ok;
}

bool polygon::getpoints(vector * v1, longint x)
{
  if (x == 1)
    {
      *v1 = p0;
      return true;
    };
  if (x == 2)
    {
      *v1 = p1;
      return true;
    };
  if (x == 3)
    {
      *v1 = p2;
      return true;
    };
  if (num_vec == 4)
    {
      if (x == 4)
	{
	  *v1 = p3;
	  return true;
	};
      return false;
    }
  return false;
}

// fr Radios
patcharray *polygon::createpatch(float Min, bool Schn, obj * grobj)
{
  pp = new patcharray(Min, Schn, grobj, num_vec, p0, p1, p2, p3);
  ebene = false;
  return pp;
}











