/*
   Berechnet die Pixelmatrix
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Copyright (C) 1996, 1997 Helmut Fahrion

*/

#include "ray.H"


// Nullwert fuer Puffer
#define COLNULL 255

// 3 X-Window Funktionen in xw.C definiert!
// Ruft ray.shoepoint auf und setzt dann die Farbe des Bildpunktes
// je Scallierung
extern void writexy (word x, word y, word s);

// Setzt je nach Scallierungsfaktor, einen Bildpunkt oder ein Rechteck
// der Farbe c
extern void writecxy (word x, word y, word s, color c);

// Setzt Farbe c und fuellt ein Rechteck
extern void writecboxxy (word x, word y, word dx, word dy, word s, color c);

bool ray::testcolors (cbyte c1, cbyte c2, cbyte c3, cbyte c4, cbyte c5)
{
  // Sind alle 3 Farbwerte aller 5 Farben gleich dann OK!
  return (((c1.r == c2.r) && (c1.r == c3.r) && (c1.r == c4.r) && (c1.r == c5.r)) &&
   ((c1.g == c2.g) && (c1.g == c3.g) && (c1.g == c4.g) && (c1.g == c5.g)) &&
     ((c1.b == c2.b) && (c1.b == c3.b) && (c1.b == c4.b) && (c1.b == c5.b)))
    ? true : false;
}

void ray::getrcolor (word xp, word yp, word x, word s, cbyte * e, dword *dw)
{
  dword a = yp * x + xp;
  *dw = a;

  if ((pbuff[a].r == COLNULL) && (pbuff[a].g == COLNULL) && (pbuff[a].b == COLNULL))
    {
      showpoint (xp, yp, pwelt, &cbuff[a]);	// Berechnen
      pbuff[a] = intcolor256(cbuff[a]);
      writecxy (xp, yp, s, cbuff[a]);	// gleich Zeichnen
    }
  *e = pbuff[a];
}

void ray::oray(word x1, word y1, word x2, word y2)
{
  cbyte c1, c2, c3, c4, c5;
  dword a;

  // Farben ermitteln
  getrcolor (x1, y1, x, s, &c1, &a);
  getrcolor (x2, y1, x, s, &c2, &a);
  getrcolor (x1, y2, x, s, &c3, &a);
  getrcolor (x2, y2, x, s, &c4, &a);
  getrcolor ((x1 + x2) / 2, (y1 + y2) / 2, x, s, &c5, &a);

  // Abbruchbedingung
  if (((x2 - x1) <= 1) && ((y2 - y1) <= 1))
    {
      // trifft immer zu da max genauigkeit
      return;
    }
  else
    {
      // Farbtest erst wenn Angegebene Genauigkeit!
      //     if (((x2 - x1) <= p) && ((y2 - y1) <= p))
      if (((x2 - x1) <= p) || ((y2 - y1) <= p))
	// Optimierung! Abbruch wenn Farben gleich sind
	if (testcolors(c1, c2, c3, c4, c5))
	  {
	    writecboxxy(x1, y1, x2 - x1, y2 - y1, s, cbuff[a]);
	    return;
	  }
      // weiter Raytracen, Reihenfolge mal anders
      oray (x1, (y1 + y2) / 2, (x1 + x2) / 2, y2);
      oray ((x1 + x2) / 2, y1, x2, (y1 + y2) / 2);
      oray ((x1 + x2) / 2, (y1 + y2) / 2, x2, y2);
      oray (x1, y1, (x1 + x2) / 2, (y1 + y2) / 2);
    }
}


// normales Raytracing
void ray::raytracebox (word x1, word y1, word x2, word y2, word s)
{
#ifndef _REENTRANT
  word x, y;
  // starte Raytracing, schreibt pixel in pixmap
  for (y = y1; y < y2; y++)
    {
      // Fortschrittsanzeige
      cout << "PID: " << pwelt->pid << " Berechne Zeile: " << y + 1 << ".\r" << flush;
      for (x = x1; x < x2; x++)
	writexy (x, y, s);
    }
#else
  cout << "Starte Raytreads!\n" << flush;
  raytread work_ray(x1, y1, x2, y2, s);
#endif
}

// in Puffer Raytracen
// Datentyp short duerfte auf allen Maschienen etwa gleich sein!
void ray::raytracebuffer (word x1, word y1, word x2, word y2, char *name)
{
  FILE *D;
  word a, b;
  color c;
  cbyte *cbuff;

  // erzeuge puffer, 0 zhlt mit!
  a = x2 - x1 + 1;
  b = y2 - y1 + 1;

  cbuff = new cbyte[a * b];

  pray.radiositybuf(pwelt->observ.x1, pwelt->observ.y1, pwelt->observ.x2, pwelt->observ.y2, 
		    pwelt->observ.pixel, pwelt->observ.opixel);	// Speicher und init

#ifndef _REENTRANT
  word x, y;
  // starte Raytracing, schreibt pixel in pixmap
  for (y = y1; y < y2; y++)
    {
      // Fortschrittsanzeige
      cout << "PID: " << pwelt->pid << " Berechne Zeile: " << y + 1 << ".\r" << flush;

      for (x = x1; x < x2; x++)
	{
	  showpoint (x, y, pwelt, &c);
	  cbuff[y * x2 + x] = intcolor256 (c);
	}
    }
#else
  cout << "Starte Raytracing Treads.\n" << flush;
  raytread work_ray(x1, y1, x2, y2, cbuff);
#endif

  cout << "\n";
  cout << "schreibe Datei " << name << "\n";

  /* schreibe Kommandofile */
  if ((D = fopen (name, "w+")) == NULL)
    {
      cerr << "ray: Fehler beim ffnen der Datei " << name << "\n";
      exit (1);
    }

  fwrite (&x1, sizeof (unsigned short), 1, D);
  fwrite (&y1, sizeof (unsigned short), 1, D);
  fwrite (&x2, sizeof (unsigned short), 1, D);
  fwrite (&y2, sizeof (unsigned short), 1, D);
  fwrite (cbuff, sizeof (cbyte), a * b, D);
  fclose (D);

  cout << "fertig!\n";
  delete cbuff;
}

// Optimiertes Raytracing
void ray::raytraceboxR (word x1, word y1, word x2, word y2, word S, word P)
{
  long gespart, z;
  int X, y, a, b;

  // erzeuge puffer, 0 zhlt mit!
  X = x2 - x1 + 1;
  y = y2 - y1 + 1;

  pbuff = new cbyte[X * y];
  cbuff = new color[X * y];  // um nicht einen Mutex setzen zu mssen

  // initialisiere
  for (b = 0; b < y; b++)
    for (a = 0; a < X; a++)
      {
	z = b * X + a;
	pbuff[z].r = pbuff[z].g = pbuff[z].b = COLNULL;		// Kennung das leer
      }

  // Globale Parameter setzen! Zwar unsauber aber Speicherschonender!
  x = X;
  s = S;
  p = P;

#ifndef _REENTRANT
  oray (x1, y1, x2, y2);
#else
  cout << "Starte Raytreads!\n" << flush;
  raytread work_ray(x1, y1, x2, y2, S);
#endif

  // Statistik
  gespart = 0;
  for (b = 0; b < y; b++)
    for (a = 0; a < x; a++)
      {
	z = b * x + a;
	if ((pbuff[z].r == COLNULL) && (pbuff[z].g == COLNULL) && (pbuff[z].b == COLNULL))
	  gespart++;
      }

  cout << (float) gespart / (float) (x * y) * 100.0
    << " Prozent beim Pixelbild gespart\n"
    << gespart << " gespart\n";

  delete pbuff;
  delete cbuff;
}

void ray::rayzbuffer (word x1, word y1, word x2, word y2, word s, word o)
{
  zmode = false; //mit Hintergrund
  // Z-Buffer - Algorithmus fuer Raytracing
  zbuffer zb (pwelt->observ.x1, pwelt->observ.y1,
	      pwelt->observ.x2, pwelt->observ.y2, pwelt->observ.pixel, o);
  cout << "Fertig ray::rayzbuffer\n";
}




