#ifndef _PATCHES_IST_INCLUDE_
#define _PATCHES_IST_INCLUDE_

/*
   Haeder fr die Patchesberechnung

   Dieses Modul steht nicht unter der GPL. Alle Urheberrechte und das
   Kopierrecht gehren Helmut Fahrion.

   Der Quellcode dieses Modules wird im Quellcode ausgeliefert um das
   Portieren dieser Software zu ermglichen.

   Dieses Modul darf fr andere Zwecke nicht verwendet werden.

   Wer dieses Modul fr Zwecke der Weiterentwicklung oder fr ein
   eigenes Produkt bentigt mu sich mit mir in Verbindung setzen.

   email:
     hf@suse.de
   oder
     nazca@informatik.htw-dresden.de

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "vect.H"
#include "defs.H"


// Prototype fr obj aus ray.H
class obj;

// Das Patch welches eine Kugel ist!
class patch
{
  public:
  patch (vector M, vector N, float R, color C):m (M), n (N), c(C)
  {
    float max;

    r = R;
    max = c.r;                // Maximum
    if (c.g > max) max = c.g;
    if (c.g > max) max = c.b;
    cm = (word)(max * (float)0xffff);
  };

  patch ()
  {
  };
  ~patch ()
  {
  };

  bool hit_in(vector pt)
  {
    return ((pt || m) < r) ? true : false;
  }

  bool hit(vector po, vector vr, vector *intpt)
  {
    float t, d; 
    vector int_pt;

    if ((d = n * (m - po)) > 0) return false;

    t = n * vr;
    
    t = (fabs(t) > eps10)? (n * (m - po)) / t :0;

    int_pt = (vr * t) + po;
    
    if ((int_pt || m) < r)
      {
	*intpt = int_pt;
	return true;
      } else return false;
  }

  bool testo (vector * e1, vector * e2, vector p1, vector p2);

  // Geometrie ist eine Kugel
  vector m, n;			// Mittelpunkt, Richtung
  float  r;			// Radius

  // Optische Eigenschaften

  color c;
  word  cm;  // color Mittelwert

#ifdef _REENTRANT
    pthread_mutex_t lock;
#endif
};

class patchtl
{
  public:
  patchtl (patchtl * Next, patch * P)
  {
    if (Next != 0x0)
      Next->next = this;
    next = 0x0;			// einketten
    p = P;
  }
   ~patchtl ()
  {
    // *p wird als array gesamt gelscht!
    if (next)
      delete next;		// lscht sich selbst
  }

  patch *p;
  patchtl *next;
};

class patcharray;

class patchtree
{
  public:
  patchtree ()
  {
  };
  patchtree (patch * pa, patchtl * pl, vector P1, vector P2);

  ~patchtree ()
  {
    if (o)
      delete o;
    for (char x = 0; x < 8; x++)
      if (pt[x])
	{
	  delete pt[x];
	}
  };

  // wird der Wrfel vom Sichtstrahl getroffen?
  bool hit_object (vector point, vector d)
  {
    float t1, t2;		// Platzhalter

    vector v (vect - point);
      return (solve_quad (d.x * d.x + d.y * d.y + d.z * d.z,	// A 
			    (v.x * d.x + v.y * d.y + v.z * d.z) * 2.0,	// B
		        v.x * v.x + v.y * v.y + v.z * v.z - radius * radius,	// C
			   &t1, &t2)) ? true : false;
  };

  patchtl *o;
  patchtree *pt[8];		// 8 Bltter

private:
  // wird der Wrfel vom Sichtstrahl getroffen?
  void newvol (vector * p1, vector * p2, char x);
  void testobj (longint * entf, longint * neu, vector p1, vector p2);
  void newobj (patchtl ** obn, patchtl ** obo, vector p1, vector p2);

  vector v1, v2;
  // Begrenzungskugel
  vector vect;
  float radius;
};

// Liste zum Erzeugen der Patches, da patch ohne Pointer sein soll
class patchl:public patch
{
  public:
  patchl (patchl * Next, vector M, vector N, float R, color C):patch (M, N, R, C)
  {
    if (Next != 0x0) Next->next = this;  next = NULL;  ok = true;
  };

  ~patchl ()  { if (next) delete next;  };
  bool ok;		// wird nach Schnitttest in array bernommen oder nicht
  patchl *next;
};

// Liste zum Erzeugen des Patchesobjekt
class patchinitl
{
  public:
  patchinitl(patchinitl * Next, vector M, vector N): m(M), n(N)
  { if (Next != 0x0) Next->next = this;  next = NULL; };

  ~patchinitl()  { if (next) delete next;  };

  vector m, n;

  patchinitl *next;
};

// Patches Array
class patcharray
{
public:
  patcharray ()
  {
  };				
  // fr jeden Objekttyp einen anderen Konstruktor
  patcharray (float min, bool schnt, obj * grobj, char poly4,
	      vector p1, vector p2, vector p3, vector p4);	          // Polygon
  patcharray (float min, bool schnt, obj * grobj, 
	      vector M, vector R, vector W);		                  // Ellipsoid
  patcharray (float min, bool schnt, obj * grobj, 
	      vector M, float R);	                                  // Kugel
  patcharray (float min, bool schnt, obj * grobj, 
	      vector p1, vector p2, vector p3, vector p4,
	      vector p5, vector p6, vector p7, vector p8);	          // Block
  patcharray (float min, bool schnt, obj * grobj, vector P1, vector P2,
	      float r1, float r2);	                                  // Zylinder
  patcharray (float min, bool schnt, obj * grobj, float D, float R,
	      vector M, vector W);	                                  // Torus
  patcharray (float min, bool schnt, obj * grobj,
	      patchinitl * Pl);	                                          // Patchobjekt

  ~patcharray ()
  {
    // if (pla) delete pla;   // wenn Schnittkrper generiert, in bilde_at!
    if (pa)
      delete pa;	// Array und Tree lschen wenn Iteration vorbei

    if (pt)
      delete pt;
  };

  // Bilde Schnittmengen
  //void addition(patcharray *Sk);
  void differenz (patcharray * Sk, obj * sobj, obj * mobj);
  void schnitt (patcharray * Sk, obj * sobj, obj * mobj);

  // bilde aus Patchliste array und baum, Liste wird entfernt
  void bilde_at (void);

  // scannt den Baum und gibt das Patch zurck
  patch * get_patch(vector npt, vector po, vector vr);
  
  // Funktion fr das Patchobjekt
  bool get_patch_int(vector po, vector vr, vector * int_pt1, vector * n_pt1, 
		     vector * int_pt2, vector * n_pt2);

  longint   anz;	// Anzahl der Arrayelemente
  patch     *pa;	// dynamisches Array of patches, keine Liste!
  patchtree *pt;	// Patches Tree, zum Schnittpunkt finden
  patchl    *pla;	// Patchliste zum Rechnen, nur zum testen public

  // Radius der Patches
  float r;

private:
  void bilde_poly (patchl ** pl, float min,
		   vector p1, vector p2, vector p3, vector p4, obj * grobj);
  // Dreieck
  bool hitinpoly (vector p1, vector p2, vector p3, vector intpt);
  // Viereck
  bool hitinpoly (vector p1, vector p2, vector p3, vector p4, vector intpt);
  // Ellipsoid
  bool calc_elip (vector * int_pt, vector * n, vector pt, vector dr);

  // bilde Radius
  float calcr (float min) { float x=min*min;  return sqrt(x+x)/2.0;  };

  // Transformation in die Koordinaten des Zylinders
  vector transz (vector in, vector p1, vector zh)
  {
    vector e = in;
      rotationVN (&e, zh);
      return (p1 + e);
  }
  // Transformation in die Koordinaten des Torus
  vector transt (vector in, vector m, vector w)
  {
    vector e = in;
      rotation (&e, VNULL, w);
      return (e + m);
  }
  
  void bildecolor(color *cl, obj *grobj, vector tp);

  // Baum rekursiv durchsuchen
  void get_patch_tree(patchtree *tr, vector po, vector vr, vector int_pt, float entf, patch **fp);


  // Funktionen fr das Patchobjekt
  void hitpatchmin(patchtree *tr, vector po, vector vr, 
		   vector * intpt, vector * npt, float *entf, 
		   bool max, bool start);

  // Daten fr Elipsoid
  vector elm, elr, elw;
};


#endif



