/*
   Stellt die Klassen fr die Unterteilung in Patches 
   zur Verfgung
   Haeder fr die Patchesberechnung

   Dieses Modul steht nicht unter der GPL. Alle Urheberrechte und das
   Kopierrecht gehren Helmut Fahrion.

   Der Quellcode dieses Modules wird im Quellcode ausgeliefert um das
   Portieren dieser Software zu ermglichen.

   Dieses Modul darf fr andere Zwecke nicht verwendet werden.

   Wer dieses Modul fr Zwecke der Weiterentwicklung oder fr ein
   eigenes Produkt bentigt mu sich mit mir in Verbindung setzen.

   email:
     hf@suse.de
   oder
     nazca@informatik.htw-dresden.de

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"         // wegen obj-classe


#define MIN_OBJ_PATCHTREE 4

// Schnitt, zweiter Krper wir aus ersten geschnitten
void patcharray::schnitt(patcharray * Sk, obj * sobj, obj * mobj)
{
  patchl *pl, *pe;

  // ist mein Patch im Schnittkrper dann weg damit
  for (pl = pla; pl; pl = pl->next)
    if (sobj->in_obj(pl->m))
	pl->ok = false;

  // ermittle Listenende
  for (pe = pla; pe->next; pe = pe->next);

  for (pl = Sk->pla; pl; pl = pl->next)
    // ist dein Patch in mir dann hole und negiere Normalvektor
    if (mobj->in_obj(pl->m))
      pe = new patchl(pe, pl->m, !pl->n, pl->r, pl->c);
}

// Differenzmange, bei 2 Kugeln bleibt eine Linse brig
void patcharray::differenz(patcharray * Sk, obj * sobj, obj * mobj)
{
  patchl *pl, *pe;

  //cerr << "Calc hit_in_mir!\n";
  for (pl = pla; pl; pl = pl->next)
    if (!sobj->in_obj(pl->m))
	pl->ok = false;

  //cerr << "ermittle Listenende!\n";
  for (pe = pla; pe->next; pe = pe->next);

  //cerr << "ermittle hit_in_dir! mobj= " << mobj << " pl->m= " << Sk->pla->m << "\n";

  for (pl = Sk->pla; pl; pl = pl->next)
    if (mobj->in_obj(pl->m))
      pe = new patchl(pe, pl->m, pl->n, pl->r, pl->c);
  
  //cerr << "ermittle fertig!\n";
}

void patcharray::get_patch_tree(patchtree *tr, vector po, vector vr, vector int_pt,
				float entf, patch **fp)
{
  byte    x;
  float   e;
  patchtl *pl;

  if (tr->hit_object(po, vr))  // Baum getroffen?
    for (pl = tr->o; pl; pl = pl->next)
      if ((vr * pl->p->n) < 0.0) // Zeigt zu mir
	{
	  e = int_pt || pl->p->m;
	  // hit_in test ist zwar besser, fhrt aber zu Fehlern an den Kanten
	  // bei einer hohen Auflsung
	  //if ((!*fp) || ((e < entf) && (pl->p->hit_in(int_pt))))
	  // also lieber eine Ungenauigkeit in der Farbverteilung als strende Fehler
	  if ((!*fp) || (e < entf))
	    {
	      *fp = pl->p;
	      entf = e;
	    }
	}
  // rekursiv den Baum durchsuchen
  for (x = 0; x < 8; x++)
    if (tr->pt[x] != NULL)
      get_patch_tree(tr->pt[x], po, vr, int_pt, entf, fp);
}

// scannt den Baum und gibt das Patch zurck
patch * patcharray::get_patch(vector npt, vector po, vector vr)
{
  patch  *fp = NULL;
  get_patch_tree(pt, po, vr, npt, 0.0, &fp);
  if (!fp) cerr << "Interner Fehler: Kein Patch gefunden!\n";
  return fp;
}

void patcharray::hitpatchmin(patchtree *tr, vector po, vector vr, 
			     vector * intpt, vector * npt, float * entf, 
			     bool max, bool start)
{
  byte    x;
  float   e;
  patchtl *pl;
  vector int_pt;
  bool    bentf;

  if (tr->hit_object(po, vr))  // Baum getroffen?
    for (pl = tr->o; pl; pl = pl->next)
	if (pl->p->hit(po, vr, &int_pt))
	  {
	    e = int_pt || pl->p->m;
	    if (max) bentf = e < *entf; else  bentf = e > *entf;

	    if (bentf || start)
	      {
		start  = false;
		*intpt = int_pt; 
		*npt   = pl->p->n; 
		*entf  = e;
	      }
	  }

  // rekursiv den Baum durchsuchen
  for (x = 0; x < 8; x++)
    if (tr->pt[x] != NULL)
      hitpatchmin(tr->pt[x], po, vr, intpt, npt, entf, max, start);
}

// scannt den Baum und gibt 2 Treffer zurck
bool patcharray::get_patch_int(vector po, vector vr, 
				 vector * int_pt1, vector * n_pt1, 
				 vector * int_pt2, vector * n_pt2)
{
  float entfmin, entfmax;

  entfmin=entfmax=0.0;

  hitpatchmin(pt, po, vr, int_pt1, n_pt1, &entfmin, true, true);
  hitpatchmin(pt, po, vr, int_pt2, n_pt2, &entfmax, false, true);

  return ((entfmin != 0.0) || (entfmax != 0.0));
}

void patcharray::bildecolor(color *cl, obj *grobj, vector tp)
{
  *cl = color(1.0, 1.0, 1.0);
  if (grobj) 
    {
      grobj->surfaceCol(cl, tp);
      *cl *= grobj->e;
    }
}

// Konstruktor fr Torus
patcharray::patcharray(float min, bool Schn, obj * grobj, float D, float R,
		       vector M, vector W)
{
  patchl *pl;
  color  cl;
  float   wink, ystep, xstep;
  longint anzx, anzy, y, x;
  vector  r1, R1, RM, n;

  pl = pla = 0;
  pt = 0;
  pa = 0;
  r = calcr(min);

  anzy = (long) (pi2 * D / min) + 1;
  ystep = pi2 / (float) anzy;

  anzx = (long) (pi2 * R / min) + 1;
  xstep = pi2 / (float) anzx;

  for (x = 0; x < anzx; x++)
    {
      r1 = vector(R, 0, 0);
      rotation(&r1, VNULL, vector(0, 0, xstep * (float) x));

      for (y = 0; y < anzy; y++)
	{
	  R1 = vector(D, 0, 0);
	  RM = vector(D, 0, 0) + r1;

	  // in Koordinaten des Torus
	  wink = ystep * (float) y;
	  rotation(&RM, VNULL, vector(0, wink, 0));
	  rotation(&R1, VNULL, vector(0, wink, 0));

	  RM = transt(RM, M, W);
	  n |= RM - transt(R1, M, W);

	  bildecolor(&cl, grobj, RM);

	  if (pl)
	    pl = new patchl(pl, RM, n, r, cl);
	  else
	    pla = pl = new patchl(NULL, RM, n, r, cl);
	}
    }
}

// Konstruktor fr Zylinder
patcharray::patcharray(float min, bool Schn, obj * grobj, vector P1, vector P2,
		       float r1, float r2)
{
  patchl  *pl;
  float   wstep, deltah, h, hoehe, dr, rm;
  longint anzx, anzy, y, x;
  vector  pz, n, zh, ah, PM;
  color  cl;

  pl = pla = 0;
  pt = 0;
  pa = 0;
  r = calcr(min);

  zh = P2 - P1;
  h = abs(zh);
  zh |= zh;
  rm = (r1 + r2) / 2.0;		// Teile die Y-Achse ein

  anzy = (int) (h / min) + 1;	// Anzahl Hoehe

  deltah = h / (float) anzy;	// Schritte Hoehe

  dr = r2 - r1;

  for (y = 0; y <= anzy; y++)
    {
      hoehe = deltah * (float) y;
      // r darf doch nicht verndert werden !
      //r = r1 + dr * hoehe / h;	// nach Strahlensatz
      //pz = vector(r, 0, hoehe);	// Zu beachten: Zylinder geht um z-Achse!
      pz = vector(r1 + dr * hoehe / h, 0, hoehe);

      n = vector(1, 0, 0);	// mit dem Anstieg mit!

      rotationVN(&n, zh);

      PM = transz(pz, P1, zh);
      bildecolor(&cl, grobj, PM);
      if (pl)
	pl = new patchl(pl, PM, n, r, cl);
      else
	pla = pl = new patchl(NULL, PM, n, r, cl);

      // je radius neu berechnen
      anzx = (long) (pi2 * rm / min) + 1;
      wstep = pi2 / (float) anzx;

      for (x = 1; x < anzx; x++)
	{
	  rotation(&pz, VNULL, vector(0, 0, wstep));

	  n |= vector(pz.x, pz.y, 0);	// richtung von Achse weg

	  rotationVN(&n, zh);

	  ah |= vector(r1 - r2, 0, h);	// Richtung des Anstieges!

	  rotation(&ah, VNULL, vector(0, 0, wstep * x));
	  rotationVZ(&n, ah);
	  
	  PM = transz(pz, P1, zh);
	  bildecolor(&cl, grobj, PM);

	  pl = new patchl(pl, PM, n, r, cl);
	}
    }

  // Deckel bilden ! , unntig da Schnittebene
}

// Konstruktor fr Block, fast wie Polygon
patcharray::patcharray(float min, bool Schn, obj * grobj,
		       vector p1, vector p2, vector p3, vector p4,
		       vector p5, vector p6, vector p7, vector p8)
{
  patchl *pl;

  pl = pla = 0;
  pt = 0;
  pa = 0;
  r = calcr(min);

  bilde_poly(&pl, r, p4, p3, p2, p1, grobj);	// Vorderseite
  bilde_poly(&pl, r, p3, p7, p6, p2, grobj);	// Rechts
  bilde_poly(&pl, r, p8, p4, p1, p5, grobj);	// Links
  bilde_poly(&pl, r, p1, p2, p6, p5, grobj);	// Unten
  bilde_poly(&pl, r, p8, p7, p3, p4, grobj);	// Oben
  bilde_poly(&pl, r, p5, p6, p7, p8, grobj);	// Hinten
}

void patcharray::bilde_poly(patchl ** pl, float min,
			    vector p1, vector p2, vector p3, vector p4, obj * grobj)
{
  vector m, n;			// Mittelpunkt und Normalvector

  float  a, b, h;
  longint anza, anzb, x, y;
  vector ra, rb, hc, v1, v2;
  color  cl;

  n |= (p2 - p1) && (p3 - p2);	// Normalvektor errechnen

  // Schleife fr Netzpunkte
  // Breite
  a = p1 || p2;
  b = p2 || p3;

  // bilde grte Seiten
  hc |= p3 - p2;
  h = abs(absgeradepunkt(p4, hc, p2));
  if (h > a)
    a = h;

  hc |= p1 - p2;
  h = abs(absgeradepunkt(p4, hc, p2));
  if (h > b)
    b = h;

  // teile die 2 grten Seiten
  anza = (long) (a / min) + 2;
  anzb = (long) (b / min) + 2;

  ra |= p1 - p2;
  rb |= p3 - p2;

  // Bilde Netz
  for (x = 0; x < anza; x++)
    for (y = 0; y < anzb; y++)
      {
	// an den Kanten etwas einrcken
	if (x == anza - 1)
	  v1 = ra * (((float) x - min / 10) * min);
	else if (x == 0)
	  v1 = ra * (((float) x + min / 10) * min);
	else
	  v1 = ra * ((float) x * min);

	if (y == anzb - 1)
	  v2 = rb * (((float) y - min / 10) * min);
	else if (y == 0)
	  v2 = rb * (((float) y + min / 10) * min);
	else
	  v2 = rb * ((float) y * min);

	m = p2 + v1 + v2;

	if (hitinpoly(p1, p2, p3, p4, m))
	  {
	    bildecolor(&cl, grobj, m);
	    // Bilde Liste, je 1 fr jede Seite
	    if (*pl)
	      *pl = new patchl(*pl, m, n, min, cl);
	    else
	      pla = *pl = new patchl(NULL, m, n, min, cl);
	  }
      }
}

// Konstruktor fr Kugel fast das gleiche wie Ellipsoid
patcharray::patcharray(float min, bool Schn, obj * grobj, vector M, float R)
: elm(M), elr(vector(R, R, R)), 
elw(VNULL)
{ 
  const vector o(0, 1, 0), u(0, -1, 0), vx(1, 0, 0);

  longint anz, x, y;
  float  w, step, hstep;
  vector vo, vu, n, hr, h, hy, p2, ri;
  patchl *pl = NULL;
  color  cl;

  // Member init
  pla = 0;
  pt = 0;
  pa = 0;
  r = calcr(min);

  anz = (long) (pi2 * R / min) + 2;
  step = pi2 / (float) (anz);

  calc_elip(&vo, &n, elm, o);
  bildecolor(&cl, grobj, vo);
  pl = pla = new patchl(NULL, vo, n, r, cl);

  calc_elip(&vu, &n, elm, u);
  bildecolor(&cl, grobj, vu);
  pl = new patchl(pl, vu, n, r, cl);

  hr = vu - vo;
  hstep = abs(hr) / (float) anz;
  hr |= hr;			// Richtung von Nordpol nach Suedpol

  ri = vx;			// Beginne Richtung X-Achse

  h = vo + (hr * hstep);	// Hoehe

  // Drehe Runde Schlieen
  for (x = 1; x < anz; x++)
    {
      w = (float) x *step;	// Obere Facetten

      p2 = ri;

      rotation(&p2, VNULL, vector(0, w, 0));	// Rotiere um y-Achse

      // 2. Punkt berechnen
      if (calc_elip(&p2, &n, h, p2))
	{
	  bildecolor(&cl, grobj, p2);
	  pl = new patchl(pl, p2, n, r, cl);
	}
      else
	return;			// Fehler

      for (y = 1; y < anz; y++)
	{
	  hy = vo + (hr * hstep * (float) y);	// Hoehe

	  w = (float) x *step;
	  p2 = vx;

	  rotation(&p2, VNULL, vector(0, w, 0));	// Rotiere um y-Achse

	  if (calc_elip(&p2, &n, hy, p2))
	    {
	      bildecolor(&cl, grobj, p2);
	      pl = new patchl(pl, p2, n, r, cl);
	    }
	  else
	    return;		// Fehler

	}
    }
}

// Konstrukor fr Ellipsoid
patcharray::patcharray(float min, bool Schn, obj * grobj, vector M, vector R, vector W)
:elm(M), elr(R), elw(W)
{
  const vector o(0, 1, 0), u(0, -1, 0), vx(1, 0, 0);

  longint anz, x, y;
  float  w, step, hstep;
  vector vo, vu, n, hr, h, hy, p2, ri;
  patchl *pl = NULL;
  color  cl;

  // Member init
  pla = 0;
  pt = 0;
  pa = 0;
  r = calcr(min);

  w = R.x < R.y ? R.x : R.y;
  if (R.z < w)
    w = R.z;

  w = pi2 * w;			// Umfang

  anz = (long) (w / min) + 2;
  step = pi2 / (float) (anz);

  calc_elip(&vo, &n, elm, o);
  bildecolor(&cl, grobj, vo);
  pl = pla = new patchl(NULL, vo, n, r, cl);

  calc_elip(&vu, &n, elm, u);
  bildecolor(&cl, grobj, vu);
  pl = new patchl(pl, vu, n, r, cl);

  hr = vu - vo;
  hstep = abs(hr) / (float) anz;
  hr |= hr;			// Richtung von Nordpol nach Suedpol

  ri = vx;			// Beginne Richtung X-Achse

  h = vo + (hr * hstep);	// Hoehe

  // Drehe Runde Schlieen
  for (x = 1; x < anz; x++)
    {
      w = (float) x *step;	// Obere Facetten

      p2 = ri;

      rotation(&p2, VNULL, vector(0, w, 0));	// Rotiere um y-Achse

      // 2. Punkt berechnen
      if (calc_elip(&p2, &n, h, p2))
	{
  	  bildecolor(&cl, grobj, p2);
	  pl = new patchl(pl, p2, n, r, cl);
	}
      else
	return;			// Fehler

      for (y = 1; y < anz; y++)
	{
	  hy = vo + (hr * hstep * (float) y);	// Hoehe

	  w = (float) x *step;
	  p2 = vx;

	  rotation(&p2, VNULL, vector(0, w, 0));	// Rotiere um y-Achse

	  if (calc_elip(&p2, &n, hy, p2))
	    {
	      bildecolor(&cl, grobj, p2);
	      pl = new patchl(pl, p2, n, r, cl);
	    }
	  else
	    return;		// Fehler
	}
    }
}

// Konstrukor fr Polygon
patcharray::patcharray(float min, bool Schn, obj * grobj, char poly4,
		       vector p1, vector p2, vector p3, vector p4)
{
  vector m, n;			// Mittelpunkt und Normalvector

  float  a, b, h;
  long   anza, anzb, x, y;
  vector ra, rb, hc, v1, v2;
  patchl *pl;
  color  cl;

  pl = pla = 0;
  pt = 0;
  pa = 0;
  r = calcr(min);

  n |= (p2 - p1) && (p3 - p2);	// Normalvektor errechnen

  cerr << "generiert Polygonpatches!\n";

  // Schleife fr Netzpunkte
  // Breite
  a = p1 || p2;
  b = p2 || p3;

  // bilde grte Seiten
  hc |= p3 - p2;
  h = abs(absgeradepunkt(p4, hc, p2));
  if (h > a)
    a = h;

  hc |= p1 - p2;
  h = abs(absgeradepunkt(p4, hc, p2));
  if (h > b)
    b = h;

  // teile die 2 grten Seiten
  anza = (long) (a / min) + 2;
  anzb = (long) (b / min) + 2;

  ra |= p1 - p2;
  rb |= p3 - p2;

  // Bilde Netz
  for (x = 0; x < anza; x++)
    for (y = 0; y < anzb; y++)
      {
	// an den Kanten etwas einrcken
	if (x == anza - 1)
	  v1 = ra * (((float) x - min / 10) * min);
	else if (x == 0)
	  v1 = ra * (((float) x + min / 10) * min);
	else
	  v1 = ra * ((float) x * min);

	if (y == anzb - 1)
	  v2 = rb * (((float) y - min / 10) * min);
	else if (y == 0)
	  v2 = rb * (((float) y + min / 10) * min);
	else
	  v2 = rb * ((float) y * min);

	m = p2 + v1 + v2;

	if ((poly4 && hitinpoly(p1, p2, p3, p4, m)) ||
	    (!poly4 && hitinpoly(p1, p2, p3, m)))
	  {
	    // Bilde Liste, je 2 fr jede Seite 
	    // falls kein Schnittkrper
	    if (pl)
	      {  
		bildecolor(&cl, grobj, m);
		pl = new patchl(pl, m, n, r, cl);
		if (Schn) 
		  pl = new patchl(pl, m, !n, r, cl);
	      }
	    else
	      {
		bildecolor(&cl, grobj, m);
		pla = pl = new patchl(NULL, m, n, r, cl);
		if (Schn) 
		  pl = new patchl(pl, m, !n, r, cl);
	      }
	  }
      }
}

bool patcharray::hitinpoly(vector p1, vector p2, vector p3,
			   vector intpt)
{
  vector a(p1 - intpt), b(p2 - intpt), c(p3 - intpt);
  // Summe der Innenwinkel rund 2pi
  return (feq((a < b) + (b < c) + (c < a), pi2, eps5));
}

bool patcharray::hitinpoly(vector p1, vector p2, vector p3, vector p4,
			   vector intpt)
{
  vector a(p1 - intpt), b(p2 - intpt), c(p3 - intpt), d(p4 - intpt);
  // Summe der Innenwinkel rund 2pi
  return feq((a < b) + (b < c) + (c < d) + (d < a), pi2, eps5);
}

// Konstruktor fr Patchobjekt
patcharray::patcharray(float min, bool Schn, obj * grobj, patchinitl * Pl)
{
  patchinitl  *px;
  patchl *pl;
  color  cl;

  pl = pla = NULL;
  pt = NULL;
  pa = NULL;
  r = calcr(min);

  for (px=Pl; px; px = px->next)
    {
      bildecolor(&cl, grobj, px->m);
      if (pl)
	pl = new patchl(pl, px->m, px->n, r, cl);
      else
	pla = pl = new patchl(NULL, px->m, px->n, r, cl);
    }

  // cerr << "patcharray gebildet! patchobjekt!\n";
}


void patcharray::bilde_at(void)
{
  patchl *pl;
  longint x;

  // Bilde Liste anzahl
  for (anz = 0, pl = pla; pl; pl = pl->next)
    if (pl->ok)
      anz++;

  pa = new patch[anz];

  for (x = 0, pl = pla; pl; pl = pl->next)
    if (pl->ok)
      pa[x++] = *pl;

  // lsche Liste, erst wenn Schnittkrper fertig!
  delete pla;

  patchtl *ptla = 0, *ptlax = 0;
  // baue Patchindexlist auf
  for (ptla = 0, x = 0; x < anz; x++)
    if (ptla)
      ptlax = new patchtl(ptlax, &pa[x]);
    else
      ptla = ptlax = new patchtl(NULL, &pa[x]);

  // durchlaufe Liste
  vector e1(pa[0].m), e2(pa[0].m);
  for (x = 0; x < anz; x++)
    {
      if (pa[x].m.x < e1.x)
	e1.x = pa[x].m.x;
      if (pa[x].m.y < e1.y)
	e1.y = pa[x].m.y;
      if (pa[x].m.z < e1.z)
	e1.z = pa[x].m.z;
      if (pa[x].m.x > e2.x)
	e2.x = pa[x].m.x;
      if (pa[x].m.y > e2.y)
	e2.y = pa[x].m.y;
      if (pa[x].m.z > e2.z)
	e2.z = pa[x].m.z;
    }

  r += eps3;
  e1 -= vector(r, r, r);
  e2 += vector(r, r, r);

  cerr << "Bilde PatchTree! " << anz << "\n";
  // Bilde next Baum
  pt = new patchtree(pa, ptla, e1, e2);

  //cerr << "Bilde PatchTree fertig!\n";
}

// Treffpunkt
bool patcharray::calc_elip(vector * int_pt, vector * n, vector pt, vector dr)
{
  int    l;
  vector r0, r1;
  float  A, B, C, t1, t2, aq, bq, cq;

  // Transformation in Koordinaten des Elipsoiden
  r0 = elm - pt;
  r1 = dr;			// Normalvektor bleibt!

  rotation(&r0, VNULL, elw);	// Koordinatensystem des Elipsoiden rotieren

  rotation(&r1, VNULL, elw);


  // Quadrate berechnen
  aq = elr.x * elr.x;
  bq = elr.y * elr.y;
  cq = elr.z * elr.z;

  // Therme des Elipsoiden
  A = (aq * (bq * r1.z * r1.z + cq * r1.y * r1.y) + bq * cq * r1.x * r1.x);
  B = (2.0 * (aq * (bq * r1.z * r0.z + cq * r1.y * r0.y) + bq * cq * r0.x * r1.x));
  C = (bq * cq * r0.x * r0.x - aq * (bq * (cq - r0.z * r0.z) - cq * r0.y * r0.y));

  // QG Lsen
  if ((l = solve_quad(A, B, C, &t1, &t2)))
    {
      //if ((t1 > 0.0) && (t2 > 0.0)) return false;

      // Treffpunkt zurckrechnen
      *int_pt = pt + (dr * fabs(t1));
      r0 = *int_pt - elm;	// Normalvektor, Kugel berechnen

      r1 = vector((aq != 0.0) ? r0.x * 2.0 / aq : 0.0,
		  (bq != 0.0) ? r0.y * 2.0 / bq : 0.0,
		  (cq != 0.0) ? r0.z * 2.0 / cq : 0.0);		// Gradiend,  1. Ableitung 

      *n |= r0 + r1;
      return true;
    }
  else
    return false;
  return false;
}

bool patch::testo(vector * e1, vector * e2, vector p1, vector p2)
{
  float  a;
  vector min, max;

  a = r - eps3;

  // aus einer Kugel wird ein Wrfel gemacht
  *e1 = min = m - vector(a, a, a);
  *e2 = max = m + vector(a, a, a);

  // Test ob reinpasst
  return ((p1.x <= min.x && p1.y <= min.y && p1.z <= min.z) &&
	  (p2.x >= max.x && p2.y >= max.y && p2.z >= max.z)) ?
    true : false;
}

patchtree::patchtree(patch * pa, patchtl * pl, vector P1, vector P2)
:v1(P1), v2(P2)
{
  byte   x;
  longint bleib, neu;
  vector nv1, nv2, m;
  patchtl *obln, *oblo, *ox;

  o = pl;			// alle Objekte

  ox = o;

  // Engerziehen !! da Patches?
  for (ox = o; ox; ox = ox->next)
    {
      ox->p->testo(&nv1, &nv2, v1, v2);

      if (nv1.x < v1.x)
	v1.x = nv1.x;
      if (nv1.y < v1.y)
	v1.y = nv1.y;
      if (nv1.z < v1.z)
	v1.z = nv1.z;
      if (nv2.x > v2.x)
	v2.x = nv2.x;
      if (nv2.y > v2.y)
	v2.y = nv2.y;
      if (nv2.z > v2.z)
	v2.z = nv2.z;
    }

  // Begrenzungskugel definieren
  m = (v2 - v1) / 2.0;
  vect = v1 + m;
  radius = abs(m);

  for (x = 0; x < 8; x++)	// die neuen Wrfel berechnen
    {
      newvol(&nv1, &nv2, x);	// neues Begrenzungsvolumen
      testobj(&bleib, &neu, nv1, nv2);
      if (neu >= MIN_OBJ_PATCHTREE)
	{
	  newobj(&obln, &oblo, nv1, nv2);	// neue Liste
	  o = oblo;		// briggebliebenen
	  pt[x] = new patchtree(pa, obln, nv1, nv2);
	}
      else
	pt[x] = NULL;
    }
}

void patchtree::testobj(longint * entf, longint * neu, vector p1, vector p2)
{
  vector d1, d2;
  patchtl *ob = o;		// Komplette Liste des Vorgngers

  // Durchlaufe Liste
  *neu = *entf = 0L;

  for (ob = o; ob; ob = ob->next)
    if (ob->p->testo(&d1, &d2, p1, p2))
      (*neu)++;
    else
      (*entf)++;
}

// bildet eine neue Objektliste und entfernt die bernommenen aus
// der alten Liste
void  patchtree::newobj(patchtl ** obn, patchtl ** obo, vector p1, vector p2)
{
  vector d1, d2;
  byte   objin = false;
  patchtl *ob = o;		// Komplette Liste des Vorgngers

  patchtl *obnn = NULL;		// mit leerer Liste beginnen

  patchtl *obon = NULL;

  *obn = NULL;
  *obo = NULL;
  d1 = d2 = vector(0, 0, 0);

  // Durchlaufe Liste
  while (ob)
    {
      objin = ob->p->testo(&d1, &d2, p1, p2);
      // Wenn ja, Objekt in neue Liste einketten und in alter lschen
      if (objin)
	{
	  if (obnn == NULL)
	    {
	      *obn = ob;	// erstes anketten
	      obnn = ob;
	      ob = ob->next;	// ob ausklinken
	      obnn->next = NULL;	// Endekennung
	    }
	  else
	    {
	      obnn->next = ob;	// letztes einklinken
	      ob = ob->next;	// ob ausklinken
	      obnn = obnn->next;	// Zeiger auf letztes
	      obnn->next = NULL;
	    }
	}
      else
	{
	  // zurckbleibende einketten
	  if (obon == NULL)
	    {
	      *obo = ob;
	      obon = ob;
	      ob = ob->next;
	      obon->next = NULL;
	    }
	  else
	    {
	      obon->next = ob;
	      ob = ob->next;
	      obon = obon->next;
	      obon->next = NULL;
	    }
	}
    }
}

// bildet neuen Wrfel je nach Nummer
void patchtree::newvol(vector * p1, vector * p2, char x)
{
/*
+   Definition der 8 Punkte des neuen Wrfels
+
+      8         7
+      +--------+
+     /|       /|
+    / |      / |
+  4+--------+3 |
+   |  +-----|--+
+   | / 5    | / 6
+   |/       |/
+   +--------+
+   1          2
+
*/

  switch (x)
    {
    case 0:
      *p1 = v1;
      *p2 = vector((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      break;
    case 1:
      *p1 = vector((v1.x + v2.x) / 2.0, v1.y, v1.z);
      *p2 = vector(v2.x, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      break;
    case 2:
      *p1 = vector((v1.x + v2.x) / 2.0, v1.y, (v1.z + v2.z) / 2.0);
      *p2 = vector(v2.x, (v1.y + v2.y) / 2.0, v2.z);
      break;
    case 3:
      *p1 = vector(v1.x, v1.y, (v1.z + v2.z) / 2.0);
      *p2 = vector((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, v2.z);
      break;
    case 4:
      *p1 = vector(v1.x, (v1.y + v2.y) / 2.0, v1.z);
      *p2 = vector((v1.x + v2.x) / 2.0, v2.y, (v1.z + v2.z) / 2.0);
      break;
    case 5:
      *p1 = vector((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, v1.z);
      *p2 = vector(v2.x, v2.y, (v1.z + v2.z) / 2.0);
      break;
    case 6:
      *p1 = vector((v1.x + v2.x) / 2.0, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      *p2 = v2;
      break;
    case 7:
      *p1 = vector(v1.x, (v1.y + v2.y) / 2.0, (v1.z + v2.z) / 2.0);
      *p2 = vector((v1.x + v2.x) / 2.0, v2.y, v2.z);
    }
}

#undef MIN_OBJ
