/*
   Grafisches Vater Objekt
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"

obj::obj(obj * lo,		    // Pointer
	 float r, float g, float b, // r g b
	 float Energie,		    // Energie (Radiosity)
	 float Material,	    // Material
	 float Mirror,		    // Spiegelung
	 float Trans,		    // -##-  durchscheinenden Lichtes darstellen
	 float Dif,		    // [0<=x<=1] Diffusionskonstante
	 float Spec,		    // [0<=x<=1] spec_const
	 float High,		    // [0<=x<=100] high_const
	 float n,		    // Velocitfaktor
	 cover * Cover,		    // Zeiger auf Cover
	 byte Type,		    // was fr ein Objekt
	 byte SType)		    // Typ des Schnittkrpers
  :col(r, g, b)
{
  next = nextS = NULL;

  // einketten
  if (lo != NULL)
    lo->next = this;

  // Daten initialiesieren
  material = Material;
  mirror = Mirror;
  trans = Trans;
  dif_const = Dif;
  spec_const = Spec;
  high_const = High;
  N = n;
  coverp = Cover;
  type = Type;
  stype = SType;
  e = Energie;

  hitin = (trans < eps4) ? false : true;

  // Elementare Objekte erzeugen
  switch (type)
    {
    case POLYGON:  grobjp = new polygon;  break;
    case BLOCK:    grobjp = new block;    break;
    case SPHERE:   grobjp = new sphere;   break;
    case ELIPSOID: grobjp = new elipsoid; break;
    case STAR:     grobjp = new star;     break;
    case CONE:     grobjp = new cone;     break;
    case TORUS:    grobjp = new torus;    break;
    case PATCHOBJ: grobjp = new patchobj; break;
    }
}

patcharray *obj::createpatches(float min)	// erzeugt Patches fr radios
 {
  obj *snobj;
  
  // hier men die Patches aufgebaut werden
  patcharray *pt;

  // ist schon generiert
  if (type == PATCHOBJ)
    return grobjp->getpatcharray();

  pt = grobjp->createpatch(min, (stype == NONE)? true:false, this); // Lichtstrke !

  // hier werden die Schnittmengen gebildet
  if (nextS)
    {
      // alle Patches erzeugen
      for (snobj = nextS; snobj; snobj = snobj->nextS)
	snobj->createpatches(min);

      for (snobj = nextS; snobj; snobj = snobj->nextS)
	{
	  switch (snobj->stype)
	    {
	    case NONE:		// erbibt sich von alleine
	      break;
	    case SCHN:
	      pt->schnitt(snobj->getpatches(), snobj, this);
	      break;
	    case DIFF:
	      pt->differenz(snobj->getpatches(), snobj, this);
	      break;
	    }
	}

      // brige patches entfernen
      // alle Patches erzeugen
      cerr << "brige patches entfernen!\n";
 
      for (snobj = nextS; snobj; snobj = snobj->nextS)
	  snobj->deletepatcharray(); 
    }

  // bilde Listtree, nur fr ,,richtiges'' Objekt
  if (stype == NONE)
    pt->bilde_at();

  return pt;
}
 
void obj::surfaceCol(color * colo, vector intpoint)
{
  // Grundfarbe dazu
  *colo *= col;

  // Bitmap Texture oder Muster
  if ((coverp) && (coverp->textcp || coverp->musterp || coverp->text3d))
    {
      color c(1.0, 1.0, 1.0);
      grobjp->surfaceCol(&c, intpoint, coverp, NORMALTXT);
      *colo *= c;
    }
}

color obj::surfaceColRadio(vector int_pt, vector pt, vector vr)
{
  color c(1,1,1);
  surfaceCol(&c, int_pt);  // Objektfarbe

  return color(1,1,1) * get_patch_color(int_pt, pt, vr); // * Beleuchtung
}

void obj::musterCol(color * col, vector intpoint)
{
  grobjp->surfaceCol(col, intpoint, coverp, VECTORTXT);
}

void obj::calc_wave(vector * d, vector intpt, vector normal)
{
  color col(1.0, 1.0, 1.0);	// Wichtig!!!!!!

  vector g, x;

  if (coverp && (coverp->textvp || coverp->musterp2))
    {
      // Farbwert holen, Vorderseite
      musterCol(&col, intpt);

      // Vereinfachte Drehung
      x = intpt - normal;
      g = vector(col.r * x.x, col.g * x.y, col.b * x.z) * pi05;

      rotation(d, intpt, g);
    }

  // Wenn simulierte Wellen vorhanden, wird Vector gedreht
  if (coverp && coverp->wavep)
    coverp->wavep->getnorm(d, intpt);
}

bool obj::calc_spiegelnd(float *sp, vector intpt)
{
//   texture *tp;
//   muster *mp;
  color col(1,1,1);
  float a;

  if (coverp && (coverp->textsp || coverp->mustersp))
    {
      grobjp->surfaceCol(&col, intpt, coverp, SPIEGTXT);

      // Maxwert
      if ((a=((col.r+col.g+col.b)/3.0)) > *sp) 	*sp = a;

      return true;
    }
  return false;  
}

bool obj::calc_brechend(float *br, vector intpt)
{
  color col(1,1,1);
  float a;

  if (coverp && (coverp->textbp || coverp->musterbp))
    {
      grobjp->surfaceCol(&col, intpt, coverp, BRECHTXT);

      // Mittelwert
      if ((a=(*br + (col.r+col.g+col.b) / 3.0)) > *br) *br = a;

      return true;
    }
  return false;
}

// fgt Schnittobjekt ein
void obj::sobj(obj * so)
{
  obj *ns, *no;

  if (nextS == NULL)
    nextS = so;
  else
    {
      no = ns = nextS;
      // laufe die Liste bis ans Ende durch
      while (ns != NULL)
	{
	  no = ns;
	  ns = ns->nextS;
	}
      no->nextS = so;
    }
}
