/*
   Musterobjekt
   Definition in ray.H

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996 Helmut Fahrion

 */

#include "ray.H"

muster::muster(muster * Mp, byte N, word A, bool R, float Mix,
       float X, float Y, color C1, color C2)
{
  int maxcol = 7, x, r, g, b;	// Farbwrfel

  next = 0x0;
  mx = X;
  my = Y;
  c1 = C1;
  c2 = C2;
  num = N;
  art = A, mix = Mix;
  ausfall = R;

  // einketten
  if (Mp)
    Mp->next = this;

  // Farbpalette init
  for (b = 0; b < maxcol; b++)
    for (g = 0; g < maxcol; g++)
      for (r = 0; r < maxcol; r++)
	{
	  x = r + maxcol * g + maxcol * maxcol * b;
	  pal[x] = color((float) r / (float) (maxcol - 1),
			 (float) g / (float) (maxcol - 1),
			 (float) b / (float) (maxcol - 1));
	  // Mischung mit Grundfarbe
	  pal[x] *= c1;
	}

  // Ausfall - Array
  if (ausfall)
    for (r = 0; r < 100; r++)
      ausf[r] = (((float) rand() / (float) RAND_MAX) > 0.5) ? 1 : 0;

  // Anzahl der Iterationen fr Fraktale, Max 7^3 = 343
  max = 200;
}

// wird von Obj aufgerufen
void muster::
getmust(color * col, vector f, vector p)	// f Fupunkt, p xy Abstand Normalisiert!
 {
  color farbe;

  switch (art)
    {
    case BLANK:
      farbe = c1;
      break;			// nur Farbe, fr Rauschen oder Turbolenzen

    case KAROS:
      farbe = karo(f, p);
      break;			// 2 Farbige Karos

    case LINIE:
      farbe = line(f, p);
      break;			// 2 Farbige Streifen

    case KREIS:
      farbe = elips(f, p);
      break;			// Kreise

    case APFEL:
      farbe = apfel(f, p);
      break;			// Mandelbrodmenge

    case JULIA:
      farbe = julia(f, p);
      break;			// Juliamenge

    case WOLKE:
      farbe = wolk(f, p);
      break;			// Juliamenge
      // im Fall einer Falschen Nummer

    default:
      *col = c1;
      return;
    }

  // Farbmischung
  *col = color(col->r * (1.0 - mix) + farbe.r * mix,
	       col->g * (1.0 - mix) + farbe.g * mix,
	       col->b * (1.0 - mix) + farbe.b * mix);
}

bool muster::
ausfrand(float x, float y)
{
  word aa = abs(((int) y + 1) * ((int) x + 1) + 50);
  // sicher ist sicher
  while (aa > 100)
    aa /= 10;
  return ausf[aa];
}

// Wolken - Musterfunktionen
color muster::
wolk(vector f, vector p)
{
  float t1, x, y, r = 0.5, r2 = 0.5;
  vector mp;

  mp = f + p;			// nur x und y Achse sind von Bedeutung

  x = mp.x / mx;		// mx und my definieren die Gre des Musters

  y = mp.y / my;

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(x, y))
    return c1;

  // in Koordinatensystem des Kreises verschieben
  x = fabs(x - (int) x) - r;	// geht nur beim Einheitskreis

  y = fabs(y - (int) y) - r;

  // x -= r; y -= r;

  r -= 0.1;			// Damit ein Rand bleibt, knnte ein Parameter werden!

  // zufllige gre des inneren Kreises
  r2 = (float) rand() / (float) RAND_MAX - 0.5;

  // Kreisgleichung
  t1 = x * x + y * y - r * r;

  // < 0 im Kreis, =0 auf Kreis, >0 auerhalb
  if (((y + r2) <= 0.0) && (t1 <= 0.0))		// plus Zufall

    return c2 * 0.7;		// innerer Kreis, unten

  else if (t1 <= 0.0)		// innerer Kreis, oben

    return c2;
  else
    // Falls kein Kreispunkt, dann Grundfarbe
    return c1;
}

// Elipsen - Musterfunktionen
color muster::
elips(vector f, vector p)
{
  float t, x, y, r = 0.5;
  vector mp;

  mp = f + p;			// nur x und y Achse sind von Bedeutung

  x = mp.x / mx;
  y = mp.y / my;

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(x, y))
    return c1;

  // in Koordinatensystem des Kreises verschieben
  x = fabs(x - (int) x);	// geht nur beim Einheitskreis

  y = fabs(y - (int) y);

  x -= r;
  y -= r;

  r -= 0.1;			// Damit ein Rand bleibt

  // Kreisgleichung
  t = x * x + y * y - r * r;

  // < 0 im Kreis, =0 auf Kreis, >0 auerhalb
  return (t <= 0.0) ? c2 : c1;
}

// Karos - Musterfunktionen
color muster::
karo(vector f, vector p)
{
  bool x, y;
  vector mp;

  mp = f + p;			// nur x und y Achse sind von Bedeutung

  x = (word) (mp.x / mx);
  y = (word) (mp.y / my);

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(x, y))
    return c1;

  x %= 2;
  y %= 2;

  // Nachkommateil, Falls kein Karopunkt, dann Grundfarbe
  return ((x && y) || (!x && !y)) ? c2 : c1;
}

// Linien - Musterfunktionen
color muster::
line(vector f, vector p)
{
  int y;
  vector mp;

  mp = f + p;			// nur y Achse ist von Bedeutung

  y = (word) (mp.y / my);

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(1.0, y))
    return c1;

  y %= 2;

  // Nachkommateil, Falls kein Linienpunkt, dann Grundfarbe
  return (y) ? c2 : c1;
}

// Iterationsroutine fr Apfelmnnchen
word muster::
apfeli(float cx, float cy, word maxiter)
{
  float x2, y2, x, y;
  x2 = y2 = x = y = 0.0;

  while ((maxiter) && (x2 + y2 < 10.0))
    {
      y = 2.0 * x * y + cy;
      x = x2 - y2 + cx;
      x2 = x * x;
      y2 = y * y;
      maxiter--;
    }
  return ++maxiter;
}

// Apfelmnnchen - Musterfunktionen
color muster::
apfel(vector f, vector p)
{
  float x, y;

  vector mp;

  mp = f + p;			// nur x und y Achse sind von Bedeutung

  x = fabs(mp.x / mx);
  y = fabs(mp.y / my);

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(x, y))
    return c1;

  // Nachkommateil
  x -= (int) x;
  y -= (int) y;
  x = 1.0 - x;

  return pal[apfeli(x * 2.3 - 1.65, y * 2.3 - 1.2, max)];
}

// Iterationsroutine fr Juliamenge
word muster::
juliai(float cx, float cy, word maxiter)
{
  float xq = 0., yq = 0., x = cx, y = cy;
  word count = maxiter;

  while ((xq + yq < 4.0) && count)
    {
      xq = x * x;
      yq = y * y;
      y = 2.0 * x * y + 0.1;
      x = xq - yq + 0.5;
      count--;
    }
  return ++count;
}

// Apfelmnnchen - Musterfunktionen
color muster::
julia(vector f, vector p)
{
  float x, y;

  vector mp;

  mp = f + p;			// nur x und y Achse sind von Bedeutung

  x = fabs(mp.x / mx);
  y = fabs(mp.y / my);

  // Ausflle je Rasterpunkt
  if (ausfall && ausfrand(x, y))
    return c1;

  // Nachkommateil
  x -= (int) x;
  y -= (int) y;
  x = 1.0 - x;

  return pal[juliai(x * 0.56 + 0.1, y * 0.56 + 0.2, max)];
}
