#include "ray.H"

/*
   Klasse fr flchenfrmige Lichtquellen

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion

*/

// get_light ist eigentlich der gleiche Algorithmus der in ray verwendet wird
// hier ist ein Ansatzpunkt eine bergeordnete Klasse ,,Lichtquelle'' einzufhren
// und diese Prozedur nur zu erben
color lichtpoly::
get_light (int i, vector int_point, vector dir, vector normal, obj * objp)
{
  obj *sobj=0;
  vector L, V, npt, nor;
  float licht, e;

  color col (0.0, 0.0, 0.0);

  // Richtungsvektor
  L |= int_point - licht_m[i];	//n;

  // Test ob der Winkel <= w des Strahlers ist!
  if ((L < n) <= w)
    {
      // wird Lampe getroffen
      if (objp == pray.show_trace(ptree, licht_m[i], L, &npt, &nor, sobj, &e))
	{
	  L = !L;

	  licht = L * normal * objp->dif_const;
	  
	  // Specular licht
	  if (licht >= 0.0)
	    {
	      V |= L - dir;
	      licht += objp->spec_const * pow (V * normal, objp->high_const);
	    }
	  else
	    licht = 0.0;

	  // lichtfarbe
	  col = pcol * licht;

	  // licht distance
	  if (licht)
	    col *= exp (ln05 / (intens == 0.0 ? eps8 : intens) * (int_point || licht_m[i]));

	}			// if obj
    }				// if <
  return col;
}

color lichtpoly::
get_light_spec(int i, vector int_point, vector dir, vector normal, obj * objp)
{
  obj *sobj=0;
  vector L, V, npt, nor;
  float licht, e;

  color col (0.0, 0.0, 0.0);

  // Richtungsvektor
  L |= int_point - licht_m[i];	//n;

  // Test ob der Winkel <= w des Strahlers ist!
  if ((L < n) <= w)
    {
      // wird Lampe getroffen
      if (objp == pray.show_trace(ptree, licht_m[i], L, &npt, &nor, sobj, &e))
	{
	  L = !L;

	  // Specular licht
	  if ((L * normal * objp->dif_const) >= 0.0)
	    {
	      V |= L - dir;
	      licht = objp->spec_const * pow (V * normal, objp->high_const);
	    }
	  else
	    licht = 0.0;

	  // lichtfarbe
	  col = pcol * licht;

	  // licht distance
	  if (licht)
	    col *= exp (ln05 / (intens == 0.0 ? eps8 : intens) * (int_point || licht_m[i]));

	}			// if obj
    }				// if <
  return col;
}

// ermittelt die Farbe des Punktes von Lichtquelle zum Punkt!
color lichtpoly::
get_color (vector int_point, vector dir, vector normal, obj * obj)
{
  int a, b, i;
  color col (0.0, 0.0, 0.0);

  // Gehe Einzellichtquellen durch
  for (b = 0; b < (yanz + 2); b++)
    for (a = 0; a < (xanz + 2); a++)
      {
	i = b * (xanz + 2) + a;
	col += get_light (i, int_point, dir, normal, obj);
      }

  return col;
}

// ermittelt die Farbe des Punktes von Lichtquelle zum Punkt!
color lichtpoly::
get_color_spec(vector int_point, vector dir, vector normal, obj * obj)
{
  int a, b, i;
  color col (0.0, 0.0, 0.0);

  // Gehe Einzellichtquellen durch
  for (b = 0; b < (yanz + 2); b++)
    for (a = 0; a < (xanz + 2); a++)
      {
	i = b * (xanz + 2) + a;
	col += get_light (i, int_point, dir, normal, obj);
      }

  return col;
}

// errechnet je Auflsung die Lichtquellenmatrix
void lichtpoly::
initmatrix (void)
{
  longint xam, yam, a, b, ia, ib;
  vector r;
  float l;

  xam = xanz + 2;
  yam = yanz + 2;

  licht_m = new vector[xam * yam];	// inklusive der Polygonpunkte

  // erzeuge Vektor 1
  r |= p2 - p1;
  l = (p2 || p1) / (float) (xam - 1);
  for (a = 0; a < xam; a++)
    licht_m[a] = p1 + r * l * a;

  // erzeuge letzten Vektor
  r |= p3 - p4;
  l = (p3 || p4) / (float) (xam - 1);
  for (a = 0; a < xam; a++)
    licht_m[(yam - 1) * xam + a] = p4 + r * l * a;

  // laufe Matrix durch
  for (a = 0; a < xam; a++)
    {
      ia = a;
      ib = (yam - 1) * xam + a;
      r |= licht_m[ib] - licht_m[ia];
      l = (licht_m[ib] || licht_m[ia]) / (float) (yam - 1);	// strecke nach b

      for (b = 1; b < yam - 1; b++)	// nimm 1. und letztes nicht

	licht_m[b * xam + a] = licht_m[ia] + r * l * b;
    }

  // Mittelwert zum testen der Richtung fr Radiosity Lichtquellenverteilung
  m = VNULL;
  for (a = 0; a < xam; a++)  m += licht_m[a];
  m /= (float)xam;

}

