/*
   File fr Lichtquelle

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "ray.H"

// ermittelt die Farbe des gegebenen Punktes
color lamp::get_color (vector int_point, vector dir, vector normal, obj * objp)
{
  obj *sobj=0;
  vector L, V, npt, nor;
  float licht, e;
  color pcol(0, 0, 0);

  // Richtungsvektor
  L |= int_point - m;

  if (objp == pray.show_trace(ptree, m, L, &npt, &nor, sobj, &e))
    {
      L = !L;

      licht = (L * normal) * objp->dif_const;

      // Specular licht
      if (licht >= 0.0)
	{
	  V |= L - dir;
	  licht += objp->spec_const * pow(V * normal, objp->high_const);
	}
       else
	return CNULL;
 	
      // if (licht < 0) cerr << "licht < 0!\n";
      pcol = col * licht;

      // licht distance
      if (type == SUNLAMP)	// Bei der Sonne zhlt die Entfernung nicht!
	pcol *= intens;
      else if (licht >= 0.0)
	pcol *= exp (ln05 / (intens == 0.0 ? eps8 : intens) * (int_point || m));
    }				// if objp
  return pcol;
}

color lamp::
get_color_spec(vector int_point, vector dir, vector normal, obj * objp)
{
  obj *sobj=0;
  vector L, V, npt, nor;
  float licht, e;

  color pcol (0.0, 0.0, 0.0);

  // Richtungsvektor
  L |= int_point - m;

  if (objp == pray.show_trace (ptree, m, L, &npt, &nor, sobj, &e))
    {
      L = !L;

      // Specular licht
      if ((L * normal * objp->dif_const) > 0.0)
	{
	  V |= L - dir;
	  licht = objp->spec_const * pow (V * normal, objp->high_const);
	}
      else
	//  licht = 0.0;
	return CNULL;

      pcol = col * licht;

      if (licht >= 0.0)
	pcol *= exp (ln05 / (intens == 0.0 ? eps8 : intens) * (int_point || m));
    }				// if objp

  return pcol;
}


