/*
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gif.H"

//  Hinweise auf die GIF-Entwickler: CompuServe Inc.
//  "The Graphics Interchange Format (C) is the Copyright
//   property of CompuServe Inc. GIF is a Service Mark 
//   property of CompuServe Inc."

struct GIFFILEHEADER
  {
    unsigned char GIF[6];	// GIF Identifikation

    unsigned short scrwidth;	// Breite des Bildschirms

    unsigned short scrheight;	// Hhe des Bildschirms

    unsigned char resflag;	// Resolution Flag

    unsigned char background;	// Hintergrundfarbe

    unsigned char Pixel;
  }
gifheader;

struct GIFIMAGEHEADER
  {
    unsigned short AX;		// Abstand x 

    unsigned short AY;		// Abstand y

    unsigned short imgwidth;	// Bildbreite

    unsigned short imgheight;	// Bildhhe

    unsigned char flagbyte;	// FLAGS

  }
gifimage;


#define      MAXENTRY   4096
int packet[MAXENTRY];		/* Tabelle mit Pixelwerten */
int pre[MAXENTRY];		/* Tabelle mit Prefixen */


int 
testbits (int bits)
{
  while (pre[bits] != -1)
    bits = pre[bits];
  return bits;
}

#define CLEAR_CODE  (1<<pixel_size)
#define EOI_CODE    (1<<pixel_size)+1


unsigned short 
getWinWordFILE (FILE * pointer, char x)
{
  unsigned short hilf = 0;
  if (x == 'I')
    {
      hilf = (getc (pointer) & 0xff);
      hilf |= (getc (pointer) & 0xff) << 8;
      return (hilf);
    }
  if (x == 'M')
    {
      hilf = (getc (pointer) & 0xff) << 8;
      hilf |= (getc (pointer) & 0xff);
      return (hilf);
    }
  return 0;
}

static unsigned long x;

void 
setpoint2 (byte * im, int prefix)
{
  if (pre[prefix] != -1)
    setpoint2 (im, pre[prefix]);
  *(im + x) = packet[prefix];
  x++;
}

int 
ReadGIFImage (texture * text, char *Name)
{
  FILE *fp;			/*  Dateizeiger  */
  int i;			/*  Laufvariable  */
  unsigned char gblock[256],	/*  Block fr Bilddaten */
    pixel_size, block_size;	/*  Speichert aktuelle Blockgre    */
  unsigned next_entry,		/*  zeigt auf ersten freie Eintrag */
    counter,			/*  Anzahl der benutzten Bits in count_word */
    mask_width,			/*  Gre der Bitmask */
    mask,			/*  Bitmaske */
    bits;			/*  aktuell gelesene Daten */
  int prefix,			/*  Vorgnger   */
    colcount,			/*  Anzahl der Farben */
    suffix,			/*  Nachfolger   */
    old_code;			/*  alter Wert */
  unsigned long count_word,	/*  nimmt Bits aus Bitstrom auf */
    help;			/*  Hilfsvariable zum Schiften */

  /* Datei ffnen */
  if ((fp = fopen (Name, "rb")) != NULL)
    {
      /* lesen des GIFFILEHEADER */
      fread (&gifheader, 13, 1, fp);

      /* Test auf GIF-Datei */
      if (strncmp ((const char *) &(gifheader.GIF[0]), "GIF", 3))
	{
	  //error(WRONGFILEFORMAT, "ReadGIF", Name);
	  fprintf (stderr, "Falsches Dateiformat, keine *.gif Datei.\n");

	  fclose (fp);
	  return (false);
	}

      /* Test auf Farbtabelle */
      if (gifheader.resflag & 0x80)
	{
	  i = 0;
	  colcount = 1 << ((gifheader.resflag & 0x07) + 1);
	  while (i < colcount)
	    {
	      text->pal[i].r = ((float) getc (fp)) / 256.0;
	      text->pal[i].g = ((float) getc (fp)) / 256.0;
	      text->pal[i].b = ((float) getc (fp)) / 256.0;
	      i++;
	    }
	}

      //  Erweiterungsblock gefunden
      if (fgetc (fp) == 0x21)
	{
	  //error(UNKNOWNERROR, "ReadGIFImage", "Erweiterungsblock gefunden");
	  fprintf (stderr, "Kein Erweiterungsblock in *.gif Datei gefunden.\n");

	  fclose (fp);
	  return (false);
	}
      else
	{
	  //  lesen des GIFIMAGHEADER
	  gifimage.AX = getWinWordFILE (fp, 'I');
	  gifimage.AY = getWinWordFILE (fp, 'I');
	  gifimage.imgwidth = getWinWordFILE (fp, 'I');
	  gifimage.imgheight = getWinWordFILE (fp, 'I');
	  gifimage.flagbyte = getc (fp);
	}

      text->x = gifimage.imgwidth;
      text->y = gifimage.imgheight;

      //  Pixelsize einlesen
      pixel_size = fgetc (fp);

      //  IMAGE kreieren
      if ((text->map = new byte[gifimage.imgwidth * gifimage.imgheight])
	  == NULL)
	{
	  fprintf (stderr, "Nicht gengend Speicher um *.gif Datei zu lesen.\n");
	  return (false);
	}

      x = 0;


      /*   Tabelle vorbesetzen */

      for (i = 0; i < (1 << pixel_size) + 2; i++)
	{
	  packet[i] = i;
	  pre[i] = -1;
	}

      /* Variablen initialisieren  */
      next_entry = (1 << pixel_size) + 2;
      counter = 0;
      count_word = 0;
      mask_width = pixel_size + 1;
      mask = (1 << mask_width) - 1;
      old_code = -1;

      /* Lese, solange es Blcke > 0 gibt  */
      for (block_size = fgetc (fp); block_size > 0; block_size = fgetc (fp))
	{
	  /*  einen Block einlesen  */
	  fread (&(gblock[0]), block_size, 1, fp);

	  /*  Block bearbeiten */
	  for (i = 0; i < block_size; i++)
	    {
	      help = (unsigned long) gblock[i];
	      count_word |= (help << counter);
	      counter += 8;

	      /*  Hole gengend Bits in count_word  */
	      while (counter >= mask_width)
		{
		  /*  Neuen Wert basteln */
		  bits = ((unsigned) count_word) & mask;
		  counter -= mask_width;
		  count_word >>= mask_width;

		  /*  EOI-Code empfangen */
		  if (bits == (unsigned) EOI_CODE)
		    {
		      /*  Datei schlieen  */
		      fclose (fp);
		      return (true);
		    }

		  /*  Clear Code empfangen */
		  if (bits == (unsigned) CLEAR_CODE)
		    {
		      next_entry = (1 << pixel_size) + 2;
		      mask_width = pixel_size + 1;
		      mask = (1 << mask_width) - 1;
		      old_code = -1;
		      continue;
		    }

		  /*  Erster Wert an die Ausgabe */
		  if (old_code == -1)
		    {
		      old_code = bits;
		      setpoint2 (text->map, bits);
		      continue;
		    }
		  else
		    {
		      /*  Ist neuer Code schon in der Tabelle ? */
		      if (bits < next_entry)
			{
			  setpoint2 (text->map, bits);
			  prefix = old_code;
			  suffix = testbits (bits);
			}
		      else
			{
			  prefix = old_code;
			  suffix = testbits (prefix);
			  setpoint2 (text->map, prefix);
			  setpoint2 (text->map, suffix);
			}

		      /*  Neuen Eintrag in die Tabelle speichern */
		      packet[next_entry] = suffix;
		      pre[next_entry] = prefix;
		      next_entry++;
		      old_code = bits;
		    }
		  /*  Breite der Bitmaske justieren, falls ntig */
		  if (next_entry > mask)
		    {
		      if (next_entry < MAXENTRY)
			{
			  mask_width++;
			  mask = (1 << mask_width) - 1;
			}
		    }
		}
	    }
	}

      /*  Datei schlieen  */
      fclose (fp);
      return (true);
    }
  return (false);
}
