/*
   Ein einfacher Elipsoid als Krper.

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"

elipsoid::elipsoid(vector M, vector R, vector W)
{
  w = W;
  r = R;
  m = M;
  ryz = rzx = 0;
}

bool   elipsoid::
in_obj(vector mp)
{
  vector r0 = m - mp;		// Transformation in Koordinaten des Elipsoiden

  rotation(&r0, VNULL, w);	// ins Koordinatensystem des Elipsoiden rotieren

  // cerr << "hit_in(" << r0 << ", " << r.x * r.x << ", "<<r.y * r.y<<", "<<r.z * r.z<<"\n";
  return hit_in(r0, r.x * r.x, r.y * r.y, r.z * r.z);	// ist point im Elipsoiden?

}

patcharray *elipsoid::
createpatch(float Min, bool Schn, obj * grobj)		// fr Radios, Patches erzeugen
{
  pp = new patcharray(Min, Schn, grobj, m, r, w);
  return pp;
}

// Oberflchenfarbe

void   elipsoid::
surfaceCol(color * col, vector intpoint, cover * cp, byte art)
{
  vector i;
  float  x, y, radius;

  texture *tp=NULL;
  muster  *mp=NULL;

  switch (art)
    {
      case NORMALTXT:
	tp = cp->textcp;
	mp = cp->musterp;
	break;
      case VECTORTXT:
	tp = cp->textvp;
	mp = cp->musterp2;
	break;
      case SPIEGTXT:
	tp = cp->textsp;
	mp = cp->mustersp;
	break;
      case BRECHTXT:
	tp = cp->textbp;
	mp = cp->musterbp;
	break;
    }

  i = m - intpoint;

  // Verschiebung des Treffpunktes je nach Muster
  if ((cp->tb.tu == 1) || (cp->tb.tu == 3))
    i += cp->tb.getturbo((m - intpoint) * cp->tb.t);

  // Drehen des Koordinatensystems
  rotation(&i, vector(0.0, 0.0, 0.0), w);

/*
   // Nherungsweise bestimmen
   x = fabs((i.x+rzx*pi05) / (pi*rzx));
   y = fabs((i.y+ryz*pi05) / (pi*ryz));
 */

  x = y = 0.0;
  // Quadrant beachten, zuerst die am meisten verwendeten
  if ((i.z < 0.0) && (i.x < 0.0))
    x = atan(fabs(i.z / i.x)) + pi;
  else if ((i.z < 0.0) && (i.x > 0.0))
    x = pi2 - atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x > 0.0))
    x = atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x < 0.0))
    x = pi - atan(fabs(i.z / i.x));

  if (x > pi2)
    x -= pi2;

  radius = (r.x + r.z) / 2.0;
  x = (x * radius) / (pi2 * radius);	// Abstand in Bezug auf die Gesamtlnge

  // Quadrant beachten, zuerst die am meisten verwendeten
  if ((i.z < 0.0) && (i.y < 0.0))
    y = atan(fabs(i.z / i.y)) + pi;
  else if ((i.z < 0.0) && (i.y > 0.0))
    y = pi2 - atan(fabs(i.z / i.y));
  else if ((i.z > 0.0) && (i.y > 0.0))
    y = atan(fabs(i.z / i.y));
  else if ((i.z > 0.0) && (i.y < 0.0))
    y = pi - atan(fabs(i.z / i.y));

  if (y > pi2)
    y -= pi2;

  radius = (r.y + r.z) / 2.0;
  y = (y * radius) / (pi2 * radius);	// Abstand in Bezug auf die Gesamtlnge

  if (tp)
    tp->gettexture(col, x, y, cp, m - intpoint);

  if (mp)
    {
      if ((cp->tb.tu == 2) || (cp->tb.tu == 3))
	mp->mix = cp->tb.getgturbo((m - intpoint) * cp->tb.t);
      mp->getmust(col, cp->musterfp, vector(x, y, 0.0));
    }

  if (cp->text3d)
    cp->text3d->gettext(col, cp->musterfp, intpoint - m);
}

bool elipsoid::hit_in(vector r0, float aq, float bq, float cq)
{
  int    l;
  float  A, B, C, t1, t2;
  vector r1;

  r1 |= m - r0;
  rotation(&r1, VNULL, w);

  // Therme des Elipsoiden
  A = (aq * (bq * r1.z * r1.z + cq * r1.y * r1.y) + bq * cq * r1.x * r1.x);
  B = (2. * (aq * (bq * r1.z * r0.z + cq * r1.y * r0.y) + bq * cq * r0.x * r1.x));
  C = (bq * cq * r0.x * r0.x - aq * (bq * (cq - r0.z * r0.z) - cq * r0.y * r0.y));

  // QG Lsen
  l = solve_quad(A, B, C, &t1, &t2);

  if (l < 1)
    return false;

  if (l == 2)
    return ((t1 > 0.0) && (t2 > 0.0)) ? false:true;

  if (l == 1)
    return (t1 > 0.0) ? false:true;

  return false;
}

// Treffpunkt
// Eingangswerte: Gerade durche point und dir definiert
// Ausgangswerte: Treffpunkt in int_point falls return true
//                Normalvektor in norma
// Return:        true falls ein Schnittpunk exisitiert ansonst false
bool elipsoid::hit_object(vector point, vector dir, bool hitin,
			  vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2)
{
  int    l;
  vector r0, r1;
  float  t1, t2, aq, bq, cq;

  // Transformation in Koordinaten des Elipsoiden
  r0 = m - point;
  r1 = dir;			// Normalvektor bleibt!

  rotation(&r0, VNULL, w);	// ins Koordinatensystem des Elipsoiden rotieren

  rotation(&r1, VNULL, w);

  // Quadrate berechnen
  aq = r.x * r.x;
  bq = r.y * r.y;
  cq = r.z * r.z;

  // ist point im Elipsoiden?
  if (hitin)
    if (hit_in(r0, aq, bq, cq))
      return false;

  if ((l = solve_quad(aq * (bq * r1.z * r1.z + cq * r1.y * r1.y) + bq * cq * r1.x * r1.x,
   2.0 * (aq * (bq * r1.z * r0.z + cq * r1.y * r0.y) + bq * cq * r0.x * r1.x),
    bq * cq * r0.x * r0.x - aq * (bq * (cq - r0.z * r0.z) - cq * r0.y * r0.y),
		     &t1, &t2)))
    {
      if ((t1 > 0.0) && (t2 > 0.0))
	return false;

      if (l == 2)
	{
	  // Treffpunkt zurckrechnen 1
	  *int_pt1 = point + (dir * fabs(t1));
	  r0 = *int_pt1 - m;	// Normalvektor, Kugel berechnen

	  r1 = vector((aq != 0.0) ? r0.x * 2.0 / aq:0.0,
		      (bq != 0.0) ? r0.y * 2.0 / bq:0.0,
		      (cq != 0.0) ? r0.z * 2.0 / cq:0.0);	// Gradiend,  1. Ableitung nach x,y und z

	  *norm1 |= r0 + r1;

	  // Treffpunkt zurckrechnen 2
	  *int_pt2 = point + (dir * fabs(t2));
	  r0 = *int_pt2 - m;	// Normalvektor, Kugel berechnen

	  r1 = vector((aq != 0.0) ? r0.x * 2.0 / aq:0.0,
		      (bq != 0.0) ? r0.y * 2.0 / bq:0.0,
		      (cq != 0.0) ? r0.z * 2.0 / cq:0.0);	// Gradiend,  1. Ableitung nach x,y und z

	  *norm2 |= r0 + r1;
	}
      else
	// Tangiert
	return false;
    }
  else
    return false;
  return true;
}

bool elipsoid::testgrobj(vector * z1, vector * z2, vector nv1, vector nv2)
{
  float  tr;

  tr = (r.x > r.y) ? r.x:r.y;
  tr = (r.z > tr) ? r.z:tr;

  // aus einem Elipsoiden wird ein Wrfel gemacht
  *z1 = m - vector(tr, tr, tr);
  *z2 = m + vector(tr, tr, tr);

  // Test ob reinpasst
  if ((nv1.x <= z1->x && nv1.y <= z1->y && nv1.z <= z1->z) &&
      (nv2.x >= z2->x && nv2.y >= z2->y && nv2.z >= z2->z))
    return true;
  else
    return false;
}

bool elipsoid::getpoints(vector * v1, longint x)
{
  float  t;

  t = (r.x > r.y) ? r.x:r.y;
  t = (r.z > t) ? r.z:t;
  t += eps2;

  if ((x >= 1) && (x <= 15))
    {
      switch (x)
	{
	case 1:	  *v1 = m + vector(0, 0, 0);	  break;
	case 2:	  *v1 = m + vector(0, 0, t);	  break;
	case 3:	  *v1 = m + vector(0, t, 0);	  break;
	case 4:	  *v1 = m + vector(t, 0, 0);	  break;
	case 5:	  *v1 = m + vector(0, t, t);	  break;
	case 6:	  *v1 = m + vector(t, t, 0);	  break;
	case 7:	  *v1 = m + vector(t, 0, t);	  break;
	case 8:	  *v1 = m + vector(t, t, t);	  break;
	case 9:	  *v1 = m - vector(0, 0, t);	  break;
	case 10:  *v1 = m - vector(0, t, 0);	  break;
	case 11:  *v1 = m - vector(t, 0, 0);	  break;
	case 12:  *v1 = m - vector(0, t, t);	  break;
	case 13:  *v1 = m - vector(t, t, 0);	  break;
	case 14:  *v1 = m - vector(t, 0, t);	  break;
	case 15:  *v1 = m - vector(t, t, t);	  break;
	}
      return true;
    }
  else
    return false;
}
