/*
   Ein einfacher Kegelstumpf als Krper.

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "ray.H"

bool cone::in_obj(vector mp)
{
  vector v0 = mp;
  rotationVZ(&v0, wn);
  return hit_in(v0); // ist point im Zylinder?
}

patcharray *cone::createpatch(float Min, bool Schn, obj * grobj)
{
  pp = new patcharray(Min, Schn, grobj, p1, p2, (r > 0.0) ? r : -r, r2);
  return pp;
}

void cone::setcone(vector P1, vector P2, float R, float R2, float Alpha)
{
  // Memberdaten setzen
  p1 = P1;
  p2 = P2;
  r = R;
  r2 = R2;
  alpha = Alpha;

  if (r == 0.0)
    r = eps4;
  if (r < 0.0)
    {
      Kegel = true;
      r = fabs(r);
    }
  else
    Kegel = false;

  // Hhe des Kegels
  h = abs(p2 - p1);
  if (fabs(h) < eps4)
    h = eps4;

  // Richtungswinkel
  wn |= p2 - p1;

  // Daten fr Berechnung
  dq = r * r;
  cq = h * h;
}

// Oberflchenfarbe
void cone::surfaceCol(color * col, vector intpoint, cover * cp, byte art)
{
  vector i;
  float x, y;

  texture *tp=NULL;
  muster  *mp=NULL;

  switch (art)
    {
      case NORMALTXT:
	tp = cp->textcp;
	mp = cp->musterp;
	break;
      case VECTORTXT:
	tp = cp->textvp;
	mp = cp->musterp2;
	break;
      case SPIEGTXT:
	tp = cp->textsp;
	mp = cp->mustersp;
	break;
      case BRECHTXT:
	tp = cp->textbp;
	mp = cp->musterbp;
	break;
    }

  i = intpoint - p1;

  // Verschiebung des Treffpunktes je nach Muster
  if ((cp->tb.tu == 1) || (cp->tb.tu == 3))
    i += cp->tb.getturbo((intpoint - p1) * cp->tb.t);

  // Drehen des Koordinatensystems in das des Kegels
  rotationVZ(&i, wn);

  // Treffpunkte am Mantel
  y = i.y;
  x = i.x;			// Dummy Zuweisung

  // Quadrant beachten, zuerst die am meisten verwendeten
  if ((i.z < 0.0) && (i.x < 0.0))
    x = atan(fabs(i.z / i.x)) + pi;
  else if ((i.z < 0.0) && (i.x > 0.0))
    x = pi2 - atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x > 0.0))
    x = atan(fabs(i.z / i.x));
  else if ((i.z > 0.0) && (i.x < 0.0))
    x = pi - atan(fabs(i.z / i.x));

  x += alpha;
  if (x > pi2)
    x -= pi2;

  x = (x * r) / (pi2 * r);	// Abstand in Bezug auf die Gesamtlnge

  // im Fall das Schnittebene zu weit weg ist

  y = fabs(y);
  // immer auf Hhe bringen
  while (y > h)
    y -= h;

  // in %
  y /= h;

  if (tp)
    tp->gettexture(col, x, y, cp, intpoint - p1);

  if (mp)
    {
      if ((cp->tb.tu == 2) || (cp->tb.tu == 3))
	mp->mix = cp->tb.getgturbo((p1 - intpoint) * cp->tb.t);
      mp->getmust(col, cp->musterfp, vector(x, y, 0.0));
    }

  if (cp->text3d)
    cp->text3d->gettext(col, cp->musterfp, intpoint - p1);
}

bool cone::
hit_in(vector v0)
{
  int l;
  float A = 0.0, B = 0.0, C = 0.0, t1, t2;

  vector dr;

  dr |= v0;

  if (Kegel)
    {
      // Kegel
      A = (dr.x * dr.x * cq - dr.z * dr.z * dq + dr.y * dr.y * cq);
      B = 2.0 * (dr.x * cq * v0.x - dr.z * dq * v0.z + dr.y * cq * v0.y);
      C = (cq * (v0.x * v0.x + v0.y * v0.y) - dq * v0.z * v0.z);
    }
  else
    {
      // Zylinder
      A = (dr.x * dr.x + dr.y * dr.y);
      B = 2.0 * (dr.x * v0.x + dr.y * v0.y);
      C = v0.x * v0.x + v0.y * v0.y - dq;
    }

  // QG Lsen
  if ((l = solve_quad(A, B, C, &t1, &t2)))
    return (l == 2)? false:true;
  return true;
}

// Treffpunkt
// Eingangswerte: Gerade durche point und dir definiert
// Ausgangswerte: Treffpunkt in int_point falls return true
//                Normalvektor in norma
// Return:        true falls ein Schnittpunk exisitiert ansonst false
bool cone::
hit_object(vector point, vector dir, bool hitin,
	 vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2)
{
  int l;
  float A, B, C, t1, t2;
  vector v0, pt, dr;

  // Transformation in Koordinaten des Kegels
  pt = point;
  dr = dir;

  v0 = p1 - pt;

  rotationVZ(&v0, wn);
  rotationVZ(&dr, wn);

  // ist point im Zylinder?
  if (hitin)
    if (hit_in(v0))
      return false;

  if (Kegel)
    {
      // Kegel
      A = (dr.x * dr.x * cq - dr.z * dr.z * dq + dr.y * dr.y * cq);
      B = 2.0 * (dr.x * cq * v0.x - dr.z * dq * v0.z + dr.y * cq * v0.y);
      C = (cq * (v0.x * v0.x + v0.y * v0.y) - dq * v0.z * v0.z);
    }
  else
    {
      // Zylinder
      A = (dr.x * dr.x + dr.y * dr.y);
      B = 2.0 * (dr.x * v0.x + dr.y * v0.y);
      C = v0.x * v0.x + v0.y * v0.y - dq;
    }

  // QG Lsen
  if ((l = solve_quad(A, B, C, &t1, &t2)))
    {
      if ((t1 > 0.0) && (t2 > 0.0))
	return false;

      // Beide Lsungen berechnen
      *int_pt1 = point + (dir * fabs(t1));	// Vektor zum Mantel, reele Koordinaten

      if (l == 2)
	*int_pt2 = point + (dir * fabs(t2));
      else
	*int_pt2 = *int_pt1;

      // Normalvektor am Mantel, Zylinder          drfte Falsch sein!!!!!!!!!!
      if (Kegel)
	{
	  v0 = absgeradepunkt(p1, wn, *int_pt2);
	  pt = vector(v0.x * 2.0 / dq, v0.y * -2.0 / dq, v0.z * 2.0 / cq);
	  *norm1 |= v0 + pt;
	  if (l == 2)
	    {
	      v0 = absgeradepunkt(p1, wn, *int_pt2);
	      pt = vector(v0.x * 2.0 / dq, v0.y * -2.0 / dq, v0.z * 2.0 / cq);
	      *norm2 |= v0 + pt;
	    }
	  else
	    *norm2 = *norm1 * -1.0;
	}
      else
	{
	  *norm1 |= absgeradepunkt(p1, wn, *int_pt1);
	  if (l == 2)
	    *norm2 |= absgeradepunkt(p1, wn, *int_pt2);
	  else
	    *norm2 = *norm1 * -1.0;
	}
      return true;
    }
  return false;			// keine Lsung

}

bool cone::
testgrobj(vector * z1, vector * z2, vector nv1, vector nv2)
{
  vector v1, v2, v3, v4, e1, e2;

  float rad = fabs(r) + eps2;

  v1 = p1 - vector(rad, rad, rad);
  v2 = p1 + vector(rad, rad, rad);
  v3 = p2 - vector(rad, rad, rad);
  v4 = p2 + vector(rad, rad, rad);

  // aus einem Zylinder wird ein Wrfel gemacht
  e1.x = v1.x;
  if (v2.x < e1.x)
    e1.x = v2.x;
  if (v3.x < e1.x)
    e1.x = v3.x;
  if (v4.x < e1.x)
    e1.x = v4.x;
  e1.y = v1.y;
  if (v2.y < e1.y)
    e1.y = v2.y;
  if (v3.y < e1.y)
    e1.y = v3.y;
  if (v4.y < e1.y)
    e1.y = v4.y;
  e1.z = v1.z;
  if (v2.z < e1.z)
    e1.z = v2.z;
  if (v3.z < e1.z)
    e1.z = v3.z;
  if (v4.z < e1.z)
    e1.z = v4.z;
  e2.x = v1.x;
  if (v2.x > e2.x)
    e2.x = v2.x;
  if (v3.x > e2.x)
    e2.x = v3.x;
  if (v4.x > e2.x)
    e2.x = v4.x;
  e2.y = v1.y;
  if (v2.y > e2.y)
    e2.y = v2.y;
  if (v3.y > e2.y)
    e2.y = v3.y;
  if (v4.y > e2.y)
    e2.y = v4.y;
  e2.z = v1.z;
  if (v2.z > e2.z)
    e2.z = v2.z;
  if (v3.z > e2.z)
    e2.z = v3.z;
  if (v4.z > e2.z)
    e2.z = v4.z;

  *z1 = e1;
  *z2 = e2;

  // Test ob reinpasst
  if ((nv1.x <= z1->x && nv1.y <= z1->y && nv1.z <= z1->z) &&
      (nv2.x >= z2->x && nv2.y >= z2->y && nv2.z >= z2->z))
    return true;
  else
    return false;
}

bool cone::
getpoints(vector * v1, longint x)
{
  float rad = fabs(r) + eps2;

  if (x == 1)
    {
      *v1 = p1 - vector(rad, rad, rad);
      return true;
    };
  if (x == 2)
    {
      *v1 = p1 + vector(rad, rad, rad);
      return true;
    };
  if (x == 3)
    {
      *v1 = p2 - vector(rad, rad, rad);
      return true;
    };
  if (x == 4)
    {
      *v1 = p2 + vector(rad, rad, rad);
      return true;
    };

  return false;
}
