/*
   ein ebener Krper

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
 */

#include "ray.H"

bool block::in_obj(vector mp)
{
  byte   x;
  vector p1v1, p1v2, p1d1, p1d2;

  for (x = 0, hit1 = 8; (hit1 == 8) && x < 6; x++)
    if (p[x].hit_object(mp, p[x].getnormal(), false, &p1v1, &p1d1, &p1v2, &p1d2))
      hit1 = x;

  if (hit1 == 8)
    return false; // garkein Treffer

  if (hit1 < 8)
    return true;  // eins wurde getroffen !

  return false;
}

patcharray *block::createpatch(float Min, bool Schnt, obj * grobj)
{
  pp = new patcharray(Min, Schnt, grobj, e[0], e[1], e[2], e[3], e[4], e[5], e[6], e[7]);
  return pp;
}

// Oberflchenfarbe
void block::surfaceCol(color * col, vector intpoint, cover * cp, byte art)
{
  // Texturfarbe vom 1. Treffpunkt holen
  if (abs(intpoint - e[0]) < eps5)
    p[hit1].surfaceCol(col, intpoint, cp, art);
  else
    p[hit2].surfaceCol(col, intpoint, cp, art);
}

// Treffpunkt
// Eingangswerte: Gerade durche point und dir definiert
// Ausgangswerte: Treffpunkt in int_point falls return true
//                Normalvektor in norma
// Return:        true falls ein Schnittpunk exisitiert ansonst false
bool block::hit_object(vector point, vector dir, bool hitin,
		       vector * int_pt1, vector * norm1, vector * int_pt2, vector * norm2)
{
  byte   x;
  vector p1v1, p1v2, p1d1, p1d2, p2v1, p2v2, p2d1, p2d2;

  if (!ok)
    return false;		// Datenfehler

  for (x = 0, hit1 = 8; (hit1 == 8) && x < 6; x++)

    {
      if (p[x].hit_object(point, dir, hitin, &p1v1, &p1d1, &p1v2, &p1d2))
	hit1 = x;
    }

  if (hit1 == 8)
    return false;		// kein Treffer

  // teste weiter
  for (x = hit1 + 1; x < 6; x++)	// 6 Polygone

    {
      if (p[x].hit_object(point, dir, hitin, &p2v1, &p2d1, &p2v2, &p2d2))
	{
	  if ((point || p1v1) < (point || p2v1))
	    {
	      hit2 = x;
	      e[0] = *int_pt1 = p1v1;
	      *norm1 = p1d1;
	      e[1] = *int_pt2 = p2v1;
	      *norm2 = p2d1;
	    }
	  else
	    {
	      hit2 = hit1;
	      hit1 = x;
	      e[0] = *int_pt1 = p2v1;
	      *norm1 = p2d1;
	      e[1] = *int_pt2 = p1v1;
	      *norm2 = p1d1;
	    }
	  return true;		// fertig

	}
    }

  // falls 1.trifft und 2. nicht -> Tangiert
  hit2 = hit1;
  e[1] = e[0] = *int_pt2 = *int_pt1 = p1v1;
  *norm2 = *norm1 = p1d1;
  return true;
}

bool block::testgrobj(vector * z1, vector * z2, vector nv1, vector nv2)
{
/*
+   Definition der 8 Punkte des neuen Wrfels
+
+      8         7
+      +--------+
+     /|       /|
+    / |      / |
+  4+--------+3 |
+   |  +-----|--+
+   | / 5    | / 6
+   |/       |/
+   +--------+
+  1          2
+
*/
  bool   ok = false;
  byte   x;
  vector v;

  *z1 = *z2 = e[0];

  for (x = 0; x < 8; x++)
    {
      // Sichtstrahl definieren
      v = e[x];
      if (v.x < z1->x)
	z1->x = v.x;
      if (v.y < z1->y)
	z1->y = v.y;
      if (v.z < z1->z)
	z1->z = v.z;
      if (v.x > z2->x)
	z2->x = v.x;
      if (v.y > z2->y)
	z2->y = v.y;
      if (v.z > z2->z)
	z2->z = v.z;
    }

  // sind alle Punkte im Wrfel?
  for (x = 0; x < 8; x++)
    {
      v = e[x];
      ok = (ok && ((nv1.x <= v.x && nv1.y <= v.y && nv1.z <= v.z) &&
		   (nv2.x >= v.x && nv2.y >= v.y && nv2.z >= v.z)))
	? true: false;
    }
  return ok;
}

// Daten setzen
void block::setvector(byte n, vector V)
{
  e[n] = V;
  if (n == 7)			// ist letzte Ecke gesetzt kann's losgehen

    {
      ok = true;
      // Polygone setzen, wie Wrfel
/*
+            7         6
+            +--------+
+           /|       /|
+          / |      / |
+        3+--------+2 |
+         |  +-----|--+
+         | / 4    | / 5
+         |/       |/
+         +--------+
+        0          1
*/
      p[0].setvector(0, e[0]);
      p[0].setvector(1, e[1]);
      p[0].setvector(2, e[2]);
      p[0].setvector(3, e[3]);
      p[1].setvector(0, e[1]);
      p[1].setvector(1, e[5]);
      p[1].setvector(2, e[6]);
      p[1].setvector(3, e[2]);
      p[2].setvector(0, e[0]);
      p[2].setvector(1, e[4]);
      p[2].setvector(2, e[7]);
      p[2].setvector(3, e[3]);
      p[3].setvector(0, e[0]);
      p[3].setvector(1, e[1]);
      p[3].setvector(2, e[5]);
      p[3].setvector(3, e[4]);
      p[4].setvector(0, e[3]);
      p[4].setvector(1, e[2]);
      p[4].setvector(2, e[6]);
      p[4].setvector(3, e[7]);
      p[5].setvector(0, e[4]);
      p[5].setvector(1, e[5]);
      p[5].setvector(2, e[6]);
      p[5].setvector(3, e[7]);
    }
}

bool block::getpoints(vector * v1, longint x)
{
  if ((x >= 1) && (x <= 7))
    {
      *v1 = e[x];
      return true;
    }
  return false;
}
