/*
   Hintergrund fr den Raytracer

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "ray.H"

// Hintergrundfarbe
void ray::
bckgrnd (color * col, color backh, color backb, vector dir)
{
  float x, n;
  word tx, ty;
  byte map, hit = 0;
  color co;

  vector i (0.0, 0.0, 0.0), v, d, int_pt1, norm1, int_pt2, norm2;
  turbo tb1 = pwelt->tb1, tb2 = pwelt->tb2;
  texture *bgtextur1 = pwelt->bgtextur1, *bgtextur2 = pwelt->bgtextur2;
  muster *bgmuster1 = pwelt->bgmuster1, *bgmuster2 = pwelt->bgmuster2;

  // im Falle von Nebel ist kein Hintergrund sichtbar entf. = Unendlich!
  if (pwelt->nebel > eps4)
    {
      *col = color (0.9, 0.9, 0.9);
      return;
    }

  d = dir;

  // Zurckdrehen des Koordinatensystems, sichert einen Treffpunkt im Polygon
  // um eine Simulation zu ermglichen ist der Ursprung der Textur zu verschieben
  rotationVZ (&d, pwelt->cam.w);

  // entspricht etwa den Himmel (Kugel)
  x = vector (0.0, 1.0, 0.0) * d;
  if (x > 1.0)    x = 1.0;
  if (x < -1.0)   x = -1.0;			// Bereichstest fr acos()

  n = (fabs (x = acos (x)) > eps5) ? pi05 / x : pi05;	// Test fr /0

  co = color (backh.r * n + backh.r * pwelt->ambient.r,
	      backh.g * n + backh.g * pwelt->ambient.g,
	      backh.b * n + backh.b * pwelt->ambient.b);
  *col = co;

  // Falls Polygon, Treffpunkt errechnen
  if (pwelt->isb)
    {
      pwelt->bo.hit_object (i, d, false, &int_pt1, &norm1, &int_pt2, &norm2);

      // Da eine Ebene fast immer getroffen wird, wird hier getestet ob vor oder hinter der
      // Kamera.
      if (d.y < 0)
	{
	  hit = 2;
	  int_pt1 += pwelt->cam.mov;	// 3D
	  if (tb2.tu) int_pt1 += tb2.getturbo (int_pt1 * tb2.t);
	}
      else
	hit = 0;
    }

  // immer erst Boden, da der Himmel immer trifft
  if (pwelt->ish && !hit)
    {
      pwelt->hi.hit_object (i, d, false, &int_pt1, &norm1, &int_pt2, &norm2);
      hit = 1;
      int_pt1 += pwelt->cam.mov;	// 3D
      if (tb1.tu) int_pt1 += tb1.getturbo(int_pt1 * tb1.t);
    }
  
  // Hintergrundtextur
  if ((hit == 1) && bgtextur1)
    {

      // Treffpunkt in map
      tx = (word) (((float) bgtextur1->x / 10.0) * (float) int_pt1.x);
      ty = (word) (((float) bgtextur1->y / 10.0) * (float) int_pt1.z);

      // fr den Fall das ber den Rahmen hinaus geht
      while (tx > bgtextur1->x) tx -= bgtextur1->x;
      while (ty > bgtextur1->y) ty -= bgtextur1->y;

      // Farbwert holen 
      map = (byte) bgtextur1->map[(ty - 1) * bgtextur1->x + tx];

      // ist Turbolenz vorhanden?
      if (tb1.tu >2)
	{
	  // auch verschieben, sieht sonst symetrisch aus
	  v = int_pt1 + pwelt->mv1 + tb1.getturbo (int_pt1 * tb1.t);
	  bgtextur1->mix = tb1.getgturbo(v);
	}
      else
	bgtextur1->mix = 0.5;

      *col = color (backh.r * (1.0 - bgtextur1->mix) +
		    (bgtextur1->pal[map].r) * bgtextur1->mix,
		    backh.g * (1.0 - bgtextur1->mix) +
		    (bgtextur1->pal[map].g) * bgtextur1->mix,
		    backh.b * (1.0 - bgtextur1->mix) +
		    (bgtextur1->pal[map].b) * bgtextur1->mix);
    }

  if ((hit == 2) && bgtextur2)
    {
      // Treffpunkt in map
      tx = (word) (((float) bgtextur2->x / 10.0) * (float) int_pt1.x);
      ty = (word) (((float) bgtextur2->y / 10.0) * (float) int_pt1.z);

      // fr den Fall das ber den Rahmen hinaus geht
      while (tx > bgtextur2->x) tx -= bgtextur2->x;
      while (ty > bgtextur2->y) ty -= bgtextur2->y;

      // Farbwert holen
      map = (byte) bgtextur2->map[(ty - 1) * bgtextur2->x + tx];

      // ist Turbolenz vorhanden?
      if (tb2.tu >2)
	{
	  v = int_pt1 + pwelt->mv2 + tb2.getturbo(int_pt1 * tb2.t);
	  bgtextur2->mix = tb2.getgturbo(v);
	}
      else
	bgtextur2->mix = 0.5;

      // rgb wert holen 
      *col = color (backb.r * (1.0 - bgtextur2->mix) +
		    (bgtextur2->pal[map].r) * bgtextur2->mix,
		    backb.g * (1.0 - bgtextur2->mix) +
		    (bgtextur2->pal[map].g) * bgtextur2->mix,
		    backb.b * (1.0 - bgtextur2->mix) +
		    (bgtextur2->pal[map].b) * bgtextur2->mix);
    }

  // Hintergrundmuster
  if ((hit == 1) && bgmuster1)
    {
      if ((tb1.tu == 2) || (tb1.tu == 3))
	{
	  v = int_pt1 + pwelt->mv1 + tb1.getturbo (int_pt1 * tb1.t);
	  bgmuster1->mix = n * 0.5 + tb1.getgturbo(v) * 0.5;
	}
      bgmuster1->getmust(col, pwelt->mv1, int_pt1);
    }

  if ((hit == 2) && bgmuster2)
    {
      if ((tb2.tu == 2) || (tb2.tu == 3))
	{
	  v = int_pt1 + pwelt->mv2 + tb2.getturbo (int_pt1 * tb2.t);
	  bgmuster2->mix = n * 0.3 + tb2.getgturbo (v) * 0.7;
	}
      bgmuster2->getmust(col, pwelt->mv2, int_pt1);
    }
}
