/* 
   Eine "Kick-Start Leiste" fuer Linux mit Motif.

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion 
 */

#include "skelett.h"

char dirhelptext[] = "Whlen sie Ihr Projektverzeichnis an.";

Widget top, WHelpDialog, prjlabel;
Atom delete_window_atom;


char   prjpath[256] = "./";

/* ###### Ziffer fuer den neuen Button #### */
typedef enum
  {
    QB_PATH,
    QB_MC,
    QB_XTERM,
    QB_RAY,
    QB_CAD,
    QB_SCHON,
    QB_NETSCAPE,
    QB_EMACS,
    QB_XV,
    QB_BKG,
    QB_MANDEL,
    QB_MANDELP,
    QB_CPU,
    MC_QUICK
  }
buttons;


Widget WGscrollwin, QWButtons[MC_QUICK], QWButtonsLabel[MC_QUICK];
void   errorbox(char *str);
void   helpfiledialog(Widget Parent, char *str);

/* ### hier mit einfuegen ### */
static int AiQButtonsID[] =
{
  QB_PATH, QB_MC, QB_XTERM, QB_RAY, QB_CAD, QB_SCHON, QB_NETSCAPE, QB_EMACS,
  QB_XV, QB_BKG, QB_MANDEL, QB_MANDELP, QB_CPU
};

/* ### Name des Programmes fuer Ressorucen-Datei ### */
STRING AIQuick[] =
{
  "PATH", "MC", "XTerm", "Ray", "CAD", "Schoner", "Netscape", "Emacs",  
  "XV", "XBild", "Mandel", "MandelP", "CPU"
};

STRING AIQuickLabel[] =
{
  "Projekt", "Kommando", "Terminal", "X-Ray", "Cad", "Sperre", "Doku", 
  "emacs",  "xv", "Bild", "Apfels", "Apfelp", "ZVE"
};

XtCallbackProc CBopenSelect(Widget W, caddr_t pClientData, caddr_t pCallData)
{
  STRING file_name;
  XmString anzstr;
  Arg Aargs;
  char anzpath[256];
  int  x;

  if (XmStringGetLtoR(((XmFileSelectionBoxCallbackStruct *) pCallData)->value,
		      XmSTRING_DEFAULT_CHARSET, &file_name))
    {
      strcpy(prjpath, file_name);
      if (!strlen(prjpath))
	errorbox("Filebox: kein File selektiert!\n");
    }
  else
    errorbox("Filebox: kein File selektiert!\n");

  XtUnmanageChild(W);

  strcpy(anzpath, prjpath);

  for (x=1; strlen(anzpath) > 16; x++)
    strcpy(anzpath, &prjpath[x]);

  anzstr = XmStringCreateLtoR(anzpath, XmSTRING_DEFAULT_CHARSET);
  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(prjlabel, &Aargs, 1);

  return NULL;
}


XtCallbackProc CBsaveCancelSelect(Widget W, caddr_t pClientData, caddr_t pCallData)
{
  /* FileBox beenden! */
  XtUnmanageChild(W);
  return NULL;
}

XtCallbackProc CBFileHelpSelect(Widget W, caddr_t pClientData, caddr_t pCallData)
{
  // Hilfe nur einmal oeffnen!
  if (!WHelpDialog)
    helpfiledialog(top, dirhelptext);
  else
    errorbox("Hilfe nur einmal ffnen!");
  return NULL;
}

void dummy(){};

XtCallbackProc CBQButtons (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  Widget WFileSel;
  XmString mask;
  Arg Aargs[7];
  int nArgs;
  char commandstr[256];
  char maskstr[256];

  switch (*(int*)pClientData)
    {
    case QB_PATH:
      sprintf(maskstr, "%s/+", prjpath);
      mask = XmStringCreateLtoR(maskstr, XmSTRING_DEFAULT_CHARSET);
      nArgs = 0;
      XtSetArg(Aargs[nArgs], XmNdirMask, mask);      nArgs++;

      /* nArgs = 0; */
      /* XtSetArg(Aargs[nArgs], XmDIALOG_LIST, dummy);      nArgs++; */

      WFileSel = XmCreateFileSelectionDialog(top, "fileopen", Aargs, nArgs);
      
      XtAddCallback(WFileSel, XmNokCallback, (XtCallbackProc) CBopenSelect, NULL);
      XtAddCallback(WFileSel, XmNcancelCallback, (XtCallbackProc) CBsaveCancelSelect, NULL);
      XtAddCallback(WFileSel, XmNhelpCallback, (XtCallbackProc) CBFileHelpSelect, NULL);

      /* sollte normalerwqeise gehen !*/
/*       XtUnmanageChild(XmFileSelectionBoxGetChild(WFileSel, XmDIALOG_LIST)); */
/*       XtUnmanageChild(XmFileSelectionBoxGetChild(WFileSel, XmDIALOG_LIST_LABEL)); */

      
      XtManageChild(WFileSel);
      break;
    case QB_MC:
      sprintf(commandstr, "cd %s; xterm -ls -geometry 80x25+170+228 -e mc&", prjpath);
      system (commandstr);
      break;
    case QB_EMACS:
      sprintf(commandstr, "cd %s; xemacs . &", prjpath);
      system (commandstr);
      break;
    case QB_XTERM:
      sprintf(commandstr, "cd %s; xterm -ls -geometry 80x25+170+228 &", prjpath);
      system (commandstr);
      break;
    case QB_CAD:
      sprintf(commandstr, "cd %s; cadtool &", prjpath);
      system (commandstr);
      break;
    case QB_RAY:
      sprintf(commandstr, "cd %s; startm &", prjpath);
      system (commandstr);
      break;
    case QB_SCHON:
      system ("xlock -mode random -nolock &");
      break;
    case QB_NETSCAPE:
      system ("cad_mosaic &");
      break;
      /*
    case QB_APPLIX:
      sprintf(commandstr, "cd %s; applix &", prjpath);
      system (commandstr);
      break;
      */
    case QB_XV:
      sprintf(commandstr, "cd %s; xv &", prjpath);
      system(commandstr);
      break;
    case QB_BKG:
      system("xbild &");
      break; 
    case QB_MANDEL:
      system("mandel &"); 
      break;
    case QB_MANDELP:
      system("mandel_t &"); 
      break;
    case QB_CPU:
      system("/usr/X11/bin/xload &");
      break;
    }
  return NULL;
}

/* Callback function to quit the program. */
XtCallbackProc CBquit (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtDestroyWidget (top);
  exit (0);

  return NULL;
}

/* Callback function to redisplay the PHIGS output. */
void redraw (Widget w, caddr_t client_data, XEvent * event)
{
/*
   if ( event->xexpose.count == 0 )
   predraw_all_structs(WS_ID, PFLAG_ALWAYS);
 */
}

int main (int argc, char **argv)
{
  Widget bar, menu, pulld1, WRowCol, WRowColM;
/*
   Window                       xid;
   XSetWindowAttributes win_attrs;
 */
  XtAppContext app;
  int i;

  static int menuID[] =
  {
    1
  };

  /* Initialize the toolkit and create the container for the PHIGS
   * window and control panel.
   */
  top = XtVaAppInitialize (&app, "Quick", NULL, 0, &argc, argv, NULL, NULL);

/*   WRowCol = XmCreateRowColumn (top, "rowcol", NULL, 0); */
/*   XtManageChild (WRowCol); */
  
  WRowCol = XtVaCreateManagedWidget("rowcol", xmRowColumnWidgetClass, top, 
				    XmNorientation, XmVERTICAL,
				    NULL);

  /* Create the menu bar. */
  bar = XmCreateMenuBar (WRowCol, "menubar", NULL, 0);
  XtVaSetValues (bar,
		 XmNtopAttachment, XmATTACH_FORM,
		 XmNleftAttachment, XmATTACH_FORM,
		 XmNrightAttachment, XmATTACH_FORM,
		 NULL);
  XtManageChild (bar);

  /* Create the pulldown menu. */
  menu = XmCreatePulldownMenu (bar, "menue", NULL, 0);
  XtVaCreateManagedWidget ("Ende", xmCascadeButtonWidgetClass, bar,
			   XmNsubMenuId, menu,
			   NULL);

  pulld1 = XtVaCreateManagedWidget ("Ende", xmPushButtonWidgetClass, menu,
				    NULL);
  XtAddCallback (pulld1, XmNactivateCallback, (XtCallbackProc) CBquit, &menuID[0]);

  WGscrollwin =
    XtVaCreateManagedWidget ("scrolwin", xmScrolledWindowWidgetClass, WRowCol,
			     XtNwidth, 110,
			     XtNheight, 550,
			     XmNscrollingPolicy, XmAUTOMATIC,
			     XmNvisualPolicy, XmVARIABLE,
			     NULL);

  WRowColM = XtVaCreateManagedWidget ("matrixrowm", xmRowColumnWidgetClass, WGscrollwin,
				      XmNorientation, XmVERTICAL,
				      XmNpacking, XmPACK_TIGHT,
				      XmNnumColumns, MC_QUICK,
				      NULL);

  for (i = 0; i < MC_QUICK; i++)
    {
      QWButtons[i] =
	XtVaCreateManagedWidget (AIQuick[i], xmPushButtonWidgetClass, WRowColM,
				 NULL);
      QWButtonsLabel[i] =
	XtVaCreateManagedWidget (AIQuickLabel[i], xmLabelWidgetClass, WRowColM,
				 NULL);
      XtAddCallback (QWButtons[i], XmNactivateCallback,
		     (XtCallbackProc) CBQButtons, &AiQButtonsID[i]);
    }


  prjlabel = XtVaCreateManagedWidget(prjpath, xmLabelWidgetClass, WRowCol, NULL);

  /* Realize the widgets. */
  XtRealizeWidget (top);

  /* Set up to use window manager DELETE_WINDOW protocol. */
  delete_window_atom = XInternAtom (XtDisplay (top), "WM_DELETE_WINDOW", TRUE);
  XmAddWMProtocols (top, &delete_window_atom, 1);
  XmSetWMProtocolHooks (top, delete_window_atom, NULL, NULL, 
			(XtCallbackProc) CBquit, NULL);

  XtAppMainLoop (app);

  return 0;
}


void CBende(Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtUnmanageChild(W);
}

void errorbox(char *str)
{
  Widget AWDialog;
  Arg Aargs[7];
  int nArgs;

  XmString errorstr, labelstr;

  errorstr = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
  labelstr = XmStringCreateLtoR("Nochmal versuchen", XmSTRING_DEFAULT_CHARSET);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNmessageString, errorstr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNokLabelString, labelstr);
  nArgs++;

  AWDialog = XmCreateErrorDialog(top, "errorbox", Aargs, nArgs);

  /*  Helpbutton Cancelbutton Abstellen */
  XtUnmanageChild(XmMessageBoxGetChild(AWDialog, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(AWDialog, XmDIALOG_CANCEL_BUTTON));
  XtAddCallback(AWDialog, XmNhelpCallback, (XtCallbackProc) CBende, (XtPointer) AWDialog);
  XtManageChild(AWDialog);
}


XtCallbackProc CBHelpOk(Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtUnmanageChild(WHelpDialog);
  WHelpDialog = NULL;
  return NULL;
}

void helpfiledialog(Widget Parent, char *str)
{
  Arg Aargs[5];
  int nArgs;

  Widget WButtonOK, WRowCol, WRowCol2, helptext, Wframe;

  WHelpDialog = XmCreateDialogShell(Parent, "helpfiledialog", NULL, 0);
  XtManageChild(WHelpDialog);

  WRowCol = XtVaCreateManagedWidget("helpfilerow", xmRowColumnWidgetClass, WHelpDialog,
				    XmNorientation, XmVERTICAL,
				    XmNpacking, XmPACK_TIGHT,
				    XmNwidth, 600,
				    XmNheight, 390,
				    XmNnumColumns, 1,
				    NULL);


  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNshadowType, XmSHADOW_ETCHED_IN);
  nArgs++;
  Wframe = XtCreateManagedWidget("helpframe", xmFrameWidgetClass, WRowCol, Aargs, nArgs);
  WRowCol2 = XmCreateRowColumn(Wframe, "helpfilerow2", NULL, 0);
  XtManageChild(WRowCol2);

  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNeditMode, XmMULTI_LINE_EDIT);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNeditable, 0);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNrows, 15);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNcolumns, 40);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNwordWrap, 1);
  nArgs++;
  helptext = XmCreateScrolledText(WRowCol2, "helptext", Aargs, nArgs);

  XmTextSetString(helptext, str);
  XtManageChild(helptext);

  WButtonOK = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol, NULL, 0);
  XtManageChild(WButtonOK);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBHelpOk, NULL);
}
