/*
   Randomliser, zeigt per Zufallszahl eine Datei an

   Compiler:  g++ -O4 -Wall xrand.C -o xrand
   Aufrufbeispiel:
   ls /os22/fraktale | xrand 'xli -onroot' /os22/fraktale > /dev/null

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996 Helmut Fahrion
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>



// Liste
class datein
{
  public:
  datein ()
  {
  };

  datein (datein * p, char *N)
  {

    strcpy (name, N);

    next = NULL;
    // einketten
    if (p != NULL)
      p->next = this;
  }

  ~datein ()
  {
    if (next)
      delete next;
  }

  char name[256];
  datein *next;
};

// Falls alles voll ist!
void 
allocerror (void *p)
{
  if (!p)
    {
      fprintf (stderr, "Nicht gengend Speicher fr Dateinamen.\n");
      exit (1);
    }
}


int 
main (int argc, char **argv)
{
  unsigned int z, r, s;
  datein *dold = NULL;
  datein *dnew = NULL;
  char suchpfad[256];

  time_t t;

  z = 0;

  // Dateinamen von stdin einlesen und in einer Liste speichern
  while (!feof (stdin))
    {
      scanf ("%s.gif", suchpfad);
      z++;
      if (dnew == NULL)
	{
	  dnew = new datein (NULL, suchpfad);
	  allocerror (dnew);
	  dold = dnew;
	}
      else
	{
	  dnew = new datein (dnew, suchpfad);
	  allocerror (dnew);
	}
    }

  // Zufallszahlengenerator nach der Systemzeit setzen
  time (&t);

// srand auf AIX
  //   srand(t);
  srandom (t);

  r = (unsigned int) ((float) rand () / (float) RAND_MAX * (float) z);

  dnew = dold;
  for (s = 0; (s < r) && (dnew != NULL); s++)
    {
      // printf("%s\n", dnew->name);
      dnew = dnew->next;
    }

  // Kommando bilden
  sprintf (suchpfad, "%s %s/%s&\n", argv[1], argv[2], dnew->name);

  // Speicher freigeben
  delete dold;

  // Programm aufrufen
  system (suchpfad);

  return 0;
}
