/* 
   **************************************************************
   Programm: mandel.cxx
   Funktion: zeichnet das Apfelmnchen
   gcc mandel.c -L/usr/X11/lib -lX11 -m486 -O4 -Wall -o mandel

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   Copyright (C) 1996 Helmut Fahrion
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define true  1
#define false 0
#define uns   unsigned
#define reg   register
#define OUT   0
#define IN    1

/* 
   Anzahl der Farben.
   Nicht zu hoch waehlen!
 */
#define PIXELS 77

float max;
float xmin;
float ymin;
float deltax;
float deltay;

char buffer[80];

/* X - Globale Vereinbarungen */
struct mainwindow
  {
    Display *display;		/* Zeiger auf die X-Datenstruktur */
    Window window;		/* X - Resource - Namen  */
    GC gc;
    Font font;
    XEvent event;		/* X Informationen ber Eingabe-Events */
    KeySym key;
    XSizeHints hint;

    /* Fuer Farben */
    Colormap cmap;		/* Ressource-ID der Farbabbildung  */

    int flags;
    uns long pixels[PIXELS + 1];

    long uns int wm_del_win;	/* del Window Massage  */

    int ncolors;		/* Anzahl der Pixel-Werte  */
    uns int newx, newy, newwidth, newheight;
    int screen;
    uns long foreground, background;
  };

struct mainwindow xm;		/* globale Struktur X - Mainwindow  */

/* Mandelbrodmenge */
void 
plotpixel (int x, int y, int color)
{
  XSetForeground (xm.display, xm.gc, xm.pixels[color]);
  XDrawPoint (xm.display, xm.window, xm.gc, x, y);
}

void 
box (int x1, int y1, int x2, int y2, int color)
{
  XSetForeground (xm.display, xm.gc, xm.pixels[color]);
  XFillRectangle (xm.display, xm.window, xm.gc,
		  x1, y1, x2 - x1, y2 - y1);
}

int 
iterate (float cx, float cy, uns int maxiter)
{
  float x2 = 0.0;
  float y2 = 0.0;
  float x = 0.0;
  float y = 0.0;
  while ((maxiter) && (x2 + y2 < max))
    {
      y = 2.0 * x * y + cy;
      x = x2 - y2 + cx;
      x2 = x * x;
      y2 = y * y;
      maxiter--;
    }
  return ++maxiter;
}

void 
calculate (int x1, int y1, int x2, int y2, uns int maxiter)
{
/*
   Toolbox 1'94  
   Joerg Braun
   Grafische Speilerein
 */
  reg float cx1, cy1, c_1;
  reg int i, j, samecolor, color, oldcolor;
  samecolor = color = oldcolor = 1;
  if (y2 - y1 < 3)
    {
      for (i = x1; i < x2; i++)
	{
	  for (j = y1; j < y2; j++)
	    {
	      cx1 = xmin + deltax * i;
	      cy1 = ymin + deltay * j;
	      color = iterate (cx1, cy1, maxiter);
	      plotpixel (i, j, color);
	    }
	}
    }
  else
    {
      for (i = x1; i < x2; i++)
	{
	  cx1 = xmin + deltax * i;
	  cy1 = ymin + deltay * y1;
	  c_1 = ymin + deltay * y2;
	  color = iterate (cx1, cy1, maxiter);
	  if (i == x1)
	    oldcolor = color;
	  if (color != oldcolor)
	    samecolor = 0;
	  plotpixel (i, y1, color);
	  color = iterate (cx1, c_1, maxiter);
	  if (color != oldcolor)
	    samecolor = 0;
	  plotpixel (i, y2, color);
	}
      for (i = y1; i < y2 - 1; i++)
	{
	  cy1 = ymin + deltay * i;
	  cx1 = xmin + deltax * x1;
	  c_1 = xmin + deltax * x2;
	  color = iterate (cx1, cy1, maxiter);
	  if (color != oldcolor)
	    samecolor = 0;
	  plotpixel (x1, i, color);
	  color = iterate (c_1, cy1, maxiter);
	  if (color != oldcolor)
	    samecolor = 0;
	  plotpixel (x2, i, color);
	}
      if (!samecolor)
	{
	  calculate (x1, y1, (x1 + x2) / 2, (y1 + y2) / 2, maxiter);
	  calculate ((x1 + x2) / 2, y1, x2, (y1 + y2) / 2, maxiter);
	  calculate (x1, (y1 + y2) / 2, (x1 + x2) / 2, y2, maxiter);
	  calculate ((x1 + x2) / 2, (y1 + y2) / 2, x2, y2, maxiter);
	}
      else
	box (x1, y1, x2, y2, color);
    }
}

void 
testepixel (void)
{
  xmin = -3.0;
  ymin = -1.8;
  deltax = 4.7 / (float) xm.newwidth;
  deltay = 4.0 / (float) xm.newheight;
  max = 10.0;

  calculate (0, 0, xm.newwidth, xm.newheight, xm.ncolors);
}

/*** X - Initroutinen ***/
uns long 
get_color (char *color_name)
{
  XColor nearest, exact;
  if (XAllocNamedColor (xm.display, xm.cmap, color_name,
			&nearest, &exact))
    return (nearest.pixel);
  else
    return (0L);
}

void 
initcolors (void)
{
  reg int x, y, z, anz, inc;
  reg int red, green, blue;

  xm.ncolors = PIXELS + 1;
  y = 0;
  anz = (xm.ncolors - y) / 6;
  inc = 0xFF / anz;
  /* Spektrum = ncolors / 6   */
  for (z = 1; z <= 6; z++)
    {
      blue = red = green = 0;
      for (x = 1; x <= anz; x++)
	{
	  switch (z)
	    {
	    case 6:
	      blue += inc;
	      break;
	    case 5:
	      green += inc;
	      break;
	    case 4:
	      red += inc;
	      break;
	    case 3:
	      green += inc;
	      blue += inc;
	      break;
	    case 2:
	      red += inc;
	      blue += inc;
	      break;
	    case 1:
	      red += inc;
	      blue += inc;
	      green += inc;
	      break;
	    }
	  /* Farbstring errechnen  */
	  sprintf (buffer, "#%02X%02X%02X", red, green, blue);
	  /* besten Pixelwert  */
	  xm.pixels[y] = get_color (buffer);
	  if (xm.pixels[y] != 0)
	    y++;
	}
    }
  xm.ncolors = y;
}

int 
initx (int argc, char *argv[], char *fontname)
{

  /* Display eroeffnen */
  xm.display = XOpenDisplay ("");
  if (!xm.display)
    {
      fprintf (stderr, "Kann kein Display herstellen!\n");
      return -1;
    }

  /* Farben holen */
  xm.cmap = DefaultColormap (xm.display,
			     DefaultScreen (xm.display));

  initcolors ();

  xm.screen = DefaultScreen (xm.display);
  xm.foreground = xm.pixels[xm.ncolors];
  xm.background = xm.pixels[0];

  /* Einstellungen  */
  xm.hint.x = 10;
  xm.hint.y = 10;
  xm.hint.width = 900;
  xm.hint.height = 700;
  xm.hint.flags = PPosition | PSize;

  xm.newx = xm.hint.x;
  xm.newy = xm.hint.y;
  xm.newwidth = xm.hint.width;
  xm.newheight = xm.hint.height;

  xm.window = XCreateSimpleWindow (xm.display,
				   DefaultRootWindow (xm.display),
			xm.hint.x, xm.hint.y, xm.hint.width, xm.hint.height,
				   5, xm.foreground, xm.background);

  sprintf (buffer, "Apfelmaenchen");
  XSetStandardProperties (xm.display, xm.window, buffer, buffer,
			  None, argv, argc, &xm.hint);

  xm.gc = XCreateGC (xm.display, xm.window, 0, 0);
  XSetBackground (xm.display, xm.gc, xm.background);
  XSetForeground (xm.display, xm.gc, xm.foreground);

  xm.font = XLoadFont (xm.display, fontname);

  XSetFont (xm.display, xm.gc, xm.font);

  XSelectInput (xm.display, xm.window,
	 ButtonPressMask | ButtonReleaseMask | KeyPressMask | ExposureMask |
		StructureNotifyMask);

  XMapRaised (xm.display, xm.window);

  /* Delete Window Protokoll  */
  xm.wm_del_win = XInternAtom (xm.display, "WM_DELETE_WINDOW", False);
  XSetWMProtocols (xm.display, xm.window, &xm.wm_del_win, 1);

  return (1);
}

void 
donex (void)
{
  XFreeGC (xm.display, xm.gc);
  XFreeColormap (xm.display, xm.cmap);
  XDestroyWindow (xm.display, xm.window);
  XCloseDisplay (xm.display);
}

/* Menuefuerung mit Buttons */
void 
rectanglebutton (int pos, char *titel, int x1, int y1, int x2, int y2)
{
  sprintf (buffer, titel);

  XSetForeground (xm.display, xm.gc, WhitePixel (xm.display, 0));	/* Wei */
  XDrawRectangle (xm.display, xm.window, xm.gc, x1, y1, x2, y2);
  XDrawImageString (xm.display, xm.window, xm.gc, x1 + 20, y1 + 18,
		    buffer, strlen (buffer));
}

void 
drawbutton (int pos, int nr)
{
  switch (nr)
    {
    case 1:
      rectanglebutton (pos, "Mandelbrodmenge", 1, 1, 200, 25);
      break;
    }
}

int 
testbuttons (void)
{
  /*  int x1, x2, y1, y2; */

  /* Button 1 */
  if ((xm.event.xbutton.x <= 200) &&
      (xm.event.xbutton.y <= 25))
    {
      drawbutton (IN, 1);
      while (xm.event.type != ButtonRelease)
	{
	  XNextEvent (xm.display, &xm.event);
	}
      drawbutton (OUT, 1);
      /* Release auch im Rechteck ? */
      if ((xm.event.xbutton.x <= 200) &&
	  (xm.event.xbutton.y <= 25))
	return (true);
    }
  return (false);
}

void 
runx (void)
{
  int done;
  done = false;
  while (done == false)
    {
      XNextEvent (xm.display, &xm.event);
      switch (xm.event.type)
	{
	case ConfigureNotify:
	  xm.newwidth = xm.event.xconfigure.width;
	  xm.newheight = xm.event.xconfigure.height;
	  break;
	case ClientMessage:
	  if (xm.event.xclient.format == 32 &&
	      xm.event.xclient.data.l[0] == xm.wm_del_win)
	    done = true;
	case Expose:
	  if (xm.event.xexpose.count == 0)
	    {
	      if (XEventsQueued (xm.display, QueuedAfterReading) > 0)
		{
		  while (XEventsQueued (xm.display, QueuedAfterReading) > 0)
		    XNextEvent (xm.display, &xm.event);
		}
	      testepixel ();
	      drawbutton (OUT, 1);
	    }
	  break;
	case MappingNotify:
	  XRefreshKeyboardMapping (&xm.event.xmapping);
	  break;
	case ButtonPress:
	  done = testbuttons ();
	  break;
	case KeyPress:
	  if (XLookupString (&xm.event.xkey, buffer, 10, &xm.key, 0)
	      == 1 && buffer[0] == 'e')
	    done = true;
	  break;
	}
    }
}

int 
main (int argc, char *argv[])
{
  if (initx (argc, argv, "10x20"))
    runx ();
  donex ();
  return (0);
}
