/* 
   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <Xm/XmAll.h>

#include "../naz/vect.H"
#include "../naz/ray.H"

// Anzahl der zu allocierenden Farben!
#define MAXCOL 6
#define Maxcols MAXCOL*MAXCOL*MAXCOL

// Daten fuer X-Funktionen zum zeichen
GC       Gc;
Display  *Disp;
Colormap Cmap;
unsigned long Pixels[Maxcols+1];
byte     Cmap_art;

static Widget	top, WGdrawarea;
Window Win;

int Width, Height;

/* ###### Ziffer fuer den neuen Button #### */
typedef enum { QB_ENDE, QB_NEU, QB_TEST, LETZTE };

Widget WGscrollwin, QWButtons[LETZTE+1];

static int MenuID[] =
    {
      QB_ENDE, QB_NEU, QB_TEST
      };

static String MenuStr[]=
{
  "Ende", "Neu", "Test"
};

int get_colormap(Display *disp);
GC CreateSimpleGC(Widget W);

uns long new_foreground=0, foreground=1;
byte i = 1;

void SetColor(int *rgb)
{
  int i;
  int summe=0;
  int differenz=0;
  int hilfrgb[3];
  XColor color;

  hilfrgb[0]=(rgb[0]*65535/255);
  hilfrgb[1]=(rgb[1]*65535/255);
  hilfrgb[2]=(rgb[2]*65535/255);

  if (Cmap_art == 1)  
    new_foreground = Pixels[(uns)(((rgb[0])/43 )+
				  MAXCOL*((rgb[1])/43)+(MAXCOL*((rgb[2])/43))*MAXCOL)];

  if (Cmap_art == 2)
    for(i=0; i < Maxcols; i++) 
    {
      summe=0;
      color.pixel=Pixels[i];
      XQueryColor(Disp, Cmap, &color);
      summe = (int) (abs((int)(hilfrgb[0]-color.red)));
      summe += (int)(abs((int)(hilfrgb[1]-color.green)));
      summe += (int)(abs((int)(hilfrgb[2]-color.blue)));
      if(i==0) differenz=summe;
      if(summe < differenz)
      {
	new_foreground=color.pixel;
	differenz=summe;
      }
    }

  if(new_foreground != foreground)
  {
    XSetForeground(Disp, Gc, new_foreground);
    foreground = new_foreground;
  }
}
    
void writergb(Window win)
{
  int r, g, rgb[3]; // Muss int sein!

  // RGB Models abbilden
  for(r=0; r < Width; r++)
    for(g=0; g < Height; g++)
    {
      switch (i)
      {
       case 1:
	rgb[0]=r*255/Width; rgb[1]=0;	rgb[2]=g*255/Height;
	break;
       case 2:
	rgb[0]=r*255/Width; rgb[1]=g*255/Height; rgb[2]=0;
	break;
       case 3:
	rgb[0]=0; rgb[1]=r*255/Width; rgb[2]=g*255/Height;
	break;
      }
      // Farbe setzen
      SetColor(rgb);   
      // Punkt im Window setzen
      XDrawPoint(Disp, Win, Gc, r, g);
    }
}

void CBQButtons(Widget W, caddr_t pClientData, caddr_t pCallData)
{

  switch ((int)*pClientData)
  {
   case QB_NEU:
    XSetForeground(Disp, Gc, XBlackPixel(Disp, 0)); // screen
    XFillRectangle(Disp, Win, Gc, 0, 0, Width-1, Height-1);
    fprintf(stderr, "raywin: neu()\n");
    break;
   case QB_TEST:
    fprintf(stderr, "raywin: test()\n");
    i = (i <= 2)? i+1 : 1;
      writergb(((XmDrawingAreaCallbackStruct*)pCallData)->window);
    break;
  }
}

/* Callback function to quit the program. */
void CBquit(Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtDestroyWidget(top);

  XFreeColormap(Disp, Cmap);
  
  // XFreePixmap(display,wi->pixmap);    
  XFreeGC(Disp, Gc);

  exit(0);
}

void CBRedraw(Widget w, caddr_t client_data, XEvent *event)
{
  fprintf(stderr, "raywin: redraw()\n");
}

int main(int argc, char **argv)
{
    Widget	   bar, roll1, pulld1, WRowCol, WSframe;
    XtAppContext   app;
    char           x;
    // XSetWindowAttributes wattrs;

    // ueber parameter setzen
    Height = Width = 400;
    
    top  = XtVaAppInitialize(&app, "Raywin", NULL, 0, &argc, argv, NULL, NULL);

    WRowCol = XmCreateRowColumn(top, "rowcol", NULL, 0);
    XtManageChild(WRowCol);

    // Create the menu bar.
    bar = XmCreateMenuBar(WRowCol, "menubar", NULL, 0);
    XtVaSetValues(bar,
	XmNtopAttachment, XmATTACH_FORM,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	NULL);
    XtManageChild(bar);

    // Create the pulldown menu.
    roll1 = XmCreatePulldownMenu(bar, "menue", NULL, 0);
    // Endebutton
    XtVaCreateManagedWidget(MenuStr[QB_ENDE], xmCascadeButtonWidgetClass, bar, 
			    XmNsubMenuId, roll1, NULL);
    pulld1 = XtVaCreateManagedWidget(MenuStr[QB_ENDE], xmPushButtonWidgetClass, roll1, NULL);
    XtAddCallback(pulld1, XmNactivateCallback, CBquit, &MenuID[QB_ENDE]);

    // Beginne bei 1, ohne Ende
    for (x=1; x<LETZTE; x++)
    {
      QWButtons[x] = XtVaCreateManagedWidget(MenuStr[x], xmPushButtonWidgetClass, bar, NULL);
      XtAddCallback(QWButtons[x], XmNactivateCallback, CBQButtons, &MenuID[x]);
    }
    
    WSframe = XtCreateManagedWidget("wsframe", xmFrameWidgetClass, WRowCol, NULL, 0);
    WGscrollwin = 
      XtVaCreateManagedWidget("scrolwin", xmScrolledWindowWidgetClass, WSframe, 
			      XtNwidth,  Width,
			      XtNheight, Height,
			      XmNscrollingPolicy, XmAUTOMATIC,
			      XmNvisualPolicy, XmVARIABLE,
			      NULL);

    // Arbeitsflche
    WGdrawarea =
      XtVaCreateManagedWidget("drawwin", xmDrawingAreaWidgetClass, WGscrollwin,
			      XtNwidth,  Width,
			      XtNheight, Height,			      
			      NULL);
    
    // dem ScrolledWindow seinen Arbeitsbereich (WorkArea) mitteilen
    XmScrolledWindowSetAreas(WGscrollwin, NULL, NULL, WGdrawarea);
    XtAddCallback(WGdrawarea, XmNexposeCallback, CBRedraw, NULL);

    XtRealizeWidget(top);

    // Daten zum Zeichnen
    Disp = XtDisplay(top);
    Win  = XtWindow(WGdrawarea);
    
    /* gebraucht ??? */
    // wattrs.backing_store = NotUseful;
    // XChangeWindowAttributes(Disp, Win, CWBackingStore, &wattrs);

    if (!get_colormap(Disp))
    {
      fprintf(stderr, "raywin: nicht mehr gengend Farbzellen frei!\n");
      return 0;
    }

    // GC erzeugen um zeichnen zu knnen
    Gc = CreateSimpleGC(WGdrawarea);

    // init i fuer Test
    i=1;
    XtAppMainLoop(app);
}


GC CreateSimpleGC(Widget W)
{
  Arg                   Aargs[5];
  Cardinal              nArgs;
  Pixel                 ForeGround, BackGround;
  Window                WWRoot;
  XGCValues             Xgc;
  unsigned long         ulMask;

  /*
  * Die Farben des Widgets holen, fuer das GC erzeugt werden soll
  */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNforeground, &ForeGround); nArgs++;
  XtSetArg(Aargs[nArgs], XmNbackground, &BackGround); nArgs++;
  XtGetValues(W, Aargs, nArgs);

  /*
  * das Window, fuer das Widget muss noch nicht bestehen, also
  * Root Window des Bildschirms benutzen, weil es dieselbe Farbtiefe
  * besitzt und die Austauschbarkeit von GCs nur von der Farbtiefe
  * eines Windows bestimmt wird, i.e. alle GCs eines Bildschirms sind
  * austauschbar
  */
  WWRoot = RootWindowOfScreen(XtScreen(W));
  
  /*
  * Farben und Font auf sinnvollen Wert einstellen
  */
  Xgc.foreground = ForeGround;
  Xgc.background = BackGround;

  /*
  * Font muss unbedingt geladen werden, wenn mit FontLists und XmStringDraw
  * gearbeitet wird, sonst Xlib Error 56 (XChangeGC)
  */
  Xgc.font = XLoadFont(XtDisplay(W), "fixed"); 

  /* 
  * die Maske bestimmt, welche Werte von XGCValues sinnvoll
  * sind und deshalb gesetzt werden sollen
  */
  ulMask = GCForeground | GCBackground | GCFont; 
  return XCreateGC(XtDisplay(W), WWRoot, ulMask, &Xgc);
}

int get_colormap(Display *disp)
{
  int   r, g, b;
  XColor  xcolor;
 
  /* Versuche Zellen der Default Colormap zu allokieren */
  if(XAllocColorCells(Disp, DefaultColormap(Disp, 0), 
		      False, 0, 0, Pixels, MAXCOL*MAXCOL*MAXCOL))
  {                   
    for(b=0; b<MAXCOL; b++)
      for(g=0; g<MAXCOL; g++)
	for(r=0; r<MAXCOL; r++)
	{ 
	  xcolor.pixel = Pixels[(uns) (r+(MAXCOL)*g+(MAXCOL)*(MAXCOL)*b)];
	  xcolor.flags = DoRed | DoGreen | DoBlue;
	  xcolor.red = (uns) (r*65535L/(MAXCOL-1));
	  xcolor.green = (uns) (g*65535L/(MAXCOL-1));
	  xcolor.blue = (uns) (b*65535L/(MAXCOL-1)); 
	  XStoreColor(Disp,
		      DefaultColormap(Disp,0), 
		      &xcolor);
	}             
    Cmap = DefaultColormap(Disp, 0);    
    XSetWindowColormap(Disp, XtWindow(top), Cmap);
    Cmap_art = 1;
    fprintf(stderr, "Setze Standard ColorMap(1)\n");
    return TRUE;
  }
  else
  {
    Cmap = XCreateColormap(Disp, Win, XDefaultVisual(Disp,0), AllocNone); 
    if(XAllocColorCells (Disp, Cmap, False, 0, 0, Pixels, MAXCOL*MAXCOL*MAXCOL))
    {                 
      for( b=0; b<MAXCOL; b++)
	for( g=0; g<MAXCOL; g++)
	  for( r=0; r<MAXCOL; r++)
	  { 
	    xcolor.pixel = Pixels[(uns) (r+(MAXCOL)*g+(MAXCOL)*(MAXCOL)*b)];
	    xcolor.flags = DoRed | DoGreen | DoBlue;
	    xcolor.red   = (uns) (r*65535L/(MAXCOL-1));
	    xcolor.green = (uns) (g*65535L/(MAXCOL-1));
	    xcolor.blue  = (uns) (b*65535L/(MAXCOL-1)); 
	    XStoreColor(Disp, Cmap, &xcolor);
	  }
      XSetWindowColormap(Disp, XtWindow(top), Cmap);
      Cmap_art = 1;
      fprintf(stderr, "Setze created ColorMap(1)\n");
      return TRUE;
    }
    else
    {
      fprintf(stderr, "Fehler bei XAllocColorCells(1)\n");
      return(FALSE);     
    } 
  } 
  
  /* Zweite Farbtabelle wird erzeugt */

  Cmap=XCreateColormap(Disp, Win, XDefaultVisual(Disp,0), AllocNone); 
  if(!XAllocColorCells (Disp, Cmap, False, 0, 0, Pixels, 256))
  {  
    XSetWindowColormap(Disp, XtWindow(top), Cmap);  
    Cmap_art = 2;
    fprintf(stderr, "Setze created ColorMap XDefaultVisual(Disp,0)\n");
    return TRUE;
  }
  else
  {
    fprintf(stderr, "Fehler bei XAllocColorCells(2)\n");
    return(FALSE);  
  }
  
  /* Dritte Farbtabelle wird erzeugt */
  Cmap=XCreateColormap(Disp, Win, XDefaultVisual(Disp,0), AllocNone); 

  if(XAllocColorCells (Disp, Cmap, False, 0, 0, Pixels, 256))
  {                 
    for(r=0; r<256; r++)
    { 
      xcolor.pixel = Pixels[r];
      xcolor.flags = DoRed | DoGreen | DoBlue;
      xcolor.red   = (uns) 0;
      xcolor.green = (uns) 0;
      xcolor.blue  = (uns) 0; 
      XStoreColor(Disp, Cmap, &xcolor);
    } 
    XSetWindowColormap(Disp, XtWindow(top), Cmap);
    Cmap_art = 3;
    fprintf(stderr, "Setze created ColorMap (3)\n");
    return TRUE;
  }
  else
  {
    fprintf(stderr, "Fehler bei XAllocColorCells(3)\n");
    return(FALSE);
  }

  return(TRUE);
}





