/*
 * Projekt : 3D-GRAFIK und Animation
 * Datei   : mrpcx.c
 * Inhalt  : Bibliothek der PCX Funktionen
 * Autor   : Roland Oberdorfer
 * Sprache : C
 */

#include "xw.H"



/* Globale Variablen */
extern Display *display;
extern int screen_num;
extern GC gc;

/* Farbtabellen */
extern Colormap colormap1;
extern Colormap colormap2;
extern Colormap colormap3;
extern Colormap errmap;

/* Farbzellen in Colormaps */
extern unsigned long colors1[MAXCOL*MAXCOL*MAXCOL+1];
extern unsigned long colors2[256];
extern unsigned long colors3[256];

typedef struct tagPCXHEADER {
    unsigned char  pcxSignature;
    unsigned char  pcxVersion;
    unsigned char  pcxCompression;
    unsigned char  pcxBitCount;
    WORD        pcxXbottom;
    WORD        pcxYbottom;
    WORD        pcxXtop;
    WORD        pcxYtop;
    WORD        pcxDPIh;
    WORD        pcxDPIv;
    unsigned char  pcxReserved;
    unsigned char  pcxPlanes;
    WORD        pcxBytesPerLine;
    WORD        pcxPalette;
} PCXHEADER;



Image *mr_ReadPCXImage(char *filename)
{
 /******************************************
  * 1. fuer 1 und 4 Bit Werte programmieren
  * 2. Dokumentieren
  ******************************************/
 PCXHEADER pcfh;
 Image *im;
 XColor color;
 FILE *pointer;
 unsigned char *bytepoint;
 unsigned char rgb[3];
/*  unsigned char bytes[8]; */
 unsigned char first;
 int width, height;
 int rep, pixel;
 int j, k;
 int col;
        
 if((pointer = fopen(filename,"rb"))==NULL)
  {
   error(CANTOPENFILE,"mr_ReadPCX",filename);
   return(0);
  }

 pcfh.pcxSignature=getc(pointer);
 if(pcfh.pcxSignature != 10) 
  {
   error(WRONGFILEFORMAT,"mr_ReadPCX",filename);
   return(0);
  }

 pcfh.pcxVersion=getc(pointer);

 pcfh.pcxCompression=getc(pointer);
 
 pcfh.pcxBitCount=getc(pointer);
 
 pcfh.pcxXtop=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxXtop |= (first << 8);
 
 pcfh.pcxYtop=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxYtop |= (first << 8);
 
 pcfh.pcxXbottom=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxXbottom |= (first << 8);
 
 pcfh.pcxYbottom=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxYbottom |= (first << 8);

 pcfh.pcxDPIh=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxDPIh |= (first << 8);
 
 pcfh.pcxDPIv=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxDPIv |= (first << 8);

 col=0;
 while(col < 16)
  {
   rgb[0]= (unsigned char) getc(pointer); 
   rgb[1]= (unsigned char) getc(pointer); 
   rgb[2]= (unsigned char) getc(pointer); 
   color.pixel = colors2[col];
   color.flags = DoRed | DoGreen | DoBlue;
   color.red = (unsigned) (rgb[0]*65535L/255L);
   color.green = (unsigned) (rgb[1]*65535L/255L);
   color.blue = (unsigned) (rgb[2]*65535L/255L); 
   XStoreColor(display,
               colormap2, 
               &color);
   col++;              
  }

 pcfh.pcxReserved=getc(pointer);
 
 pcfh.pcxPlanes=getc(pointer);
  
 pcfh.pcxBytesPerLine=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxBytesPerLine |= (first << 8);

 pcfh.pcxPalette=getc(pointer);
 first = (unsigned char) getc(pointer);
 pcfh.pcxPalette |= (first << 8);

 fseek(pointer,128,0);

 height = pcfh.pcxYbottom-pcfh.pcxYtop+1;
 width  = pcfh.pcxXbottom-pcfh.pcxXtop+1;
 if((bytepoint = (unsigned char *) malloc(height*pcfh.pcxBytesPerLine*
                               sizeof(unsigned char)+1))==NULL)
  {
   error(NOMEMORY,"mr_ReadPCX",NULL);
   return(0);
  }                             


 j=0;
 k=0;
 /* Komprimierte Daten */
 if(pcfh.pcxCompression)
  {
   while(j<(height*pcfh.pcxBytesPerLine))
    {
     /* Wiederholungen herausfinden */
     rep = getc(pointer);
     if(rep<192)
      {
       bytepoint[j++]=rep;
      } 
     else
      { 
       rep = rep & 63;
       pixel = getc(pointer);
       while(k++<rep) 
        bytepoint[j++] = pixel;
       k=0; 
      } 
    }
  }
 /* Unkomprimierte Daten */ 
 else 
  {
   fread(bytepoint,height-1,pcfh.pcxBytesPerLine,pointer);
  }

 if(getc(pointer) == 12) 
  {
   col=0;
   while(col < (1 << pcfh.pcxBitCount))
    {
     rgb[0]= (unsigned char) getc(pointer); 
     rgb[1]= (unsigned char) getc(pointer); 
     rgb[2]= (unsigned char) getc(pointer); 
     color.pixel = colors2[col];
     color.flags = DoRed | DoGreen | DoBlue;
     color.red = (unsigned) (rgb[0]*65535L/255L);
     color.green = (unsigned) (rgb[1]*65535L/255L);
     color.blue = (unsigned) (rgb[2]*65535L/255L); 
     XStoreColor(display,
                 colormap2, 
                 &color);
     col++;              
    }    
  } 

 /* erzeugen der Bildverwaltungsstruktur */
 im = gr_CreateImage(width,height);
 im->byteptr = bytepoint;
 im->colormap = colormap2;
 
  
 im->im = XCreateImage(display,
                   XDefaultVisual(display,screen_num),
                   XDefaultDepth(display,screen_num),
                   ZPixmap,
                   0,
                   (char *) bytepoint,
                   width,
                   height,
                   XBitmapPad(display),
                   pcfh.pcxBytesPerLine);

 /* gelungen */
 return(im);           
} 






int mr_WritePCXImage(Image *im, char *filename)
{
 XColor xc;
 FILE *pointer;
 unsigned char rgb[3];
 unsigned char bytes[4];
 int i;
 int j;
 char *bytepoint;
 int k;
 unsigned char rep;


 if((pointer = fopen(filename,"wb"))==NULL)
  {
   error(CANTOPENFILE,"mr_WritePCX",filename);
   return(0);
  }

 /* File ID  */
 putc(10,pointer);

 /* Version  */
 putc(5,pointer);

 /* Komprimierung ? */
 putc(1,pointer);

 /* Bits pro Pixel */
 putc(8,pointer);

 /* X Top */
 getBytes(0,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);
 
 /* Y Top */
 getBytes(0,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);
 
 /* X Bottom */
 getBytes(im->width-1,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);

 /* Y Bottom */
 getBytes(im->height-1,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);
 
 /* DPIh */
 getBytes(0,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);

 /* DPIv */
 getBytes(0,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);

 /* Farbtabelle */
 for(i=0 ; i<16 ; i++)
  {
   if(im->colormap == colormap1)
     xc.pixel = colors1[i];
   if(im->colormap == colormap2)  
     xc.pixel = colors2[i];
  
   XQueryColor(display,im->colormap, 
                &xc);
     
   rgb[0] = xc.red/256;
   rgb[1] = xc.green/256;
   rgb[2] = xc.blue/256;             
   putc(rgb[0],pointer);
   putc(rgb[1],pointer);
   putc(rgb[2],pointer);
  }
  
 /* Reserviert */
 putc(0,pointer);

 /* Planes */
 putc(1,pointer);
 
 /* Bytes per Line */
 getBytes(im->im->bytes_per_line,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);
 
 /* Palette */
 getBytes(0,bytes);
 putc(bytes[0],pointer);
 putc(bytes[1],pointer);
 
 i=0;
 while(i<58)
  {
   putc(0,pointer);
   i++;
  }
  
 bytepoint = im->im->data;
 
 j=0;
 while(j<(im->height*im->im->bytes_per_line))
  {
   /* Byte lesen */
   rep = bytepoint[j++];
   k=1;

   /* sind die obersten 2 Bit des Byte gesetzt ? */
   if((rep & 0xc0) == 0xc0) 
    {
     /* Die Bits sind gesetzt */
     
     /* feststellen ob weitere gleiche Bytes folgen */
     while( (rep == (unsigned)bytepoint[j]) && (k < 63) && 
                 j<(im->height * im->im->bytes_per_line))
      {
       k++;
       j++;
      } 

     putc(k|0xc0,pointer);  
     putc(rep,pointer);  
    }
   else
    {
     /* Die Bits sind nicht gesetzt */
     
     /* feststellen ob weitere gleiche Bytes folgen */
     while(rep == (unsigned)bytepoint[j] && k<63 && 
	   j<(im->height*im->im->bytes_per_line))
      {
       k++;
       j++;
      } 

     if(k==1)
      {
       putc(rep,pointer);
      }
     else 
      {
       putc(k|0xc0,pointer);  
       putc(rep,pointer);  
      }
    } 
  }

 getBytes(12,bytes);
 putc(bytes[0],pointer);

 for(i=0 ; i<256 ; i++)
  {
   if(im->colormap == colormap1)
     xc.pixel = colors1[i];
   if(im->colormap == colormap2)  
     xc.pixel = colors2[i];
  
   XQueryColor(display,im->colormap, 
                &xc);
     
   rgb[0] = xc.red/256;
   rgb[1] = xc.green/256;
   rgb[2] = xc.blue/256;             
   putc(rgb[0],pointer);
   putc(rgb[1],pointer);
   putc(rgb[2],pointer);
  }
  
 fclose(pointer); 
 return(1);
}
 

int WritePCX(gr_Window *wi, char *filename, int x, int y, int width, int height)
{
 Image *im;

 if((im=gr_GetImage(wi,x,y,width,height)) != NULL)
  {
   if(mr_WritePCXImage(im,filename))
    {
     gr_DestroyImage(im);
     return(1);
    }
   else
    {
     gr_DestroyImage(im);
     return(0);
    } 
  }
 else
  return(0); 
}


int ReadPCX(gr_Window *wi, char *filename, int x, int y)
{
 Image *im;

 /* Bild in Imagestruktur einlesen */
 if((im=mr_ReadPCXImage(filename)) == NULL)
  return(0);

 /* Bild auf dem Fenster ausgeben */
 gr_PutImage(wi,im,x,y,im->width,im->height,0);

 /* Speicher wieder freigeben */
 gr_DestroyImage(im);

 /* gelungen */
 return(1); 
}

