/*
                                                                          
  READ will check a created binary file and read all available datas.     
  For further information, contact:                                       
                                                                          
                      K. Arfa-Kaboodvand                                  
                      Technical University of Darmstadt                   
                      Petersenstr.13                                      
                      64287 Germany                                       
                                                                          
                      phone:  49-6151-163809                              
                      fax  :  49-6151-164512                              
                      email:  KOUROSH@IPGS.VERM.TH-DARMSTADT.DE           
                                                                          
*/

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#define TRUE (1)
#define WAIT getch()
#define FALSE (0)


/*========================================================================+
|                                 VOID NRERRO                             |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Print out the error string.                                             |
+-------------------------------------------------------------------------+
| INPUTS : error_text = String for the error text                         |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                            |
+========================================================================*/
void nrerror(int WERT,char error_text[])
{
		fprintf(stderr,"\n\n...Run-time error...");
		fprintf(stderr,"\n%d %s",WERT,error_text);
		fprintf(stderr,"\n...now exiting to system...");
		exit(1);
}

/*========================================================================+
|                                 DVECTOR                                 |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Allocate a double vector with subscript range v[nl..nh].                |
+-------------------------------------------------------------------------+
| INPUTS : nl = Start dimension (subscript range) of the vector           |
|          nh = End dimension (subscript range) of the vector             |
+-------------------------------------------------------------------------+
| OUTPUTS: dvector = Allocated vector                                     |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
double *dvector(int nl,int nh)
{
	double *v;

	v=(double *)malloc((size_t) ((nh-nl+1+1)*sizeof(double)));
	if (!v)
		nrerror(0,"allocation failure in dvector()");
	return v-nl+1;
}

/*========================================================================+
|                          FREE_DVECTOR(DOUBLE)                           |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Free a double vector allocated with dvector().                          |
+-------------------------------------------------------------------------+
| INPUTS : v  = the vector, which should be free.                         |
|          nl = The starting number of row.                               |
+-------------------------------------------------------------------------+
| OUTPUTS: %                                                              |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
void free_dvector(double *v,int nl)
{
		free((char *) (v+nl-1));
}

/*========================================================================+
|                              DOUBLE DMATRIX                             |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Allocate a double matrix with subscript range m[nrl..nrh][ncl..nch].    |
+-------------------------------------------------------------------------+
| INPUTS : nrl = Starting row number (subscript range) of the matrix      |
|          nrh = Ending row number (subscript range) of the matrix        |
|          ncl = Starting column number (subscript range) of the matrix   |
|          nch = Ending column number (subscript range) of the matrix     |
+-------------------------------------------------------------------------+
| OUTPUTS: dmatrix = Allocated matrix                                     |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
char **Cmatrix(int nrl, int nrh, int ncl, int nch)
{
	int i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	char **m;

	/* Allocate pointers to rows: */
	m=(char **) malloc((size_t)((nrow+1)*sizeof(char*)));
	if (!m)
			nrerror(0,"allocation failure 1 in matrix()");
	m += 1;
	m -= nrl;

	/* Allocate rows and set pointers to them: */
	m[nrl]=(char *) malloc((size_t)((nrow*ncol+1)*sizeof(char)));
	if (!m[nrl])
			nrerror(0,"allocation failure 2 in matrix()");
	m[nrl] += 1;
	m[nrl] -= ncl;

	for(i=nrl+1;i<=nrh;i++)
			m[i]=m[i-1]+ncol;

	/* Return pointer to array of pointers to rows : */
	return m;
}

/*========================================================================+
|                             FREE_MATRIX(DOUBLE)                         |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Free a double matrix allocated with dmatrix().                          |
+-------------------------------------------------------------------------+
| INPUTS : m  = the matrix, which should be free.                         |
|          nrl= The starting number of row.                               |
|          ncl= The starting number of column.                            |
+-------------------------------------------------------------------------+
| OUTPUTS: %                                                              |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
void free_Cmatrix(double **m, int nrl, int ncl)
/* Free a double matrix allocated by dmatrix() : */
{
		free((char*) (m[nrl]+ncl-1));
		free((char*) (m+nrl-1));
}


/*
  MAIN PROGRAM 
*/
int main(void)
{
/* DECLARATION: */
	int    KSIZE,I,J,NCON,IPT[4][13],LPT[4],NUMDE;
	long   SIZE;
	double SS[4],*CVAL,AU,EMRAT,*DD;
	char   **CNAM;
	char   *NAME2 = "            ";
	FILE   *fp_Bin,*fp2;
	struct{ int NRW,NCOEFF; double *DB;} s;

/* READ THE INITIAL VALUES :*/
	printf("4) Name of binary file = ");scanf("%s",NAME2);

	if((fp_Bin = fopen(NAME2,"rb")) == NULL)
			{ printf(stderr, "Cannot open %s file.\n",NAME2);
					return 1;
			};
	fseek(fp_Bin,-1L*sizeof(int),SEEK_END);
	fread(&NCON,sizeof(int),1, fp_Bin);
	fclose(fp_Bin);
	fp_Bin=fopen(NAME2,"rb");
	SIZE=-41L*sizeof(int)-2L*sizeof(double)-3L*sizeof(double)-
							(long)NCON*sizeof(double)-(long)NCON*9L*sizeof(char)-
							1L*sizeof(int);
	fseek(fp_Bin,SIZE,SEEK_END);

/* READ THE SIZE AND NUMBER OF MAIN EPHEMERIS: */
	fread(&KSIZE,sizeof(int),1, fp_Bin);
	printf("\n KSIZE = %d",KSIZE);

/* READ THE NUMBER AND NAMES OF CONSTANTS: (GROUP 1040/4):*/
	printf("\n NCON = %d",NCON);
	WAIT;
	CNAM = Cmatrix(1,NCON,0,8);
	for(I=1;I<=NCON;++I)
				{ fread(CNAM[I],9,1,fp_Bin);
						printf("\n CNAM[%d] = %s",I,CNAM[I]);
						if((I%10)==0)WAIT;
				}

	/* READ NUMBER OF VALUES AND VALUES (GROUP 1041/4): */
	CVAL = dvector(1,NCON);

	for(I = 1;I <= NCON; ++I)
				{ fread(&CVAL[I],sizeof(double),1, fp_Bin);
						printf("\n CVAL[%d]= %24.15g ",I,CVAL[I]);
						if((I%10)==0)WAIT;
				}

	for(I=1;I<=3;++I)
				{ fread(&(SS)[I],sizeof(double),1, fp_Bin);
						printf("\n ss[%d] = %24.15g ",I,SS[I]);
				}
	WAIT;

	fread(&AU,sizeof(double),1, fp_Bin);
	printf("\n AU= %24.15g ",AU);
	fread(&EMRAT,sizeof(double),1, fp_Bin);
	printf("\n EMRAT= %24.15g ",EMRAT);
	fread(&NUMDE,sizeof(int),1, fp_Bin);
	printf("\n NUMDE= %d ",NUMDE);
	WAIT;


/* READ POINTERS NEEDED BY INTERP (GROUP 1050): */
	for(I = 1;I <= 3; ++I)
				{ for(J = 1;J <= 12; ++J)
									{ fread(&IPT[I][J],sizeof(int),1, fp_Bin);
											printf("\n IPT[%d][%d] =%d ",I,J,IPT[I][J]);
									}
							WAIT;
				}

	for(I=1;I<=3;++I)
				{ fread(&LPT[I],sizeof(int),1, fp_Bin);
						printf("\n LPT[%d]= %d ",I,LPT[I]);
				}

	WAIT;

	/* READ THE NAME OF EPHEMERIS DATA (GROUP 1070) & CLOSE HEADER FILE: */

	/* OPEN THE EPHEMERIS FILE (NAME1):*/
	/* OPEN THE EPHEMERIS FILE FOR CHECKING THE DIMENSION AND TIME CHECKING */
	/* (NAME1):                                                             */
	fseek(fp_Bin,0L,SEEK_SET);

	/* READ THE BLOCK NR NUMBER OF COEFFICIENTS AND THE COEFFICIENT: */
	fscanf(fp2,"%d",&(s.NRW));   /* Read the block number!           */
	fscanf(fp2,"%d",&(s.NCOEFF));/* Read the number of coefficients! */

	/* >>>>>>>>> COMPUTATION LOOP: <<<<<<<<<<<<<*/
	printf("\nWRITE THE EPHEMERIS IN TEMP FILE:\n");
	DD = dvector(1,KSIZE);      /* Initialise the vector DB!        */
	for(;;)
			{ for(I=1;I<=KSIZE;++I)
								fread(&DD[I],sizeof(double),1, fp_Bin);
					printf("\n DB[1]=%24.18g    DB[2]=%24.18g ",DD[1],DD[2]);

					if((DD[2])==SS[2])
							break;
					fscanf(fp2,"%d",&(s.NRW));   /* Read the block number!           */
					fscanf(fp2,"%d",&(s.NCOEFF));/* Read the number of coefficients! */
			}
	fclose(fp_Bin);

	return 0;
}
