/*
                                                                          
  MERGE will merge two binary files of Ephemeris to a binary file.        
  For further information, contact:                                       
                                                                          
                      K. Arfa-Kaboodvand                                  
                      Technical University of Darmstadt                   
                      Petersenstr.13                                      
                      64287 Germany                                       
                                                                          
                      phone:  49-6151-163809                              
                      fax  :  49-6151-164512                              
                      email:  KOUROSH@IPGS.VERM.TH-DARMSTADT.DE           
                                                                          
*/

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

#define TRUE (1)
#define WAIT getch()
#define FALSE (0)


/*========================================================================+
|                                 VOID NRERRO                             |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Print out the error string.                                             |
+-------------------------------------------------------------------------+
| INPUTS : error_text = String for the error text                         |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                            |
+========================================================================*/
void nrerror(int WERT,char error_text[])
{
		fprintf(stderr,"\n\n...Run-time error...");
		fprintf(stderr,"\n%d %s",WERT,error_text);
		fprintf(stderr,"\n...now exiting to system...");
		exit(1);
}

/*========================================================================+
|                                 DVECTOR                                 |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Allocate a double vector with subscript range v[nl..nh].                |
+-------------------------------------------------------------------------+
| INPUTS : nl = Start dimension (subscript range) of the vector           |
|          nh = End dimension (subscript range) of the vector             |
+-------------------------------------------------------------------------+
| OUTPUTS: dvector = Allocated vector                                     |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
double *dvector(int nl,int nh)
{
	double *v;

	v=(double *)malloc((size_t) ((nh-nl+1+1)*sizeof(double)));
	if (!v)
			nrerror(0,"allocation failure in dvector()");
	return v-nl+1;
}

/*========================================================================+
|                          FREE_DVECTOR(DOUBLE)                           |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Free a double vector allocated with dvector().                          |
+-------------------------------------------------------------------------+
| INPUTS : v  = the vector, which should be free.                         |
|          nl = The starting number of row.                               |
+-------------------------------------------------------------------------+
| OUTPUTS: %                                                              |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
void free_dvector(double *v,int nl)
{
		free((char *) (v+nl-1));
}

/*========================================================================+
|                              DOUBLE DMATRIX                             |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Allocate a double matrix with subscript range m[nrl..nrh][ncl..nch].    |
+-------------------------------------------------------------------------+
| INPUTS : nrl = Starting row number (subscript range) of the matrix      |
|          nrh = Ending row number (subscript range) of the matrix        |
|          ncl = Starting column number (subscript range) of the matrix   |
|          nch = Ending column number (subscript range) of the matrix     |
+-------------------------------------------------------------------------+
| OUTPUTS: dmatrix = Allocated matrix                                     |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
char **Cmatrix(int nrl, int nrh, int ncl, int nch)
{
	int i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
	char **m;

	/* Allocate pointers to rows: */
	m=(char **) malloc((size_t)((nrow+1)*sizeof(char*)));
	if (!m)
				nrerror(0,"allocation failure 1 in matrix()");
	m += 1;
	m -= nrl;

	/* Allocate rows and set pointers to them: */
	m[nrl]=(char *) malloc((size_t)((nrow*ncol+1)*sizeof(char)));
	if (!m[nrl])
		nrerror(0,"allocation failure 2 in matrix()");
	m[nrl] += 1;
	m[nrl] -= ncl;

	for(i=nrl+1;i<=nrh;i++)
				m[i]=m[i-1]+ncol;

	/* Return pointer to array of pointers to rows : */
	return m;
}

/*========================================================================+
|                             FREE_MATRIX(DOUBLE)                         |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Free a double matrix allocated with dmatrix().                          |
+-------------------------------------------------------------------------+
| INPUTS : m  = the matrix, which should be free.                         |
|          nrl= The starting number of row.                               |
|          ncl= The starting number of column.                            |
+-------------------------------------------------------------------------+
| OUTPUTS: %                                                              |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
void free_Cmatrix(double **m, int nrl, int ncl)
/* Free a double matrix allocated by dmatrix() : */
{
		free((char*) (m[nrl]+ncl-1));
		free((char*) (m+nrl-1));
}


/*
  MAIN PROGRAM 
*/
int main(void)
{
/* DECLARATION: */
	char   *NAME1 = "            ";
	char   *NAME2 = "            ";
	char   *NAME3 = "            ";
	FILE   *fp_Bin1,*fp_Bin2,*fp_Bin3,*fp_HELP;
	int    NCON[3],KSIZE[2],I,N,J,IPT1[4][13],IPT2[4][13],LPT1[4],LPT2[4],
								NUMDE1,NUMDE2,HELP,STATUS;
	long   SIZE;
	double SS1[4],SS2[4],*CVAL1,*CVAL2,*CVAL3,AU1,AU2,EMRAT1,EMRAT2,*DD,DS;
	char   **CNAM1,**CNAM2,**CNAM3;

	/* READ THE INITIAL VALUES :*/
	printf("\n1) Name of the first binary file     = ");scanf("%s",NAME1);
	printf("2) Name of the second binary file    = ");scanf("%s",NAME2);
	printf("3) Name of the resulting binary file = ");scanf("%s",NAME3);

	if((fp_Bin1 = fopen(NAME1,"rb")) == NULL)
			{ printf(stderr, "Cannot open %s file.\n",NAME1);return 1; };
	if((fp_Bin2 = fopen(NAME2,"rb")) == NULL)
			{ printf(stderr, "Cannot open %s file.\n",NAME2);return 1; };
	if((fp_Bin3 = fopen(NAME3,"wb")) == NULL)
			{ printf(stderr, "Cannot open %s file.\n",NAME3);return 1; };

	fseek(fp_Bin1,-1L*sizeof(int),SEEK_END);
	fread(&NCON[0],sizeof(int),1, fp_Bin1);
	fclose(fp_Bin1);

	fseek(fp_Bin2,-1L*sizeof(int),SEEK_END);
	fread(&NCON[1],sizeof(int),1, fp_Bin2);
	fclose(fp_Bin2);

	fp_Bin1=fopen(NAME1,"rb");
	SIZE=-42L*sizeof(int)-2L*sizeof(double)-3L*sizeof(double)-
							(long)(NCON[0])*sizeof(double)-(long)(NCON[0])*9L*sizeof(char);
	fseek(fp_Bin1,SIZE,SEEK_END);

	fp_Bin2=fopen(NAME2,"rb");
	SIZE=-42L*sizeof(int)-2L*sizeof(double)-3L*sizeof(double)-
							(long)(NCON[1])*sizeof(double)-(long)(NCON[1])*9L*sizeof(char);
	fseek(fp_Bin2,SIZE,SEEK_END);

	/* READ THE SIZE AND NUMBER OF MAIN EPHEMERIS: */
	fread(&KSIZE[0],sizeof(int),1, fp_Bin1);
	fread(&KSIZE[1],sizeof(int),1, fp_Bin2);

	if(KSIZE[0]!=KSIZE[1])
			{ printf("\n KSIZE[1]=%d   KSIZE[2]=%d ",KSIZE[0],KSIZE[1]);
					nrerror(0,"ERROR...The number of coefficients are not equal!");
			}

	if(NCON[0]!=NCON[1])
			{ printf("\n NCON[1]=%d   NCON[2]=%d ",NCON[0],NCON[1]);
					nrerror(0,"ERROR...The number of constants are not equal!");
			}

	/* READ THE NUMBER AND NAMES OF CONSTANTS: (GROUP 1040/4):*/
	CNAM1 = Cmatrix(1,NCON[0],0,8);
	for(I=1;I<=NCON[0];++I)
				fread(CNAM1[I],9,1,fp_Bin1);

	CNAM2 = Cmatrix(1,NCON[1],0,8);
	for(I=1;I<=NCON[1];++I)
				fread(CNAM2[I],9,1,fp_Bin2);

	/* READ NUMBER OF VALUES AND VALUES (GROUP 1041/4): */
	CVAL1 = dvector(1,NCON[0]);
	for(I = 1;I <= NCON[0]; ++I)
				fread(&CVAL1[I],sizeof(double),1, fp_Bin1);

	CVAL2 = dvector(1,NCON[1]);
	for(I = 1;I <= NCON[1]; ++I)
				fread(&CVAL2[I],sizeof(double),1, fp_Bin2);

	HELP=0;

	for(J=1;J<=NCON[1];++J)
				{ N=0;
						for(I=1;I<=NCON[0];++I)
									{ if((strcmp(CNAM2[J],CNAM1[I]))==0)
													{ N++;
															if((CVAL2[J])!=(CVAL1[I]))
																	{ printf("CNAM1[%d]=%s CNAM2[%d]=%s",I,CNAM1[I],J,CNAM2[J]);
																			printf("\nCVAL1[%d]=%24.8g CVAL2[%d]=%24.8g",I,CVAL1[I],J,
																											CVAL2[J]);
																			nrerror(0,"CONSTANT ERROR... C(1st file)!=C(2nd file)!");
																	}
													}
									}
						if(N==0)HELP++;
				}

	NCON[2]=NCON[0]+HELP;
	CNAM3 = Cmatrix(1,NCON[2],0,8);
	CVAL3 = dvector(1,NCON[2]);

	for(I=1;I<=NCON[0];++I)
				{ strcpy(CNAM3[I],CNAM1[I]);CVAL3[I]=CVAL1[I]; }

	if(HELP!=0)
			{ N=1;
					for(J=1;J<=NCON[1];++J)
								for(I=1;I<=NCON[0];++I)
											{ if((strcmp(CNAM2[J],CNAM1[I]))!=0)
															{ strcpy(CNAM3[(NCON[0]+N)],CNAM2[J]);
																	CVAL3[(NCON[0]+N)]=CVAL2[J];
																	N+=1;
															}
											}
			}

	for(I=1;I<=3;++I)
				{ fread(&SS1[I],sizeof(double),1, fp_Bin1);
						fread(&SS2[I],sizeof(double),1, fp_Bin2);
				}

	DS=SS2[2]+SS1[2]-SS2[1]-SS1[1];
	DS=DS/(SS1[3]*20.);

	if(SS1[3]!=SS2[3])
				nrerror(0,"TIME SPAN ERROR.. T(first file)!=T(2nd file)!");

	if(SS2[2]<SS1[2])
			nrerror(0,"EPOCH ERROR... End-Epoch(1st file)>End-Epoch(2nd file)!");

	fread(&AU1,sizeof(double),1, fp_Bin1);
	fread(&AU2,sizeof(double),1, fp_Bin2);
	if(AU1!=AU2)
			nrerror(0,"ASTRONOMICAL UNIT ERROR... AU(1st file)!=AU(2nd file)!");

	fread(&EMRAT1,sizeof(double),1, fp_Bin1);
	fread(&EMRAT2,sizeof(double),1, fp_Bin2);
	if(EMRAT1!=EMRAT2)
			nrerror(0,"EARTH-MOON RATIO ERROR... EMR(1st file)!=EMR(2nd file)!");

	fread(&NUMDE1,sizeof(int),1, fp_Bin1);
	fread(&NUMDE2,sizeof(int),1, fp_Bin2);
	if(NUMDE1!=NUMDE2)
			nrerror(0,"EPHEMERIS NUMBER ERROR... EN(1st file)!=EN(2nd file)!");

/* READ POINTERS NEEDED BY INTERP (GROUP 1050): */
	for(I = 1;I <= 3; ++I)
				{ for(J = 1;J <= 12; ++J)
									{ fread(&IPT1[I][J],sizeof(int),1, fp_Bin1);
											fread(&IPT2[I][J],sizeof(int),1, fp_Bin2);
											if(IPT1[I][J]!=IPT2[I][J])
													nrerror(0,"IPT ERROR... IPT(1st file)!=IPT(2nd file)!");
									}
				}

		for(I=1;I<=3;++I)
					{ fread(&LPT1[I],sizeof(int),1, fp_Bin1);
							fread(&LPT2[I],sizeof(int),1, fp_Bin2);
							if(LPT1[I]!=LPT2[I])
									nrerror(0,"LPT ERROR... LPT(1st file)!=LPT(2nd file)!");
					}

	fseek(fp_Bin1,0L,SEEK_SET);
	fseek(fp_Bin2,0L,SEEK_SET);

/* >>>>>>>>> COMPUTATION LOOP: <<<<<<<<<<<<<*/
	printf("\nWRITE THE EPHEMERIS IN DESTINATION FILE:\n\n");
	printf("  IIIIIIIIIIIIIIIIIIII\n  ");

	/* Initialise the vector DB!        */
	DD = dvector(1,KSIZE[0]);
	J=1;
	N=1;
	STATUS=0;

	for(;;)
				{ for(I=1;I<=KSIZE[0];++I)
									{ if(J==1)
													fp_HELP=fp_Bin1;
											else
													fp_HELP=fp_Bin2;
											fread(&DD[I],sizeof(double),1, fp_HELP);

											if(J==1) fwrite(&DD[I],sizeof(double),1, fp_Bin3);
											if((J==2) && (DD[1]==SS1[2])) STATUS=1;
											if((J==2) && STATUS==1)fwrite(&DD[I],sizeof(double),1, fp_Bin3);
									}
						if((N/DS)>=1.)
								{ N=1;printf("I"); }
						N++;
						if((J==1) && (DD[2]==SS1[2])) J=2;
						if((J==2) && (DD[2]==SS2[2])) break;
				}

		printf("\n");
	/* WRITE OUTPUT TO THE OUTPUT BINARY FILE (VARIABLES;CONSTANTS; ETC.): */
	fwrite(&(KSIZE)[0],sizeof(int), 1, fp_Bin3);

	if(STATUS==0)
			{ NCON[2]=NCON[0];SS2[2]=SS1[2]; }

	for(I = 1;I <= NCON[2]; ++I)
			fwrite(CNAM3[I],strlen(CNAM3[I])+1,1, fp_Bin3);

	for(I = 1;I <= NCON[2]; ++I)
				fwrite(&(CVAL3)[I],sizeof(double), 1, fp_Bin3);

	SS1[2]=SS2[2];
	for(I = 1;I <= 3; ++I)
				fwrite(&SS1[I],sizeof(double), 1, fp_Bin3);

	fwrite(&AU1,sizeof(double), 1, fp_Bin3);
	fwrite(&EMRAT1,sizeof(double), 1, fp_Bin3);
	fwrite(&NUMDE1,sizeof(int), 1, fp_Bin3);

	for(J = 1;J <= 3; ++J)
				for(I=1;I<=12;++I)
							fwrite(&IPT1[J][I],sizeof(int), 1, fp_Bin3);

	for(I = 1;I <= 3; ++I)
				fwrite(&LPT1[I],sizeof(int), 1, fp_Bin3);

	fwrite(&NCON[2],sizeof(int), 1, fp_Bin3);

	if(STATUS==0)
			{ printf("\n The 2nd file could not be merged, since it has no starting");
					printf("\n epoch which equals to the ending epoch of the 1st file!");
			}

	return 0;
}
