/*
   Zeitrechnung von Sekunden ausgehend in eine Zeichenkette,
   nach Heutiger Zeitrechnung.

   Copyright (C) 1996 Helmut Fahrion
   
   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.
   
   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>

/* Korrektur zu 01.01.-4713 */
#define korr        -1.48730904e11
#define sekjetag 86400.0

void s2d(char *str, double sek)
{
 int      monat, h, m, s;
 long int jahr = 0;
 double   rtage, zeit, tage = (sek + korr) / sekjetag;

 /* // positiv oder negative Zeit? */
 if (tage >= 0)
 {
   /* // zhle Jahre hoch */
   for (jahr=0; tage >= (365.0 + (double)((jahr % 4) == 0)); jahr++)
    tage -= 365.0 + (double)((jahr % 4) == 0);

   /* // ermittle Tage des Monates */
   rtage = tage;
   for (monat=1; rtage >= 0.0; monat++)
   {
     switch (monat)
     {
       case 1:  rtage -= 31.0; break;
       case 2:  rtage -= 28.0 + (double)((jahr % 4) == 0); break;
       case 3:  rtage -= 31.0; break;
       case 4:  rtage -= 30.0; break;
       case 5:  rtage -= 31.0; break;
       case 6:  rtage -= 30.0; break;
       case 7:  rtage -= 31.0; break;
       case 8:  rtage -= 31.0; break;
       case 9:  rtage -= 30.0; break;
       case 10: rtage -= 31.0; break;
       case 11: rtage -= 30.0; break;
       case 12: rtage -= 31.0; break;
     }
     if (rtage > 0.0) tage = rtage;
   }
   /* immer ein Monat zuviel */
   monat--;
   /* habe mit ein Tag zuwenig begonnen, die Tage beginnen nicht bei 0! */
   tage++;
 }
 else
 {
   /* Wie oben nur das runtergezhlt wird! */
   tage = -tage;
   for (jahr=-1; tage > (365.0 + (double)((jahr % 4) == 0)); jahr--)
    tage -= 365.0 + (double)((jahr % 4) == 0);

   rtage = tage;
   for (monat=12; rtage > 0.0; monat--)
   {
     switch (monat)
     {
       case 1:  rtage -= 31.0; break;
       case 2:  rtage -= 28.0 + (double)((jahr % 4) == 0); break;
       case 3:  rtage -= 31.0; break;
       case 4:  rtage -= 30.0; break;
       case 5:  rtage -= 31.0; break;
       case 6:  rtage -= 30.0; break;
       case 7:  rtage -= 31.0; break;
       case 8:  rtage -= 31.0; break;
       case 9:  rtage -= 30.0; break;
       case 10: rtage -= 31.0; break;
       case 11: rtage -= 30.0; break;
       case 12: rtage -= 31.0; break;
     }
     if (rtage > 0.0) tage = rtage;
   }
   monat++;

   switch (monat)
   {
     case 1:  tage = 31.0 - tage; break;
     case 2:  tage = 28.0 + (double)((jahr % 4) == 0) - tage; break;
     case 3:  tage = 31.0 - tage; break;
     case 4:  tage = 30.0 - tage; break;
     case 5:  tage = 31.0 - tage; break;
     case 6:  tage = 30.0 - tage; break;
     case 7:  tage = 31.0 - tage; break;
     case 8:  tage = 31.0 - tage; break;
     case 9:  tage = 30.0 - tage; break;
     case 10: tage = 31.0 - tage; break;
     case 11: tage = 30.0 - tage; break;
     case 12: tage = 31.0 - tage; break;
   }
   tage++;
 }

 zeit = (tage > 0.0) ? tage : -tage;
 /* Uhrzeit */
 zeit = (zeit - (double)(int)zeit) * 24.0; /* Nachkomma bleiben */
 h = (int)(zeit+0.5);                      /* runden nicht vergessen! */
 zeit = (zeit - (double)h) * 60.0;
 m = (int)(zeit+0.5);
 zeit = (zeit - (double)m) * 60.0;
 s = (int)(zeit+0.5);

 sprintf(str, "%2d.%02d.%05ld; %02d:%02d:%02d\n", (int)tage, monat, jahr, h, m, s);
}


/* nur fr Testzwecke

double d2s(double s)
{
  return(3600.0 * 24.0 * s);
}

int main(void)
{
 char datum[256];

 double sek;

 sek = -d2s(365)-d2s(365)-d2s(365)-d2s(366-31-28) + 7200;
 s2d(datum, sek);

 printf("%0.0e -> %s\n", sek, datum);

 return 0;
 
}

*/
