/*
                                                                          
  TEST will check the usage of the subroutines pleph and state and inter- 
  polate and comare the computed datas with the available jpl test datas. 
  For further information, contact:                                       
                                                                          
                      K. Arfa-Kaboodvand                                  
                      Technical University of Darmstadt                   
                      Petersenstr.13                                      
                      64287 Germany                                       
                                                                          
                      phone:  49-6151-163809                              
                      fax  :  49-6151-164512                              
                      email:  KOUROSH@IPGS.VERM.TH-DARMSTADT.DE           
                                                                          
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
//#include <conio.h>

//#define WAIT getch()

#define WAIT getc(stdin)

#define TRUE_ (1)
#define FALSE_ (0)

/* Common Block Declarations */
struct { char **cnam;
  double *cval,ss[3],au,emrat;
  int denum, ncon, ipt[36],lpt[3],ksize;
} HEADER;

struct { double *buf;}epib;

/*     COMMON AREA STCOMM:                                               */
/*          KM   LOGICAL FLAG DEFINING PHYSICAL UNITS OF THE OUTPUT      */
/*               STATES. KM = .TRUE., KM AND KM/SEC                      */
/*                          = .FALSE., AU AND AU/DAY                     */
/*               DEFAULT VALUE = .FALSE.  (KM DETERMINES TIME UNIT       */
/*              FOR NUTATIONS AND LIBRATIONS. ANGLE UNIT IS ALWAYS RAD.) */
/*        BARY   LOGICAL FLAG DEFINING OUTPUT CENTER.                    */
/*               ONLY THE 9 PLANETS ARE AFFECTED.                        */
/*                       BARY = .TRUE. =\ CENTER IS SOLAR-SYS. BARYCEN.  */
/*                             = .FALSE. =\ CENTER IS SUN                */
/*               DEFAULT VALUE = .FALSE.                                 */
/*       PVSUN   DP 6-WORD ARRAY CONTAINING THE BARYCENTRIC POSITION AND */
/*               VELOCITY OF THE SUN.                                    */
struct { int km, bary;
  double pvsun[6];
} stcomm;

int const2 = 2;
int const3 = 3;


/*========================================================================+
|                                 VOID ERROR                              |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Print out the error string.                                             |
+-------------------------------------------------------------------------+
| INPUTS : error_text = String for the error text                         |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                            |
+========================================================================*/
void ERROR(int i,char *msg)
{
  fprintf(stderr,"\n\n...Run-time error...");
  fprintf(stderr,"\n%d %s",i,msg);
  fprintf(stderr,"\n...now exiting to system...");
  exit(1);
}


/*========================================================================+
|                                 DVECTOR                                 |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Allocate a double vector with subscript range v[nl..nh].                |
+-------------------------------------------------------------------------+
| INPUTS : nl = Start dimension (subscript range) of the vector           |
|          nh = End dimension (subscript range) of the vector             |
+-------------------------------------------------------------------------+
| OUTPUTS: dvector = Allocated vector                                     |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
double *dvector(int nl,int nh)
{
  double *v;

  v=(double *)malloc((size_t) ((nh-nl+1+1)*sizeof(double)));
  if (!v)
    ERROR(0,"allocation failure in dvector()");
  return v-nl+1;
}


/*========================================================================+
|                          FREE_DVECTOR(DOUBLE)                           |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Free a double vector allocated with dvector().                          |
+-------------------------------------------------------------------------+
| INPUTS : v  = the vector, which should be free.                         |
|          nl = The starting number of row.                               |
+-------------------------------------------------------------------------+
| OUTPUTS: %                                                              |
+-------------------------------------------------------------------------+
| REFERENCE: NUMERICAL RECEPIES IN C                                      |
+========================================================================*/
void free_dvector(double *v,int nl)
{
  free((char *) (v+nl-1));
}


/*========================================================================+
|                              CHAR CMATRIX                               |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Allocate a double matrix with subscript range m[nrl..nrh][ncl..nch].    |
+-------------------------------------------------------------------------+
| INPUTS : nrl = Starting row number (subscript range) of the matrix      |
|          nrh = Ending row number (subscript range) of the matrix        |
|          ncl = Starting column number (subscript range) of the matrix   |
|          nch = Ending column number (subscript range) of the matrix     |
+-------------------------------------------------------------------------+
| OUTPUTS: dmatrix = Allocated matrix                                     |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                            |
+========================================================================*/
char **Cmatrix(int nrl, int nrh, int ncl, int nch)
{
  int i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
  char **m;

  /* Allocate pointers to rows: */
  m=(char **) malloc((size_t)((nrow+1)*sizeof(char*)));
  if (!m)
    ERROR(0,"allocation failure 1 in matrix()");
  m += 1;
  m -= nrl;

  /* Allocate rows and set pointers to them: */
  m[nrl]=(char *) malloc((size_t)((nrow*ncol+1)*sizeof(char)));
  if (!m[nrl])
    ERROR(0,"allocation failure 2 in matrix()");
  m[nrl] += 1;
  m[nrl] -= ncl;

  for(i=nrl+1;i<=nrh;i++)
    m[i]=m[i-1]+ncol;

  /* Return pointer to array of pointers to rows : */
  return m;
}


/*========================================================================+
|                             FREE_MATRIX(CHAR)                           |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Free a double matrix allocated with dmatrix().                          |
+-------------------------------------------------------------------------+
| INPUTS : m  = the matrix, which should be free.                         |
|          nrl= The starting number of row.                               |
|          ncl= The starting number of column.                            |
+-------------------------------------------------------------------------+
| OUTPUTS: %                                                              |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                            |
+========================================================================*/
void free_Cmatrix(char **m, int nrl, int ncl)
/* Free a double matrix allocated by dmatrix() : */
{
  free((char*) (m[nrl]+ncl-1));
  free((char*) (m+nrl-1));
}


/*========================================================================+
|                                GO2POS                                   |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| Position the cursor about x characters from the actual position of the  |
| cursor in a specified file to the right side.                           |
+-------------------------------------------------------------------------+
| INPUTS : fp = File identification                                       |
|          nr = Number of characters to be read.                          |
+-------------------------------------------------------------------------+
| OUTPUTS: %                                                              |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                              |
+========================================================================*/
void GO2POS(FILE *fp,int nr)
{
  int i;
  char ch;
  for(i=1;i<=nr;++i)
    fscanf(fp,"%c",&ch);
}


/*========================================================================+
|                               INITIAL                                   |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| INITIALIZE THE CONSTANTS FROM THE JPL BINARY FILE.                      |
+-------------------------------------------------------------------------+
| INPUTS : %                                                              |
+-------------------------------------------------------------------------+
| OUTPUTS: FP_BIN = POINTER TO THE JPL BINARY FILE.                       |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                            |
+========================================================================*/
FILE *INITIAL(char *Name)
{
  long SIZE;
  int  I;
  FILE *fp_Bin;

  /* READ THE SIZE AND NUMBER OF MAIN EPHEMERIS: */
  if((fp_Bin = fopen(Name,"rb")) == NULL)
    { fprintf(stderr, "Cannot open %s file.\n",Name);
    exit(1);
    };

  fseek(fp_Bin,-1L*sizeof(int),SEEK_END);
  fread(&HEADER.ncon,sizeof(int),1, fp_Bin);
  SIZE=-42L*sizeof(int)-2L*sizeof(double)-3L*sizeof(double)-
    (long)HEADER.ncon*(sizeof(double)+9L*sizeof(char));
  fseek(fp_Bin,SIZE,SEEK_END);

  /* READ THE SIZE AND NUMBER OF MAIN EPHEMERIS: */
  fread(&HEADER.ksize,sizeof(int),1, fp_Bin);

  /* READ THE NUMBER AND NAMES OF CONSTANTS: (GROUP 1040/4):*/
  HEADER.cnam = Cmatrix(1,HEADER.ncon,0,8);
  for(I=1;I<=HEADER.ncon;++I)
    fread(HEADER.cnam[I],9,1,fp_Bin);

  /* READ NUMBER OF VALUES AND VALUES (GROUP 1041/4): */
  HEADER.cval = dvector(1,HEADER.ncon);
  for(I = 1;I <= HEADER.ncon; ++I)
    fread(&HEADER.cval[I],sizeof(double),1, fp_Bin);

  for(I=0;I<=2;++I)
    fread(&HEADER.ss[I],sizeof(double),1, fp_Bin);

  fread(&HEADER.au,sizeof(double),1, fp_Bin);
  fread(&HEADER.emrat,sizeof(double),1, fp_Bin);
  fread(&HEADER.denum,sizeof(int),1, fp_Bin);

  /* READ POINTERS NEEDED BY INTERP (GROUP 1050): */
  for(I = 0;I <= 35; ++I)
    fread(&HEADER.ipt[I],sizeof(int),1, fp_Bin);

  for(I=0;I<=2;++I)
    fread(&HEADER.lpt[I],sizeof(int),1, fp_Bin);

  epib.buf=dvector(1,HEADER.ksize);

  return(fp_Bin);
}


/*========================================================================+
|                               PRINTOUT                                  |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+========================================================================*/
void PRINTOUT(void)
{
  int I;
  printf("\n ksize = %d",HEADER.ksize);
  printf("\n ncon  = %d\n\n Please enter a key...\n\n",HEADER.ncon);

  // WAIT;

  for(I=1;I<=HEADER.ncon;++I)
    { printf("\n %s = %24.15g",HEADER.cnam[I],HEADER.cval[I]);
    if((I%20)==0)
      { printf("\n\n Please enter a key...\n\n");//WAIT;
      }
    }

  for(I=0;I<=2;++I)
    printf("\n ss[%d] = %24.15g",I,HEADER.ss[I]);

  printf("\n AU    = %24.15g",HEADER.au);
  printf("\n EMRAT = %24.15g",HEADER.emrat);
  printf("\n DENUM = %d",HEADER.denum);
  printf("\n\n Please enter a key...\n\n");
  //WAIT;

  for(I = 0;I <= 35; ++I)
    printf("\n ipt[%d]=%d",I,HEADER.ipt[I]);
  printf("\n\n Please enter a key...\n\n");
//WAIT;
  for(I=0;I<=2;++I)
    printf("\nlpt[%d]=%d",I,HEADER.lpt[I]);
  printf("\n\n Please wait the program is searching for");
  printf(" the correct time span...\n\n");

}


/*========================================================================+
|                           SPLIT & DINT                                  |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| This subroutine breaks a D.P. number into a D.P. integer and a D.P.     |
| fractional part.                                                        |
+-------------------------------------------------------------------------+
| INPUTS :                                                                |
|         TT = D.P. input number                                          |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
|          FR = D.P. 2-word output array.                                 |
|               FR(1) contains integer part                               |
|               FR(2) contains fractional part                            |
|               For negative input numbers, FR(1) contains the next       |
|               more negative integer; FR(2) contains a positive fraction.|
+-------------------------------------------------------------------------+
| REFERENCE: JPL (FORTRAN CODE)                                           |
+========================================================================*/
double Dint(double x)
{ return( (x>0) ? floor(x) : -floor(-x) );}

/*=======================================================================*/

int SPLIT(double tt,double *fr)
{
  /* Function Body */
  fr[0] = Dint(tt);
  fr[1] = tt - fr[0];
  if(tt < 0. && fr[1] != 0.)
    { /* Make adjustments for negative input number. */
      fr[0] += -1.;
      fr[1] += 1.;
    }
  return 0;
}


/*========================================================================+
|                               DMOD                                      |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| DOUBLE PRECISION MODULA                                                 |
+-------------------------------------------------------------------------+
| INPUTS :                                                                |
|          x = NUMERATOR                                                  |
|          y = DENOMINATOR                                                |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
|         DMOD = D.P. MODULA                                              |
+-------------------------------------------------------------------------+
| REFERENCE: %                                                            |
+========================================================================*/
double Dmod(double x,double y)
{
  double quotient;

  quotient = x / y;
  if(quotient >= 0)
    quotient = floor(quotient);
  else
    quotient = -floor(-quotient);
  return(x - y * quotient );
}


/*========================================================================+
|                               INTERP                                    |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| This subroutine differentiates and interpolates a set of Chebyshev      |
| coefficients to give position and velocity.                             |
+-------------------------------------------------------------------------+
| INPUTS :                                                                |
|  BUF   1st location of array of D.P. Chebyshev coefficients of position |
|    T   T(1) IS DP FRACTIONAL TIME IN INTERVAL COVERED BY                |
|             COEFFICIENTS AT WHICH INTERPOLATION IS WANTED               |
|             (0 .LE. T(1) .LE. 1).  T(2) IS DP LENGTH OF WHOLE           |
|             INTERVAL IN INPUT TIME UNITS.                               |
|  NCF   # OF COEFFICIENTS PER COMPONENT                                  |
|  NCM   # OF COMPONENTS PER SET OF COEFFICIENTS                          |
|   NA   # OF SETS OF COEFFICIENTS IN FULL ARRAY                          |
|          (I.E., # OF SUB-INTERVALS IN FULL INTERVAL)                    |
|   FL   INTEGER FLAG: =1 FOR POSITIONS ONLY                              |
|                      =2 FOR POS AND VEL                                 |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
|  PV   INTERPOLATED QUANTITIES REQUESTED.  DIMENSION  EXPECTED IS        |
|       PV(NCM,FL), DP.                                                   |
+-------------------------------------------------------------------------+
| REFERENCE: JPL (FORTRAN CODE)                                           |
+========================================================================*/
int INTERP(double *buf,double *t,int ncf,int ncm,int na,int fl,double *pv)
{
  /* Initialized data */
  static int np = 2;
  static int nv = 3;
  static double twot = 0.;
  static double pc[18] = {1.,0.,0.,0.,0.,0.,0.,0.,0.,
			  0.,0.,0.,0.,0.,0.,0.,0.,0.};
  static double vc[18] = { 0.,1.,0.,0.,0.,0.,0.,0.,0.,
			   0.,0.,0.,0.,0.,0.,0.,0.,0.};

  /* Local variables */
  double vfac, temp;
  int    i, j, l;
  double tc, dt1, dna;

  /* ENTRY POINT. GET CORRECT SUB-INTERVAL NUMBER FOR THIS SET */
  /* OF COEFFICIENTS AND THEN GET NORMALIZED CHEBYSHEV TIME    */
  /* WITHIN THAT SUBINTERVAL.                                  */
  dna = (double)na;
  dt1 = Dint(t[0]);
  temp = dna * t[0];
  l = (Dint) (temp - dt1)+1;

  /* TC IS THE NORMALIZED CHEBYSHEV TIME (-1 .LE. TC .LE. 1) */
  tc = (Dmod(temp, 1.) + dt1) * 2. - 1.;

  /* CHECK TO SEE WHETHER CHEBYSHEV TIME HAS CHANGED,    */
  /* AND COMPUTE NEW POLYNOMIAL VALUES IF IT HAS.        */
  /* (THE ELEMENT PC(2) IS THE VALUE OF T1(TC) AND HENCE */
  /* CONTAINS THE VALUE OF TC ON THE PREVIOUS CALL.)     */
  if(tc != pc[1])
    { np = 2;
    nv = 3;
    pc[1] = tc;
    twot = tc + tc;
    }

  /* BE SURE THAT AT LEAST 'NCF' POLYNOMIALS HAVE BEEN EVALUATED */
  /* AND ARE STORED IN THE ARRAY 'PC'.                           */
  if(np < ncf)
    { for(i = np + 1; i <= ncf; ++i)
      pc[i - 1] = twot * pc[i - 2] - pc[i - 3];
    np = ncf;
    }

  /* INTERPOLATE TO GET POSITION FOR EACH COMPONENT */
  for(i = 1; i <= ncm; ++i)
    { pv[i-1] = 0.;
    for(j = ncf; j >= 1; --j)
      pv[i-1]+=pc[j-1]*buf[j-1+(i-1+(l-1)*ncm)*ncf];
    }
  if (fl <= 1)
    return 0;

  /* IF VELOCITY INTERPOLATION IS WANTED, BE SURE ENOUGH    */
  /* DERIVATIVE POLYNOMIALS HAVE BEEN GENERATED AND STORED. */
  vfac = (dna + dna) / t[1];
  vc[2] = twot + twot;
  if(nv < ncf)
    { for (i = nv + 1; i <= ncf; ++i)
      vc[i-1]=twot*vc[i-2]+pc[i-2]+pc[i-2]-vc[i-3];
    nv = ncf;
    }

  /* INTERPOLATE TO GET VELOCITY FOR EACH COMPONENT */
  for(i = 1; i <= ncm; ++i)
    { pv[i-1+ncm] = 0.;
    for (j =ncf; j >= 2; --j)
      pv[i-1+ncm]+=vc[j-1]*buf[j-1+(i-1+(l-1)*ncm)*ncf];
    pv[i-1+ncm] *= vfac;
    }
  return 0;
}


/*========================================================================+
|                               STATE                                     |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| THIS SUBROUTINE READS AND INTERPOLATES THE JPL PLANETARY EPHEMERIS FILE.|
+-------------------------------------------------------------------------+
| INPUTS :                                                                |
|         JED   DP 2-WORD JULIAN EPHEMERIS EPOCH AT WHICH INTERPOLATION   |
|               IS WANTED.  ANY COMBINATION OF JED(1)+JED(2) WHICH FALLS  |
|               WITHIN THE TIME SPAN ON THE FILE IS A PERMISSIBLE EPOCH.  |
|                A. FOR EASE IN PROGRAMMING, THE USER MAY PUT THE         |
|                   ENTIRE EPOCH IN JED(1) AND SET JED(2)=0.              |
|                B. FOR MAXIMUM INTERPOLATION ACCURACY, SET JED(1) =      |
|                   THE MOST RECENT MIDNIGHT AT OR BEFORE INTERPOLATION   |
|                   EPOCH AND SET JED(2) = FRACTIONAL PART OF A DAY       |
|                   ELAPSED BETWEEN JED(1) AND EPOCH.                     |
|                C. AS AN ALTERNATIVE, IT MAY PROVE CONVENIENT TO SET     |
|                   JED(1) = SOME FIXED EPOCH,SUCH AS START OF INTEGRATION|
|                   AND JED(2) = ELAPSED INTERVAL BETWEEN THEN AND EPOCH. |
|        LIST   12-WORD INTEGER ARRAY SPECIFYING WHAT INTERPOLATION       |
|               IS WANTED FOR EACH OF THE BODIES ON THE FILE.             |
|                         LIST(I)=0, NO INTERPOLATION FOR BODY I          |
|                                =1, POSITION ONLY                        |
|                                =2, POSITION AND VELOCITY                |
|               THE DESIGNATION OF THE ASTRONOMICAL BODIES BY I IS:       |
|                         I = 1: MERCURY                                  |
|                           = 2: VENUS                                    |
|                           = 3: EARTH-MOON BARYCENTER                    |
|                           = 4: MARS                                     |
|                           = 5: JUPITER                                  |
|                           = 6: SATURN                                   |
|                           = 7: URANUS                                   |
|                           = 8: NEPTUNE                                  |
|                           = 9: PLUTO                                    |
|                           =10: GEOCENTRIC MOON                          |
|                           =11: NUTATIONS IN LONGITUDE AND OBLIQUITY     |
|                           =12: LUNAR LIBRATIONS (IF ON FILE)            |
|                                                                         |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
|          PV   DP 6 X 11 ARRAY THAT WILL CONTAIN REQUESTED INTERPOLATED  |
|               QUANTITIES.  THE BODY SPECIFIED BY LIST(I) WILL HAVE ITS  |
|               STATE IN THE ARRAY STARTING AT PV(1,I).  (ON ANY GIVEN    |
|               CALL, ONLY THOSE WORDS IN 'PV' WHICH ARE AFFECTED BY THE  |
|              FIRST 10 'LIST' ENTRIES (AND BY LIST(12) IF LIBRATIONS ARE |
|               ON THE FILE) ARE SET.  THE REST OF THE 'PV' ARRAY         |
|               IS UNTOUCHED.)  THE ORDER OF COMPONENTS STARTING IN       |
|               PV(1,I) IS: X,Y,Z,DX,DY,DZ.                               |
|               ALL OUTPUT VECTORS ARE REFERENCED TO THE EARTH MEAN       |
|               EQUATOR AND EQUINOX OF EPOCH. THE MOON STATE IS ALWAYS    |
|               GEOCENTRIC; THE OTHER NINE STATES ARE EITHER HELIOCENTRIC |
|               OR SOLAR-SYSTEM BARYCENTRIC, DEPENDING ON THE SETTING OF  |
|               COMMON FLAGS (SEE BELOW).                                 |
|               LUNAR LIBRATIONS, IF ON 12, ARE PUT INTO PV(K,11) IF      |
|               LIST(12) IS 1 OR 2.                                       |
|         NUT   DP 4-WORD ARRAY THAT WILL CONTAIN NUTATIONS AND RATES,    |
|               DEPENDING ON THE SETTING OF LIST(11).  THE ORDER OF       |
|               QUANTITIES IN NUT IS:                                     |
|                        D PSI  (NUTATION IN LONGITUDE)                   |
|                        D EPSILON (NUTATION IN OBLIQUITY)                |
|                        D PSI DOT                                        |
|                        D EPSILON DOT                                    |
+-------------------------------------------------------------------------+
| REFERENCE: JPL (FORTRAN CODE)                                           |
+========================================================================*/
int STATE(FILE *fp_Bin,double *jed,int *list,double *pv,double *nut)
{
  /* Initialized data */
  static double aufac  = 1.;
  static int FIRST = TRUE_;
  static long nrl  = 0L;
  static double t[2];

  /* Local variables */
  int i, j, k;
  double s,jd[4];
  long nr;

  /* 1ST TIME IN, GET POINTER DATA, ETC., FROM EPH FILE */
  if(FIRST)
    { FIRST = FALSE_;
    if(stcomm.km)
      { t[1] = HEADER.ss[2] * 86400.;}
    else
      { t[1] = HEADER.ss[2];
      aufac = 1. / HEADER.au;
      }
    }

  /* MAIN ENTRY POINT -- CHECK EPOCH AND READ RIGHT RECORD */
  s = jed[0] - .5;
  SPLIT(s, &jd[0]);
  SPLIT(jed[1], &jd[2]);
  jd[0] = jd[0] + jd[2] + .5;
  jd[1] += jd[3];
  SPLIT(jd[1], &jd[2]);
  jd[0] += jd[2];

  /* ERROR RETURN OF EPOCH OUT OF RANGE */
  if((jd[0] < HEADER.ss[0]) || ((jd[0] + jd[3]) > HEADER.ss[1]))
    { printf("\n STATE: Epoch out of range.");
    exit(1);
    }

  /* CALCULATE RECORD # AND RELATIVE TIME IN INTERVAL */
  nr  = (long) ((jd[0] - HEADER.ss[0]) / HEADER.ss[2])+1;
  if(jd[0]==HEADER.ss[1])
    --nr;

  t[0]= ((jd[0]-((double)(nr-1)*HEADER.ss[2]+HEADER.ss[0]))+jd[3])/
    HEADER.ss[2];

  /* READ CORRECT RECORD IF NOT IN CORE */
  if(nr != nrl)
    { fseek(fp_Bin,(long)(nr-1)*HEADER.ksize*sizeof(double),SEEK_SET);
    nrl = nr;
    for(k=1;k<=HEADER.ksize;++k)
      fread(&epib.buf[k],sizeof(double),1, fp_Bin);
    }

  /* INTERPOLATE SSBARY SUN */
  INTERP(&epib.buf[HEADER.ipt[10]],t,HEADER.ipt[22],const3,
	 HEADER.ipt[34],const2,stcomm.pvsun);

  for(i = 1; i <= 6; ++i)
    stcomm.pvsun[i - 1] *= aufac;

  /* CHECK AND INTERPOLATE WHICHEVER BODIES ARE REQUESTED */
  for(i = 1; i <= 10; ++i)
    { if(list[i-1] > 0)
      { if(HEADER.ipt[11+i] <= 0)
	ERROR(i, "th body requested - not on file");
      INTERP(&epib.buf[HEADER.ipt[i-1]],t,HEADER.ipt[11+i],
	     const3,HEADER.ipt[23+i],list[i-1],&pv[(i-1)*6]);
      for(j = 1; j <= list[i-1] * 3; ++j)
	{ if(i <= 9 && !stcomm.bary)
	  pv[6*i-7+j]=pv[6*i-7+j]*aufac-stcomm.pvsun[j-1];
	else
	  pv[j +6*i -7] *= aufac;

	}
      }
    }

  /* DO NUTATIONS IF REQUESTED (AND IF ON FILE) */
  if(list[10] > 0 && HEADER.ipt[23] > 0)
    INTERP(&epib.buf[HEADER.ipt[11]],t,HEADER.ipt[23],const2,
	   HEADER.ipt[35],list[10],&nut[0]);

  /* GET LIBRATIONS IF REQUESTED (AND IF ON FILE) */
  if(HEADER.lpt[1] > 0 && list[11] > 0)
    INTERP(&epib.buf[HEADER.lpt[0]],t,HEADER.lpt[1],const3,
	   HEADER.lpt[2],list[11],&pv[60]);

  /* THAT'S ALL */
  return 0;

} /* state_ */


/*========================================================================+
|                                PLEPH0                                   |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+-------------------------------------------------------------------------+
| DESCRIPTION:                                                            |
| THIS SUBROUTINE READS THE JPL PLANETARY EPHEMERIS & GIVES THE POSITION  |
| AND VELOCITY OF THE POINT 'TARG'WITH RESPECT TO 'CENT'.                 |
+-------------------------------------------------------------------------+
| INPUTS :                                                                |
|       JD = D.P. JULIAN EPHEMERIS DATE AT WHICH INTERPOLATION IS WANTED. |
|       ** NOTE THE ENTRY DPLEPH FOR A DOUBLY-DIMENSIONED TIME **         |
|          THE REASON FOR THIS OPTION IS DISCUSSED IN THE SUB. STATE      |
|      TARG = int NUMBER OF 'TARGET' POINT.                               |
|      CENT = int NUMBER OF CENTER POINT.                                 |
|             THE NUMBERING CONVENTION FOR 'TARG' AND 'CENT' IS:          |
|                 1 = MERCURY         8 = NEPTUNE                         |
|                 2 = VENUS           9 = PLUTO                           |
|                 3 = EARTH          10 = MOON                            |
|                 4 = MARS           11 = SUN                             |
|                 5 = JUPITER        12 = SOLAR-SYSTEM BARYCENTER         |
|                 6 = SATURN         13 = EARTH-MOON BARYCENTER           |
|                 7 = URANUS         14 = NUTATIONS (intITUDE AND OBLIQ)  |
|                15 = LIBRATIONS, IF ON EPH FILE                          |
|               (IF NUTATIONS ARE WANTED, SET TARG = 14. FOR LIBRATIONS,  |
|               SET TARG = 15. 'CENT' WILL BE IGNORED ON EITHER CALL.)    |
+-------------------------------------------------------------------------+
| OUTPUTS:                                                                |
|       RRD = OUTPUT 6-WORD D.P. ARRAY CONTAINING POSITION AND VELOCITY   |
|             OF POINT 'TARG' RELATIVE TO 'CENT'. THE UNITS ARE AU AND    |
|             AU/DAY. FOR LIBRATIONS THE UNITS ARE RADIANS AND RADIANS    |
|             PER DAY. IN THE CASE OF NUTATIONS THE FIRST FOUR WORDS OF   |
|             RRD WILL BE SET TO NUTATIONS AND RATES, HAVING UNITS OF     |
|             RADIANS AND RADIANS/DAY.                                    |
|             NOTE: IN MANY CASES THE USER WILL NEED ONLY POSITION        |
|                   VALUES FOR EPHEMERIDES OR NUTATIONS. FOR              |
|                   POSITION-ONLY OUTPUT, THE int VARIABLE 'IPV'          |
|                   IN THE COMMON AREA /PLECOM/ SHOULD BE SET = 1         |
|                   BEFORE THE NEXT CALL TO PLEPH. (ITS DEFAULT           |
|                   VALUE IS 2, WHICH RETURNS BOTH POSITIONS AND          |
|                   RATES.)                                               |
|                                                                         |
|      INSIDE is .TRUE. if the input Julian Ephemeris Date (JD) is within |
|             the ephemeris time span.  If not, INSIDE is set to .FALSE.  |
+-------------------------------------------------------------------------+
| REFERENCE: JPL (Fortran code)                                           |
+========================================================================*/
int PLEPH0(FILE *fp_Bin,int n,double jd,int targ,int cent,
	   double *rrd, int *inside, double *jd2)
{
  /* INITIALIZED DATA: */
  double     fac =   0.;
  double embf[2] = { -1.,1. };
  double  pv[78] = { 0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
  static int  nemb = 1;
  static int FIRST = TRUE_;
  static int bsave;
  static double ve[2];

  /* DECLARATION: */
  int list[12] = { 0,0,0,0,0,0,0,0,0,0,0,0 };
  int llst[13] = { 1,2,10,4,5,6,7,8,9,10,11,11,3 };

  int l[2],tc[2],i,lme;
  double jed[2],jdtot;

  /* 1ST TIME IN, BE SURE EPHEMERIS IS INITIALIZED */
  if(FIRST)
    { FIRST=FALSE_;
    ve[0] = 1. / (HEADER.emrat + 1.);
    ve[1] = HEADER.emrat * ve[0];
    }

  if(n==1)
    { /* ENTRY POINT 'DPLEPH' FOR DOUBLY-DIMENSIONED TIME ARGUMENT */
      /* (SEE THE DISCUSSION IN THE SUBROUTINE STATE)              */
      jed[0] = jd2[0];
      jed[1] = jd2[1];
    }
  else
    { /* INITIALIZE JED FOR 'STATE' AND SET UP COMPONENT COUNT */
      jed[0] = jd;
      jed[1] = 0.;
    }

  jdtot = jed[0] + jed[1];

  if(jdtot < HEADER.ss[0] || jdtot > HEADER.ss[1])
    { *inside = FALSE_;
    return(0);
    }

  *inside = TRUE_;

  /* CHECK FOR NUTATION CALL */
  if(targ == 14)
    { if(HEADER.ipt[34] > 0)
      { list[10] = 2;
      STATE(fp_Bin,jed, list, pv, rrd);
      list[10] = 0;
      return(0);
      }
    else
      { printf("\n *** NO NUTATION ON THE EPHEMERIS FILE ***");
      exit(1);
      }
    }

  /* CHECK FOR LIBRATIONS */
  if(targ == 15)
    { if(HEADER.lpt[1] > 0)
      { list[11] = 2;
      STATE(fp_Bin,jed, list, pv,rrd);
      list[11] = 0;
      for(i = 1; i <= 6; ++i)
	rrd[i-1] = pv[i + 59];
      return(0);
      }
    else
      { printf("\n *** NO LIBRATIONS ON THE EPHEMERIS FILE ***");
      exit(1);
      }
    }

  /* CHECK FOR TARGET POINT = CENTER POINT */
  if(targ == cent)
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = 0.;
    return(0);
    }

  /* FORCE BARYCENTRIC OUTPUT BY 'STATE' */
  bsave = stcomm.bary;
  stcomm.bary = TRUE_;

  /* SET UP PROPER ENTRIES IN 'LIST' ARRAY FOR STATE CALL */
  tc[0] = targ;
  tc[1] = cent;
  lme = 0;

  for(i = 1; i <= 2; ++i)
    { l[i - 1] = llst[tc[i - 1] - 1];
    if( l[i - 1] < 11)list[l[i - 1] - 1] = 2;
    if(tc[i - 1] == 3)
      { lme = 3;
      fac = -ve[0];
      }
    else if( tc[i - 1] == 10)
      { lme = 10; fac = ve[1];}
    else if( tc[i - 1] == 13)
      { nemb = i; }
    }

  if((list[9] == 2) && (l[0] != l[1]))
    list[2] = 2 - list[2];

  /* MAKE CALL TO STATE */
  STATE(fp_Bin,jed, list, pv, rrd);

  /* CASE: EARTH-TO-MOON */
  if((targ == 10) && (cent == 3))
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = pv[i + 53];
    }
  /* CASE: MOON-TO-EARTH */
  else if((targ == 3) && (cent == 10))
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = -pv[i + 53];
    }
  /* CASE: EMBARY TO MOON OR EARTH */
  else if((targ == 13 || cent == 13) && list[9] == 2)
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = pv[i + 53] * fac * embf[nemb - 1];
    }
  /* OTHERWISE, GET EARTH OR MOON VECTOR AND THEN GET OUTPUT VECTOR */
  else
    { for(i = 1; i <= 6; ++i)
      { pv[i + 59] = stcomm.pvsun[i - 1];
      pv[i + 71] = pv[i + 11];
      if(lme > 0)
	pv[i + lme * 6 - 7] = pv[i + 11] + fac * pv[i + 53];
      rrd[i-1] = pv[i + targ*6 - 7] - pv[i + cent * 6 - 7];
      }
    }

  /* CLEAR 'STATE' BODY ARRAY AND RESTORE BARYCENTER FLAG */
  list[2] = 0;
  list[l[0] - 1] = 0;
  list[l[1] - 1] = 0;
  stcomm.bary = bsave;

  /*  THAT'S ALL */
  return(0);
} /* pleph0 */


/*========================================================================+
|                                PLEPH                                    |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+========================================================================*/
int PLEPH(FILE *fp_Bin,double jd,int targ,int cent,double *rrd,int *inside)
{
		return PLEPH0(fp_Bin,0,jd,targ,cent,rrd,inside,(double *)0);
}


/*========================================================================+
|                               DPLEPH                                    |
+=========================================================================+
| AUTOR: K. ARFA-KABOODVAND (Aero-Space Engineer)                         |
+========================================================================*/
int DPLEPH(FILE *fp_Bin,double *jd2,int targ,int cent,double *rrd)
{
		return PLEPH0(fp_Bin,1,(double)0,targ,cent,rrd,(int *)0,jd2);
}


/*
  MAIN PROGRAM 
*/
int main(int argv , char *argc[])
{
  /* VARIABLES FOR JPL COMPUTATION:*/
  FILE *fp_Bin;

  /* VARIABLES FOR TESTING:*/
  FILE *fp1,*fp2;
  char Name1[80], Name2[80], dump[80];

  /* VARIABLE DECLARATION: */
  int I,J,nctr,ntarg,ncoord,nvs,line,inside;
  double r[6],del,et,xi,jd2;

  /* INITIAL THE CONSTANTS: */
  fp_Bin=INITIAL(argc[1]);

  /* READ THE NAME OF THE TESTING FILE: */
  printf("*** Name of testing file   = %s\n", argc[2]);
  strcpy(Name1, argc[2]);

  printf("*** Name of resulting file = %s\n", argc[3]);
  strcpy(Name2, argc[3]);

  /* LET THE USER KNOW WHAT THE CONSTANTS ARE: */
  PRINTOUT();

  /* READ THE TESTING FILE AND SKIP THE HEADER COMMENTS: */

  fprintf(stderr, "open %s\n", Name1);
  if((fp1 = fopen(Name1,"r")) == NULL)
    { fprintf(stderr, "Cannot open %s file.\n", Name1);
    return 1;
    };

  while(strcmp(dump,"EOT" )!= 0)
    { fscanf(fp1,"%3s\n",dump);}

  fprintf(stderr, "open %s\n", Name2);
  /* OPEN THE RESULTING FILE: */
  if((fp2 = fopen(Name2,"w")) == NULL)
    { fprintf(stderr, "Cannot open %s file.\n", Name2);
    return 1;
    };

  fprintf(fp2,"  line       jed    t   c  x              difference");
  /* Go through each of the test cases.  If a test case is for a time not */
  /* in JPL-EPHEMERIDS-FILE just keep going.                              */
  line = 0;
  inside = FALSE_;

  printf("\n");

  for(;;)
    { GO2POS(fp1,15);
    fscanf(fp1,"%lg",&et);
    fscanf(fp1,"%d",&ntarg);
    fscanf(fp1,"%d",&nctr);
    fscanf(fp1,"%d",&ncoord);
    fscanf(fp1,"%lg\n",&xi);

    if(et >= HEADER.ss[1])break;

    if(feof(fp1))
      break;

    /* Where does the ephemeris think things should be? */
    PLEPH(fp_Bin,et,ntarg,nctr,r,&inside);

    if(inside)
      { /* Epoch is spanned by the ephemeris, how far off are we? */
	del = r[ncoord - 1] - xi;
	++line;

	/* Print out results for every 100th line. */
	fprintf(stderr, "\n%+6d %+12.2f %2d %2d %2d %+30.18g",line,et,ntarg,
	       nctr,ncoord,del);
	fprintf(fp2,"\n%+6d %+12.2f %2d %2d %2d %+30.18g",line,et,ntarg,
		nctr,ncoord,del);

	/* Print out WARNING if difference greater than tolerance. */
	if(fabs(del) >= 1e-13)
	  { printf("\nERROR: %6d %20.13g %20.13g",line,et,del);
	  //WAIT;
	  }
      }
    }
  printf("\n");

  free_Cmatrix(HEADER.cnam,1,1);
  free_dvector(HEADER.cval,1);
  free_dvector(epib.buf,1);

  fclose(fp1);
  fclose(fp2);
  fclose(fp_Bin);
  return 0;

} /* MAIN__ */




