#include "pleph.H"

/* Common Block Declarations */
struct { char **cnam;
  double *cval,ss[3],au,emrat;
  int denum, ncon, ipt[36],lpt[3],ksize;
} HEADER;

struct { double *buf;}epib;
struct { int km, bary;
  double pvsun[6];
} stcomm;

int const2 = 2;
int const3 = 3;

void ERROR(int i,char *msg)
{
  fprintf(stderr,"\n\n...Run-time error...");
  fprintf(stderr,"\n%d %s",i,msg);
  fprintf(stderr,"\n...now exiting to system...");
  exit(1);
}

void free_dvector(double *v,int nl)
{
  free((char *) (v+nl-1));
}


void free_Cmatrix(char **m, int nrl, int ncl)
/* Free a double matrix allocated by dmatrix() : */
{
  free((char*) (m[nrl]+ncl-1));
  free((char*) (m+nrl-1));
}


double *dvector(int nl,int nh)
{
  double *v;

  v=(double *)malloc((size_t) ((nh-nl+1+1)*sizeof(double)));
  if (!v)
    ERROR(0,"allocation failure in dvector()");
  return v-nl+1;
}

char **Cmatrix(int nrl, int nrh, int ncl, int nch)
{
  int i, nrow=nrh-nrl+1,ncol=nch-ncl+1;
  char **m;

  /* Allocate pointers to rows: */
  m=(char **) malloc((size_t)((nrow+1)*sizeof(char*)));
  if (!m)
    ERROR(0,"allocation failure 1 in matrix()");
  m += 1;
  m -= nrl;

  /* Allocate rows and set pointers to them: */
  m[nrl]=(char *) malloc((size_t)((nrow*ncol+1)*sizeof(char)));
  if (!m[nrl])
    ERROR(0,"allocation failure 2 in matrix()");
  m[nrl] += 1;
  m[nrl] -= ncl;

  for(i=nrl+1;i<=nrh;i++)
    m[i]=m[i-1]+ncol;

  /* Return pointer to array of pointers to rows : */
  return m;
}


FILE *INITIAL(char *Name)
{
  long SIZE;
  int  I;
  FILE *fp_Bin;

  /* READ THE SIZE AND NUMBER OF MAIN EPHEMERIS: */
  if((fp_Bin = fopen(Name,"rb")) == NULL)
    { fprintf(stderr, "Cannot open %s file.\n",Name);
    exit(1);
    };

  fseek(fp_Bin,-1L*sizeof(int),SEEK_END);
  fread(&HEADER.ncon,sizeof(int),1, fp_Bin);
  SIZE=-42L*sizeof(int)-2L*sizeof(double)-3L*sizeof(double)-
    (long)HEADER.ncon*(sizeof(double)+9L*sizeof(char));
  fseek(fp_Bin,SIZE,SEEK_END);

  /* READ THE SIZE AND NUMBER OF MAIN EPHEMERIS: */
  fread(&HEADER.ksize,sizeof(int),1, fp_Bin);

  /* READ THE NUMBER AND NAMES OF CONSTANTS: (GROUP 1040/4):*/
  HEADER.cnam = Cmatrix(1,HEADER.ncon,0,8);
  for(I=1;I<=HEADER.ncon;++I)
    fread(HEADER.cnam[I],9,1,fp_Bin);

  /* READ NUMBER OF VALUES AND VALUES (GROUP 1041/4): */
  HEADER.cval = dvector(1,HEADER.ncon);
  for(I = 1;I <= HEADER.ncon; ++I)
    fread(&HEADER.cval[I],sizeof(double),1, fp_Bin);

  for(I=0;I<=2;++I)
    fread(&HEADER.ss[I],sizeof(double),1, fp_Bin);

  fread(&HEADER.au,sizeof(double),1, fp_Bin);
  fread(&HEADER.emrat,sizeof(double),1, fp_Bin);
  fread(&HEADER.denum,sizeof(int),1, fp_Bin);

  /* READ POINTERS NEEDED BY INTERP (GROUP 1050): */
  for(I = 0;I <= 35; ++I)
    fread(&HEADER.ipt[I],sizeof(int),1, fp_Bin);

  for(I=0;I<=2;++I)
    fread(&HEADER.lpt[I],sizeof(int),1, fp_Bin);

  epib.buf=dvector(1,HEADER.ksize);

  return(fp_Bin);
}

double Dint(double x)
{ return( (x>0) ? floor(x) : -floor(-x) );}

int SPLIT(double tt,double *fr)
{
  /* Function Body */
  fr[0] = Dint(tt);
  fr[1] = tt - fr[0];
  if(tt < 0. && fr[1] != 0.)
    { /* Make adjustments for negative input number. */
      fr[0] += -1.;
      fr[1] += 1.;
    }
  return 0;
}


double Dmod(double x,double y)
{
  double quotient;

  quotient = x / y;
  if(quotient >= 0)
    quotient = floor(quotient);
  else
    quotient = -floor(-quotient);
  return(x - y * quotient );
}


int INTERP(double *buf,double *t,int ncf,int ncm,int na,int fl,double *pv)
{
  /* Initialized data */
  static int np = 2;
  static int nv = 3;
  static double twot = 0.;
  static double pc[18] = {1.,0.,0.,0.,0.,0.,0.,0.,0.,
			  0.,0.,0.,0.,0.,0.,0.,0.,0.};
  static double vc[18] = { 0.,1.,0.,0.,0.,0.,0.,0.,0.,
			   0.,0.,0.,0.,0.,0.,0.,0.,0.};

  /* Local variables */
  double vfac, temp;
  int    i, j, l;
  double tc, dt1, dna;

  /* ENTRY POINT. GET CORRECT SUB-INTERVAL NUMBER FOR THIS SET */
  /* OF COEFFICIENTS AND THEN GET NORMALIZED CHEBYSHEV TIME    */
  /* WITHIN THAT SUBINTERVAL.                                  */
  dna = (double)na;
  dt1 = Dint(t[0]);
  temp = dna * t[0];

  // hefa edit
  //l = (Dint)(temp - dt1) + 1;
  l = (int) (Dint)(temp - dt1) + 1;

  /* TC IS THE NORMALIZED CHEBYSHEV TIME (-1 .LE. TC .LE. 1) */
  tc = (Dmod(temp, 1.) + dt1) * 2. - 1.;

  /* CHECK TO SEE WHETHER CHEBYSHEV TIME HAS CHANGED,    */
  /* AND COMPUTE NEW POLYNOMIAL VALUES IF IT HAS.        */
  /* (THE ELEMENT PC(2) IS THE VALUE OF T1(TC) AND HENCE */
  /* CONTAINS THE VALUE OF TC ON THE PREVIOUS CALL.)     */
  if(tc != pc[1])
    { np = 2;
    nv = 3;
    pc[1] = tc;
    twot = tc + tc;
    }

  /* BE SURE THAT AT LEAST 'NCF' POLYNOMIALS HAVE BEEN EVALUATED */
  /* AND ARE STORED IN THE ARRAY 'PC'.                           */
  if(np < ncf)
    { for(i = np + 1; i <= ncf; ++i)
      pc[i - 1] = twot * pc[i - 2] - pc[i - 3];
    np = ncf;
    }

  /* INTERPOLATE TO GET POSITION FOR EACH COMPONENT */
  for(i = 1; i <= ncm; ++i)
    { pv[i-1] = 0.;
    for(j = ncf; j >= 1; --j)
      pv[i-1]+=pc[j-1]*buf[j-1+(i-1+(l-1)*ncm)*ncf];
    }
  if (fl <= 1)
    return 0;

  /* IF VELOCITY INTERPOLATION IS WANTED, BE SURE ENOUGH    */
  /* DERIVATIVE POLYNOMIALS HAVE BEEN GENERATED AND STORED. */
  vfac = (dna + dna) / t[1];
  vc[2] = twot + twot;
  if(nv < ncf)
    { for (i = nv + 1; i <= ncf; ++i)
      vc[i-1]=twot*vc[i-2]+pc[i-2]+pc[i-2]-vc[i-3];
    nv = ncf;
    }

  /* INTERPOLATE TO GET VELOCITY FOR EACH COMPONENT */
  for(i = 1; i <= ncm; ++i)
    { pv[i-1+ncm] = 0.;
    for (j =ncf; j >= 2; --j)
      pv[i-1+ncm]+=vc[j-1]*buf[j-1+(i-1+(l-1)*ncm)*ncf];
    pv[i-1+ncm] *= vfac;
    }
  return 0;
}


int STATE(FILE *fp_Bin,double *jed,int *list,double *pv,double *nut)
{
  /* Initialized data */
  static double aufac  = 1.;
  static int FIRST = TRUE_;
  static long nrl  = 0L;
  static double t[2];

  /* Local variables */
  int i, j, k;
  double s,jd[4];
  long nr;

  /* 1ST TIME IN, GET POINTER DATA, ETC., FROM EPH FILE */
  if(FIRST)
    { FIRST = FALSE_;
    if(stcomm.km)
      { t[1] = HEADER.ss[2] * 86400.;}
    else
      { t[1] = HEADER.ss[2];
      aufac = 1. / HEADER.au;
      }
    }

  /* MAIN ENTRY POINT -- CHECK EPOCH AND READ RIGHT RECORD */
  s = jed[0] - .5;
  SPLIT(s, &jd[0]);
  SPLIT(jed[1], &jd[2]);
  jd[0] = jd[0] + jd[2] + .5;
  jd[1] += jd[3];
  SPLIT(jd[1], &jd[2]);
  jd[0] += jd[2];

  /* ERROR RETURN OF EPOCH OUT OF RANGE */
  if((jd[0] < HEADER.ss[0]) || ((jd[0] + jd[3]) > HEADER.ss[1]))
    { printf("\n STATE: Epoch out of range.");
    exit(1);
    }

  /* CALCULATE RECORD # AND RELATIVE TIME IN INTERVAL */
  nr  = (long) ((jd[0] - HEADER.ss[0]) / HEADER.ss[2])+1;
  if(jd[0]==HEADER.ss[1])
    --nr;

  t[0]= ((jd[0]-((double)(nr-1)*HEADER.ss[2]+HEADER.ss[0]))+jd[3])/
    HEADER.ss[2];

  /* READ CORRECT RECORD IF NOT IN CORE */
  if(nr != nrl)
    { fseek(fp_Bin,(long)(nr-1)*HEADER.ksize*sizeof(double),SEEK_SET);
    nrl = nr;
    for(k=1;k<=HEADER.ksize;++k)
      fread(&epib.buf[k],sizeof(double),1, fp_Bin);
    }

  /* INTERPOLATE SSBARY SUN */
  INTERP(&epib.buf[HEADER.ipt[10]],t,HEADER.ipt[22],const3,
	 HEADER.ipt[34],const2,stcomm.pvsun);

  for(i = 1; i <= 6; ++i)
    stcomm.pvsun[i - 1] *= aufac;

  /* CHECK AND INTERPOLATE WHICHEVER BODIES ARE REQUESTED */
  for(i = 1; i <= 10; ++i)
    { if(list[i-1] > 0)
      { if(HEADER.ipt[11+i] <= 0)
	ERROR(i, "th body requested - not on file");
      INTERP(&epib.buf[HEADER.ipt[i-1]],t,HEADER.ipt[11+i],
	     const3,HEADER.ipt[23+i],list[i-1],&pv[(i-1)*6]);
      for(j = 1; j <= list[i-1] * 3; ++j)
	{ if(i <= 9 && !stcomm.bary)
	  pv[6*i-7+j]=pv[6*i-7+j]*aufac-stcomm.pvsun[j-1];
	else
	  pv[j +6*i -7] *= aufac;

	}
      }
    }

  /* DO NUTATIONS IF REQUESTED (AND IF ON FILE) */
  if(list[10] > 0 && HEADER.ipt[23] > 0)
    INTERP(&epib.buf[HEADER.ipt[11]],t,HEADER.ipt[23],const2,
	   HEADER.ipt[35],list[10],&nut[0]);

  /* GET LIBRATIONS IF REQUESTED (AND IF ON FILE) */
  if(HEADER.lpt[1] > 0 && list[11] > 0)
    INTERP(&epib.buf[HEADER.lpt[0]],t,HEADER.lpt[1],const3,
	   HEADER.lpt[2],list[11],&pv[60]);

  /* THAT'S ALL */
  return 0;

} /* state_ */


int PLEPH0(FILE *fp_Bin,int n,double jd,int targ,int cent,
	   double *rrd, int *inside, double *jd2)
{
  /* INITIALIZED DATA: */
  double     fac =   0.;
  double embf[2] = { -1.,1. };
  double  pv[78] = { 0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,
		     0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
  static int  nemb = 1;
  static int FIRST = TRUE_;
  static int bsave;
  static double ve[2];

  /* DECLARATION: */
  int list[12] = { 0,0,0,0,0,0,0,0,0,0,0,0 };
  int llst[13] = { 1,2,10,4,5,6,7,8,9,10,11,11,3 };

  int l[2],tc[2],i,lme;
  double jed[2],jdtot;

  /* 1ST TIME IN, BE SURE EPHEMERIS IS INITIALIZED */
  if(FIRST)
    { FIRST=FALSE_;
    ve[0] = 1. / (HEADER.emrat + 1.);
    ve[1] = HEADER.emrat * ve[0];
    }

  if(n==1)
    { /* ENTRY POINT 'DPLEPH' FOR DOUBLY-DIMENSIONED TIME ARGUMENT */
      /* (SEE THE DISCUSSION IN THE SUBROUTINE STATE)              */
      jed[0] = jd2[0];
      jed[1] = jd2[1];
    }
  else
    { /* INITIALIZE JED FOR 'STATE' AND SET UP COMPONENT COUNT */
      jed[0] = jd;
      jed[1] = 0.;
    }

  jdtot = jed[0] + jed[1];

  if(jdtot < HEADER.ss[0] || jdtot > HEADER.ss[1])
    { *inside = FALSE_;
  cerr << "jdtot=" << jdtot << " Header = " <<  HEADER.ss[0] << " " <<  HEADER.ss[1] << "\n";
    return(0);
    }


  *inside = TRUE_;

  /* CHECK FOR NUTATION CALL */
  if(targ == 14)
    { if(HEADER.ipt[34] > 0)
      { list[10] = 2;
      STATE(fp_Bin,jed, list, pv, rrd);
      list[10] = 0;
      return(0);
      }
    else
      { printf("\n *** NO NUTATION ON THE EPHEMERIS FILE ***");
      exit(1);
      }
    }

  /* CHECK FOR LIBRATIONS */
  if(targ == 15)
    { if(HEADER.lpt[1] > 0)
      { list[11] = 2;
      STATE(fp_Bin,jed, list, pv,rrd);
      list[11] = 0;
      for(i = 1; i <= 6; ++i)
	rrd[i-1] = pv[i + 59];
      return(0);
      }
    else
      { printf("\n *** NO LIBRATIONS ON THE EPHEMERIS FILE ***");
      exit(1);
      }
    }

  /* CHECK FOR TARGET POINT = CENTER POINT */
  if(targ == cent)
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = 0.;
    return(0);
    }

  /* FORCE BARYCENTRIC OUTPUT BY 'STATE' */
  bsave = stcomm.bary;
  stcomm.bary = TRUE_;

  /* SET UP PROPER ENTRIES IN 'LIST' ARRAY FOR STATE CALL */
  tc[0] = targ;
  tc[1] = cent;
  lme = 0;

  for(i = 1; i <= 2; ++i)
    { l[i - 1] = llst[tc[i - 1] - 1];
    if( l[i - 1] < 11)list[l[i - 1] - 1] = 2;
    if(tc[i - 1] == 3)
      { lme = 3;
      fac = -ve[0];
      }
    else if( tc[i - 1] == 10)
      { lme = 10; fac = ve[1];}
    else if( tc[i - 1] == 13)
      { nemb = i; }
    }

  if((list[9] == 2) && (l[0] != l[1]))
    list[2] = 2 - list[2];

  /* MAKE CALL TO STATE */
  STATE(fp_Bin,jed, list, pv, rrd);

  /* CASE: EARTH-TO-MOON */
  if((targ == 10) && (cent == 3))
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = pv[i + 53];
    }
  /* CASE: MOON-TO-EARTH */
  else if((targ == 3) && (cent == 10))
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = -pv[i + 53];
    }
  /* CASE: EMBARY TO MOON OR EARTH */
  else if((targ == 13 || cent == 13) && list[9] == 2)
    { for(i = 1; i <= 6; ++i)
      rrd[i-1] = pv[i + 53] * fac * embf[nemb - 1];
    }
  /* OTHERWISE, GET EARTH OR MOON VECTOR AND THEN GET OUTPUT VECTOR */
  else
    { for(i = 1; i <= 6; ++i)
      { pv[i + 59] = stcomm.pvsun[i - 1];
      pv[i + 71] = pv[i + 11];
      if(lme > 0)
	pv[i + lme * 6 - 7] = pv[i + 11] + fac * pv[i + 53];
      rrd[i-1] = pv[i + targ*6 - 7] - pv[i + cent * 6 - 7];
      }
    }

  /* CLEAR 'STATE' BODY ARRAY AND RESTORE BARYCENTER FLAG */
  list[2] = 0;
  list[l[0] - 1] = 0;
  list[l[1] - 1] = 0;
  stcomm.bary = bsave;

  /*  THAT'S ALL */
  return(0);
} /* pleph0 */


int PLEPH(FILE *fp_Bin,double jd,int targ,int cent,double *rrd,int *inside)
{
  return PLEPH0(fp_Bin, 0, jd, targ, cent, rrd, inside, (double *)0);
}


int DPLEPH(FILE *fp_Bin,double *jd2,int targ,int cent,double *rrd)
{
  return PLEPH0(fp_Bin,1,(double)0,targ,cent,rrd,(int *)0,jd2);
}

void freeall(void)
{
  //free_Cmatrix(HEADER.cnam,1,1);
  // Ob diese nderung richtig ist ?
  free_Cmatrix(HEADER.cnam,1,0);
  free_dvector(HEADER.cval,1);
  free_dvector(epib.buf,1);
}
