char *HILFESTR =
"     Das Datumsprogramm fr den Raytracer\n                Version 0.1\n\nWenn ich %s, \ndas Programm (oder eine darauf basierende \nArbeit) modifiziere oder verbreite, erklre ich \nmein Einverstndnis mit dieser Lizenz und allen \nihren Begriffen und Bedingungen zum Kopieren, \nVerbreiten und Modifizieren des Programms oder \neiner darauf basierenden Arbeit.\n\nThis program ist free software; you can redistribute \nist and/or modify it under the terms of the GNU \nGeneral Public License as publisched by the Free \nSoftware Foundation; either version 2 of the License, \nor (at your opption) any later version.\n\nThis program is distributed in the hope that it well \nbe useful, but WITHOUT ANY WARRANTY; without even the \nimplied warranty of MERCHANTABILITY or FITNESS FOR A \nPARTICULAR PURPOSE. See the GNU General Public License \nfor more details.\n\nYou should have received a copy of the GNU General \nPublic License along with this program; if not, write \nto the Free Software Foundation, Inc., 675 Mass Ave, \nCambridge, MA 02139, USA.\n\nDie GPL finden Sie in der HTML-Dokumentation.\n\nCopyright (C) 1996 Helmut Fahrion\n\nAls Student (ev. bis Januar 1997) bin ich erreichbar \nunter:\n   sfa2002@informatik.htw-dresden.de\n\nIn Verbindung mit dem Softwareprojekt:\n   nazca@vermessung.htw-dresden.de\n\nPost:\n   Helmut Fahrion jun.\n   An der Wyhra 35\n   04552 Borna\n   Germany\n";

#include <iostream.h>
#include <stdlib.h>
#include <unistd.h>		// getlogin
#include <pwd.h>

#include <Xm/XmAll.h>

/* Vektorrechnung */
#include "vect.H"
#include "planeten.H"
#include "pleph.H"

typedef char *STRING;		/* C - String */

typedef enum
  {
    IM_ENDE,
    IM_DOKU, IM_README, IM_HINWEIS,
    IM_QSTART, IM_QOK
  };

typedef enum
  {
    QB_ENDE, QB_HILFE, LETZTE_PD
  };

typedef enum
  {
    QB_QOK, LETZTE_QUICK
  };

typedef enum
  {
    QB_IM_ENDE, LETZTE_ENDE
  };
typedef enum
  {
    QB_IM_DOKU, QB_IM_README, QB_IM_HINWEIS, LETZTE_HILFE
  };

XtAppContext app;
Widget top, WHelpDialog, DateWText, WLabel1, WLabel2;
char datumstr[80], zeitindatum[80], zeitinjulian[80];

/*  Prototypen */
void helpfiledialog (Widget Parent, char *str);

/* Matrix in der die richtigen Positionen der Planeten in Bezug */
/* zum Schnittpunkt der Koordinatenachsen */
vector star_pos[11], star_gesch[11], star_erg[11];


void showhinweis (void)
{
  char text[3072], *un;		/* Puffer fr Text */
  char anonymous[] = "ANONYMOUS";
  struct passwd *pwd;

  if (!(pwd = getpwuid (getuid ())))
    un = anonymous;
  else
    un = pwd->pw_gecos;

  if (!strlen (un))
    un = pwd->pw_name;		/* 0 Lnge in passwd */
  if (!strlen (un))
    un = anonymous;		/* 0 Lnge in passwd */

  sprintf (text, HILFESTR, un);
  helpfiledialog (top, text);
}

/* Callback function to quit the program. */
void CBquit (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtDestroyWidget (top);
  exit (0);
}

/* Callback function to quit the program. */
void 
CBhilfe (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  switch (*(int *) pClientData)
    {
    case IM_DOKU:
      system ("cad_mosaic&");
      break;
    case IM_README:
      system ("cad_liesmich&");
      break;
    case IM_HINWEIS:
      // helpfiledialog(top, HILFESTR);
      showhinweis ();
      break;
    default:
      fprintf (stderr, "Falsche Menue-ID!\n");
    }
}

/* ++++++++++++++++++++ Kalenderrechnung ++++++++++++++++++ */

void wnachv (vector * p, vector w)
{
  *p = vector (cos (w.x), cos (w.y), cos (w.z));

  // Normalisieren, ansonsten steht der Vektor in einer
  // Kugel vom Radius 1!
  *p /= abs (*p);
}

/* ###############################
   X-Achse ist 0 Meridian Aequator
   Z-Achse geht durch Nordpol
   Y-Achse rechtwinklig zu beiden
   ############################### */
void calc_pos (void)
{
  // Pure Annahmen!
  //     Null-Richtung     Normalvektor des Standpunktes         
  vector v (1.0, 0.0, 0.0), z (0.0, 0.0, 0.0);
  int planet;

  for (planet = 0; planet < SONNE; planet++)
    {
      // init
      star_erg[planet] = v;

      // auch Mglich, Drehung def. als Winkel zum Vektor
      wnachv (&star_erg[planet], star_pos[planet]);

      // drehung um die Koordinatenachsen
      //rotation(&star_erg[planet], vector(0.0, 0.0, 0.0), star_pos[planet]);

      // Verschiebung kann entfallen, da es sich um eine Richtung handelt!!!
      // star_erg[planet] += move;

      // Drehung zum Normalvektor des Standpunktes auf der Erdkugel
      rotationVN (&star_erg[planet], z);


      // Tests
      if (abs (star_erg[planet]) > 1.0 + eps4)
	cerr << "Interner Fehler, Vektor lnger als 1! Planet: " << planet << "\n";
    }
};

/* Berechne Wochentag */
int 
wochentag (int day, int month, int year)
{
  int century, yr, dw;

  if (month < 3)
    {
      month += 10;
      year--;
    }
  else
    month -= 2;
  century = year / 100;
  yr = year % 100;
  dw = (((26 * month - 2) / 10) + day + yr + (yr / 4) +
	(century / 4) - (2 * century)) % 7;

  if (dw < 0)
    dw += 7;

  // Umrechnung Deutsche Woche
  if (dw == 0)
    dw = 7;

  return --dw;
}

/* Funktionierende Fortran Routine */
/*
   JUDATE BERECHNET DAS JULIANISCHE DATUM
   BEI GEGEBENEN GREGORIANISCHEN DATUM
   I=JAHR,  J=MONAT K=TAG DES MONATS

   GUELTIG FUER 12 UHR MITTAGS 
 */
double judate(long int J, long int K, long int I)
{
  return (K - 32075 + 1461 * (I + 4800 + (J - 14) / 12) / 4 + 367 * (J - 2 - (J - 14) /
		12 * 12) / 12 - 3 * ((I + 4900 + (J - 14) / 12) / 100) / 4);
}

double set(int j, int m, int t, int s, int min)
{
  // int    monate[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
  char *tagestr[] =
  {"Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"};
  char ju[80];

  int wt;
  // julianisches Datum 
  double JUDATE;


  XmString anzstr;
  Arg Aargs;

  // 12.00 Uhr Mittags
  JUDATE = judate (m, t, j);

  /* addition der Stunden und Minuten */
  JUDATE += (float) s / 24.0 + (float) min / 24.0 / 60.0;

  wt = wochentag (t, m, j);
  sprintf (zeitindatum, "%s %d.%d.%d %d.%d", tagestr[wt], t, m, j, s, min);
  sprintf (zeitinjulian, "%0.2f", JUDATE);

  sprintf (ju, "Julian: %s", zeitinjulian);
  anzstr = XmStringCreateLtoR (ju, XmSTRING_DEFAULT_CHARSET);
  XtSetArg (Aargs, XmNlabelString, anzstr);
  XtSetValues (WLabel2, &Aargs, 1);

  anzstr = XmStringCreateLtoR (zeitindatum, XmSTRING_DEFAULT_CHARSET);
  XtSetArg (Aargs, XmNlabelString, anzstr);
  XtSetValues (WLabel1, &Aargs, 1);
  
  return JUDATE;
}

/* Callback function to quit the program. */
void CBQButton (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  char tage[80];
  byte planet;

  double jd;
  double rrg[6];
  int    inside;

  FILE *D;

  STRING str;
  int tag, monat, jahr, stunde, minute;

  // Text in Zahlen umwandeln
  str = XmTextGetString (DateWText);
  sscanf (str, "%d.%d.%d %d.%d", &tag, &monat, &jahr, &stunde, &minute);

  jd = set(jahr, monat, tag, stunde, minute);

  /*
 // ++++++++++++++++++++++++
  // schreibe Datenfile fr "writepos"
  if ((D = fopen ("star_data", "w+")) == NULL)
    {
      cerr << "datem: Fehler beim ffnen der Datei 'star_data'\n";
      exit (1);
    }

  sscanf (zeitinjulian, "%s d\n", tage);

  // Stelligkeit mu exakt eingehalten werden
  //   sonst reagiert das Fortranprogramm falsch
  for (planet = 1; planet <= SONNE; planet++)
    fprintf (D, "%s%3d%3d\n", tage, planet, ERDE);

  fclose (D);

  // starte Berechnung ber das Fortran-Programm, nicht im Hintergrund!
  system ("star_start");

  // lese Ergebnis ein
  if ((D = fopen ("star_erg", "r+")) == NULL)
    {
      cerr << "xdata: Fehler beim ffnen der Datei 'star_erg'\n";
      exit (1);
    }
    
  for (planet = 0; planet < SONNE; planet++)
    {
      fscanf (D, "%f %f %f %f %f %f\n",
	      &star_pos[planet].x, &star_pos[planet].y, &star_pos[planet].z,
       &star_gesch[planet].x, &star_gesch[planet].y, &star_gesch[planet].z);
      calc_pos ();
    }
  fclose (D);
  ++++++++++++++++++++++++++++
*/

  /*
  if ((D = fopen ("ephbin", "rb")) == NULL)
    {
      cerr << "datem: Fehler beim ffnen der Datei 'ephbin'\n";
      return;
    }
    */

  D = INITIAL("/opt/eph/ephbin");

  fprintf(stderr, "\njd= %f\n", jd);

  inside = false;
  
  for (planet = 1; planet <= SONNE; planet++)
    {
      //                          ERDE
      PLEPH(D, (double)jd, planet, 3, rrg, &inside);

      if (!inside)
	cerr << "Julianisches Datum ist nicht in der mglichen Zeitspanne!\n";

      star_pos[planet]   = vector(rrg[0], rrg[1], rrg[2]);
      star_gesch[planet] = vector(rrg[3], rrg[4], rrg[5]);

      fprintf(stderr, "%f %f %f\n", rrg[0], rrg[1], rrg[2]);

      calc_pos ();
    }

  freeall();
  fclose(D);

  // schreibe Kommandofile
  if ((D = fopen ("./star_pos", "w+")) == NULL)
    {
      cerr << "datem: Fehler beim ffnen der Datei 'star_pos'\n";
      return;
    }

  /* die Reihenfolge ist in #define Anweisungen */
  /* festgelegt */
  /* Planeten von Sonne bis Pluto dann Mond und Sonne */
  for (planet = 0; planet < SONNE; planet++)
    fprintf (D, "%e %e %e\n", star_erg[planet].x, star_erg[planet].y, star_erg[planet].z);

  fclose (D);
}


int 
main (int argc, char *argv[])
{
  STRING AIPulldown[] =
  {"ende", "hilfe"};
  STRING AICascade[] =
  {"Ende", "Hilfe"};
  STRING AIEnde[] =
  {"Ende"};
  STRING AIHilfe[] =
  {"Doku", "README", "Hinweis"};
  STRING AIQButtons[] =
  {"OK"};

  static int AiEndeMenuID[] =
  {IM_ENDE};
  static int AiHilfeMenuID[] =
  {IM_DOKU, IM_README, IM_HINWEIS};
  static int AiQButtonsID[] =
  {IM_QOK};

  Widget WMenuBar, AWPulldown[LETZTE_PD], AWCascade[LETZTE_PD], AWEnde[LETZTE_ENDE],
    AWHilfe[LETZTE_HILFE], AWButtons[LETZTE_QUICK], WRowCol, WQBox, QWframe;

  Arg Aargs[5];
  int x, nArgs;

  top = XtVaAppInitialize (&app, "XMDate", NULL, 0, &argc, argv, NULL, NULL);

  WRowCol = XmCreateRowColumn (top, "rowcol", NULL, 0);
  XtManageChild (WRowCol);

  /* 1. MenuBar mit PulldownMenu als Kind erzeugen */
  WMenuBar = XmCreateMenuBar (WRowCol, "menubar", NULL, 0);
  XtVaSetValues (WMenuBar, XmNtopAttachment, XmATTACH_FORM, XmNleftAttachment, XmATTACH_FORM,
		 XmNrightAttachment, XmATTACH_FORM, NULL);
  XtManageChild (WMenuBar);


  /* Pulldowns erzeugen */
  for (x = 0; x < LETZTE_PD; x++)
    AWPulldown[x] = XmCreatePulldownMenu (WMenuBar, AIPulldown[x], NULL, 0);

  /* 2. PulldownMens an CascadeButtons binden */
  for (x = 0; x < LETZTE_PD; x++)
    {
      nArgs = 0;
      XtSetArg (Aargs[nArgs], XmNsubMenuId, AWPulldown[x]);
      nArgs++;
      AWCascade[x] = XmCreateCascadeButton (WMenuBar, AICascade[x], Aargs, nArgs);
    }

  /* Hilfe Menue steht ganz rechts */
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNmenuHelpWidget, (XtArgVal) AWCascade[x - 1]);
  nArgs++;
  XtSetValues (WMenuBar, Aargs, nArgs);
  XtManageChildren (AWCascade, x);


  for (x = 0; x < LETZTE_ENDE; x++)
    {
      AWEnde[x] = XmCreatePushButton (AWPulldown[0], AIEnde[x], NULL, 0);
      XtAddCallback (AWEnde[x], XmNactivateCallback, (XtCallbackProc) CBquit, &AiEndeMenuID[x]);
    }
  XtManageChildren (AWEnde, x);


  for (x = 0; x < LETZTE_HILFE; x++)
    {
      AWHilfe[x] = XmCreatePushButton (AWPulldown[1], AIHilfe[x], NULL, 0);
      XtAddCallback (AWHilfe[x], XmNactivateCallback, (XtCallbackProc) CBhilfe, &AiHilfeMenuID[x]);
    }
  XtManageChildren (AWHilfe, x);


  QWframe = XtCreateManagedWidget ("quickframe", xmFrameWidgetClass, WRowCol, NULL, 0);

  WQBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWframe,
				   XmNorientation, XmHORIZONTAL, XmNpacking,
				   XmPACK_COLUMN, NULL);

  for (x = 0; x < LETZTE_QUICK; x++)
    {
      AWButtons[x] =
	XtCreateManagedWidget (AIQButtons[x], xmPushButtonWidgetClass, WQBox, NULL, 0);
      XtAddCallback (AWButtons[x], XmNactivateCallback, (XtCallbackProc) CBQButton, &AiQButtonsID[x]);
    }

  // Datum
  Widget QWposframe, WQposBox;

  QWposframe = XtCreateManagedWidget ("posframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQposBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWposframe,
				   XmNorientation, XmHORIZONTAL, XmNpacking,
				      XmPACK_COLUMN, NULL);
  sprintf (datumstr, "24.10.1965 02.03");
  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNvalue, datumstr);
  nArgs++;
  DateWText = XtCreateManagedWidget ("datum", xmTextWidgetClass, WQposBox, Aargs, nArgs);

  // Label
  Widget QWlabframe, WQlabBox;

  QWlabframe = XtCreateManagedWidget ("labframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WQlabBox = XtVaCreateManagedWidget ("qbox", xmRowColumnWidgetClass, QWlabframe,
				      XmNorientation, XmVERTICAL, XmNpacking,
				      XmPACK_COLUMN, NULL);

  WLabel1 = XtCreateManagedWidget ("So 24.10.1965 2.3", xmLabelWidgetClass, WQlabBox, NULL, 0);
  WLabel2 = XtCreateManagedWidget ("Julian: 2439058.00", xmLabelWidgetClass, WQlabBox, NULL, 0);

  /* Hauptprogramm */
  XtRealizeWidget (top);
  XtAppMainLoop (app);		// Endlosschleife

  /* UNREACHABLE */
  return (0);
}


/* ******** ffnet eine Textbox als Hilfetext ******** */

void 
CBHelpOk (Widget W, caddr_t pClientData, caddr_t pCallData)
{
  XtUnmanageChild (WHelpDialog);
  WHelpDialog = NULL;
}

void 
helpfiledialog (Widget Parent, char *str)
{
  Arg Aargs[5];
  int nArgs;

  Widget WButtonOK, WRowCol, WRowCol2, helptext, Wframe;

  WHelpDialog = XmCreateDialogShell (Parent, "helpfiledialog", NULL, 0);
  XtManageChild (WHelpDialog);

  WRowCol = XtVaCreateManagedWidget ("helpfilerow", xmRowColumnWidgetClass, WHelpDialog,
				     XmNorientation, XmVERTICAL,
				     XmNpacking, XmPACK_TIGHT,
				     XmNwidth, 600,
				     XmNheight, 390,
				     NULL);

  Wframe = XtCreateManagedWidget ("helpframe", xmFrameWidgetClass, WRowCol, NULL, 0);
  WRowCol2 = XmCreateRowColumn (Wframe, "helpfilerow2", NULL, 0);
  XtManageChild (WRowCol2);

  nArgs = 0;
  XtSetArg (Aargs[nArgs], XmNeditMode, XmMULTI_LINE_EDIT);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNeditable, false);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNrows, 15);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNcolumns, 40);
  nArgs++;
  XtSetArg (Aargs[nArgs], XmNwordWrap, true);
  nArgs++;
  helptext = XmCreateScrolledText (WRowCol2, "helptext", Aargs, nArgs);

  XmTextSetString (helptext, str);
  XtManageChild (helptext);

  WButtonOK = XtCreateManagedWidget ("OK", xmPushButtonWidgetClass, WRowCol, NULL, 0);
  XtManageChild (WButtonOK);

  XtAddCallback (WButtonOK, XmNactivateCallback, (XtCallbackProc) CBHelpOk, NULL);
}
