/*
   Programm zur Erzeugung vom Oberflchen
   aus Y-Pufferdatei

   Schreibt die Polygone in eine Textdatei.

   Programmierer Helmut Fahrion
   Aufruf:
   >g++ surface.C vect.o -o surface -lm
   >demo|surface

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include "vect.H"

#define TRUE  1
#define FALSE 0
#define OBEN  1
#define RECHTS 0

// Datenpuffer
float *ypuffer;

// Polygonliste
class poly
{
 public:
  
  poly(poly *p, int X1, int Z1, int X2, int Z2, float Y1, float Y2, float Y3, float Y4)
  {
    x1 = X1;    z1 = Z1;    x2 = X2;    z2 = Z2;
    y1 = Y1;    y2 = Y2;    y3 = Y3;    y4 = Y4;
    next = NULL;
    // einketten
    if (p != NULL) 
     p->next = this;
  }

  ~poly()
  {
    if (next) delete next;  
  }
  
  unsigned long x1, z1, x2, z2;
  float y1, y2, y3, y4;
  poly *next;
};

// Dreiecksliste
class drei
{
 public:

  drei(drei *p, int X1, int Z1, int X2, int Z2, int X3, int Z3, float Y1, float Y2, float Y3)
  {
    x1 = X1;    z1 = Z1;    x2 = X2;    z2 = Z2;   x3 = X3; z3 = Z3;
    y1 = Y1;    y2 = Y2;    y3 = Y3;
    next = NULL;
    // einketten
    if (p != NULL) 
     p->next = this;
  }

  ~drei()
  {
    if (next) delete next;  
  }
  
  unsigned long x1, z1, x2, z2, x3, z3;
  float y1, y2, y3;
  drei *next;
};


class textdata
{
 public:

  // Position ab wo es gilt
  unsigned long x1, x2, z1, z2;
};

void allocerror(void *p)
{
  if (!p)
  {
    fprintf(stderr, "Nicht gengend Speicher fr Objekt.\n");
    exit(1);
  }
}

char testebene(vector r0, vector r1, vector r2, vector r3)
{
  float x;
  
  // Test ob Ebene richtig definiert ist
  x = ((r2 - r1) && (r3 - r1)) * (r0 - r1);
  if ((x > eps5) || (x < -eps5))
    return FALSE;
  else return TRUE;
}

/* Durchsucht die Polygonliste nach einen Polygon,
   das an der Kante liegt und sich in der Ebene befindet. */
unsigned char suchequadrat(poly *p, unsigned char richtung)
{
  unsigned char r;
  
  vector r1, r2, r3, r4;
  unsigned long  xn1, xn2, zn1, zn2, x1, x2, z1, z2;

  poly *old;
  poly *vorg = p;

  x1 = vorg->x1;    x2 = vorg->x2;
  z1 = vorg->z1;    z2 = vorg->z2;
  
  while (vorg != NULL)
  {
    // gibt es eine benachbarte Kante
    xn1 = vorg->x1;    xn2 = vorg->x2;
    zn1 = vorg->z1;    zn2 = vorg->z2;
        
    // Kante oben, Kanten sind Ganzzahlen!
    if (richtung)
    {
      //printf("test oben: %d=%d %d=%d %d=%d\n", x1,xn1,x2,xn2,z2,zn1);      
      r = (x1 == xn1) && (x2 == xn2) && (z2 == zn1);
    }
    else
    {
      //printf("test rechts: %d=%d %d=%d %d=%d\n", z1,zn1,z2,zn2,x2,xn1);
      r = (z1 == zn1) && (z2 == zn2) && (x2 == xn1);
    }
        
    if (r)
    {
       // Test ob das Polygon eine Ebene bildet
       r1.x = (float)x1;  r1.y = p->y1;  r1.z = (float)z1;
       r2.x = (float)x2;  r2.y = p->y2;  r2.z = (float)z1;
       r3.x = (float)x1;  r3.y = p->y4;  r3.z = (float)z2;
       r4.x = (float)xn2;  r4.y = vorg->y3;  r4.z = (float)zn2;
       
       if (testebene(r1, r2, r3, r4))
       {
	 // Polygon anknpfen, je Richtung
	 if (richtung)
	 {
	   p->z2 = vorg->z2;
	   p->y3 = vorg->y3;
	   p->y4 = vorg->y4;
         }
	 else
	 {
	   p->x2 = vorg->x2;
	   p->y2 = vorg->y2;
	   p->y3 = vorg->y3;
	 }
	 
      	 // Vorgnger auf nchstes
	 old->next = vorg->next;
	 
	 // damit sich nicht die ganze Liste auflst
	 if (vorg->next) 
	   vorg->next= NULL;

	 // Speicher freigeben
	 delete vorg;

	 //printf("entfernte %d %d %d %d\n", xn1, xn2,  zn1,  zn2);

	 // um Schleife zu beenden
	 return TRUE;
       }
    }
    old  = vorg;
    vorg = vorg->next; // immer nur 2 Vergleichen
  }
  return FALSE;
}

int main(void)
{
  textdata t1, t2, t3;

  vector r1, r2, r3, r4;
  
  poly *pon, *poo, *nextp;
  drei *drn, *dro, *nextd;

  unsigned long x, z, x1, x2, x3, y1, y2, y3;
  float y, p1, p2, p3, p4, s1, s2;

  // Datendefinition
  unsigned long   XRaster;    // Pufferraster x
  unsigned long   ZRaster;    // Pufferraster z
  float Raster;     // Abstnde der Netzlinien
  float zabs;       // Abstand zur X Achse
  float yabs;       // Abstand zur Z Achse  
  float xabs;       // Abstand zur Y Achse  

  pon = poo = nextp = NULL;
  drn = dro = nextd = NULL;
  zabs = 1.0;
  

  // Dimension lesen

  scanf("x=%ld z=%ld a=%lf y=%lf x=%lf\n", &XRaster, &ZRaster, &Raster, &yabs, &xabs);
  //printf("x=%d z=%d a=%f y=%f\n", XRaster, ZRaster, Raster, yabs);
  
  // Texturkoordinaten einlesen
  scanf("x1=%ld z1=%ld x2=%ld z2=%ld\n", &t1.x1, &t1.z1, &t1.x2, &t1.z2);

  // Speicher allocieren
  ypuffer = new float[XRaster*ZRaster];
  allocerror(ypuffer);
  
  for (z = 0; z < ZRaster; z++)
  {
    for (x = 0; x < XRaster; x++)
      scanf("%lf", &(ypuffer[z * XRaster + x]));
    scanf("\n");
  }


  // zur Kontrolle ##################
/*
  for (z = 0; z < ZRaster; z++)
  {
    for (x = 0; x < XRaster; x++)
    {
      printf("%f ", ypuffer[z * XRaster + x]);
    }
    printf("\n");
  }
*/
   /* 
   Bilde aus Y-Puffer eine Oberflche aus Dreiecken.
   Nach dem Hhenlinienmodell wird, im rechten Winkel zur Flierichtung (des Wassers),
   die Kante des Dreieckes gebildet. 
   */  

  // Polygone bilden
  for (z = 0; z < (ZRaster -1); z++)
  {
    for (x = 0; x < (XRaster -1); x++)
    { 
       p1 = ypuffer[ z    * XRaster + x    ] + yabs;
       p2 = ypuffer[ z    * XRaster + (x+1)] + yabs;
       p3 = ypuffer[(z+1) * XRaster + (x+1)] + yabs;
       p4 = ypuffer[(z+1) * XRaster + x    ] + yabs;

       // Summe der Verbindungslinien mu kleiner sein
       s1 = p1 + p3;
       s2 = p2 + p4;

       // Test auf Polygon -> Definition einer Ebene
       r1.x = (float) x   * Raster;  r1.y = p1;  r1.z = (float)z* Raster;
       r2.x = (float)(x+1)* Raster;  r2.y = p2;  r2.z = (float)z* Raster;
       r3.x = (float)(x+1)* Raster;  r3.y = p3;  r3.z = (float)(z+1)* Raster;
       r4.x = (float) x   * Raster;  r4.y = p4;  r4.z = (float)(z+1)* Raster;

       if (testebene(r1, r2, r3, r4))
       {
	 // Polygonliste erzeugen
	 if (poo == NULL)
	 {
	   poo = new poly(NULL, x, z, x+1, z+1, p1, p2, p3, p4);
           allocerror(poo);
	   pon = poo;
	 }
	 else
         { 
	   pon = new poly(pon, x, z, x+1, z+1, p1, p2, p3, p4);
           allocerror(pon);
	 }
       }
       else
       {
         if (s1 < s2)
         {
	   // erstes Dreieck
	   if (dro == NULL) 
	   {
	     dro = new drei(NULL, 
			    x, z, 
			    x+1, z, 
			    x+1, z+1, p1, p2, p3);
	     allocerror(dro);
	     drn = dro;
	   }
	   else
           { 
	     drn = new drei(drn, 
			    x, z, 
			    x+1, z, 
			    x+1, z+1, p1, p2, p3);
	     allocerror(drn);
	   }
	   // zweites Dreieck
	   drn = new drei(drn, 
			  x, z, 
			  x+1, z+1, 
			  x, z+1, p1,  p3, p4);
	   allocerror(drn);


	   /*
	   printf("polygon\n");
	   printf("1.0 1.0 1.0 1.0 0.0 0.0 0.9 1.0 100.0 1.5 0\n");
	   printf("3\n");
	   printf("%f %f %f\n",
		  (float)x * Raster +xabs, p1, (float)z * Raster+zabs);
	   printf("%f %f %f\n", 
		  (float)(x+1) * Raster+xabs, p2, (float)z * Raster+zabs);
	   printf("%f %f %f\n", 
		  (float)(x+1) * Raster+xabs, p3, (float)(z+1) * Raster+zabs);
	   printf("polygon\n");
	   printf("1.0 1.0 1.0 1.0 0.0 0.0 0.9 1.0 100.0 1.5 0\n");
	   printf("3\n");
	   printf("%f %f %f\n", 
		  (float)x * Raster+xabs, p1, (float)z * Raster+zabs);
	   printf("%f %f %f\n", 
		  (float)(x+1) * Raster+xabs, p3, (float)(z+1) * Raster+zabs);
	   printf("%f %f %f\n", 
		  (float)x * Raster+xabs, p4, (float)(z+1) * Raster+zabs);
	   */
         } else
	 {
	     // erstes Dreieck
	     if (dro == NULL) 
	     {
	       dro = new drei(NULL, 
			      x, z, 
			      x+1, z, 
			      x, z+1, p1, p2, p4);
	       allocerror(dro);
	       drn = dro;
	     }
	     else
	     { 
	       drn = new drei(drn, 
			      x, z, 
			      x+1, z, 
			      x, z+1, p1, p2, p4);
	       allocerror(drn);
	     }
	     // zweites Dreieck
	     drn = new drei(drn, 
			    x+1, z, 
			    x+1, z+1, 
			    x, z+1, p2, p3, p4);
	     allocerror(drn);
	   /*
	   printf("polygon\n");
	   printf("1.0 1.0 1.0 1.0 0.0 0.0 0.9 1.0 100.0 1.5 0\n");
	   printf("3\n");
	   printf("%f %f %f\n", 
		  (float)x * Raster+xabs, p1, (float)z * Raster+zabs);
	   printf("%f %f %f\n", 
		  (float)(x+1) * Raster+xabs, p2, (float)z * Raster+zabs);
	   printf("%f %f %f\n", 
		  (float)x * Raster+xabs, p4, (float)(z+1) * Raster+zabs);
	   printf("polygon\n");
	   printf("1.0 1.0 1.0 1.0 0.0 0.0 0.9 1.0 100.0 1.5 0\n");
	   printf("3\n");
	   printf("%f %f %f\n", 
		  (float)(x+1) * Raster+xabs, p2, (float)z * Raster +zabs);
	   printf("%f %f %f\n", 
		  (float)(x+1) * Raster+xabs, p3, (float)(z+1) * Raster+zabs);
	   printf("%f %f %f\n", 
		  (float)x * Raster+xabs, p4, (float)(z+1) * Raster+zabs);
*/
	 }
       }
     }
  }

  // wurde eins nach rechts oder oben verbunden, suche
  // nchstes
  if (XRaster > ZRaster) 
    y = XRaster / 2;
  else 
    y = ZRaster / 2;
  
  for (x=0; x < y; x++)
  {
    // verbinde eins nach rechts
    nextp = poo;
    while (nextp != NULL)
    {
       suchequadrat(nextp, RECHTS);
       nextp = nextp->next;
    }

    // verbinde eins nach oben
    nextp = poo;
    while (nextp != NULL)
    {
       suchequadrat(nextp, OBEN);
       nextp = nextp->next;
    }
  }

  // Rundere Approximation durch Interpolation ber den Gradienten ist mglich.

  // Ausgabe der Polygonliste
  nextp = poo;
  while (nextp != NULL)
  {
     // Teste ob Polygonursprung dem Textur1 entspricht, oder komplett drin liegt
     // (erstmal mit einer Textur testen!
     if ((nextp->x1 <= t1.x1) && (nextp->x2 >= t1.x2) &&
       	 (nextp->z1 <= t1.z1) && (nextp->z2 >= t1.z2))
       x = 2; 
     else
       x = 1;
    // printf(" x1 %d x2 %d z1 %d z2 %d\n", nextp->x1, nextp->x2, nextp->z1, nextp->z2);

     printf("polygon\n");
     printf("1.0 1.0 1.0 1.0 0.0 0.0 0.9 1.0 100.0 1.5 %d N\n", x);
     printf("4\n");
     printf("%f %f %f\n", 
	    (float)nextp->x1 * Raster+xabs, nextp->y1, (float)nextp->z1 * Raster+zabs);
     printf("%f %f %f\n", 
	    (float)nextp->x2 * Raster+xabs, nextp->y2, (float)nextp->z1 * Raster+zabs);
     printf("%f %f %f\n", 
	    (float)nextp->x2 * Raster+xabs, nextp->y3, (float)nextp->z2 * Raster+zabs);
     printf("%f %f %f\n", 
	    (float)nextp->x1 * Raster+xabs, nextp->y4, (float)nextp->z2 * Raster+zabs);

     nextp = nextp->next;
  }
  // Polygonspeicher freigeben
  delete poo;


  // Ausgabe von Dreiecken
  nextd = dro;
  while (nextd != NULL)
  {
     // Teste ob Polygonursprung dem Textur1 entspricht
//      if ((nextd->x1 == t1.x1) && (nextd->x2 == t1.x2) && 
// 	 (nextd->z1 == t1.z1) && (nextd->z2 == t1.z2))
//        x = 1;
//      else
       x = 1;

     printf("polygon\n");
     printf("1.0 1.0 1.0 1.0 0.0 0.0 0.9 1.0 100.0 1.5 %d N\n", x);
     printf("3\n");
     printf("%f %f %f\n", 
	    (float)nextd->x1 * Raster+xabs, nextd->y1, (float)nextd->z1 * Raster+zabs);
     printf("%f %f %f\n", 
	    (float)nextd->x2 * Raster+xabs, nextd->y2, (float)nextd->z2 * Raster+zabs);
     printf("%f %f %f\n", 
	    (float)nextd->x3 * Raster+xabs, nextd->y3, (float)nextd->z3 * Raster+zabs);

     nextd = nextd->next;
  }
  // Dreiecksspeicher freigeben
  delete dro;

  delete ypuffer;   // Y-Puffer wieder freigeben

  return 0;  
}










