/*
   Programm zur Erzeugung zuflliger
   Oberflchen.

   Schreibt die Struktur in eine Textdatei.

   Programmierer Helmut Fahrion
   Aufruf:
   g++ rberg.C -o rberg

   Copyright (C) 1996 Helmut Fahrion

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#define uns unsigned
#define word uns int
#define byte uns char

// Datenpuffer
float *ypuffer;

// Zufallszahlen
float frandom(float x)
{
  return( ((float)rand() / (float)RAND_MAX) * x );
}

// errechnet Y-Puffer
void rechne(word Schleife, float yinc, word Schichten, 
	    word XRaster, word ZRaster, float RandY, float RandSY, float YStart)
{
  word x, z;
  float y;

  if (Schleife <= Schichten)
  {

    // Berechne Zufallshhe
    yinc += frandom(RandSY);

    z = Schleife;
    for (x = Schleife; x <= (XRaster - Schleife)+1; x++)
    {
      y = yinc + frandom(RandY);
      ypuffer[(z -1) * (XRaster -1) + (x -1)] = y;
    }

    x--;
    for (z = Schleife; z <= (ZRaster - Schleife)+1; z++)
    {
      y = yinc + frandom(RandY);
      ypuffer[(z -1) * (XRaster -1) + (x -1)] = y;
    }

    z--;
    for (x = Schleife; x <= (XRaster - Schleife)+1; x++)
    {
      y = yinc + frandom(RandY);
      ypuffer[(z -1) * (XRaster -1) + (x -1)] = y;
    }

    x = Schleife;
    for (z = Schleife; z <= (ZRaster - Schleife)+1; z++)
    {
      y = yinc + frandom(RandY);
      ypuffer[(z -1) * (XRaster -1) + (x -1)] = y;
    }

    // Rekursion fr nchste Schicht
    rechne(++Schleife, yinc, Schichten, 
	   XRaster, ZRaster, RandY, RandSY, YStart);
  }
}


int main(void)
{
  word x, z;
  float y;

  // Datendefinition
  word XRaster = 5;     // Pufferraster x
  word ZRaster = 5;     // Pufferraster y
  word Schichten = 3;   // Schichten des Berges

  float RandY = 0.2;    // Abweichung y
  float RandSY = 0.5;   // Schichthhe y [0 <= s <= RandSY]
  float YStart = 0.0;   // Starthhe

  float Raster = 0.5;   // Abstnde des Netzes
  float YMove  = -1.0;  

  // Speicher allocieren
  ypuffer = new float[XRaster*ZRaster];
  if (!ypuffer)
  {
    fprintf(stderr, "Nicht gengend Speicher fr Y-Puffer.\n");
    exit(1);
  }

  //    Schleife  IncrementY
  rechne(1,       1.0, Schichten, XRaster, ZRaster, RandY, RandSY, YStart);

  // Schreibe Textdatei ber Eingabeumleitung

  printf("x=%d z=%d a=%f y=%f\n", XRaster, ZRaster, Raster, YMove);  

  for (z = 0; z < ZRaster; z++)
  {
    for (x = 0; x < XRaster; x++)
    {
      printf("%f ", ypuffer[z * (XRaster -1) + x]);
    }
    printf("\n");
  }

  delete ypuffer;   // Speicher wieder freigeben

  return 0;  
}















