/*  
   Dialogbox fuer die Dateneingabe eines Zylinders

   This program ist free software; you can redistribute ist and/or
   modify it under the terms of the GNU General Public License as
   publisched by the Free Software Foundation; either version 2 of
   the License, or (at your opption) any later version.

   This program is distributed in the hope that it well be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Copyright (C) 1996, 1997 Helmut Fahrion
*/

#include "pextool.H"

#define ZYLINDER_APPROX_ANZ 4
struct zylinderstruktur ZylinderDialog;
STRING helpzylinderdialog = "Definition eines Zylinder.";
Widget WZylinderDialog, ZylinderWText1, ZylinderWText2, ZylinderWText3,
  ZylinderCoverLabel;
int ZylinderArt;
grobjekt *zylinder_grobj;
longint zylinder_anknr;
PEXVertexNormal zylinder_netz[(ZYLINDER_APPROX_ANZ + 1) * (ZYLINDER_APPROX_ANZ + 1)];


void
ZylinderDialog_init(longint Nrcover, vector P1, vector P2, float R1, float R2, float W)
{
  ZylinderDialog.p1 = P1;
  ZylinderDialog.p2 = P2;
  ZylinderDialog.r1 = R1;
  ZylinderDialog.r2 = R2;
  ZylinderDialog.w = W;
  ZylinderDialog.nrcover = Nrcover;
}

void
ZylinderDialog_get(longint * Nrcover, vector * P1, vector * P2,
		   float *R1, float *R2, float *W)
{
  *P1 = ZylinderDialog.p1;
  *P2 = ZylinderDialog.p2;
  *R1 = ZylinderDialog.r1;
  *R2 = ZylinderDialog.r2;
  *W = ZylinderDialog.w;
  *Nrcover = ZylinderDialog.nrcover;
}

void
create_test_marker(PEXCoord * testmarker)
{
  testmarker[0].x = ZylinderDialog.p1.x;
  testmarker[0].y = ZylinderDialog.p1.y;
  testmarker[0].z = ZylinderDialog.p1.z;
  testmarker[1].x = ZylinderDialog.p2.x;
  testmarker[1].y = ZylinderDialog.p2.y;
  testmarker[1].z = ZylinderDialog.p2.z;
}

void
create_zylinder_polyline(Display * D, PEXStructure poly, vector p1, vector p2, vector p3,
			 vector p4, vector pn)
{
  PEXCoord lp, coord[4];

  // Polymarker
  PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, poly, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, poly, PEXOCStore, PEXColorTypeRGB, &echo_color);
//   SET_VECTA(p1, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p2, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p3, lp); PEXMarkers(D, poly, PEXOCStore, 1, &lp);
  //   SET_VECTA(p4, lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

  // Polyline
  SET_VECTA(p1, coord[0]);
  SET_VECTA(p2, coord[1]);
  SET_VECTA(p3, coord[2]);
  SET_VECTA(p1, coord[3]);
  PEXPolyline(D, poly, PEXOCStore, 4, coord);

//   PEXSetMarkerType(D, poly, PEXOCStore, PEXMarkerCross);
  //   SET_VECTA(p4+(pn*0.1), lp); 
  //   PEXMarkers(D, poly, PEXOCStore, 1, &lp);

//   // Polyline Dreieck
  //   SET_VECTA(p4+(pn*0.1), coord[0]);
  //   SET_VECTA(p4, coord[1]);
  //   PEXPolyline(D, poly, PEXOCStore,  2, coord);
}

/*
void
zylinder_listtree(Display * D, PEXStructure obj,
		  vector m, vector n, float r)
{
  PEXCoord lp, coord[2];

  // Polymarker
  PEXSetMarkerType(D, obj, PEXOCStore, PEXMarkerCircle);
  PEXSetMarkerScale(D, obj, PEXOCStore, 3.0);
  PEXSetMarkerColor(D, obj, PEXOCStore, PEXColorTypeRGB, &echo_color);

  SET_VECTA(m, lp);
  PEXMarkers(D, obj, PEXOCStore, 1, &lp);

  // Polyline Dreieck
  SET_VECTA(m, coord[0]);
  SET_VECTA(m + (n * r), coord[1]);
  PEXPolyline(D, obj, PEXOCStore, 2, coord);
}

void
listzylindertree(patchtree * patr, longint a, longint * z,
		 Display * D, PEXStructure obj)
{
  patchtl *ptl;

  for (ptl = patr->o; ptl; ptl = ptl->next)
    {
      zylinder_listtree(D, obj, ptl->p->m, ptl->p->n, ptl->p->r);
      *z += 1;
      a++;
    }

  // cerr << a << " Elemente im Tree!\n";

  for (char x = 0; x < 8; x++)
    if (patr->pt[x] != NULL)
      listzylindertree(patr->pt[x], 0, z, D, obj);
}

void
zylinder_calcpatches(vector p1, vector p2, float r1, float r2,
		     Display * D, PEXStructure obj)
{
  cerr << "Erzeuge Zylinder-Block!\n";

  patcharray pt(Patchweite, true, NULL, p1, p2, r1, r2);

//   cerr << "Zeige Kugelliste an!\n";
  //    patchl *pl; 
  //    for (pl = pt.pla; pl; pl = pl->next) 
  //        kugel_listtree(D, obj, pl->m, pl->n, pl->r);

//   patch *pat = pt.pa;
  //   // teste Array
  //   for (long x=0; x<pt.anz; x++) ellip_listtree(D, obj, pat[x].m, pat[x].n, pat[x].r);

  longint z = 0;
  pt.bilde_at();
  listzylindertree(pt.pt, 0, &z, D, obj);

  cerr << "Zylinder gesamt = " << z << " Patches.\n";
}
*/

void
create_zylinder_netz(Display * D, PEXStructure obj)
{
  double phi, yabs, ystep, rabs, radd;
  int index, i, j, anzpoints, anznetz;
  vector w, h;

  // generiere ein Netz in den Koordinaten eines Zylinder
  phi = 0.0;
  anzpoints = ZYLINDER_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // ergibt den Abzuziehenden Abstand je Schleife
  rabs = (ZylinderDialog.r2 - ZylinderDialog.r1) / ZYLINDER_APPROX_ANZ;
  radd = ZylinderDialog.r1;

  // Zylinder geht nach oben, wegen rotationVN() Funktion!
  h = ZylinderDialog.p2 - ZylinderDialog.p1;

  ystep = 0.0;
  yabs = abs(h) / ZYLINDER_APPROX_ANZ;

  h |= h;

  // in richtigen koordinaten erzeugen!
  for (i = 0; i < anznetz; i++)
    {
      for (j = 0; j < anznetz; j++)
	{
	  index = i * anznetz + j;
	  zylinder_netz[index].point.x = sin(phi) * radd;
	  zylinder_netz[index].point.y = cos(phi) * radd;

	  w = vector(zylinder_netz[index].point.x, zylinder_netz[index].point.y, ystep);
	  rotationVN(&w, h);
	  w += ZylinderDialog.p1;
	  zylinder_netz[index].point.x = w.x;
	  zylinder_netz[index].point.y = w.y;
	  zylinder_netz[index].point.z = w.z;
	  // Normalvektor
	  zylinder_netz[index].normal.x = zylinder_netz[index].point.x;
	  zylinder_netz[index].normal.y = zylinder_netz[index].point.y;
	  zylinder_netz[index].normal.z = zylinder_netz[index].point.z;
	  normal(&zylinder_netz[index].normal);

	  phi += (2.0 * pi) / (float) anzpoints;
	}

      ystep += yabs;
      radd += rabs;

      // Kreis schlieen
      index = i * anznetz + anzpoints;
      zylinder_netz[index].point = zylinder_netz[index - anzpoints].point;
      zylinder_netz[index].normal = zylinder_netz[index - anzpoints].normal;
    }

  /*
  zylinder_calcpatches(ZylinderDialog.p1, ZylinderDialog.p2,
		       ZylinderDialog.r1, ZylinderDialog.r2, D, obj);
		       */

}

void
aendere_zylinder(void)
{
  int anzpoints, anznetz;

  // Zylinderberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex zylinder_vertex;
  PEXCoord testmarker[2];
  PEXStructure *zylinderp = &(zylinder_grobj->obj_struct);

  anzpoints = ZYLINDER_APPROX_ANZ;
  anznetz = anzpoints + 1;

  /* Aendern im grobjekt */
  zylinder_grobj->cover = ZylinderDialog.nrcover;	// Covereintrag

  ((cadzylinder *) (zylinder_grobj->objp))->
    init(ZylinderDialog.p1, ZylinderDialog.p2, ZylinderDialog.r1, ZylinderDialog.r2,
	 ZylinderDialog.w);

  PEXSetEditingMode(pDisplay, *zylinderp, PEXStructureReplace);
  PEXSetElementPtr(pDisplay, *zylinderp, PEXBeginning, 0);

  PEXSetElementPtrAtLabel(pDisplay, *zylinderp, OBJ_POLYLINE_LABEL, 1);

  create_zylinder_netz(pDisplay, *zylinderp);
  zylinder_vertex.normal = zylinder_netz;
  PEXQuadrilateralMesh(pDisplay, *zylinderp, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, zylinder_vertex);
  // Polymarker
  create_test_marker(testmarker);
  PEXSetElementPtr(pDisplay, *zylinderp, PEXBeginning, 0);

  PEXSetElementPtrAtLabel(pDisplay, *zylinderp, OBJ_MARKER_LABEL, 1);
  PEXSetMarkerType(pDisplay, *zylinderp, PEXOCStore, PEXMarkerCross);
  PEXSetMarkerScale(pDisplay, *zylinderp, PEXOCStore, 4.0);
  PEXSetMarkerColor(pDisplay, *zylinderp, PEXOCStore, PEXColorTypeRGB, &echo_color);
  PEXMarkers(pDisplay, *zylinderp, PEXOCStore, 2, testmarker);

  un_echo(zylinder_grobj, zylinder_grobj->ch == 'N');
}

void
create_zylinder(Display * D, Widget W, grobjekt * zylinder, longint ank_nr, longint pick_id)
{
  bool echocolor = True;
  int anzpoints, anznetz;
  PEXCoord ref_point, testmarker[2];
  PEXName name[2];
  PEXMatrix matrix;
  PEXVector tr, scale;
  PEXStructure *zylinder_element = NULL;
  grobjekt *ankobj = NULL;

  // Zylinderberechnung
  PEXArrayOfFacetData dummy;
  PEXArrayOfVertex zylinder_vertex;

  anzpoints = ZYLINDER_APPROX_ANZ;
  anznetz = anzpoints + 1;

  // suche strukturpointer zum anhngen
  if (ank_nr == 0L)
    {
      echocolor = True;
      zylinder_element = &root_struct;
      ankobj = NULL;
    }
  else
    {
      if ((ankobj = oliste.getobjp(ank_nr)) != NULL)
	{
	  echocolor = ankobj->ch == 'N';
	  zylinder_element = &ankobj->obj_struct;
	}
      else
	ankobj = NULL;
    }

  // Nameset und Pickid sind wichtig fr das Picken
  name[0] = (PEXName) GROBJSTR;
  name[1] = (PEXName) CONE;
  PEXAddToNameSet(D, zylinder->obj_struct, PEXOCStore, 2, name);
  PEXSetPickID(D, zylinder->obj_struct, PEXOCStore, pick_id);

  PEXLabel(D, zylinder->obj_struct, PEXOCStore, COLORLABEL);
  if (zylinder->ch == 'N')
    PEXSetSurfaceColor(D, zylinder->obj_struct, PEXOCStore, PEXColorTypeRGB, &normal_color);
  else
    PEXSetSurfaceColor(D, zylinder->obj_struct, PEXOCStore, PEXColorTypeRGB, &schnitt_color);

  SET_VECT(0.0, 0.0, 0.0, tr);
  SET_VECT(0.0, 0.0, 0.0, ref_point);
  SET_VECT(1.0, 1.0, 1.0, scale);
  PEXBuildTransform(&ref_point, &tr, 0.0, 0.0, 0.0, &scale, matrix);
  PEXLabel(D, zylinder->obj_struct, PEXOCStore, TRANSFORM_LABEL);
  PEXSetLocalTransform(D, zylinder->obj_struct, PEXOCStore, PEXReplace, matrix);
  // Hier werden die Pickelemente eingefgt 
  PEXLabel(D, zylinder->obj_struct, PEXOCStore, OBJ_PICK_ANF_LABEL);
  PEXLabel(D, zylinder->obj_struct, PEXOCStore, OBJ_PICK_END_LABEL);

  PEXLabel(D, zylinder->obj_struct, PEXOCStore, OBJ_POLYLINE_LABEL);

  create_zylinder_netz(D, zylinder->obj_struct);
  zylinder_vertex.normal = zylinder_netz;
  PEXQuadrilateralMesh(D, zylinder->obj_struct, PEXOCStore, PEXShapeConvex,
		       PEXGANone, PEXGANormal, PEXColorTypeRGB, dummy,
		       anznetz, anznetz, zylinder_vertex);

  // Polymarker
  PEXLabel(pDisplay, zylinder->obj_struct, PEXOCStore, OBJ_MARKER_LABEL);
  create_test_marker(testmarker);
  PEXSetMarkerType(pDisplay, zylinder->obj_struct, PEXOCStore, PEXMarkerCross);
  PEXSetMarkerScale(pDisplay, zylinder->obj_struct, PEXOCStore, 4.0);
  PEXSetMarkerColor(pDisplay, zylinder->obj_struct, PEXOCStore, PEXColorTypeRGB, &echo_color);
  PEXMarkers(pDisplay, zylinder->obj_struct, PEXOCStore, 2, testmarker);

  // Kennung das hier die Kette beginnt
  PEXLabel(D, zylinder->obj_struct, PEXOCStore, OBJ_KETTE_LABEL);

  /* in Root-Struktur einfgen */
  PEXSetEditingMode(D, *zylinder_element, PEXStructureInsert);
  PEXSetElementPtr(D, *zylinder_element, PEXEnd, 0);
  PEXLabel(D, *zylinder_element, PEXOCStore, GROBJ_LABEL + pick_id);
  PEXExecuteStructure(D, *zylinder_element, PEXOCStore, zylinder->obj_struct);

  un_echo(ankobj, echocolor);
}

void
delete_cover_zylinder_liste(void)
{
  int x, anzelem;

  for (anzelem = 0, coverx = coveranf; coverx; anzelem++, coverx = coverx->next);

  /* Strings freigeben */
  for (x = 0; x < anzelem; x++)
    XmStringFree(ZylinderDialog.pCoverStr[x]);
}


void
CBZylinderOk(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  STRING str;
  grobjekt *zylinder;
  longint pick_id;
  vector p1, p2;
  float r1, r2, w;
  char ok;

  /* Text in Zahlen umwandeln */
  str = XmTextGetString(ZylinderWText1);
  if (!(ok = expr_vector(&p1, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor p1 liefert eine ungueltige Zahl!");
      return;			// gehe zurueck ohne Dialog zu beenden

    }
  // XmStringFree((XmString)str);
  ZylinderDialog.p1 = p1;

  str = XmTextGetString(ZylinderWText2);
  if (!(ok = expr_vector(&p2, str)))	// 0 Fehler, 1 OK, 2 Relativ

    {
      errorbox("Vektor p1 liefert eine ungueltige Zahl!");
      return;			// gehe zurck ohne Dialog zu beenden

    }
  if (ok == 2)
    p2 += p1;
  // XmStringFree((XmString)str);
  ZylinderDialog.p2 = p2;

  str = XmTextGetString(ZylinderWText3);
  sscanf(str, "%f;%f;%f", &r1, &r2, &w);
  // XmStringFree((XmString)str);
  ZylinderDialog.r1 = r1;
  ZylinderDialog.r2 = r2;
  ZylinderDialog.w = w;

  /* neuen Zylinder anketten? */
  if (ZylinderArt == NEU)
    {
      pick_id = ank_grobjekt(CONE, zylinder_anknr,
	  ObjDialog.r, ObjDialog.g, ObjDialog.b, ObjDialog.e, ObjDialog.mat,
		  ObjDialog.sp, ObjDialog.du, ObjDialog.dif, ObjDialog.spec,
			     ObjDialog.high, ObjDialog.vel, ObjDialog.ch,
			     ZylinderDialog.nrcover, vector(0.0, 0.0, 0.0),
			     vector(0.0, 0.0, 0.0));
      zylinder =
	ank_zylinder(ZylinderDialog.p1, ZylinderDialog.p2, ZylinderDialog.r1, ZylinderDialog.r2,
		     ZylinderDialog.w);

      create_zylinder(XtDisplay(W), W, zylinder, zylinder_anknr, pick_id);
    }
  else
    aendere_zylinder();


  delete_cover_zylinder_liste();

  /* erst hier!!! */
  WObjDialog = NULL;

  XtUnmanageChild(WZylinderDialog);
  WZylinderDialog = NULL;
}

void
CBZylinderCancel(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  delete_cover_zylinder_liste();
  XtUnmanageChild(WZylinderDialog);

  /*  erst hier!!! */
  WObjDialog = NULL;

  WZylinderDialog = NULL;
}

void
CBZylinderHelp(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  // Hilfe nur einmal ffnen!
  if (!WHelpDialog)
    helpfiledialog(WTop, helpzylinderdialog);
  else
    infobox("helpnureinmal");
}

void
CBZylinderCover(Widget W, caddr_T pClientData, caddr_T pCallData)
{
  char cpos[5];
  XmString anzstr;
  Arg Aargs;

  ZylinderDialog.nrcover = (((XmListCallbackStruct *) pCallData)->item_position) - 1;
  sprintf(cpos, "%ld", ZylinderDialog.nrcover);
  anzstr = XmStringCreateLtoR(cpos, XmSTRING_DEFAULT_CHARSET);

  XtSetArg(Aargs, XmNlabelString, anzstr);
  XtSetValues(ZylinderCoverLabel, &Aargs, 1);
  strcpy(ZylinderDialog.coverlabel, cpos);
}

void
create_zylinder_listen(void)
{
  char str[256];
  longint x = 0, anzelem = 0;

  /* CoverListe */
  if (coveranf)
    {
      coverx = coveranf;
      while (coverx)
	{
	  anzelem = coverx->nr;
	  coverx = coverx->next;
	}
      ZylinderDialog.anzcover = anzelem + 1;
      ZylinderDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString) * (anzelem + 1));
      /* Alle Lichter durchlaufen */
      coverx = coveranf;
      x = 0;
      /* Dummy fr keine */
      sprintf(str, "%d: %s", 0, "keine");	/* C String erzeugen */
      ZylinderDialog.pCoverStr[x++] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
      while (coverx)
	{
	  sprintf(str, "%ld: Cover", coverx->nr);	/* C String erzeugen */
	  ZylinderDialog.pCoverStr[x] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	  coverx = coverx->next;
	  x++;
	}
    }
  else
    {
      /* nur Dummy */
      ZylinderDialog.anzcover = 1;
      ZylinderDialog.pCoverStr = (XmString *) XtMalloc(sizeof(XmString));
      strcpy(str, "0: keine");
      ZylinderDialog.pCoverStr[0] = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
    }
}

void
zylinderdialog(Widget W, class grobjekt * grobjp, longint ank_nr, char art)
{
  Widget WButtonOK, WButtonPick, WButtonCancel, WButtonHelp, WRowCol1,
    WRowCol2, WRowCol3, WRowCol4, frame1, frame2, WLabel, WCoverList;

  Arg Aargs[MAX_ARGS];
  int nArgs;
  char str[256];

  ZylinderArt = art;
  zylinder_anknr = ank_nr;
  zylinder_grobj = grobjp;

  if (ZylinderArt == AENDERN)
    {
      ((cadzylinder *) (zylinder_grobj->objp))->
	get(&ZylinderDialog.p1, &ZylinderDialog.p2, &ZylinderDialog.r1, &ZylinderDialog.r2,
	    &ZylinderDialog.w);
      // zustzlich
      ZylinderDialog.nrcover = zylinder_grobj->cover;
    }
  else
    ZylinderDialog_init(0L, vector(0.2, -0.2, -0.2), vector(0.0, 0.5, 0.0), 0.2, 0.1, 0.0);

  /* Strings fr Listen Aufbauen */
  create_zylinder_listen();

  WZylinderDialog = XmCreateDialogShell(W, "zylinderdialog", NULL, 0);
  XtManageChild(WZylinderDialog);

  /* Umramung und Boxen */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNwidth, 350);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNheight, 340);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmVERTICAL);
  nArgs++;
  WRowCol1 = XmCreateRowColumn(WZylinderDialog, "zylinderrow1", Aargs, nArgs);
  XtManageChild(WRowCol1);

  frame1 = XtCreateManagedWidget("zylinderframe1", xmFrameWidgetClass, WRowCol1, NULL, 0);
  WRowCol2 = XmCreateRowColumn(frame1, "zylinderrow2", NULL, 0);
  XtManageChild(WRowCol2);

  WLabel = XtCreateManagedWidget("Vektor x;y;z :", xmLabelWidgetClass, WRowCol2, NULL, 0);

  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  ZylinderDialog.p1.x, ZylinderDialog.p1.y, ZylinderDialog.p1.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  ZylinderWText1 = XtCreateManagedWidget("zylinderm", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f",
	  ZylinderDialog.p2.x, ZylinderDialog.p2.y, ZylinderDialog.p2.z);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  ZylinderWText2 = XtCreateManagedWidget("zylinderr", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  sprintf(str, "%0.2f;%0.2f;%0.2f", ZylinderDialog.r1, ZylinderDialog.r2, ZylinderDialog.w);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNvalue, str);
  nArgs++;
  ZylinderWText3 = XtCreateManagedWidget("zylinderw", xmTextWidgetClass, WRowCol2, Aargs, nArgs);

  /* Cover Auswahl */
  frame2 = XtCreateManagedWidget("zylindercoverf", xmFrameWidgetClass, WRowCol2, NULL, 0);
  WRowCol4 = XmCreateRowColumn(frame2, "zylinderc4", NULL, 0);
  XtManageChild(WRowCol4);

  sprintf(str, "%ld", ZylinderDialog.nrcover);
  ZylinderCoverLabel = XtCreateManagedWidget(str, xmLabelWidgetClass, WRowCol4, NULL, 0);
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNitems, ZylinderDialog.pCoverStr);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNitemCount, ZylinderDialog.anzcover);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNvisibleItemCount, 4);
  nArgs++;
  WCoverList = XmCreateScrolledList(WRowCol4, "zylindercover", Aargs, nArgs);
  XtAddCallback(WCoverList, XmNdefaultActionCallback, (XtCallbackProc) CBZylinderCover, NULL);
  XtManageChild(WCoverList);

  /* fr Dialog Buttons */
  nArgs = 0;
  XtSetArg(Aargs[nArgs], XmNpacking, XmPACK_COLUMN);
  nArgs++;
  XtSetArg(Aargs[nArgs], XmNorientation, XmHORIZONTAL);
  nArgs++;
  WRowCol3 = XmCreateRowColumn(WRowCol1, "zylinderrow3", Aargs, nArgs);
  // XtManageChild(WRowCol3);

  /* Buttons */
  WButtonOK =
    XtCreateManagedWidget("ok", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonOK);
  WButtonPick =
    XtCreateManagedWidget("pick", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonPick);
  WButtonCancel =
    XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonCancel);
  WButtonHelp =
    XtCreateManagedWidget("help", xmPushButtonWidgetClass, WRowCol3, NULL, 0);
  XtManageChild(WButtonHelp);
  XtManageChild(WRowCol3);

  XtAddCallback(WButtonOK, XmNactivateCallback, (XtCallbackProc) CBZylinderOk, NULL);
  XtAddCallback(WButtonPick, XmNactivateCallback, (XtCallbackProc) CBGetPick, NULL);
  XtAddCallback(WButtonCancel, XmNactivateCallback, (XtCallbackProc) CBZylinderCancel, NULL);
  XtAddCallback(WButtonHelp, XmNactivateCallback, (XtCallbackProc) CBZylinderHelp, NULL);
}
